/*
 * Decompiled with CFR 0.152.
 */
package datastructures.stdcollections;

import datastructures.SmallList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001a\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a'\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u001a/\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u00022\u0006\u0010\t\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\n\u001a7\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u00022\u0006\u0010\t\u001a\u0002H\u00022\u0006\u0010\u000b\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\f\u001a?\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u0002H\u00022\u0006\u0010\u0007\u001a\u0002H\u00022\u0006\u0010\t\u001a\u0002H\u00022\u0006\u0010\u000b\u001a\u0002H\u00022\u0006\u0010\r\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a+\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0010\"\u0002H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a#\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a0\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00180\u001aH\u0086\b\u00f8\u0001\u0000\u001a0\u0010\u001b\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00180\u001aH\u0086\b\u00f8\u0001\u0000\u001a,\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u001d2\u0006\u0010\u0004\u001a\u0002H\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010\u001e\u001a-\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u001d2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u001fH\u0086\u0002\u001a\u001c\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u001f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"emptyList", "", "T", "listOf", "element", "(Ljava/lang/Object;)Ljava/util/List;", "element0", "element1", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "element2", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "element3", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "element4", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "elements", "", "([Ljava/lang/Object;)Ljava/util/List;", "allButFirst", "allButLast", "containsIgnoringFirst", "", "(Ljava/util/List;Ljava/lang/Object;)Z", "forAllButFirst", "", "action", "Lkotlin/Function1;", "forAllButLast", "plus", "", "(Ljava/util/Collection;Ljava/lang/Object;)Ljava/util/List;", "", "toList", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nLists.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lists.kt\ndatastructures/stdcollections/ListsKt\n*L\n1#1,142:1\n37#1,4:143\n*S KotlinDebug\n*F\n+ 1 Lists.kt\ndatastructures/stdcollections/ListsKt\n*L\n49#1:143,4\n*E\n"})
public final class ListsKt {
    @NotNull
    public static final <T> List<T> allButFirst(@NotNull List<? extends T> $this$allButFirst) {
        Intrinsics.checkNotNullParameter($this$allButFirst, "<this>");
        return $this$allButFirst.subList(1, $this$allButFirst.size());
    }

    @NotNull
    public static final <T> List<T> allButLast(@NotNull List<? extends T> $this$allButLast) {
        Intrinsics.checkNotNullParameter($this$allButLast, "<this>");
        int size = $this$allButLast.size();
        int end = size == 0 ? 0 : size - 1;
        return $this$allButLast.subList(0, end);
    }

    public static final <T> void forAllButFirst(@NotNull List<? extends T> $this$forAllButFirst, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forAllButFirst, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forAllButFirst = false;
        for (T elem : ListsKt.allButFirst($this$forAllButFirst)) {
            action.invoke(elem);
        }
    }

    public static final <T> void forAllButLast(@NotNull List<? extends T> $this$forAllButLast, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forAllButLast, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forAllButLast = false;
        for (T elem : ListsKt.allButLast($this$forAllButLast)) {
            action.invoke(elem);
        }
    }

    public static final <T> boolean containsIgnoringFirst(@NotNull List<? extends T> $this$containsIgnoringFirst, T element) {
        Intrinsics.checkNotNullParameter($this$containsIgnoringFirst, "<this>");
        List<? extends T> $this$forAllButFirst$iv = $this$containsIgnoringFirst;
        boolean $i$f$forAllButFirst = false;
        Iterator<T> iterator2 = ListsKt.allButFirst($this$forAllButFirst$iv).iterator();
        while (iterator2.hasNext()) {
            T elem$iv;
            T it2 = elem$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual(it2, element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T> List<T> emptyList() {
        return SmallList.Companion.Of0();
    }

    @NotNull
    public static final <T> List<T> listOf() {
        return SmallList.Companion.Of0();
    }

    @NotNull
    public static final <T> List<T> listOf(T element) {
        return new SmallList.Of1<T>(element);
    }

    @NotNull
    public static final <T> List<T> listOf(T element0, T element1) {
        return new SmallList.Of2<T>(element0, element1);
    }

    @NotNull
    public static final <T> List<T> listOf(T element0, T element1, T element2) {
        return new SmallList.Of3<T>(element0, element1, element2);
    }

    @NotNull
    public static final <T> List<T> listOf(T element0, T element1, T element2, T element3) {
        return new SmallList.Of4<T>(element0, element1, element2, element3);
    }

    @NotNull
    public static final <T> List<T> listOf(T element0, T element1, T element2, T element3, T element4) {
        return new SmallList.Of5<T>(element0, element1, element2, element3, element4);
    }

    @NotNull
    public static final <T> List<T> listOf(T ... elements) {
        List<T> list;
        Intrinsics.checkNotNullParameter(elements, "elements");
        switch (elements.length) {
            case 0: {
                list = ListsKt.listOf();
                break;
            }
            case 1: {
                list = ListsKt.listOf(elements[0]);
                break;
            }
            case 2: {
                list = ListsKt.listOf(elements[0], elements[1]);
                break;
            }
            case 3: {
                list = ListsKt.listOf(elements[0], elements[1], elements[2]);
                break;
            }
            case 4: {
                list = ListsKt.listOf(elements[0], elements[1], elements[2], elements[3]);
                break;
            }
            case 5: {
                list = ListsKt.listOf(elements[0], elements[1], elements[2], elements[3], elements[4]);
                break;
            }
            default: {
                list = CollectionsKt.listOf(Arrays.copyOf(elements, elements.length));
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> plus(@NotNull Collection<? extends T> $this$plus, T element) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        if ($this$plus instanceof List) {
            switch ($this$plus.size()) {
                case 0: {
                    list = ListsKt.listOf(element);
                    break;
                }
                case 1: {
                    list = ListsKt.listOf(((List)$this$plus).get(0), element);
                    break;
                }
                case 2: {
                    list = ListsKt.listOf(((List)$this$plus).get(0), ((List)$this$plus).get(1), element);
                    break;
                }
                case 3: {
                    list = ListsKt.listOf(((List)$this$plus).get(0), ((List)$this$plus).get(1), ((List)$this$plus).get(2), element);
                    break;
                }
                case 4: {
                    list = ListsKt.listOf(((List)$this$plus).get(0), ((List)$this$plus).get(1), ((List)$this$plus).get(2), ((List)$this$plus).get(3), element);
                    break;
                }
                default: {
                    list = CollectionsKt.plus($this$plus, element);
                    break;
                }
            }
        } else {
            list = CollectionsKt.plus($this$plus, element);
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> plus(@NotNull Collection<? extends T> $this$plus, @NotNull Iterable<? extends T> elements) {
        List<T> list;
        Intrinsics.checkNotNullParameter($this$plus, "<this>");
        Intrinsics.checkNotNullParameter(elements, "elements");
        List<T> list2 = CollectionsKt.plus($this$plus, elements);
        switch (list2.size()) {
            case 0: {
                list = ListsKt.listOf();
                break;
            }
            case 1: {
                list = ListsKt.listOf(list2.get(0));
                break;
            }
            case 2: {
                list = ListsKt.listOf(list2.get(0), list2.get(1));
                break;
            }
            case 3: {
                list = ListsKt.listOf(list2.get(0), list2.get(1), list2.get(2));
                break;
            }
            case 4: {
                list = ListsKt.listOf(list2.get(0), list2.get(1), list2.get(2), list2.get(3));
                break;
            }
            case 5: {
                list = ListsKt.listOf(list2.get(0), list2.get(1), list2.get(2), list2.get(3), list2.get(4));
                break;
            }
            default: {
                list = list2;
            }
        }
        return list;
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterable<? extends T> $this$toList) {
        List<Object> list;
        Intrinsics.checkNotNullParameter($this$toList, "<this>");
        Iterable<T> iterable = $this$toList;
        if (iterable instanceof List) {
            switch (((List)$this$toList).size()) {
                case 0: {
                    list = ListsKt.emptyList();
                    break;
                }
                case 1: {
                    list = ListsKt.listOf(((List)$this$toList).get(0));
                    break;
                }
                case 2: {
                    list = ListsKt.listOf(((List)$this$toList).get(0), ((List)$this$toList).get(1));
                    break;
                }
                case 3: {
                    list = ListsKt.listOf(((List)$this$toList).get(0), ((List)$this$toList).get(1), ((List)$this$toList).get(2));
                    break;
                }
                case 4: {
                    list = ListsKt.listOf(((List)$this$toList).get(0), ((List)$this$toList).get(1), ((List)$this$toList).get(2), ((List)$this$toList).get(3));
                    break;
                }
                case 5: {
                    list = ListsKt.listOf(((List)$this$toList).get(0), ((List)$this$toList).get(1), ((List)$this$toList).get(2), ((List)$this$toList).get(3), ((List)$this$toList).get(4));
                    break;
                }
                default: {
                    list = CollectionsKt.toList($this$toList);
                    break;
                }
            }
        } else if (iterable instanceof Collection) {
            if (((Collection)$this$toList).size() == 0) {
                list = ListsKt.emptyList();
            } else {
                Iterator<T> it2 = $this$toList.iterator();
                boolean bl = false;
                switch (((Collection)$this$toList).size()) {
                    case 1: {
                        list = ListsKt.listOf(it2.next());
                        break;
                    }
                    case 2: {
                        list = ListsKt.listOf(it2.next(), it2.next());
                        break;
                    }
                    case 3: {
                        list = ListsKt.listOf(it2.next(), it2.next(), it2.next());
                        break;
                    }
                    case 4: {
                        list = ListsKt.listOf(it2.next(), it2.next(), it2.next(), it2.next());
                        break;
                    }
                    case 5: {
                        list = ListsKt.listOf(it2.next(), it2.next(), it2.next(), it2.next(), it2.next());
                        break;
                    }
                    default: {
                        list = CollectionsKt.toList($this$toList);
                    }
                }
            }
        } else {
            list = CollectionsKt.toList($this$toList);
        }
        return list;
    }
}

