/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.owasp.html.HtmlElementTablesCanned;
import org.owasp.shim.Java8Shim;

public final class HtmlElementTables {
    public static final int TEXT_NODE = -1;
    private final HtmlElementNames elementNames;
    private final DenseElementBinaryMatrix canContain;
    private final DenseElementBinaryMatrix closedOnClose;
    private final DenseElementBinaryMatrix closedOnOpen;
    private final SparseElementToElements explicitClosers;
    private final SparseElementMultitable impliedElements;
    private final TextContentModel textContentModel;
    private final DenseElementSet resumable;
    private final int DIR_TAG;
    private final int OL_TAG;
    private final int UL_TAG;
    private final int LI_TAG;
    private final int SELECT_TAG;
    private final int OPTION_TAG;
    private final int OPTGROUP_TAG;
    private final int SCRIPT_TAG;
    private final int STYLE_TAG;
    private final int TABLE_TAG;
    private final int TBODY_TAG;
    private final int TFOOT_TAG;
    private final int THEAD_TAG;
    private final int TR_TAG;
    private final int TD_TAG;
    private final int TH_TAG;
    private final int CAPTION_TAG;
    private final int COL_TAG;
    private final int COLGROUP_TAG;
    private final int IFRAME_TAG;
    private final FreeWrapper[] FREE_WRAPPERS;
    private final int[] LI_TAG_ARR;
    private final int[] OPTION_TAG_ARR;
    private final DenseElementSet nofeatureElements;
    static final int[] ZERO_INTS = new int[0];
    static final Comparator<int[]> COMPARE_BY_ZEROTH = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            return Integer.compare(a[0], b[0]);
        }
    };

    public HtmlElementTables(HtmlElementNames elementNames2, DenseElementBinaryMatrix canContain, DenseElementBinaryMatrix closedOnClose, DenseElementBinaryMatrix closedOnOpen, SparseElementToElements explicitClosers, SparseElementMultitable impliedElements, TextContentModel textContentModel, DenseElementSet resumable) {
        this.elementNames = elementNames2;
        this.canContain = canContain;
        this.closedOnClose = closedOnClose;
        this.closedOnOpen = closedOnOpen;
        this.explicitClosers = explicitClosers;
        this.impliedElements = impliedElements;
        this.textContentModel = textContentModel;
        this.resumable = resumable;
        this.DIR_TAG = this.indexForName("dir");
        this.OL_TAG = this.indexForName("ol");
        this.UL_TAG = this.indexForName("ul");
        this.LI_TAG = this.indexForName("li");
        this.SELECT_TAG = this.indexForName("select");
        this.OPTION_TAG = this.indexForName("option");
        this.OPTGROUP_TAG = this.indexForName("opgroup");
        this.SCRIPT_TAG = this.indexForName("script");
        this.STYLE_TAG = this.indexForName("style");
        this.TABLE_TAG = this.indexForName("table");
        this.TBODY_TAG = this.indexForName("tbody");
        this.TFOOT_TAG = this.indexForName("tfoot");
        this.THEAD_TAG = this.indexForName("thead");
        this.TR_TAG = this.indexForName("tr");
        this.TD_TAG = this.indexForName("td");
        this.TH_TAG = this.indexForName("th");
        this.CAPTION_TAG = this.indexForName("caption");
        this.COL_TAG = this.indexForName("col");
        this.COLGROUP_TAG = this.indexForName("colgroup");
        this.IFRAME_TAG = this.indexForName("iframe");
        List<FreeWrapper> freeWrappers = Java8Shim.j8().listOf((T[])new FreeWrapper[]{new FreeWrapper(this.LI_TAG, new int[]{this.DIR_TAG, this.OL_TAG, this.UL_TAG, this.LI_TAG}, new int[]{this.UL_TAG}), new FreeWrapper(this.OPTION_TAG, new int[]{this.SELECT_TAG, this.OPTGROUP_TAG, this.OPTION_TAG}, new int[]{this.SELECT_TAG}), new FreeWrapper(this.OPTGROUP_TAG, new int[]{this.SELECT_TAG, this.OPTGROUP_TAG}, new int[]{this.SELECT_TAG}), new FreeWrapper(this.TD_TAG, new int[]{this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG, this.TR_TAG}), new FreeWrapper(this.TH_TAG, new int[]{this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG, this.TR_TAG}), new FreeWrapper(this.TR_TAG, new int[]{this.TBODY_TAG, this.THEAD_TAG, this.TFOOT_TAG, this.TR_TAG, this.TD_TAG, this.TH_TAG}, new int[]{this.TABLE_TAG, this.TBODY_TAG}), new FreeWrapper(this.TBODY_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), new FreeWrapper(this.THEAD_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), new FreeWrapper(this.TFOOT_TAG, new int[]{this.TABLE_TAG, this.THEAD_TAG, this.TBODY_TAG, this.TFOOT_TAG}, new int[]{this.TABLE_TAG}), new FreeWrapper(this.CAPTION_TAG, new int[]{this.TABLE_TAG}, new int[]{this.TABLE_TAG}), new FreeWrapper(this.COL_TAG, new int[]{this.COLGROUP_TAG}, new int[]{this.TABLE_TAG, this.COLGROUP_TAG}), new FreeWrapper(this.COLGROUP_TAG, new int[]{this.TABLE_TAG}, new int[]{this.TABLE_TAG})});
        int maxDescIdx = -1;
        for (FreeWrapper freeWrapper : freeWrappers) {
            maxDescIdx = Math.max(freeWrapper.desc, maxDescIdx);
        }
        FreeWrapper[] freeWrapperArr = new FreeWrapper[maxDescIdx + 1];
        Iterator<FreeWrapper> iterator2 = freeWrappers.iterator();
        while (iterator2.hasNext()) {
            FreeWrapper freeWrapper3;
            freeWrapperArr[freeWrapper3.desc] = freeWrapper3 = iterator2.next();
        }
        this.FREE_WRAPPERS = freeWrapperArr;
        this.LI_TAG_ARR = new int[]{this.LI_TAG};
        this.OPTION_TAG_ARR = new int[]{this.OPTION_TAG};
        boolean[] blArray = new boolean[this.nElementTypes()];
        blArray[this.indexForName((String)"noembed")] = true;
        blArray[this.indexForName((String)"noframes")] = true;
        blArray[this.indexForName((String)"noscript")] = true;
        this.nofeatureElements = new DenseElementSet(blArray);
    }

    public boolean canContain(int parent, int child) {
        if (this.nofeatureElements.get(parent)) {
            return true;
        }
        return child == -1 ? this.canContainText(parent) : this.canContain.get(parent, child);
    }

    public int indexForName(String canonName) {
        return this.elementNames.getElementNameIndex(canonName);
    }

    public String canonNameForIndex(int index) {
        return this.elementNames.canonNames.get(index);
    }

    public boolean resumable(int index) {
        return this.resumable.get(index);
    }

    public boolean canContainText(int index) {
        return this.textContentModel.canContainText(index);
    }

    public boolean canContainPlainText(int index) {
        return this.textContentModel.canContainPlainText(index) && index != this.IFRAME_TAG;
    }

    boolean canContainComment(int ix) {
        return this.textContentModel.canContainComment(ix);
    }

    boolean canContainCharacterReference(int ix) {
        return this.textContentModel.canContainEntities(ix);
    }

    boolean isTextContentRaw(int ix) {
        return this.textContentModel.isRaw(ix);
    }

    boolean isUnended(int ix) {
        return this.textContentModel.isUnended(ix);
    }

    boolean isAlternateCloserFor(int closeTag, int openElement) {
        return this.explicitClosers.get(openElement, closeTag);
    }

    boolean closedOnOpen(int alreadyOpenElement, int openTag) {
        return this.closedOnOpen.get(alreadyOpenElement, openTag);
    }

    boolean closedOnClose(int alreadyOpenElement, int closeTag) {
        return this.closedOnClose.get(alreadyOpenElement, closeTag);
    }

    public int nElementTypes() {
        return this.elementNames.canonNames.size();
    }

    int[] impliedElements(int anc, int desc) {
        int[] implied;
        FreeWrapper wrapper;
        if (desc == this.SCRIPT_TAG || desc == this.STYLE_TAG) {
            return ZERO_INTS;
        }
        FreeWrapper freeWrapper = wrapper = desc != -1 && desc < this.FREE_WRAPPERS.length ? this.FREE_WRAPPERS[desc] : null;
        if (wrapper != null && anc < wrapper.allowedContainers.length && !wrapper.allowedContainers[anc]) {
            return wrapper.implied;
        }
        if (desc != -1 && (implied = this.impliedElements.getElementIndexList(anc, desc)).length != 0) {
            return implied;
        }
        int[] oneImplied = null;
        if (anc == this.OL_TAG || anc == this.UL_TAG) {
            oneImplied = this.LI_TAG_ARR;
        } else if (anc == this.SELECT_TAG) {
            oneImplied = this.OPTION_TAG_ARR;
        }
        if (oneImplied != null && desc != oneImplied[0]) {
            return this.LI_TAG_ARR;
        }
        return ZERO_INTS;
    }

    static HtmlElementTables get() {
        return HtmlElementTablesCanned.TABLES;
    }

    static boolean binSearchRange(int[] arr, int leftIncl, int rightExcl, int value2) {
        int lo = leftIncl;
        int hi = rightExcl;
        while (lo < hi) {
            int mid = lo + hi >>> 1;
            assert (mid >= lo);
            int el = arr[mid];
            int delta = value2 - el;
            if (delta == 0) {
                return true;
            }
            if (delta < 0) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return false;
    }

    public static boolean[] unpack(int[] packed, int length) {
        boolean[] bools = new boolean[length];
        for (int i = 0; i < length; ++i) {
            bools[i] = (packed[i >> 5] & 1 << (i & 0x1F)) != 0;
        }
        return bools;
    }

    public static enum TextContentModelBit {
        COMMENTS(1),
        ENTITIES(2),
        RAW(4),
        TEXT(8),
        UNENDED(16),
        PLAIN_TEXT(32);

        public final int bitMask;

        private TextContentModelBit(int bitMask) {
            this.bitMask = bitMask;
        }
    }

    public static final class TextContentModel {
        private final byte[] contentModelBitsPerElement;

        public TextContentModel(byte[] contentModelBitsPerElement) {
            this.contentModelBitsPerElement = (byte[])contentModelBitsPerElement.clone();
        }

        public boolean canContainComment(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.COMMENTS.bitMask);
        }

        public boolean canContainEntities(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.ENTITIES.bitMask);
        }

        public boolean canContainText(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.TEXT.bitMask);
        }

        public boolean canContainPlainText(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.PLAIN_TEXT.bitMask);
        }

        public boolean isRaw(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.RAW.bitMask);
        }

        public boolean isUnended(int elementIndex) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & TextContentModelBit.UNENDED.bitMask);
        }

        public boolean isAllowed(int elementIndex, TextContentModelBit modelBit) {
            return 0 != (this.contentModelBitsPerElement[elementIndex] & modelBit.bitMask);
        }
    }

    public static final class SparseElementMultitable {
        private final int[][][] arrs;
        private static final int[][] ZERO_INT_ARRS = new int[0][];

        public SparseElementMultitable(int[][][] arrs) {
            this.arrs = (int[][][])arrs.clone();
            int n = arrs.length;
            for (int j = 0; j < n; ++j) {
                if (this.arrs[j] == null) {
                    this.arrs[j] = ZERO_INT_ARRS;
                    continue;
                }
                this.arrs[j] = (int[][])this.arrs[j].clone();
                int[][] arrEl = this.arrs[j];
                int m = arrEl.length;
                for (int i = 0; i < m; ++i) {
                    arrEl[i] = (int[])arrEl[i].clone();
                    int[] row = arrEl[i];
                    if (i == 0 || row[0] > arrEl[i - 1][0]) continue;
                    throw new IllegalStateException("Illegal array state");
                }
            }
        }

        public int[] getElementIndexList(int aIndex, int bIndex) {
            if (aIndex < this.arrs.length) {
                int[][] aArrs = this.arrs[aIndex];
                int bi = Arrays.binarySearch(aArrs, new int[]{bIndex}, COMPARE_BY_ZEROTH);
                if (bi >= 0) {
                    int[] bIndexThenRow = aArrs[bi];
                    int[] row = new int[bIndexThenRow.length - 1];
                    System.arraycopy(bIndexThenRow, 1, row, 0, row.length);
                    return row;
                }
            }
            return ZERO_INTS;
        }
    }

    public static final class SparseElementToElements {
        private final int[][] arrs;

        public SparseElementToElements(int[][] arrs) {
            this.arrs = (int[][])arrs.clone();
            int last2 = -1;
            int n = this.arrs.length;
            for (int i = 0; i < n; ++i) {
                arrs[i] = (int[])arrs[i].clone();
                int[] arr = arrs[i];
                if (last2 >= arr[0]) {
                    throw new IllegalArgumentException("Non sorted array");
                }
                last2 = arr[0];
                int lastVal = -1;
                int m = arr.length;
                for (int j = 1; j < m; ++j) {
                    int val = arr[j];
                    if (val <= lastVal) {
                        throw new IllegalArgumentException("Non sorted array");
                    }
                    lastVal = val;
                }
            }
        }

        boolean get(int key, int value2) {
            int row = Arrays.binarySearch(this.arrs, new int[]{key}, COMPARE_BY_ZEROTH);
            if (row < 0) {
                return false;
            }
            int[] arr = this.arrs[row];
            return HtmlElementTables.binSearchRange(arr, 1, arr.length, value2);
        }
    }

    public static final class DenseElementSet {
        private final boolean[] bits;

        public DenseElementSet(boolean[] bits) {
            this.bits = (boolean[])bits.clone();
        }

        public boolean get(int i) {
            return this.bits[i];
        }
    }

    static final class DenseElementBinaryMatrix {
        private final int matrixLength;
        private final boolean[] bits;

        public DenseElementBinaryMatrix(boolean[] bits, int matrixLength) {
            if (bits.length != matrixLength * matrixLength) {
                throw new IllegalArgumentException("Invalid matrix size");
            }
            this.matrixLength = matrixLength;
            this.bits = (boolean[])bits.clone();
        }

        public boolean get(int a, int b) {
            if (a < 0 || a >= this.matrixLength) {
                throw new IndexOutOfBoundsException("Invalid index for first element");
            }
            if (b < 0 && b >= this.matrixLength) {
                throw new IndexOutOfBoundsException("Invalid index for second element");
            }
            return this.bits[a * this.matrixLength + b];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int k = 0;
            for (int j = 0; j < this.matrixLength; ++j) {
                if (j != 0) {
                    sb.append('\n');
                }
                int i = 0;
                while (i < this.matrixLength) {
                    sb.append(this.bits[k] ? (char)'1' : '.');
                    ++i;
                    ++k;
                }
            }
            return sb.toString();
        }
    }

    public static final class HtmlElementNames {
        static final String CUSTOM_ELEMENT_NAME = "xcustom";
        public final List<String> canonNames;
        private transient Map<String, Integer> canonNameToIndex;
        private transient int customElementIndex;

        public HtmlElementNames(List<String> canonNames) {
            this.canonNames = Java8Shim.j8().listCopyOf(canonNames);
        }

        HtmlElementNames(String ... canonNames) {
            this.canonNames = Java8Shim.j8().listOf((T[])canonNames);
        }

        public int getElementNameIndex(String canonName) {
            Integer index;
            if (this.canonNameToIndex == null) {
                HashMap<String, Integer> builder = new HashMap<String, Integer>();
                int n = this.canonNames.size();
                for (int i = 0; i < n; ++i) {
                    builder.put(this.canonNames.get(i), i);
                }
                this.canonNameToIndex = Collections.unmodifiableMap(builder);
                this.customElementIndex = this.canonNames.indexOf(CUSTOM_ELEMENT_NAME);
                if (this.customElementIndex < 0) {
                    throw new IllegalStateException("Negative element index");
                }
            }
            return (index = this.canonNameToIndex.get(canonName)) != null ? index : this.customElementIndex;
        }
    }

    private static final class FreeWrapper {
        final int desc;
        final boolean[] allowedContainers;
        final int[] implied;

        FreeWrapper(int desc, int[] allowedContainers, int[] implied) {
            this.desc = desc;
            int maxAllowedContainer = -1;
            for (int allowedContainer : allowedContainers) {
                maxAllowedContainer = Math.max(maxAllowedContainer, allowedContainer);
            }
            this.allowedContainers = new boolean[maxAllowedContainer + 1];
            for (int allowedContainer : allowedContainers) {
                this.allowedContainers[allowedContainer] = true;
            }
            this.implied = implied;
        }
    }
}

