/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.NonGhostVariableAsHavocTarget$;
import utils.Range;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="Havoc of CVL variables is currently limited to ghosts.")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        function mutateThis(uint256 x) {\n            havoc #x# assuming true;\n        }\n        ", exampleMessage="Cannot havoc `x`. Local CVL parameters are not ghosts and cannot be havoced."), @CVLErrorExample(exampleCVLWithRange="\n        rule check_havoc {\n            calldataarg args;\n            env e;\n            method f;\n            f(e, args);\n            havoc #args#;\n            method g;\n            g(e, args);\n        }\n        ", exampleMessage="Cannot havoc `args`. Havoc of calldataarg has been deprecated. Try defining a new variable instead.")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B-\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u00c1\u0001\u00a2\u0006\u0002\b\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lspec/cvlast/typechecker/NonGhostVariableAsHavocTarget;", "Lspec/cvlast/typechecker/CVLError;", "seen1", "", "location", "Lutils/Range;", "message", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILutils/Range;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lutils/Range;Ljava/lang/String;)V", "getLocation", "()Lutils/Range;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class NonGhostVariableAsHavocTarget
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private NonGhostVariableAsHavocTarget(Range location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public Range getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(NonGhostVariableAsHavocTarget self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ NonGhostVariableAsHavocTarget(int seen1, Range location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public /* synthetic */ NonGhostVariableAsHavocTarget(Range location, String message2, DefaultConstructorMarker $constructor_marker) {
        this(location, message2);
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{Range.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u00c6\u0001\u00a8\u0006\n"}, d2={"Lspec/cvlast/typechecker/NonGhostVariableAsHavocTarget$Companion;", "", "()V", "fromSymbolValue", "Lspec/cvlast/typechecker/NonGhostVariableAsHavocTarget;", "variable", "Lspec/cvlast/CVLExp$VariableExp;", "sv", "serializer", "Lkotlinx/serialization/KSerializer;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NonGhostVariableAsHavocTarget fromSymbolValue(@NotNull CVLExp.VariableExp variable2, @Nullable Object sv) {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            Range location = variable2.getRangeOrEmpty();
            String reason = sv instanceof CVLParam ? "Local CVL parameters are not ghosts and cannot be havoced." : (sv instanceof CVLCmd.Simple.Declaration && ((CVLCmd.Simple.Declaration)sv).getCvlType() instanceof CVLType.PureCVLType.VMInternal.RawArgs ? "Havoc of calldataarg has been deprecated. Try defining a new variable instead." : "Havoc of non-ghost variables is not allowed.");
            String message2 = "Cannot havoc `" + variable2.getId() + "`. " + reason;
            return new NonGhostVariableAsHavocTarget(location, message2, null);
        }

        @NotNull
        public final KSerializer<NonGhostVariableAsHavocTarget> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

