/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import bridge.types.SolidityTypeDescription;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.CVLKeywords;
import spec.cvlast.EVMBuiltinTypes;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.UndeclaredVariable$;
import utils.Range;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="All CVL variables must be declared before they are used")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n    function f() {\n        mathint y = 2 * #x#;\n    }\n    ", exampleMessage="Variable `x` has not been declared."), @CVLErrorExample(exampleCVLWithRange="function f() { method f; assert f.selector == externalTakesUint(#uint#).selector; }", exampleMessage="Variable `uint` has not been declared.  Did you forget to use `sig:` for a method selector?"), @CVLErrorExample(exampleCVLWithRange="function no_sig(method f) { require f.selector == contract_method(#address#); }"), @CVLErrorExample(exampleCVLWithRange="function f() { address cc = #calledContract#; }", exampleMessage="The special CVL variable `calledContract` is not defined in this context."), @CVLErrorExample(exampleCVLWithRange="function f() { address x = #msg#.sender; }", exampleMessage="Variable `msg` has not been declared.  The Solidity variable `msg` is available as a field of an `env` struct (e.g. `env e; e.msg`)."), @CVLErrorExample(exampleCVLWithRange="function f() { #x# = 3; }"), @CVLErrorExample(exampleCVLWithRange="function f() { #x#[3] = 0; }"), @CVLErrorExample(exampleCVLWithRange="function f() { uint[] x; x[#y#] = 0; }"), @CVLErrorExample(exampleCVLWithRange="function f() { havoc #x#; }"), @CVLErrorExample(exampleCVLWithRange="methods { function externalFunction() external => summary(#x#); } function summary() {}"), @CVLErrorExample(exampleCVLWithRange="rule r { if(_) { mathint x = 0; } else { mathint x = 1; } assert #x# == 2; }"), @CVLErrorExample(exampleCVLWithRange="rule r { if(_) { mathint x = 0; } else { mathint x = 1; } #x# = 2; assert false; }"), @CVLErrorExample(exampleCVLWithRange="rule bug { mathint y = #x# + x; mathint x = y; mathint z = x; assert true; }"), @CVLErrorExample(exampleCVLWithRange="rule r(method f) filtered { f -> f.isPure, g -> #g#.isPure } { assert false; }"), @CVLErrorExample(exampleCVLWithRange="invariant i() true filtered { x -> #g#.selector != 0 }")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u00c1\u0001\u00a2\u0006\u0002\b\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lspec/cvlast/typechecker/UndeclaredVariable;", "Lspec/cvlast/typechecker/CVLError;", "id", "", "location", "Lutils/Range;", "(Ljava/lang/String;Lutils/Range;)V", "seen1", "", "message", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILutils/Range;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lutils/Range;Ljava/lang/String;)V", "getLocation", "()Lutils/Range;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class UndeclaredVariable
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private UndeclaredVariable(Range location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public Range getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public UndeclaredVariable(@NotNull String id, @NotNull Range location) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(location, "location");
        this(location, Companion.specialize(id));
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(UndeclaredVariable self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ UndeclaredVariable(int seen1, Range location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{Range.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lspec/cvlast/typechecker/UndeclaredVariable$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/UndeclaredVariable;", "specialize", "", "id", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String specialize(@NotNull String id) {
            Intrinsics.checkNotNullParameter(id, "id");
            return EVMBuiltinTypes.INSTANCE.isEVMKeyword(id) ? "Variable `" + id + "` has not been declared.  The Solidity variable `" + id + "` is available as a field of an `env` struct (e.g. `env e; e." + id + "`)." : (CVLKeywords.Companion.find(id) != null ? "The special CVL variable `" + id + "` is not defined in this context." : (SolidityTypeDescription.Companion.builtin(id) != null ? "Variable `" + id + "` has not been declared.  Did you forget to use `sig:` for a method selector?" : "Variable `" + id + "` has not been declared."));
        }

        @NotNull
        public final KSerializer<UndeclaredVariable> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

