/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ \u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u0016\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ.\u0010'\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\"\u0010)\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010*\u001a\u00020\u001aJ\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010.\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u00100\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0004H\u0002J\u000e\u00104\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nJ\f\u00108\u001a\u00020\n*\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lutils/ArtifactFileUtils;", "", "()V", "MAX_FILE_NAME_LENGTH", "", "getMAX_FILE_NAME_LENGTH", "()I", "conversion", "", "Lkotlin/Pair;", "", "appendExtension", "basename", "extension", "createFolderIfNotExists", "", "dirString", "dirName", "filePath", "dirSize", "", "dir", "Ljava/nio/file/Path;", "getActualFile", "Ljava/io/File;", "overwrite", "", "append", "getActualFileName", "getBasenameOnly", "fileName", "getCertoraDir", "getExtensionMethod", "getNameFromPath", "name", "getRelativeFileName", "wholePath", "newRootDir", "getResultFile", "getWriterAndActualFileName", "Ljava/io/FileWriter;", "getWriterForFile", "hasCertoraDir", "isSol", "isSolana", "isTAC", "isWasm", "numFiles", "reserveFileName", "sanitizeFileBaseName", "_filename", "extensionLength", "sanitizePath", "wrapPathWith", "path", "srcDir", "normalizeEncodedStringToStringWithABIChars", "SanitizedPath", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nArtifactFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactFileUtils.kt\nutils/ArtifactFileUtils\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,288:1\n32#2,2:289\n1#3:291\n1268#4,3:292\n*S KotlinDebug\n*F\n+ 1 ArtifactFileUtils.kt\nutils/ArtifactFileUtils\n*L\n76#1:289,2\n155#1:292,3\n*E\n"})
public final class ArtifactFileUtils {
    @NotNull
    public static final ArtifactFileUtils INSTANCE = new ArtifactFileUtils();
    @NotNull
    private static final List<Pair<String, String>> conversion;
    private static final int MAX_FILE_NAME_LENGTH;

    private ArtifactFileUtils() {
    }

    public final boolean hasCertoraDir() {
        return System.getenv().containsKey("CERTORA");
    }

    @NotNull
    public final String getCertoraDir() {
        String string = System.getenv("CERTORA");
        Intrinsics.checkNotNullExpressionValue(string, "getenv(...)");
        return string;
    }

    @NotNull
    public final String getNameFromPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = new File(name).getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @NotNull
    public final String getResultFile() {
        return "Results.txt";
    }

    public final void createFolderIfNotExists(@NotNull String dirString) {
        boolean success;
        Intrinsics.checkNotNullParameter(dirString, "dirString");
        File dir = new File(dirString);
        if (!(dir.exists() || (success = dir.mkdirs()) || dir.exists())) {
            throw new Exception("Failed to create directory " + dirString);
        }
    }

    @NotNull
    public final String getRelativeFileName(@NotNull String wholePath, @NotNull String newRootDir) {
        Intrinsics.checkNotNullParameter(wholePath, "wholePath");
        Intrinsics.checkNotNullParameter(newRootDir, "newRootDir");
        if (!StringsKt.contains$default((CharSequence)wholePath, newRootDir, false, 2, null)) {
            throw new Exception("Could not find " + newRootDir + " in " + wholePath);
        }
        int cfgDirPathIdx = 0;
        Path path = FileSystems.getDefault().getPath(wholePath, new String[0]);
        Iterator<Path> $this$getRelativeFileName_u24lambda_u241 = path.iterator();
        boolean bl = false;
        Intrinsics.checkNotNull($this$getRelativeFileName_u24lambda_u241);
        Iterator<Path> $this$forEach$iv = $this$getRelativeFileName_u24lambda_u241;
        boolean $i$f$forEach = false;
        Iterator<Path> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Path element$iv;
            Path it2 = element$iv = iterator2.next();
            boolean bl2 = false;
            if (Intrinsics.areEqual(((Object)it2).toString(), newRootDir)) break;
            ++cfgDirPathIdx;
        }
        return ((Object)path.subpath(cfgDirPathIdx, path.getNameCount())).toString();
    }

    public final boolean isTAC(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return StringsKt.equals(FilesKt.getExtension(new File(fileName)), "tac", true);
    }

    public final boolean isSol(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return StringsKt.equals(FilesKt.getExtension(new File(fileName)), "sol", true);
    }

    public final boolean isWasm(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return StringsKt.equals(FilesKt.getExtension(new File(fileName)), "wasm", true);
    }

    public final boolean isSolana(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string = FilesKt.getExtension(new File(fileName)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String ext = string;
        return Intrinsics.areEqual(ext, "o") || Intrinsics.areEqual(ext, "so");
    }

    @NotNull
    public final String getBasenameOnly(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String separators = "/|\\\\";
        CharSequence charSequence = fileName;
        Regex regex = new Regex(separators);
        int n = 0;
        String filename = CollectionsKt.last(regex.split(charSequence, n));
        boolean bl = false;
        return FilesKt.getNameWithoutExtension(new File(filename));
    }

    private final String sanitizeFileBaseName(String _filename, int extensionLength) {
        Object object;
        String filename = null;
        filename = _filename;
        for (Pair<String, String> p2 : conversion) {
            filename = StringsKt.replace$default(filename, p2.getFirst(), p2.getSecond(), false, 4, null);
        }
        int maxLength = MAX_FILE_NAME_LENGTH - extensionLength;
        if (!(maxLength > 1)) {
            boolean bl = false;
            String string = "extension length (" + extensionLength + ") larger than " + MAX_FILE_NAME_LENGTH + " -- unexpected";
            throw new IllegalArgumentException(string.toString());
        }
        if (filename.length() > maxLength) {
            String string = Integer.toString(filename.hashCode(), CharsKt.checkRadix(36));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String hash2 = string;
            if (!(maxLength - 1 - hash2.length() > 1)) {
                boolean bl = false;
                String string2 = "hash (" + hash2 + ") is longer than a more-than-max-length file name (" + filename + ") -- unexpected";
                throw new IllegalStateException(string2.toString());
            }
            String string3 = filename.substring(0, maxLength - 1 - hash2.length());
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            object = string3 + "_" + hash2;
        } else {
            object = filename;
        }
        return object;
    }

    private final String appendExtension(String basename, String extension) {
        if (!(!StringsKt.contains$default((CharSequence)extension, ".", false, 2, null))) {
            boolean bl = false;
            String string = "File name extension (" + extension + ") contains a \".\".";
            throw new IllegalArgumentException(string.toString());
        }
        return ((CharSequence)extension).length() == 0 ? basename : basename + "." + extension;
    }

    private final String dirName(String filePath) {
        Object object;
        Object object2;
        String string = new File(filePath).getParent();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            object2 = it2 + File.separator;
        } else {
            object2 = object = null;
        }
        if (object2 == null) {
            object = "";
        }
        return object;
    }

    public final long dirSize(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "trying to caclulate dir size on non dir path: " + ((Object)dir.toAbsolutePath()).toString();
            throw new IllegalStateException(string.toString());
        }
        File file = dir.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        return SequencesKt.sumOfLong(SequencesKt.map(SequencesKt.filter(FilesKt.walkTopDown(file), dirSize.2.INSTANCE), dirSize.3.INSTANCE));
    }

    public final int numFiles(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-check-ArtifactFileUtils$numFiles$22 = false;
            String $i$a$-check-ArtifactFileUtils$numFiles$22 = "trying to collect num files on non dir path: " + ((Object)dir.toAbsolutePath()).toString();
            throw new IllegalStateException($i$a$-check-ArtifactFileUtils$numFiles$22.toString());
        }
        File file = dir.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        Sequence $this$count$iv = FilesKt.walkTopDown(file);
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            File it2 = (File)element$iv;
            boolean bl = false;
            if (!it2.isFile() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    @NotNull
    public final String getExtensionMethod(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return FilesKt.getExtension(new File(filePath));
    }

    @NotNull
    public final String sanitizePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return new SanitizedPath(filePath).getSanitizedFullPath();
    }

    @NotNull
    public final FileWriter getWriterForFile(@NotNull String filePath, boolean overwrite, boolean append) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        return this.getWriterAndActualFileName(filePath, overwrite, append).getFirst();
    }

    public static /* synthetic */ FileWriter getWriterForFile$default(ArtifactFileUtils artifactFileUtils, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getWriterForFile(string, bl, bl2);
    }

    @NotNull
    public final Pair<FileWriter, String> getWriterAndActualFileName(@NotNull String filePath, boolean overwrite, boolean append) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        String actualFileName = this.getActualFileName(filePath, overwrite, append);
        return TuplesKt.to(new FileWriter(actualFileName, append), actualFileName);
    }

    public static /* synthetic */ Pair getWriterAndActualFileName$default(ArtifactFileUtils artifactFileUtils, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getWriterAndActualFileName(string, bl, bl2);
    }

    private final boolean reserveFileName(String filePath) {
        boolean bl;
        try {
            Files.createFile(Path.of(filePath, new String[0]), new FileAttribute[0]);
            bl = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final File getActualFile(@NotNull String filePath, boolean overwrite, boolean append) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        String actualName = this.getActualFileName(filePath, overwrite, append);
        return new File(actualName);
    }

    public static /* synthetic */ File getActualFile$default(ArtifactFileUtils artifactFileUtils, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return artifactFileUtils.getActualFile(string, bl, bl2);
    }

    private final String getActualFileName(String filePath, boolean overwrite, boolean append) {
        SanitizedPath sanitizedPath = new SanitizedPath(filePath);
        int retryCount = 0;
        while (true) {
            Object object;
            if (new File(sanitizedPath.getSanitizedFullPath()).exists() && !overwrite && !append) {
                String uniqueSuffix = "_" + ++retryCount;
                if (sanitizedPath.getSanitizedFileBaseName().length() + uniqueSuffix.length() + 1 + sanitizedPath.getFileExtension().length() > MAX_FILE_NAME_LENGTH) {
                    if (!(sanitizedPath.getSanitizedFileBaseName().length() - uniqueSuffix.length() > 1)) {
                        boolean bl = false;
                        String string = "length of sanitized file name (" + sanitizedPath + ".sanitizedFileBaseName) minus length of uniqueSuffix (" + uniqueSuffix + ") is negative, even though the expected file length exceeds the maximum allowed file name length (" + MAX_FILE_NAME_LENGTH + ") --> unexpected ";
                        throw new IllegalStateException(string.toString());
                    }
                    String string = sanitizedPath.getSanitizedFileBaseName().substring(0, sanitizedPath.getSanitizedFileBaseName().length() - uniqueSuffix.length());
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    object = string + uniqueSuffix;
                } else {
                    object = sanitizedPath.getSanitizedFileBaseName() + uniqueSuffix;
                }
            } else {
                object = sanitizedPath.getSanitizedFileBaseName();
            }
            String nonConflictingFileBaseName = object;
            String actualFileName = sanitizedPath.getDirPart() + this.appendExtension(nonConflictingFileBaseName, sanitizedPath.getFileExtension());
            if (overwrite || append || this.reserveFileName(actualFileName)) {
                return actualFileName;
            }
            Thread.sleep(10L);
        }
    }

    public final int getMAX_FILE_NAME_LENGTH() {
        return MAX_FILE_NAME_LENGTH;
    }

    @Deprecated(message="Never use this function. DO NOT reintroduce any translation back to strings with ABI chars", level=DeprecationLevel.ERROR)
    @NotNull
    public final String normalizeEncodedStringToStringWithABIChars(@NotNull String $this$normalizeEncodedStringToStringWithABIChars) {
        Intrinsics.checkNotNullParameter($this$normalizeEncodedStringToStringWithABIChars, "<this>");
        String filename = $this$normalizeEncodedStringToStringWithABIChars;
        for (Pair<String, String> p2 : conversion) {
            filename = StringsKt.replace$default(filename, p2.getSecond(), p2.getFirst(), false, 4, null);
        }
        return filename;
    }

    @NotNull
    public final String wrapPathWith(@NotNull String path, @NotNull String srcDir) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(srcDir, "srcDir");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
        return path2.isAbsolute() ? path : srcDir + File.separator + path;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<String, String>("(", "LP"), new Pair<String, String>(")", "RP"), new Pair<String, String>(",", "C"), new Pair<String, String>("[", "LB"), new Pair<String, String>("]", "RB"), new Pair<String, String>("[]", "LBRB"), new Pair<String, String>("uint256", "U256"), new Pair<String, String>("address", "ADR"), new Pair<String, String>("bytes32", "B32")};
        conversion = CollectionsKt.listOf(pairArray);
        Object object = System.getenv("CERTORA_MAX_FILENAME");
        MAX_FILE_NAME_LENGTH = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 255;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lutils/ArtifactFileUtils$SanitizedPath;", "", "filePath", "", "(Ljava/lang/String;)V", "dirPart", "getDirPart", "()Ljava/lang/String;", "fileExtension", "getFileExtension", "sanitizedFileBaseName", "getSanitizedFileBaseName", "sanitizedFullPath", "getSanitizedFullPath", "GeneralUtils"})
    public static final class SanitizedPath {
        @NotNull
        private final String dirPart;
        @NotNull
        private final String fileExtension;
        @NotNull
        private final String sanitizedFileBaseName;
        @NotNull
        private final String sanitizedFullPath;

        public SanitizedPath(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter(filePath, "filePath");
            this.dirPart = INSTANCE.dirName(filePath);
            this.fileExtension = FilesKt.getExtension(new File(filePath));
            this.sanitizedFileBaseName = INSTANCE.sanitizeFileBaseName(INSTANCE.getBasenameOnly(filePath), this.fileExtension.length() + 1);
            this.sanitizedFullPath = this.dirPart + INSTANCE.appendExtension(this.sanitizedFileBaseName, this.fileExtension);
        }

        @NotNull
        public final String getDirPart() {
            return this.dirPart;
        }

        @NotNull
        public final String getFileExtension() {
            return this.fileExtension;
        }

        @NotNull
        public final String getSanitizedFileBaseName() {
            return this.sanitizedFileBaseName;
        }

        @NotNull
        public final String getSanitizedFullPath() {
            return this.sanitizedFullPath;
        }
    }
}

