# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.document_properties_address_lines import DocumentPropertiesAddressLines
from onfido.models.document_properties_barcode_inner import DocumentPropertiesBarcodeInner
from onfido.models.document_properties_document_classification import DocumentPropertiesDocumentClassification
from onfido.models.document_properties_document_numbers_inner import DocumentPropertiesDocumentNumbersInner
from onfido.models.document_properties_driving_licence_information import DocumentPropertiesDrivingLicenceInformation
from onfido.models.document_properties_extracted_data import DocumentPropertiesExtractedData
from onfido.models.document_properties_nfc import DocumentPropertiesNfc
from onfido.models.document_with_driver_verification_report_all_of_properties_all_of_passenger_vehicle import DocumentWithDriverVerificationReportAllOfPropertiesAllOfPassengerVehicle
from onfido.models.document_with_driver_verification_report_all_of_properties_all_of_vehicle_class_details_inner import DocumentWithDriverVerificationReportAllOfPropertiesAllOfVehicleClassDetailsInner
from typing import Optional, Set
from typing_extensions import Self

class DocumentWithDriverVerificationReportAllOfProperties(BaseModel):
    """
    DocumentWithDriverVerificationReportAllOfProperties
    """ # noqa: E501
    date_of_birth: Optional[date] = None
    date_of_expiry: Optional[date] = None
    personal_number: Optional[StrictStr] = None
    document_numbers: Optional[List[DocumentPropertiesDocumentNumbersInner]] = None
    document_type: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = None
    middle_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    gender: Optional[StrictStr] = None
    issuing_country: Optional[StrictStr] = None
    nationality: Optional[StrictStr] = None
    issuing_state: Optional[StrictStr] = None
    issuing_date: Optional[date] = None
    categorisation: Optional[StrictStr] = None
    mrz_line1: Optional[StrictStr] = None
    mrz_line2: Optional[StrictStr] = None
    mrz_line3: Optional[StrictStr] = None
    address: Optional[StrictStr] = None
    place_of_birth: Optional[StrictStr] = None
    spouse_name: Optional[StrictStr] = None
    widow_name: Optional[StrictStr] = None
    alias_name: Optional[StrictStr] = None
    issuing_authority: Optional[StrictStr] = None
    remarks: Optional[StrictStr] = None
    civil_state: Optional[StrictStr] = None
    expatriation: Optional[StrictStr] = None
    father_name: Optional[StrictStr] = None
    mother_name: Optional[StrictStr] = None
    religion: Optional[StrictStr] = None
    type_of_permit: Optional[StrictStr] = None
    version_number: Optional[StrictStr] = None
    document_subtype: Optional[StrictStr] = None
    profession: Optional[StrictStr] = None
    security_document_number: Optional[StrictStr] = None
    tax_number: Optional[StrictStr] = None
    nist_identity_evidence_strength: Optional[StrictStr] = None
    has_issuance_confirmation: Optional[StrictStr] = None
    real_id_compliance: Optional[StrictBool] = None
    security_tier: Optional[StrictStr] = None
    address_lines: Optional[DocumentPropertiesAddressLines] = None
    barcode: Optional[List[DocumentPropertiesBarcodeInner]] = None
    nfc: Optional[DocumentPropertiesNfc] = None
    driving_licence_information: Optional[DocumentPropertiesDrivingLicenceInformation] = None
    document_classification: Optional[DocumentPropertiesDocumentClassification] = None
    extracted_data: Optional[DocumentPropertiesExtractedData] = None
    drivers_licence: Optional[StrictBool] = Field(default=None, description="True for **non-restricted** driving licences")
    restricted_licence: Optional[StrictBool] = Field(default=None, description="True for **limited/restricted** driving license, including learner's permits")
    raw_licence_category: Optional[StrictStr] = Field(default=None, description="Underlying, non-normalised, licence category (e.g. \"Junior operators license\")")
    raw_vehicle_classes: Optional[StrictStr] = Field(default=None, description="Comma-separated vehicle classes that the user is qualified for")
    vehicle_class_details: Optional[List[DocumentWithDriverVerificationReportAllOfPropertiesAllOfVehicleClassDetailsInner]] = Field(default=None, description="Detailed classes/categories information")
    passenger_vehicle: Optional[DocumentWithDriverVerificationReportAllOfPropertiesAllOfPassengerVehicle] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["date_of_birth", "date_of_expiry", "personal_number", "document_numbers", "document_type", "first_name", "middle_name", "last_name", "gender", "issuing_country", "nationality", "issuing_state", "issuing_date", "categorisation", "mrz_line1", "mrz_line2", "mrz_line3", "address", "place_of_birth", "spouse_name", "widow_name", "alias_name", "issuing_authority", "remarks", "civil_state", "expatriation", "father_name", "mother_name", "religion", "type_of_permit", "version_number", "document_subtype", "profession", "security_document_number", "tax_number", "nist_identity_evidence_strength", "has_issuance_confirmation", "real_id_compliance", "security_tier", "address_lines", "barcode", "nfc", "driving_licence_information", "document_classification", "extracted_data", "drivers_licence", "restricted_licence", "raw_licence_category", "raw_vehicle_classes", "vehicle_class_details", "passenger_vehicle"]

    @field_validator('nist_identity_evidence_strength')
    def nist_identity_evidence_strength_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['superior', 'strong', 'fair', 'weak', 'unacceptable', 'unspecified_identity_evidence_strength']):
            raise ValueError("must be one of enum values ('superior', 'strong', 'fair', 'weak', 'unacceptable', 'unspecified_identity_evidence_strength')")
        return value

    @field_validator('has_issuance_confirmation')
    def has_issuance_confirmation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false', 'unspecified']):
            raise ValueError("must be one of enum values ('true', 'false', 'unspecified')")
        return value

    @field_validator('security_tier')
    def security_tier_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['tier_1', 'tier_2', 'tier_3', 'tier_4', 'tier_5', 'unspecified_security_tier']):
            raise ValueError("must be one of enum values ('tier_1', 'tier_2', 'tier_3', 'tier_4', 'tier_5', 'unspecified_security_tier')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentWithDriverVerificationReportAllOfProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in document_numbers (list)
        _items = []
        if self.document_numbers:
            for _item in self.document_numbers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['document_numbers'] = _items
        # override the default output from pydantic by calling `to_dict()` of address_lines
        if self.address_lines:
            _dict['address_lines'] = self.address_lines.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in barcode (list)
        _items = []
        if self.barcode:
            for _item in self.barcode:
                if _item:
                    _items.append(_item.to_dict())
            _dict['barcode'] = _items
        # override the default output from pydantic by calling `to_dict()` of nfc
        if self.nfc:
            _dict['nfc'] = self.nfc.to_dict()
        # override the default output from pydantic by calling `to_dict()` of driving_licence_information
        if self.driving_licence_information:
            _dict['driving_licence_information'] = self.driving_licence_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of document_classification
        if self.document_classification:
            _dict['document_classification'] = self.document_classification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extracted_data
        if self.extracted_data:
            _dict['extracted_data'] = self.extracted_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vehicle_class_details (list)
        _items = []
        if self.vehicle_class_details:
            for _item in self.vehicle_class_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['vehicle_class_details'] = _items
        # override the default output from pydantic by calling `to_dict()` of passenger_vehicle
        if self.passenger_vehicle:
            _dict['passenger_vehicle'] = self.passenger_vehicle.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentWithDriverVerificationReportAllOfProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date_of_birth": obj.get("date_of_birth"),
            "date_of_expiry": obj.get("date_of_expiry"),
            "personal_number": obj.get("personal_number"),
            "document_numbers": [DocumentPropertiesDocumentNumbersInner.from_dict(_item) for _item in obj["document_numbers"]] if obj.get("document_numbers") is not None else None,
            "document_type": obj.get("document_type"),
            "first_name": obj.get("first_name"),
            "middle_name": obj.get("middle_name"),
            "last_name": obj.get("last_name"),
            "gender": obj.get("gender"),
            "issuing_country": obj.get("issuing_country"),
            "nationality": obj.get("nationality"),
            "issuing_state": obj.get("issuing_state"),
            "issuing_date": obj.get("issuing_date"),
            "categorisation": obj.get("categorisation"),
            "mrz_line1": obj.get("mrz_line1"),
            "mrz_line2": obj.get("mrz_line2"),
            "mrz_line3": obj.get("mrz_line3"),
            "address": obj.get("address"),
            "place_of_birth": obj.get("place_of_birth"),
            "spouse_name": obj.get("spouse_name"),
            "widow_name": obj.get("widow_name"),
            "alias_name": obj.get("alias_name"),
            "issuing_authority": obj.get("issuing_authority"),
            "remarks": obj.get("remarks"),
            "civil_state": obj.get("civil_state"),
            "expatriation": obj.get("expatriation"),
            "father_name": obj.get("father_name"),
            "mother_name": obj.get("mother_name"),
            "religion": obj.get("religion"),
            "type_of_permit": obj.get("type_of_permit"),
            "version_number": obj.get("version_number"),
            "document_subtype": obj.get("document_subtype"),
            "profession": obj.get("profession"),
            "security_document_number": obj.get("security_document_number"),
            "tax_number": obj.get("tax_number"),
            "nist_identity_evidence_strength": obj.get("nist_identity_evidence_strength"),
            "has_issuance_confirmation": obj.get("has_issuance_confirmation"),
            "real_id_compliance": obj.get("real_id_compliance"),
            "security_tier": obj.get("security_tier"),
            "address_lines": DocumentPropertiesAddressLines.from_dict(obj["address_lines"]) if obj.get("address_lines") is not None else None,
            "barcode": [DocumentPropertiesBarcodeInner.from_dict(_item) for _item in obj["barcode"]] if obj.get("barcode") is not None else None,
            "nfc": DocumentPropertiesNfc.from_dict(obj["nfc"]) if obj.get("nfc") is not None else None,
            "driving_licence_information": DocumentPropertiesDrivingLicenceInformation.from_dict(obj["driving_licence_information"]) if obj.get("driving_licence_information") is not None else None,
            "document_classification": DocumentPropertiesDocumentClassification.from_dict(obj["document_classification"]) if obj.get("document_classification") is not None else None,
            "extracted_data": DocumentPropertiesExtractedData.from_dict(obj["extracted_data"]) if obj.get("extracted_data") is not None else None,
            "drivers_licence": obj.get("drivers_licence"),
            "restricted_licence": obj.get("restricted_licence"),
            "raw_licence_category": obj.get("raw_licence_category"),
            "raw_vehicle_classes": obj.get("raw_vehicle_classes"),
            "vehicle_class_details": [DocumentWithDriverVerificationReportAllOfPropertiesAllOfVehicleClassDetailsInner.from_dict(_item) for _item in obj["vehicle_class_details"]] if obj.get("vehicle_class_details") is not None else None,
            "passenger_vehicle": DocumentWithDriverVerificationReportAllOfPropertiesAllOfPassengerVehicle.from_dict(obj["passenger_vehicle"]) if obj.get("passenger_vehicle") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


