/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.provider;

import com.github.drapostolos.typeparser.NoSuchRegisteredParserException;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.TypeParserException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.provider.BindInvocationHandler;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.GenericTypeInterface;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.context.environment.MissingEnvironmentException;
import org.cfg4j.validator.BindingValidator;

class SimpleConfigurationProvider
implements ConfigurationProvider {
    private final ConfigurationSource configurationSource;
    private final Environment environment;

    SimpleConfigurationProvider(ConfigurationSource configurationSource, Environment environment) {
        this.configurationSource = Objects.requireNonNull(configurationSource);
        this.environment = Objects.requireNonNull(environment);
    }

    @Override
    public Properties allConfigurationAsProperties() {
        try {
            return this.configurationSource.getConfiguration(this.environment);
        }
        catch (IllegalStateException | MissingEnvironmentException e) {
            throw new IllegalStateException("Couldn't fetch configuration from configuration source", e);
        }
    }

    @Override
    public <T> T getProperty(String key, Class<T> type) {
        String propertyStr = this.getProperty(key);
        try {
            TypeParser parser = TypeParser.newBuilder().build();
            return (T)parser.parse(propertyStr, type);
        }
        catch (NoSuchRegisteredParserException | TypeParserException e) {
            throw new IllegalArgumentException("Unable to cast value '" + propertyStr + "' to " + type, e);
        }
    }

    @Override
    public <T> T getProperty(String key, GenericTypeInterface genericType) {
        String propertyStr = this.getProperty(key);
        try {
            TypeParser parser = TypeParser.newBuilder().build();
            Object property = parser.parseType(propertyStr, genericType.getType());
            return (T)property;
        }
        catch (NoSuchRegisteredParserException | TypeParserException e) {
            throw new IllegalArgumentException("Unable to cast value '" + propertyStr + "' to " + genericType, e);
        }
    }

    private String getProperty(String key) {
        try {
            Object property = this.configurationSource.getConfiguration(this.environment).get(key);
            if (property == null) {
                throw new NoSuchElementException("No configuration with key: " + key);
            }
            return property.toString();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Couldn't fetch configuration from configuration source for key: " + key, e);
        }
    }

    @Override
    public <T> T bind(String prefix, Class<T> type) {
        return this.bind(this, prefix, type);
    }

    <T> T bind(ConfigurationProvider configurationProvider, String prefix, Class<T> type) {
        Object proxy = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BindInvocationHandler(configurationProvider, prefix));
        new BindingValidator().validate(proxy, type);
        return (T)proxy;
    }

    public String toString() {
        return "SimpleConfigurationProvider{configurationSource=" + this.configurationSource + ", environment=" + this.environment + '}';
    }
}

