/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.compose;

import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.SourceCommunicationException;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.context.environment.MissingEnvironmentException;

public class FallbackConfigurationSource
implements ConfigurationSource {
    private final ConfigurationSource[] sources;

    public FallbackConfigurationSource(ConfigurationSource ... sources) {
        this.sources = Objects.requireNonNull(sources);
        for (ConfigurationSource source : sources) {
            Objects.requireNonNull(source);
        }
    }

    @Override
    public Properties getConfiguration(Environment environment) {
        boolean allMissEnvironment = true;
        for (ConfigurationSource source : this.sources) {
            try {
                return source.getConfiguration(environment);
            }
            catch (MissingEnvironmentException missingEnvironmentException) {
            }
            catch (IllegalStateException e) {
                allMissEnvironment = false;
            }
        }
        if (allMissEnvironment) {
            throw new MissingEnvironmentException(environment.getName());
        }
        throw new IllegalStateException();
    }

    @Override
    public void init() {
        boolean atLeastOneSuccess = false;
        for (ConfigurationSource source : this.sources) {
            try {
                source.init();
                atLeastOneSuccess = true;
            }
            catch (IllegalStateException | SourceCommunicationException runtimeException) {
                // empty catch block
            }
        }
        if (!atLeastOneSuccess) {
            throw new IllegalStateException("Unable to initialize any of the underlying sources");
        }
    }

    @Override
    public void reload() {
        boolean atLeastOneSuccess = false;
        for (ConfigurationSource source : this.sources) {
            try {
                source.reload();
                atLeastOneSuccess = true;
            }
            catch (IllegalStateException | SourceCommunicationException runtimeException) {
                // empty catch block
            }
        }
        if (!atLeastOneSuccess) {
            throw new IllegalStateException("Unable to reload any of the underlying sources");
        }
    }

    public String toString() {
        return "FallbackConfigurationSource{sources=" + Arrays.toString(this.sources) + '}';
    }
}

