/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.compose;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;

public class MergeConfigurationSource
implements ConfigurationSource {
    private final ConfigurationSource[] sources;

    public MergeConfigurationSource(ConfigurationSource ... sources) {
        this.sources = Objects.requireNonNull(sources);
        for (ConfigurationSource source : sources) {
            Objects.requireNonNull(source);
        }
    }

    @Override
    public Properties getConfiguration(Environment environment) {
        Properties properties = new Properties();
        for (ConfigurationSource source : this.sources) {
            Properties sourceProperties = source.getConfiguration(environment);
            properties.putAll((Map<?, ?>)sourceProperties);
        }
        return properties;
    }

    @Override
    public void init() {
        for (ConfigurationSource source : this.sources) {
            source.init();
        }
    }

    @Override
    public void reload() {
        for (ConfigurationSource source : this.sources) {
            source.reload();
        }
    }

    public String toString() {
        return "MergeConfigurationSource{sources=" + Arrays.toString(this.sources) + '}';
    }
}

