/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.context.propertiesprovider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.cfg4j.source.context.propertiesprovider.FormatBasedPropertiesProvider;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonBasedPropertiesProvider
extends FormatBasedPropertiesProvider {
    @Override
    public Properties getProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            JSONTokener tokener = new JSONTokener(inputStream);
            if (tokener.end()) {
                return properties;
            }
            if (tokener.nextClean() == '\"') {
                tokener.back();
                properties.put("content", tokener.nextValue().toString());
            } else {
                tokener.back();
                JSONObject obj = new JSONObject(tokener);
                Map<String, Object> yamlAsMap = this.convertToMap(obj);
                properties.putAll(this.flatten(yamlAsMap));
            }
            return properties;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load json configuration from provided stream", e);
        }
    }

    private Map<String, Object> convertToMap(Object jsonDocument) {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        if (!(jsonDocument instanceof JSONObject)) {
            jsonMap.put("content", jsonDocument);
            return jsonMap;
        }
        JSONObject obj = (JSONObject)jsonDocument;
        for (String key : obj.keySet()) {
            Map<String, Object> value = obj.get(key);
            if (value instanceof JSONObject) {
                value = this.convertToMap(value);
            } else if (value instanceof JSONArray) {
                ArrayList<Map<String, Object>> collection = new ArrayList<Map<String, Object>>();
                for (Object element : (JSONArray)value) {
                    collection.add(this.convertToMap(element));
                }
                value = collection;
            }
            jsonMap.put(key, value);
        }
        return jsonMap;
    }
}

