/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.context.propertiesprovider;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.cfg4j.source.context.propertiesprovider.FormatBasedPropertiesProvider;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.scanner.ScannerException;

public class YamlBasedPropertiesProvider
extends FormatBasedPropertiesProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getProperties(InputStream inputStream) {
        Yaml yaml = new Yaml();
        Properties properties = new Properties();
        try (UnicodeReader reader = new UnicodeReader(inputStream);){
            Object object = yaml.load((Reader)reader);
            if (object != null) {
                Map<String, Object> yamlAsMap = this.convertToMap(object);
                properties.putAll(this.flatten(yamlAsMap));
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException | ScannerException e) {
            throw new IllegalStateException("Unable to load yaml configuration from provided stream", e);
        }
    }

    private Map<String, Object> convertToMap(Object yamlDocument) {
        LinkedHashMap<String, Object> yamlMap = new LinkedHashMap<String, Object>();
        if (!(yamlDocument instanceof Map)) {
            yamlMap.put("content", yamlDocument);
            return yamlMap;
        }
        for (Map.Entry entry : ((Map)yamlDocument).entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.convertToMap(value);
            } else if (value instanceof Collection) {
                ArrayList<Map<String, Object>> collection = new ArrayList<Map<String, Object>>();
                for (Object element : (Collection)value) {
                    collection.add(this.convertToMap(element));
                }
                value = collection;
            }
            yamlMap.put(entry.getKey().toString(), value);
        }
        return yamlMap;
    }
}

