/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.reload.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.cfg4j.source.reload.ReloadStrategy;
import org.cfg4j.source.reload.Reloadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicalReloadStrategy
implements ReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicalReloadStrategy.class);
    private final long duration;
    private final TimeUnit timeUnit;
    private final Timer timer;
    private final Map<Reloadable, TimerTask> tasks;

    public PeriodicalReloadStrategy(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = Objects.requireNonNull(timeUnit);
        this.tasks = Collections.synchronizedMap(new HashMap());
        this.timer = new Timer();
    }

    @Override
    public void register(final Reloadable resource) {
        LOG.debug("Registering resource " + resource + " with reload time of " + this.duration + " " + this.timeUnit.toString().toLowerCase());
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    resource.reload();
                }
                catch (Exception e) {
                    LOG.warn("Periodical resource reload failed. Will re-try at the next scheduled time.", (Throwable)e);
                }
            }
        };
        timerTask.run();
        this.tasks.put(resource, timerTask);
        this.timer.schedule(timerTask, this.timeUnit.toMillis(this.duration), this.timeUnit.toMillis(this.duration));
    }

    @Override
    public void deregister(Reloadable resource) {
        LOG.debug("De-registering resource " + resource);
        TimerTask timerTask = this.tasks.remove(resource);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    public String toString() {
        return "PeriodicalReloadStrategy{duration=" + this.duration + ", timeUnit=" + (Object)((Object)this.timeUnit) + ", timer=" + this.timer + '}';
    }
}

