/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.system;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentVariablesConfigurationSource
implements ConfigurationSource {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentVariablesConfigurationSource.class);
    private static final char ENV_DELIMITER = '_';
    private static final char PROPERTIES_DELIMITER = '.';
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    private boolean initialized = false;

    @Override
    public Properties getConfiguration(Environment environment) {
        if (!this.initialized) {
            throw new IllegalStateException("Configuration source has to be successfully initialized before you request configuration.");
        }
        Properties properties = new Properties();
        String environmentContext = EnvironmentVariablesConfigurationSource.formatEnvironmentContext(environment);
        for (Map.Entry<String, String> entry : this.environmentVariables.entrySet()) {
            if (!entry.getKey().startsWith(environmentContext)) continue;
            properties.put(EnvironmentVariablesConfigurationSource.convertToPropertiesKey(entry.getKey(), environmentContext), entry.getValue());
        }
        return properties;
    }

    @Override
    public void init() {
        LOG.debug("Initializing: Environment Variable Configuration Source");
        this.reload();
        this.initialized = true;
    }

    @Override
    public void reload() {
        LOG.debug("Reloading OS Environment Variables");
        this.environmentVariables.clear();
        this.environmentVariables.putAll(System.getenv());
    }

    public String toString() {
        return "EnvironmentVariablesConfigurationSource{}";
    }

    private static String convertToPropertiesKey(String environmentVariableKey, String environmentContext) {
        return environmentVariableKey.substring(environmentContext.length()).replace('_', '.');
    }

    private static String formatEnvironmentContext(Environment environment) {
        String environmentName = environment.getName();
        if (environmentName == null || environmentName.isEmpty()) {
            return "";
        }
        return environmentName.endsWith("_") ? environmentName : environmentName + "_";
    }
}

