/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingValidator {
    private static final Logger LOG = LoggerFactory.getLogger(BindingValidator.class);

    public <T> void validate(T configurationBean, Class<T> type) {
        LOG.debug("Validating configuration bean of type " + type);
        for (Method declaredMethod : type.getDeclaredMethods()) {
            try {
                LOG.debug("Validating method: " + declaredMethod.getName());
                declaredMethod.invoke(configurationBean, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    if (e.getCause() instanceof NoSuchElementException) {
                        throw (NoSuchElementException)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)e.getCause();
                    }
                }
                throw new IllegalStateException("Can't bind method " + declaredMethod.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't bind method " + declaredMethod.getName(), e);
            }
        }
    }
}

