/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.db2;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class DB2SqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "--#SET TERMINATOR";
    private static final Pattern KEYWORDS_AFTER_STRING_LITERAL_REGEX = Pattern.compile("(.*')(DO)(?!.)");
    private static final Pattern BLOCK_STATEMENT_REGEX = Pattern.compile("^CREATE( OR REPLACE)? (FUNCTION|PROCEDURE|TRIGGER)(\\s.*)?");
    private String statementStart = "";
    private Delimiter currentDelimiter = this.defaultDelimiter;
    private String previousLine = "";

    public DB2SqlStatementBuilder(Delimiter defaultDelimiter) {
        super(defaultDelimiter);
    }

    @Override
    public Delimiter extractNewDelimiterFromLine(String line) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return null;
    }

    @Override
    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--") && !line.startsWith(DELIMITER_KEYWORD);
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("X'")) {
            return token.substring(token.indexOf("'"));
        }
        Matcher afterMatcher = KEYWORDS_AFTER_STRING_LITERAL_REGEX.matcher(token);
        if (afterMatcher.find()) {
            token = afterMatcher.group(1);
        }
        return super.cleanToken(token);
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (delimiter != null && !delimiter.equals(this.currentDelimiter)) {
            this.currentDelimiter = delimiter;
        }
        if (this.hasNonCommentPart() && StringUtils.countOccurrencesOf(this.statementStart, " ") < 4) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
        }
        return this.currentDelimiter;
    }

    @Override
    protected boolean isBlockStatement() {
        return BLOCK_STATEMENT_REGEX.matcher(this.statementStart).matches();
    }

    @Override
    protected boolean isBlockBeginToken(String token) {
        return "BEGIN".equals(token) || "CASE".equals(token) || "IF".equals(token) || "DO".equals(token) || "LOOP".equals(token) || "REPEAT".equals(token);
    }

    @Override
    protected boolean isBlockEndToken(String token) {
        return "END".equals(token);
    }

    @Override
    protected Collection<String> tokenizeLine(String line) {
        String processedLine = line;
        if (this.previousLine.endsWith("END")) {
            if (line.startsWith("IF")) {
                processedLine = processedLine.substring(2);
            } else if (line.startsWith("FOR")) {
                processedLine = processedLine.substring(3);
            } else if (line.startsWith("CASE")) {
                processedLine = processedLine.substring(4);
            } else if (line.startsWith("LOOP")) {
                processedLine = processedLine.substring(4);
            } else if (line.startsWith("WHILE")) {
                processedLine = processedLine.substring(5);
            } else if (line.startsWith("REPEAT")) {
                processedLine = processedLine.substring(6);
            }
        }
        if (StringUtils.hasLength(line)) {
            this.previousLine = line;
        }
        return super.tokenizeLine(processedLine.replaceAll("END (IF|FOR|CASE|LOOP|WHILE|REPEAT)", "END"));
    }
}

