/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.DynamicParser;
import com.github.drapostolos.typeparser.NoSuchRegisteredParserException;
import com.github.drapostolos.typeparser.ParserHelper;
import com.github.drapostolos.typeparser.TypeParserException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingDeque;

class DefaultDynamicParsers {
    private static final List<DynamicParser> regularTypes = DefaultDynamicParsers.asList(RegularType.values());
    private static final List<DynamicParser> containerTypes = DefaultDynamicParsers.asList(ContainerType.values());

    private DefaultDynamicParsers() {
        throw new AssertionError((Object)"Not meant for instantiation");
    }

    static List<DynamicParser> asList(DynamicParser[] parsers) {
        ArrayList<DynamicParser> result = new ArrayList<DynamicParser>();
        for (DynamicParser dynamicParser : parsers) {
            result.add(dynamicParser);
        }
        return result;
    }

    static List<DynamicParser> forContainerTypes() {
        return containerTypes;
    }

    static List<DynamicParser> forRegularTypes() {
        return regularTypes;
    }

    private static Collection<Object> populateCollection(Collection<Object> collection, Class<?> elementType, String input, ParserHelper helper) {
        for (String value : helper.split(input)) {
            collection.add(helper.parseType(value, elementType));
        }
        return collection;
    }

    private static Class<?> extractElementType(ParserHelper helper) {
        if (helper.isTargetTypeParameterized()) {
            return helper.getParameterizedClassArgumentByIndex(0);
        }
        return String.class;
    }

    private static enum RegularType implements DynamicParser
    {
        ENUM{

            @Override
            public Object parse(String input, ParserHelper helper) {
                if (!helper.getRawTargetClass().isEnum()) {
                    return TRY_NEXT;
                }
                Class enumType = helper.getRawTargetClass();
                Enum temp = Enum.valueOf(enumType.asSubclass(Enum.class), input.trim());
                return temp;
            }
        }
        ,
        CLASS{

            @Override
            public Object parse(String input, ParserHelper helper) {
                Class t = helper.getRawTargetClass();
                if (t != Class.class) {
                    return TRY_NEXT;
                }
                try {
                    return Class.forName(input.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new UnsupportedOperationException("ClassNotFound: " + e.getMessage(), e);
                }
            }
        }
        ,
        CLASS_DECLARING_STATIC_VALUE_OF_METHOD{
            private final Object STATIC_METHOD = null;

            @Override
            public Object parse(String input, ParserHelper helper) {
                boolean methodFound = false;
                Method method = null;
                Type argType = null;
                Class targetType = helper.getRawTargetClass();
                Object argument = null;
                for (Method m : targetType.getDeclaredMethods()) {
                    if (!m.getName().equals("valueOf") || m.getGenericParameterTypes().length != 1 || !Modifier.isStatic(m.getModifiers())) continue;
                    argType = m.getGenericParameterTypes()[0];
                    try {
                        argument = helper.parseType(input, argType);
                        method = m;
                        methodFound = true;
                        break;
                    }
                    catch (NoSuchRegisteredParserException e) {
                    }
                    catch (TypeParserException e) {
                        if (e.getCause() instanceof StackOverflowError) {
                            String message = "StackOverflowError: Cyclic argument type for method '%s' on this type.";
                            throw new StackOverflowError(String.format(message, m));
                        }
                        throw e;
                    }
                }
                if (!methodFound) {
                    return TRY_NEXT;
                }
                try {
                    method.setAccessible(true);
                    return method.invoke(this.STATIC_METHOD, argument);
                }
                catch (Exception e) {
                    String message = "Failed when calling static factory method %s, with error message: %s";
                    message = String.format(message, method, e.getMessage());
                    throw new UnsupportedOperationException(message, e);
                }
            }
        }
        ,
        CLASS_DECLARING_SINGLE_ARGUMENT_CONSTRUCTOR{

            @Override
            public Object parse(String input, ParserHelper helper) {
                Class targetType = helper.getRawTargetClass();
                boolean constructorFound = false;
                Constructor<?> constructor = null;
                Type argType = null;
                Object argument = null;
                for (Constructor<?> c : targetType.getDeclaredConstructors()) {
                    if (c.getGenericParameterTypes().length != 1) continue;
                    argType = c.getGenericParameterTypes()[0];
                    try {
                        argument = helper.parseType(input, argType);
                        constructor = c;
                        constructorFound = true;
                        break;
                    }
                    catch (NoSuchRegisteredParserException e) {
                    }
                    catch (TypeParserException e) {
                        if (e.getCause() instanceof StackOverflowError) {
                            String message = "StackOverflowError: Cyclic argument type for constructor '%s' on this type.";
                            throw new StackOverflowError(String.format(message, c));
                        }
                        throw e;
                    }
                }
                if (!constructorFound) {
                    return TRY_NEXT;
                }
                constructor.setAccessible(true);
                try {
                    return constructor.newInstance(argument);
                }
                catch (Exception e) {
                    String message = "Failed when calling constructor %s, with error message: %s";
                    message = String.format(message, constructor, e.getMessage());
                    throw new UnsupportedOperationException(message, e);
                }
            }
        };

    }

    static enum ContainerType implements DynamicParser
    {
        ENUMSET{

            @Override
            public Object parse(String input, ParserHelper helper) {
                if (!helper.getRawTargetClass().equals(EnumSet.class)) {
                    return TRY_NEXT;
                }
                Class elementType = DefaultDynamicParsers.extractElementType(helper);
                EnumSet<Enum> collection = EnumSet.noneOf(elementType.asSubclass(Enum.class));
                return DefaultDynamicParsers.populateCollection(collection, elementType, input, helper);
            }
        }
        ,
        COLLECTION{

            @Override
            public Object parse(String input, ParserHelper helper) {
                if (!helper.isTargetTypeAssignableTo(Collection.class)) {
                    return TRY_NEXT;
                }
                Collection collection = this.instantiateCollection(helper.getRawTargetClass());
                Class elementType = DefaultDynamicParsers.extractElementType(helper);
                return DefaultDynamicParsers.populateCollection(collection, elementType, input, helper);
            }

            private <T> Collection<T> instantiateCollection(Class<? extends T> collectionType) {
                if (collectionType.isInterface()) {
                    return this.instantiateCollectionFromInterface(collectionType);
                }
                return this.instantiateCollectionFromClass(collectionType);
            }

            private <T> Collection<T> instantiateCollectionFromClass(Class<? extends T> collectionType) {
                try {
                    Collection temp = (Collection)collectionType.newInstance();
                    return temp;
                }
                catch (Exception e) {
                    String message = "Cannot instantiate collection of type '%s'";
                    throw new UnsupportedOperationException(String.format(message, collectionType), e);
                }
            }

            private <T> Collection<T> instantiateCollectionFromInterface(Class<? extends T> collectionType) {
                if (List.class.isAssignableFrom(collectionType)) {
                    return new ArrayList();
                }
                if (SortedSet.class.isAssignableFrom(collectionType)) {
                    return new TreeSet();
                }
                if (Set.class.isAssignableFrom(collectionType)) {
                    return new LinkedHashSet();
                }
                if (BlockingDeque.class.isAssignableFrom(collectionType)) {
                    return new LinkedBlockingDeque();
                }
                if (Deque.class.isAssignableFrom(collectionType)) {
                    return new ArrayDeque();
                }
                if (BlockingQueue.class.isAssignableFrom(collectionType)) {
                    return new LinkedBlockingDeque();
                }
                if (Queue.class.isAssignableFrom(collectionType)) {
                    return new LinkedList();
                }
                return new ArrayList();
            }
        }
        ,
        MAP{
            private static final int KEY = 0;
            private static final int VALUE = 1;

            @Override
            public Object parse(String input, ParserHelper helper) {
                if (!helper.isTargetTypeAssignableTo(Map.class)) {
                    return TRY_NEXT;
                }
                Class keyType = helper.getParameterizedClassArgumentByIndex(0);
                Class valueType = helper.getParameterizedClassArgumentByIndex(1);
                Map map = this.instantiateMap(helper.getRawTargetClass());
                for (String entryString : helper.split(input)) {
                    List<String> entry = helper.splitKeyValue(entryString);
                    map.put(helper.parse(entry.get(0), keyType), helper.parse(entry.get(1), valueType));
                }
                return map;
            }

            private <K, V> Map<K, V> instantiateMap(Class<?> rawType) {
                if (rawType.isInterface()) {
                    return this.instantiateMapFromInterface(rawType);
                }
                return this.instantiateMapFromClass(rawType);
            }

            private <K, V> Map<K, V> instantiateMapFromInterface(Class<?> targetType) {
                if (NavigableMap.class.isAssignableFrom(targetType)) {
                    return new ConcurrentSkipListMap();
                }
                if (ConcurrentMap.class.isAssignableFrom(targetType)) {
                    return new ConcurrentHashMap();
                }
                if (SortedMap.class.isAssignableFrom(targetType)) {
                    return new TreeMap();
                }
                return new LinkedHashMap();
            }

            private <K, V> Map<K, V> instantiateMapFromClass(Class<?> rawType) {
                try {
                    Map temp = (Map)rawType.newInstance();
                    return temp;
                }
                catch (Exception e) {
                    String message = String.format("Cannot instantiate map of type '%s'", rawType);
                    throw new UnsupportedOperationException(message, e);
                }
            }
        }
        ,
        ARRAY{

            @Override
            public Object parse(String input, ParserHelper helper) {
                if (!helper.getRawTargetClass().isArray()) {
                    return TRY_NEXT;
                }
                List<String> strList = helper.split(input);
                Class<?> componentType = helper.getComponentClass();
                Object result = Array.newInstance(componentType, strList.size());
                for (int i = 0; i < strList.size(); ++i) {
                    Object element = helper.parse(strList.get(i), componentType);
                    Array.set(result, i, element);
                }
                return result;
            }
        };

    }
}

