/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.ParserHelper;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class DefaultStaticParsers {
    private static final Map<Type, Parser<?>> DEFAULT_STATIC_PARSERS;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMAT;

    private DefaultStaticParsers() {
        throw new AssertionError((Object)"Not meant for instantiation");
    }

    static Map<Type, Parser<?>> copy() {
        return new LinkedHashMap(DEFAULT_STATIC_PARSERS);
    }

    private static List<Type> types(Type ... types) {
        return Arrays.asList(types);
    }

    private static void addStaticParser(Map<Type, Parser<?>> map, List<Type> types, Parser<?> parser) {
        for (Type type : types) {
            DefaultStaticParsers.addStaticParser(map, type, parser);
        }
    }

    private static void addStaticParser(Map<Type, Parser<?>> map, Type type, Parser<?> parser) {
        map.put(type, parser);
    }

    private static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    static {
        NUMBER_FORMAT = new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                return NumberFormat.getInstance(Locale.US);
            }
        };
        LinkedHashMap<Type, Parser<?>> map = DefaultStaticParsers.newLinkedHashMap();
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Byte.class, Byte.TYPE}), new Parser<Byte>(){

            @Override
            public Byte parse(String input, ParserHelper helper) {
                return Byte.valueOf(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Integer.class, Integer.TYPE}), new Parser<Integer>(){

            @Override
            public Integer parse(String input, ParserHelper helper) {
                return Integer.valueOf(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Long.class, Long.TYPE}), new Parser<Long>(){

            @Override
            public Long parse(String input, ParserHelper helper) {
                return Long.valueOf(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Short.class, Short.TYPE}), new Parser<Short>(){

            @Override
            public Short parse(String input, ParserHelper helper) {
                return Short.valueOf(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Float.class, Float.TYPE}), new Parser<Float>(){

            @Override
            public Float parse(String input, ParserHelper helper) {
                return Float.valueOf(input);
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Double.class, Double.TYPE}), new Parser<Double>(){

            @Override
            public Double parse(String input, ParserHelper helper) {
                return Double.valueOf(input);
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Boolean.class, Boolean.TYPE}), new Parser<Boolean>(){

            @Override
            public Boolean parse(String input, ParserHelper helper) {
                String value = input.trim().toLowerCase();
                if (value.equals("true")) {
                    return Boolean.TRUE;
                }
                if (value.equals("false")) {
                    return Boolean.FALSE;
                }
                String message = "\"%s\" is not parsable to a Boolean.";
                throw new IllegalArgumentException(String.format(message, input));
            }
        });
        DefaultStaticParsers.addStaticParser(map, DefaultStaticParsers.types(new Type[]{Character.class, Character.TYPE}), new Parser<Character>(){

            @Override
            public Character parse(String input, ParserHelper helper) {
                if (input.length() == 1) {
                    return Character.valueOf(input.charAt(0));
                }
                String message = "\"%s\" must only contain a single character.";
                throw new IllegalArgumentException(String.format(message, input));
            }
        });
        DefaultStaticParsers.addStaticParser(map, BigInteger.class, new Parser<BigInteger>(){

            @Override
            public BigInteger parse(String input, ParserHelper helper) {
                return new BigInteger(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, BigDecimal.class, new Parser<BigDecimal>(){

            @Override
            public BigDecimal parse(String input, ParserHelper helper) {
                try {
                    return new BigDecimal(input.trim());
                }
                catch (NumberFormatException e) {
                    String message = "NumberFormatException For input string: \"" + input + "\"";
                    NumberFormatException e2 = new NumberFormatException(message);
                    e2.setStackTrace(e.getStackTrace());
                    throw e2;
                }
            }
        });
        DefaultStaticParsers.addStaticParser(map, URL.class, new Parser<URL>(){

            @Override
            public URL parse(String input, ParserHelper helper) {
                try {
                    return new URL(input.trim());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("MalformedURLException: " + e.getMessage(), e);
                }
            }
        });
        DefaultStaticParsers.addStaticParser(map, URI.class, new Parser<URI>(){

            @Override
            public URI parse(String input, ParserHelper helper) {
                try {
                    return new URI(input.trim());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        });
        DefaultStaticParsers.addStaticParser(map, File.class, new Parser<File>(){

            @Override
            public File parse(String input, ParserHelper helper) {
                return new File(input.trim());
            }
        });
        DefaultStaticParsers.addStaticParser(map, String.class, new Parser<String>(){

            @Override
            public String parse(String input, ParserHelper helper) {
                return input;
            }
        });
        DefaultStaticParsers.addStaticParser(map, Object.class, new Parser<Object>(){

            @Override
            public Object parse(String input, ParserHelper helper) {
                return input;
            }
        });
        DefaultStaticParsers.addStaticParser(map, Number.class, new Parser<Number>(){

            @Override
            public Number parse(String input, ParserHelper helper) {
                try {
                    return ((NumberFormat)NUMBER_FORMAT.get()).parse(input.trim());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        });
        DEFAULT_STATIC_PARSERS = Collections.unmodifiableMap(map);
    }
}

