/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.GenericType;
import com.github.drapostolos.typeparser.TargetType;
import com.github.drapostolos.typeparser.Util;
import java.lang.reflect.Type;
import java.util.List;

abstract class Helper {
    private final TargetType tt;

    Helper(TargetType targetType) {
        this.tt = targetType;
    }

    public String toString() {
        return Util.objectToString(this.tt.targetType());
    }

    public final Type getTargetType() {
        return this.tt.targetType();
    }

    public final List<Class<?>> getParameterizedClassArguments() {
        return this.tt.getParameterizedClassArguments();
    }

    Class<?> getComponentClass() {
        if (this.tt.rawTargetType().isArray()) {
            return this.tt.rawTargetType().getComponentType();
        }
        throw new UnsupportedOperationException("type is not an array.");
    }

    public final <T> Class<T> getParameterizedClassArgumentByIndex(int index) {
        List<Class<?>> list = this.getParameterizedClassArguments();
        if (index > list.size() - 1 || index < 0) {
            String message = "index %s is out of bounds. Should be within [0, %s]";
            throw new IndexOutOfBoundsException(String.format(message, index, list.size() - 1));
        }
        Class<?> temp = list.get(index);
        return temp;
    }

    public final <T> Class<T> getTargetClass() {
        if (this.tt.targetType() instanceof Class) {
            Class temp = (Class)this.tt.targetType();
            return temp;
        }
        String message = "%s cannot be casted to java.lang.Class";
        message = String.format(message, Util.objectToString(this.tt.targetType()));
        throw new UnsupportedOperationException(message);
    }

    public final boolean isTargetTypeParameterized() {
        return this.tt.isTargetTypeParameterized();
    }

    public final boolean isTargetTypeAssignableTo(Class<?> type) {
        return type.isAssignableFrom(this.tt.rawTargetType());
    }

    public final boolean isTargetTypeEqualTo(Class<?> type) {
        return this.tt.targetType().equals(type);
    }

    public final boolean isTargetTypeEqualTo(GenericType<?> genericType) {
        return this.tt.targetType().equals(genericType.getType());
    }

    public final boolean isRawTargetClassAnyOf(Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.equals(this.tt.rawTargetType())) continue;
            return true;
        }
        return false;
    }

    public final <T> Class<T> getRawTargetClass() {
        return this.tt.rawTargetType();
    }
}

