/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.DefaultDynamicParsers;
import com.github.drapostolos.typeparser.DynamicParser;
import com.github.drapostolos.typeparser.NoSuchRegisteredParserException;
import com.github.drapostolos.typeparser.NullStringStrategy;
import com.github.drapostolos.typeparser.NullStringStrategyHelper;
import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.ParserHelper;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.TargetType;
import com.github.drapostolos.typeparser.TypeParser;
import java.lang.reflect.Type;
import java.util.List;

final class ParserInvoker {
    private final String preprocessedInput;
    private final Parsers parsers;
    private final ParserHelper helper;
    private final TargetType targetType;
    private final NullStringStrategy nullStringStrategy;

    ParserInvoker(TypeParser typeParser, TargetType targetType, String preprocessedInput) {
        this.targetType = targetType;
        this.preprocessedInput = preprocessedInput;
        this.parsers = typeParser.parsers;
        this.nullStringStrategy = typeParser.nullStringStrategy;
        this.helper = new ParserHelper(targetType, typeParser);
    }

    Object invoke() {
        Object result = this.invokeDynamicParsersRegisteredByClient();
        if (result != DynamicParser.TRY_NEXT) {
            return result;
        }
        if (this.parsers.containsStaticParser(this.targetType.targetType())) {
            return this.invokeStaticParser();
        }
        result = this.invokeDynamicParsersForContainerTypes();
        if (result != DynamicParser.TRY_NEXT) {
            return result;
        }
        result = this.invokeDynamicParsersForRegularTypes();
        if (result != DynamicParser.TRY_NEXT) {
            return result;
        }
        throw new NoSuchRegisteredParserException("There is no registered 'Parser' for that type.");
    }

    private Object invokeDynamicParsersForContainerTypes() {
        return this.invokeDynamicParsers(DefaultDynamicParsers.forContainerTypes());
    }

    private Object invokeDynamicParsersRegisteredByClient() {
        return this.invokeDynamicParsers(this.parsers.dynamicParsers());
    }

    private Object invokeDynamicParsersForRegularTypes() {
        if (this.isNullString()) {
            return null;
        }
        return this.invokeDynamicParsers(DefaultDynamicParsers.forRegularTypes());
    }

    private Object invokeDynamicParsers(List<DynamicParser> dynamicParsers) {
        for (DynamicParser dynamicParser : dynamicParsers) {
            Object result = dynamicParser.parse(this.preprocessedInput, this.helper);
            if (result == DynamicParser.TRY_NEXT) continue;
            return result;
        }
        return DynamicParser.TRY_NEXT;
    }

    private Object invokeStaticParser() {
        if (this.isNullString()) {
            if (this.isPrimitive(this.targetType.targetType())) {
                throw new UnsupportedOperationException("Primitive can not be set to null");
            }
            return null;
        }
        Parser<?> parser = this.parsers.getStaticParser(this.targetType.targetType());
        return parser.parse(this.preprocessedInput, this.helper);
    }

    private boolean isNullString() {
        NullStringStrategyHelper helper = new NullStringStrategyHelper(this.targetType);
        return this.nullStringStrategy.isNullString(this.preprocessedInput, helper);
    }

    private boolean isPrimitive(Type targetType) {
        if (targetType instanceof Class) {
            Class c = (Class)targetType;
            return c.isPrimitive();
        }
        return false;
    }
}

