/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.DefaultStaticParsers;
import com.github.drapostolos.typeparser.DynamicParser;
import com.github.drapostolos.typeparser.Parser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class Parsers {
    private final Map<Type, Parser<?>> staticParsers;
    private final List<DynamicParser> dynamicParsers;

    static Parsers copyDefault() {
        return new Parsers(DefaultStaticParsers.copy(), new ArrayList<DynamicParser>());
    }

    static Parsers unmodifiableCopy(Parsers parsers) {
        return new Parsers(Collections.unmodifiableMap(Parsers.copyMap(parsers.staticParsers)), Collections.unmodifiableList(Parsers.copyList(parsers.dynamicParsers)));
    }

    private static <K, V> Map<K, V> copyMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    private static <T> List<T> copyList(List<T> list) {
        return new ArrayList<T>(list);
    }

    private Parsers(Map<Type, Parser<?>> staticParsers, List<DynamicParser> dynamicParsers) {
        this.staticParsers = staticParsers;
        this.dynamicParsers = dynamicParsers;
    }

    boolean containsStaticParser(Type targetType) {
        return this.staticParsers.containsKey(targetType);
    }

    Parser<?> getStaticParser(Type targetType) {
        return this.staticParsers.get(targetType);
    }

    void removeStaticParser(Type type) {
        this.staticParsers.remove(type);
    }

    void addStaticParser(Type type, Parser<?> parser) {
        this.staticParsers.put(type, parser);
    }

    void addDynamicParser(DynamicParser parser) {
        this.dynamicParsers.add(parser);
    }

    List<DynamicParser> dynamicParsers() {
        return this.dynamicParsers;
    }
}

