/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HsqldbDAO
extends DbDAO {
    private static final Logger log = LoggerFactory.getLogger(HsqldbDAO.class);

    @Override
    protected PreparedStatement prepareGetNextId(Connection conn, String tableName) throws SQLException {
        String sql = "VALUES NEXT VALUE FOR " + tableName + "_seq";
        return conn.prepareStatement(sql);
    }

    @Override
    protected String getTestSQL() {
        return "select 1 from model";
    }

    @Override
    protected void shutdownIfNeeded() throws IxException {
        try (Connection conn = this.getDs().getConnection();){
            if (this.getConfig().url().contains(":file")) {
                conn.createStatement().execute("SHUTDOWN");
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error closing the database connection!", e);
        }
    }
}

