/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDAO
extends DbDAO {
    private static final Logger log = LoggerFactory.getLogger(PostgresDAO.class);

    @Override
    PreparedStatement prepareGetNextId(Connection conn, String tableName) throws SQLException {
        String sql = "SELECT nextval(?)";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, tableName + "_seq");
        return stmt;
    }

    @Override
    protected String getTestSQL() {
        return "select 1";
    }

    @Override
    public void getIndexSets(Scenario scen, int runId) throws IxException {
        String sql = "SELECT name, itemid, ele_blob FROM ix_idxset WHERE runid = ? AND itemid > -1 ORDER BY itemid";
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, runId);
            try (ResultSet results = stmt.executeQuery();){
                while (results.next()) {
                    String name = results.getString(1);
                    int itemId = results.getInt(2);
                    List<Element> elements = null;
                    try (InputStream stream = results.getBinaryStream(3);){
                        if (!results.wasNull()) {
                            elements = this.readElementFromBlob(stream);
                        }
                    }
                    new IndexSet(scen.getMp(), scen, name, itemId, elements);
                }
            }
        }
        catch (IOException | SQLException e) {
            throw this.loggedIxException("Error getting index sets", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected <T> T getBlobFromDB(int runId, Item item, String col, DbDAO.Converter<Object, T> converter) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void setBlob(PreparedStatement updatePrepStmt, int columnIndex, boolean isNull, ByteArrayInputStream input, int size) throws SQLException {
        if (isNull) {
            updatePrepStmt.setNull(columnIndex, -2);
        } else {
            updatePrepStmt.setBinaryStream(columnIndex, (InputStream)input, size);
        }
    }

    @Override
    protected void saveBlobToDB(Connection conn, String name, String type, String col, Object obj, int size, int runId) throws IxException {
        this.assertElementType(type);
        String sql = "UPDATE ix_" + type + "_blobstore SET " + col + "_blob = ? WHERE runid = ? AND name = ? ";
        try (PreparedStatement updatePrepStmt = conn.prepareStatement(sql);){
            int blobLength = 0;
            if (obj == null || size == 0) {
                updatePrepStmt.setNull(1, -2);
            } else {
                byte[] bytes = this.writeInputStream(obj, name);
                blobLength = bytes.length;
                updatePrepStmt.setBinaryStream(1, new ByteArrayInputStream(bytes));
            }
            updatePrepStmt.setInt(2, runId);
            updatePrepStmt.setString(3, name);
            int updateRc = updatePrepStmt.executeUpdate();
            log.debug(String.format("update %s %s rc=%d size=%d", type, name, updateRc, blobLength));
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("Error saving the %s blob for item '%s' to the database!", type, name), e);
        }
    }
}

