/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Equation
extends Item {
    private static final Logger log = LoggerFactory.getLogger(Equation.class);
    private Element scalarEle = null;

    protected Equation(Platform platform) {
        super(platform);
    }

    Equation(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames) {
        super(mp);
        this.initializeIXItem(scenario, name, "equation");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Equation(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames, String pScheme) {
        super(mp);
        this.initializeIXItem(scenario, name, "equation");
        this.setIXitemIdDims(indexSets, indexNames, pScheme);
        scenario.addToItemList(this);
    }

    public Equation(Platform mp, Scenario scenario, String name, int itemId, int dim) {
        super(mp);
        this.initializeIXItem(scenario, name, "equation", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    @Override
    public void setElementListFromDB(List<Element> blob) {
        super.setElementListFromDB(blob);
        if (this.isScalar()) {
            this.scalarEle = (Element)this.eleList.get(this.eleList.size() - 1);
        }
    }

    boolean removeAllElements() throws IxException {
        boolean retval = false;
        if (this.hasElements()) {
            this.eleList = new ArrayList();
            this.eleMap = new HashMap();
            this.scalarEle = null;
            if (this.scenario.isChangeLogged().booleanValue()) {
                log.info("dropped all elements for " + this.getTypeName() + "!");
                this.scenario.changeLogList.add(new ChangelogEntry("dropped all elements for equation", this.name));
            }
            retval = true;
            this.hasUpdatedElement = true;
        }
        this.eleLoadedFromDB = true;
        return retval;
    }

    void addElement(Vector<Integer> keyVector, Double level, Double marginal) throws IxException {
        if (level == null || marginal == null) {
            throw new IxException(String.format("A value of NULL cannot be assigned to %s!", this.getTypeName()));
        }
        if (level.isNaN() || marginal.isNaN()) {
            throw new IxException(String.format("A value of NaN cannot be assigned to %s!", this.getTypeName()));
        }
        if (this.isScalar()) {
            throw new IxException(String.format("You cannot assign an element with a key to scalar %s!", this.getTypeName()));
        }
        this.addItemElement(new Element((Item)this, keyVector, level, marginal), null);
    }

    void addElement(Double level, Double marginal) throws IxException {
        if (level == null || marginal == null) {
            throw new IxException("A value of NULL cannot be assigned to " + this.getTypeName() + "!");
        }
        if (level.isNaN() || marginal.isNaN()) {
            throw new IxException("A value of NaN cannot be assigned to " + this.getTypeName() + "!");
        }
        if (!this.isScalar()) {
            throw new IxException("This equation is not a scalar!");
        }
        this.scalarEle = new Element((Item)this, level, marginal);
        this.addItemElement(this.scalarEle, null);
    }

    public Double getEleLevel(List<String> pKeyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use 'getElementLevel()'!", this.getTypeName()));
        }
        return this.getElement(pKeyList).getLevel();
    }

    public Double getEleLevel(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use 'getElementLevel()'!", this.getTypeName()));
        }
        return this.getElement(pKeyVector).getLevel();
    }

    public double[] getLevels(List<Element> eleList) throws IxException {
        double[] ret = new double[eleList.size()];
        int i = 0;
        for (Element ele : eleList) {
            ret[i] = ele.getLevel();
            ++i;
        }
        return ret;
    }

    public Double getEleMarginal(List<String> keyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use 'getScalarMarginal()'!", this.getTypeName()));
        }
        return this.getElement(keyList).getMarginal();
    }

    public Double getEleMarginal(Vector<Integer> keyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException("The " + this.getTypeName() + " is initialized as a scalar, use 'getScalarMarginal()'!");
        }
        return this.getElement(keyVector).getMarginal();
    }

    public double[] getMarginals(List<Element> eleList) throws IxException {
        double[] ret = new double[eleList.size()];
        int i = 0;
        for (Element ele : eleList) {
            ret[i] = ele.getMarginal();
            ++i;
        }
        return ret;
    }

    public Double getScalarLevel() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getLevel();
    }

    public Double getScalarMarginal() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getMarginal();
    }

    public List<Map<Object, Object>> toJsonList(Map<String, List<String>> eleListFilter) throws IxException {
        LinkedList<Map<Object, Object>> jsonList = new LinkedList<Map<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            Map<Object, Object> jsonMap = this.toMap(ele, "equation");
            Double val = ele.getLevel();
            if (!val.isInfinite()) {
                jsonMap.put("level", val);
            } else if (val < 0.0) {
                jsonMap.put("level", "-Infinity");
            } else {
                jsonMap.put("level", "Infinity");
            }
            Double mrg = ele.getMarginal();
            if (!mrg.isInfinite()) {
                jsonMap.put("marginal", mrg);
            } else if (val.isInfinite() && mrg < 0.0) {
                jsonMap.put("marginal", "-Infinity");
            } else {
                jsonMap.put("marginal", "Infinity");
            }
            jsonList.add(jsonMap);
        }
        return jsonList;
    }

    @Override
    public Item copyTo(Scenario target, boolean keepElements) throws IxException {
        Equation clone = (Equation)super.copyTo(target, keepElements);
        if (keepElements && clone.isScalar() && !clone.eleList.isEmpty()) {
            clone.scalarEle = (Element)clone.eleList.get(clone.eleList.size() - 1);
        }
        return clone;
    }

    @Override
    protected Item createInstance(Platform platform) {
        return new Equation(platform);
    }
}

