/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.modelspecs.MESSAGEspecs;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.ScenarioDbStatus;
import at.ac.iiasa.ixmp.objects.ScenarioState;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.objects.Variable;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSException;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSParameterRecord;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSWorkspace;
import com.gams.api.GAMSWorkspaceInfo;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgScenario
extends Scenario {
    private static final Logger log = LoggerFactory.getLogger(MsgScenario.class);
    public TreeSet<String> nodes = null;
    public TreeSet<String> tecs = null;
    private List<Integer> years = null;
    public TreeSet<String> times = null;
    public TreeSet<String> emissions = null;
    private List<String> reqIdxSets = null;
    private List<String> reqSets = null;
    private List<String> reqPars = null;
    private List<String> reqVars = null;
    private List<String> reqEqus = null;
    private Map<String, List<String>> indexSetsMap = null;
    private Map<String, List<String>> indexNamesMap = null;
    private boolean hasMESSAGEspecs = false;
    public List<String> tecParList = new LinkedList<String>();
    public List<String> tecActParList = new LinkedList<String>();

    public MsgScenario(Platform mp, String model, String scenario, Boolean isNew, String annotation) throws IxException {
        super(mp, model, scenario, isNew, "MESSAGE", annotation);
        this.initializeMsgSetsParameters(true);
        this.assignMessageSetList(false);
    }

    public MsgScenario(Platform mp, String model, String scenario) throws IxException {
        super(mp, model, scenario);
        boolean isCurrent = this.initializeMsgSetsParameters(false);
        if (!isCurrent) {
            this.updateMsgScheme();
        }
        this.assignMessageSetList();
    }

    public MsgScenario(Platform mp, String model, String scenario, int version) throws IxException {
        super(mp, model, scenario, version);
        boolean isCurrent = this.initializeMsgSetsParameters(false);
        if (!isCurrent) {
            this.updateMsgScheme();
        }
        this.assignMessageSetList();
    }

    public MsgScenario(Platform mp, int runId) throws IxException {
        super(mp, runId);
        boolean isCurrent = this.initializeMsgSetsParameters(false);
        if (!isCurrent) {
            this.updateMsgScheme();
        }
        this.assignMessageSetList(false);
    }

    private void updateMsgScheme() throws IxException {
        this.state = ScenarioState.CHECKED_OUT_FOR_TIMESERIES_UPDATE;
        DbDAO db = this.getMp().getDb();
        ScenarioDbStatus dbStatus = db.getStatus(this.runId);
        if (dbStatus == ScenarioDbStatus.LOCKED_IN_DB) {
            String lockUser = db.getLockInfo(this.runId).getLockUser();
            throw new IxException(String.format("This %s is currently locked by user %s", this.type, lockUser));
        }
        if (dbStatus == ScenarioDbStatus.FROZEN_IN_DB) {
            throw new IxException(String.format("This %s is locked and frozen in the database!", this.type));
        }
        db.setStatus(System.getProperty("user.name", "(unknown)"), this.runId, ScenarioDbStatus.LOCKED_IN_DB);
        this.initializeMsgSetsParameters(true);
        try {
            this.commit("updating MESSAGE-scheme scenario to version " + MESSAGEspecs.getMsgVersionAsString());
        }
        catch (IxException e) {
            log.error("There was a problem updating the MESSAGE-scheme specifications!");
            this.discardChanges();
        }
    }

    public MsgScenario(Platform mp, String user, MsgScenario sourceScenario, String model, String scenario, String annotation, boolean keepSolution, Integer newFirstYear) throws IxException {
        super(mp, sourceScenario, model, scenario, annotation);
        boolean isSameDb = mp == sourceScenario.getMp();
        this.state = ScenarioState.NEW;
        String cloneAnnotation = String.format("clone Scenario from '%s|%s', version: %d", sourceScenario.getModel(), sourceScenario.getScenario(), sourceScenario.getVersion());
        Integer firstYear = sourceScenario.getFirstModelYear();
        if (newFirstYear == null) {
            this.commit(user, cloneAnnotation, isSameDb ? sourceScenario : null, keepSolution, firstYear);
            return;
        }
        if (newFirstYear < firstYear) {
            throw new IxException("Shifting the first model year only works forward!");
        }
        this.commit(user, cloneAnnotation, isSameDb ? sourceScenario : this, true, false, newFirstYear);
        this.getMESSAGEspecs();
        this.checkOut(user, false, false);
        LinkedList<String> keyList = new LinkedList<String>();
        keyList.add(Integer.toString(newFirstYear));
        this.addCatEle("year", "firstmodelyear", keyList, true);
        LinkedList<String> yrList = new LinkedList<String>();
        this.getYearList();
        for (Integer yr : this.years) {
            if (yr < firstYear || yr >= newFirstYear) continue;
            yrList.add(yr.toString());
        }
        HashMap<String, List<String>> yrMap = new HashMap<String, List<String>>();
        yrMap.put("year", yrList);
        Map<Vector<Integer>, Double> extraction = this.assignVarToPar("EXT", "historical_extraction", yrMap);
        Parameter duration_period = this.getPar("duration_period");
        Parameter resource_volume = this.getPar("resource_volume");
        for (Map.Entry<Vector<Integer>, Double> extEle : extraction.entrySet()) {
            Vector<Integer> resEle = new Vector<Integer>();
            resEle.add(extEle.getKey().get(0));
            resEle.add(extEle.getKey().get(1));
            resEle.add(extEle.getKey().get(2));
            String yr = this.getKeyIdString(extEle.getKey().get(3));
            double numYrs = duration_period.getElement(yr).getValue();
            Element ele = resource_volume.getElement(resEle);
            Double val = ele.getValue();
            String unit = ele.getUnit();
            resource_volume.addElement(resEle, (Double)(val - extEle.getValue() * numYrs), unit, "updated during clone-and-shift-firstmodelyear");
        }
        HashMap<String, List<String>> capMap = new HashMap<String, List<String>>();
        capMap.put("year_vtg", yrList);
        this.assignVarToPar("CAP_NEW", "historical_new_capacity", capMap);
        HashMap<String, List<String>> actMap = new HashMap<String, List<String>>();
        actMap.put("year_act", yrList);
        this.assignVarToPar("ACT", "historical_activity", actMap);
        this.assignVarToPar("DEMAND", "demand", yrMap);
        this.assignVarToPar("LAND", "historical_land", yrMap);
        this.assignVarToPar("GDP", "historical_gdp", yrMap);
        String sliceAnnotation = String.format("shift first model year to '%d', assign solution to historical parameters, remove solution", newFirstYear);
        if (!keepSolution) {
            for (Variable aVar : this.varList.values()) {
                aVar.removeAllElements();
            }
            for (Equation aEqu : this.equList.values()) {
                aEqu.removeAllElements();
            }
        }
        this.commit(user, sliceAnnotation);
    }

    public int getFirstModelYear() throws IxException {
        String[] catEle = this.getCatEle("year", "firstmodelyear");
        if (catEle.length == 1) {
            return Integer.parseInt(catEle[0]);
        }
        return Integer.parseInt(this.getIndexSetKeys("year")[0]);
    }

    private void getMESSAGEspecs() {
        if (!this.hasMESSAGEspecs) {
            this.reqIdxSets = MESSAGEspecs.getRequiredSetList(true);
            this.reqSets = MESSAGEspecs.getRequiredSetList();
            this.reqPars = MESSAGEspecs.getRequiredParameterList();
            this.reqVars = MESSAGEspecs.getRequiredVariableList();
            this.reqEqus = MESSAGEspecs.getRequiredEquationList();
            this.indexSetsMap = MESSAGEspecs.getIndexDimMap();
            this.indexNamesMap = MESSAGEspecs.getIndexDimMap(true);
            this.hasMESSAGEspecs = true;
        }
    }

    private boolean initializeMsgSetsParameters(boolean makeChanges) throws IxException {
        this.getMESSAGEspecs();
        boolean edits = false;
        for (String aSet : this.reqSets) {
            if (this.hasSet(aSet)) continue;
            if (makeChanges) {
                this.initializeSet(aSet);
            }
            edits = true;
        }
        for (String aPar : this.reqPars) {
            if (this.hasPar(aPar)) continue;
            if (makeChanges) {
                this.initializePar(aPar);
            }
            edits = true;
        }
        edits = this.addStandardElementToSet(edits, makeChanges, "node", "World");
        edits = this.addStandardElementToSet(edits, makeChanges, "lvl_spatial", "World");
        edits = this.addStandardElementToSet(edits, makeChanges, "lvl_spatial", "global");
        edits = this.addStandardElementToSet(edits, makeChanges, "time", "year");
        edits = this.addStandardElementToSet(edits, makeChanges, "lvl_temporal", "year");
        edits = this.addStandardElementToSet(edits, makeChanges, "map_temporal_hierarchy", "year.year.year");
        edits = this.addStandardElementToPar(edits, makeChanges, "duration_time", "year", 1.0, "%");
        edits = this.addStandardElementToSet(edits, makeChanges, "type_year", "firstmodelyear");
        edits = this.addStandardElementToSet(edits, makeChanges, "type_year", "lastmodelyear");
        edits = this.addStandardElementToSet(edits, makeChanges, "type_year", "initializeyear_macro");
        edits = this.addStandardElementToSet(edits, makeChanges, "type_node", "economy");
        edits = this.addStandardElementToSet(edits, makeChanges, "type_tec", "all");
        edits = this.addStandardElementToSet(edits, makeChanges, "rating", "firm");
        edits = this.addStandardElementToSet(edits, makeChanges, "rating", "unrated");
        edits = this.addStandardElementToSet(edits, makeChanges, "mode", "all");
        return edits;
    }

    private boolean addStandardElementToSet(boolean edits, boolean makeChanges, String name, String key) throws IxException {
        Set ixSet = this.getSet(name);
        if (ixSet.hasElement(key)) {
            return edits;
        }
        if (makeChanges) {
            ixSet.addElement(key);
        }
        return true;
    }

    private boolean addStandardElementToPar(boolean edits, boolean makeChanges, String name, String key, double value, String unit) throws IxException {
        Parameter ixPar = this.getPar(name);
        if (ixPar.hasElement(key)) {
            return edits;
        }
        if (makeChanges) {
            ixPar.addElement(key, (Double)value, unit);
        }
        return true;
    }

    private void assignMessageSetList() throws IxException {
        this.assignMessageSetList(true);
    }

    private void assignMessageSetList(boolean sanityChecks) throws IxException {
        this.getMESSAGEspecs();
        this.nodes = new TreeSet();
        for (Integer n : this.getIndexSetKeyIds("node")) {
            this.nodes.add(this.getKeyIdString(n));
        }
        this.tecs = new TreeSet();
        for (Integer n : this.getIndexSetKeyIds("technology")) {
            this.tecs.add(this.getKeyIdString(n));
        }
        this.times = new TreeSet();
        for (Integer n : this.getIndexSetKeyIds("time")) {
            this.times.add(this.getKeyIdString(n));
        }
        this.emissions = new TreeSet();
        for (Integer n : this.getIndexSetKeyIds("emission")) {
            this.emissions.add(this.getKeyIdString(n));
        }
        this.tecParList = MESSAGEspecs.getTecParameterList();
        this.tecActParList = MESSAGEspecs.getTecActParameterList();
        if (sanityChecks) {
            String[] requiredSets;
            for (String aSet : requiredSets = new String[]{"node", "technology", "year", "time"}) {
                if (!this.getIndexSetKeyIds(aSet).isEmpty()) continue;
                throw new IxException("The required set '" + aSet + "' is empty!");
            }
            ScenarioState scenarioState = this.state;
            this.state = ScenarioState.NEW;
            this.assignDisaggregationMaps();
            this.assignPeriodMaps();
            this.state = scenarioState;
        }
    }

    private void assignDisaggregationMaps() throws IxException {
        Vector<Integer> eleVector2;
        Vector<Integer> eleVector1;
        Vector<Integer> eleVector;
        log.info(" spatial and temporal disaggregation maps assignment");
        List<Integer> lvlSet = this.getIndexSetKeyIds("lvl_spatial");
        Set map_spatial = this.getSet("map_spatial_hierarchy");
        HashMap<Integer, List> nodeHierarchyMap = new HashMap<Integer, List>();
        for (int i = lvlSet.size() - 1; i >= 0; --i) {
            int lvl = lvlSet.get(i);
            for (Element ele : map_spatial.getElements()) {
                if (ele.getKeyId("lvl_spatial") != lvl) continue;
                Integer nodeParent = ele.getKeyId("node_parent");
                Integer nodeLocation = ele.getKeyId("node");
                List nodeList = nodeHierarchyMap.computeIfAbsent(nodeParent, k -> new LinkedList());
                nodeList.add(nodeParent);
                nodeList.add(nodeLocation);
                List subNodeList = (List)nodeHierarchyMap.get(nodeLocation);
                if (subNodeList == null || Objects.equals(nodeLocation, nodeParent)) continue;
                nodeList.addAll(subNodeList);
            }
        }
        Set nodeMapSet = this.getSet("map_node");
        for (Object parentNode : nodeHierarchyMap.keySet()) {
            eleVector = new Vector<Integer>();
            eleVector.add((Integer)parentNode);
            eleVector.add((Integer)parentNode);
            nodeMapSet.addElement(eleVector);
            for (Integer childNode : (List)nodeHierarchyMap.get(parentNode)) {
                eleVector1 = new Vector<Integer>();
                eleVector1.add((Integer)parentNode);
                eleVector1.add(childNode);
                nodeMapSet.addElement(eleVector1);
                eleVector2 = new Vector<Integer>();
                eleVector2.add(childNode);
                eleVector2.add(childNode);
                nodeMapSet.addElement(eleVector2);
            }
        }
        lvlSet = this.getIndexSetKeyIds("lvl_temporal");
        Set mapSet = this.getSet("map_temporal_hierarchy");
        HashMap<Integer, List> timeHierarchyMap = new HashMap<Integer, List>();
        for (int i = lvlSet.size() - 1; i >= 0; --i) {
            int lvl = lvlSet.get(i);
            for (Element ele : mapSet.getElements()) {
                if (ele.getKeyId("lvl_temporal") != lvl) continue;
                Integer timeParent = ele.getKeyId("time_parent");
                Integer timeActual = ele.getKeyId("time");
                List timeList = timeHierarchyMap.computeIfAbsent(timeParent, k -> new LinkedList());
                timeList.add(timeParent);
                timeList.add(timeActual);
                List subTimeList = (List)timeHierarchyMap.get(timeActual);
                if (subTimeList == null || Objects.equals(timeParent, timeActual)) continue;
                timeList.addAll(subTimeList);
            }
        }
        Set timeMapSet = this.getSet("map_time");
        for (Integer parentTime : timeHierarchyMap.keySet()) {
            eleVector = new Vector();
            eleVector.add(parentTime);
            eleVector.add(parentTime);
            timeMapSet.addElement(eleVector);
            for (Integer childTime : (List)timeHierarchyMap.get(parentTime)) {
                eleVector1 = new Vector();
                eleVector1.add(parentTime);
                eleVector1.add(childTime);
                timeMapSet.addElement(eleVector1);
                eleVector2 = new Vector();
                eleVector2.add(childTime);
                eleVector2.add(childTime);
                timeMapSet.addElement(eleVector2);
            }
        }
    }

    private void assignPeriodMaps() throws IxException {
        log.info(" period mapping assignment");
        Set catTypeYearSet = this.getSet("type_year");
        Set aCatYearSet = this.getSet("cat_year");
        catTypeYearSet.addElement("cumulative");
        Integer fModelYear = null;
        for (Element ele : aCatYearSet.getElements()) {
            if (!ele.checkKeyAtIndex("type_year", (Integer)this.addKey("firstmodelyear"))) continue;
            fModelYear = Integer.parseInt(this.getKeyIdString(ele.getKeyId("year")));
        }
        this.getYearList();
        for (Integer aYr : this.years) {
            if (fModelYear != null && fModelYear > aYr) continue;
            catTypeYearSet.addElement("" + aYr);
            aCatYearSet.addElement("cumulative." + aYr);
            aCatYearSet.addElement(aYr + "." + aYr);
        }
        log.info(" duration period assignment");
        Parameter duration_period = this.getPar("duration_period");
        for (int i = 1; i < this.years.size(); ++i) {
            int dur = this.years.get(i) - this.years.get(i - 1);
            duration_period.addElement("" + this.years.get(i), Double.valueOf(dur), "y");
        }
        if (this.years.size() > 1) {
            duration_period.addElement("" + this.years.get(0), Double.valueOf(this.years.get(1) - this.years.get(0)), "y");
        } else {
            duration_period.addElement("" + this.years.get(0), (Double)1.0, "y");
        }
    }

    public List<Integer> getYearList() throws IxException {
        if (this.years == null || this.getSet((String)"year").hasUpdatedElement) {
            this.years = new LinkedList<Integer>();
            for (Integer eleId : this.getIndexSetKeyIds("year")) {
                this.years.add(Integer.valueOf(this.getKeyIdString(eleId)));
            }
        }
        return this.years;
    }

    public String[] getTypeList(String name) throws IxException {
        return this.getTypeSet(name).getIndexSetKeys();
    }

    public void addCatEle(String name, String cat, List<String> keyList, boolean isUnique) throws IxException {
        Set typeSet;
        this.assertTimeSeriesIsEditable(false);
        int pCatId = this.addKey(cat);
        Set catSet = this.getCatSet(name);
        if (name.equals("addon")) {
            typeSet = this.getSet("type_addon");
            if (!typeSet.hasElement(cat)) {
                typeSet.addElement(cat);
                log.info(String.format("added the category type '%s' for set '%s'", cat, name));
            }
        } else {
            typeSet = this.getTypeSet(name);
            if (!((IndexSet)typeSet).hasIndexSetKey(pCatId)) {
                ((IndexSet)typeSet).addElement(pCatId);
                log.info(String.format("added the category type '%s' for set '%s'", cat, name));
            }
        }
        if (isUnique) {
            if (cat.equals("all")) {
                throw new IxException("the category mapping 'all' cannot be a singleton!");
            }
            if (keyList.size() > 1) {
                throw new IxException("only add one element to a unique mapping!");
            }
            HashMap<Integer, List<Integer>> eleFilter = new HashMap<Integer, List<Integer>>();
            LinkedList<Integer> catIdList = new LinkedList<Integer>();
            catIdList.add(pCatId);
            eleFilter.put(0, catIdList);
            for (Element ele : catSet.filteredEleList(eleFilter)) {
                catSet.removeElement(ele);
            }
        }
        for (String aKey : keyList) {
            int pKeyId = this.getKeyId(aKey);
            if (name.equals("addon")) {
                this.getIndexSet("technology").checkIndexSetKey(pKeyId);
            } else {
                this.getIndexSet(name).checkIndexSetKey(pKeyId);
            }
            Vector<Integer> catVector = catSet.getNewVector();
            catVector.add(pCatId);
            catVector.add(pKeyId);
            catSet.addElement(catVector);
        }
    }

    @Override
    public String[] getCatEle(String name, String category) throws IxException {
        if (category.equals("all")) {
            return this.getIndexSet(name).getIndexSetKeys();
        }
        int categoryId = this.getKeyId(category);
        IndexSet typeSet = this.getTypeSet(name);
        Set catSet = this.getCatSet(name);
        typeSet.checkIndexSetKey(categoryId);
        HashMap<Integer, List<Integer>> eleFilter = new HashMap<Integer, List<Integer>>();
        LinkedList<Integer> catIdList = new LinkedList<Integer>();
        catIdList.add(categoryId);
        eleFilter.put(0, catIdList);
        return catSet.getCol(1, catSet.filteredEleList(eleFilter));
    }

    private IndexSet getTypeSet(String name) throws IxException {
        if (name.equals("technology")) {
            return this.getIndexSet("type_tec");
        }
        return this.getIndexSet("type_" + name);
    }

    private Set getCatSet(String name) throws IxException {
        if (name.equals("technology")) {
            return this.getSet("cat_tec");
        }
        return this.getSet("cat_" + name);
    }

    public int[] getTecActYrs(String node, String tec, String yearVintage) throws IxException {
        Parameter duration_period = this.getPar("duration_period");
        Parameter lifetime = this.getPar("technical_lifetime");
        Double lt = lifetime.getEleValue(this.getKeyIdVector(node, tec, yearVintage));
        double elapsedLt = 0.0;
        Integer aVtg = Integer.parseInt(yearVintage);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (Integer aYr : this.getYearList()) {
            if (aYr < aVtg) continue;
            ret.add(aYr);
            String[] stringArray = new String[]{aYr.toString()};
            if (!((elapsedLt += duration_period.getEleValue(this.getKeyIdVector(stringArray)).doubleValue()) >= lt)) continue;
            break;
        }
        return Arrays.stream(ret.toArray(new Integer[0])).mapToInt(Integer::intValue).toArray();
    }

    public Set initializeSet(String setName) throws IxException {
        if (this.hasItem(setName)) {
            throw new IxException(String.format("An item with the name '%s' already exists!", setName));
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.containsKey(setName)) {
            throw new IxException(String.format("There are no standard MESSAGE index assignments for set '%s'!", setName));
        }
        Set aSet = this.indexSetsMap.get(setName).isEmpty() ? new IndexSet(this.getMp(), this, setName) : new Set(this.getMp(), this, setName, this.indexSetsMap.get(setName), this.indexNamesMap.get(setName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aSet);
            this.changeLogList.add(new ChangelogEntry("initialize set", setName));
        }
        return aSet;
    }

    @Override
    public Set initializeSet(String setName, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.indexSetsMap.containsKey(setName)) {
            if (this.hasItem(setName)) {
                throw new IxException(String.format("An item with the name '%s' already exists!", setName));
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException(String.format("Set '%s' can only be initialized with MESSAGE standard dimensions!", setName));
            }
            return this.initializeSet(setName);
        }
        return super.initializeSet(setName, indexSets, indexNames);
    }

    public String[] getParList(String type, boolean excludeRelation) throws IxException {
        LinkedList<String> ret = new LinkedList<String>();
        switch (type) {
            case "technology": {
                for (String aPar : this.tecParList) {
                    if (excludeRelation && aPar.contains("relation")) continue;
                    ret.add(aPar);
                }
                for (String aPar : this.tecActParList) {
                    if (excludeRelation && aPar.contains("relation")) continue;
                    ret.add(aPar);
                }
                break;
            }
            case "relations": {
                if (excludeRelation) {
                    throw new IxException("Querying for relations excluding relations doesn't make sense!");
                }
                for (Parameter aPar : this.parList.values()) {
                    if (!aPar.getName().contains("relation")) continue;
                    ret.add(aPar.getName());
                }
                break;
            }
            default: {
                throw new IxException("This function is currently only available for parameters pertaining to technologies and relations!");
            }
        }
        return ret.toArray(new String[0]);
    }

    public Parameter initializePar(String parName) throws IxException {
        if (this.hasItem(parName)) {
            throw new IxException("An item with the name '" + parName + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.containsKey(parName)) {
            throw new IxException("There are no standard MESSAGE index assignments for parameter '" + parName + "'!");
        }
        Parameter aPar = new Parameter(this.getMp(), this, parName, this.indexSetsMap.get(parName), this.indexNamesMap.get(parName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aPar);
            this.changeLogList.add(new ChangelogEntry("initialize parameter", parName));
        }
        return aPar;
    }

    @Override
    public Parameter initializePar(String parName, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.indexSetsMap.containsKey(parName)) {
            if (this.hasItem(parName)) {
                throw new IxException(String.format("An item with the name '%s' already exists!", parName));
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException(String.format("Parameter '%s' can only be initialized with MESSAGE standard dimensions!", parName));
            }
            return this.initializePar(parName);
        }
        return super.initializePar(parName, indexSets, indexNames);
    }

    public Variable initializeVar(String varName) throws IxException {
        if (this.hasItem(varName)) {
            throw new IxException(String.format("An item with the name '%s' already exists!", varName));
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.containsKey(varName)) {
            throw new IxException(String.format("There are no standard MESSAGE index assignments for variable '%s'!", varName));
        }
        Variable aVar = new Variable(this.getMp(), this, varName, this.indexSetsMap.get(varName), this.indexNamesMap.get(varName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aVar);
            this.changeLogList.add(new ChangelogEntry("initialize variable", varName));
        }
        return aVar;
    }

    @Override
    public Variable initializeVar(String varName, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.indexSetsMap.containsKey(varName)) {
            if (this.hasItem(varName)) {
                throw new IxException(String.format("An item with the name '%s' already exists!", varName));
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException(String.format("Variable '%s' can only be initialized with MESSAGE standard dimensions!", varName));
            }
            return this.initializeVar(varName);
        }
        return super.initializeVar(varName, indexSets, indexNames);
    }

    public Equation initializeEqu(String equName) throws IxException {
        if (this.hasItem(equName)) {
            throw new IxException(String.format("An item with the name '%s' already exists!", equName));
        }
        this.assertTimeSeriesIsEditable(false);
        this.getMESSAGEspecs();
        if (!this.indexSetsMap.containsKey(equName)) {
            throw new IxException(String.format("There are no standard MESSAGE index assignments for equation '%s'!", equName));
        }
        Equation aEqu = new Equation(this.getMp(), this, equName, this.indexSetsMap.get(equName), this.indexNamesMap.get(equName), "MESSAGE");
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aEqu);
            this.changeLogList.add(new ChangelogEntry("initialize variable", equName));
        }
        return aEqu;
    }

    @Override
    public Equation initializeEqu(String equName, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.indexSetsMap.containsKey(equName)) {
            if (this.hasItem(equName)) {
                throw new IxException(String.format("An item with the name '%s' already exists!", equName));
            }
            if (indexSets != null || indexNames != null) {
                throw new IxException(String.format("Equation '%s' can only be initialized with MESSAGE standard dimensions!", equName));
            }
            return this.initializeEqu(equName);
        }
        return super.initializeEqu(equName, indexSets, indexNames);
    }

    public Map<Vector<Integer>, Double> assignVarToPar(String varName, String parName, Map<String, List<String>> eleListFilter) throws IxException {
        Variable var = this.getVar(varName);
        var.loadItemElementsFromDB();
        List<Element> eleList = var.getElements(eleListFilter);
        Parameter par = this.getPar(parName);
        par.loadItemElementsFromDB();
        HashMap<Integer, Integer> idxMap = new HashMap<Integer, Integer>();
        int i = 0;
        for (String parIdx : par.idxNames) {
            idxMap.put((Integer)var.nameIdxMap.get(parIdx), i);
            ++i;
        }
        HashMap<Vector<Integer>, Double> newEleList = new HashMap<Vector<Integer>, Double>();
        for (Element element : eleList) {
            double val;
            Vector<Integer> newEle = new Vector<Integer>();
            for (int j = 0; j < par.dim; ++j) {
                newEle.add(-1);
            }
            for (Map.Entry entry : idxMap.entrySet()) {
                newEle.set((Integer)entry.getValue(), element.getKeyId((Integer)entry.getKey()));
            }
            if (newEleList.containsKey(newEle)) {
                val = (Double)newEleList.get(newEle);
                val += element.getLevel().doubleValue();
            } else {
                val = element.getLevel();
            }
            newEleList.put(newEle, val);
        }
        for (Map.Entry entry : newEleList.entrySet()) {
            par.addElement((Vector)entry.getKey(), (Double)entry.getValue(), "???", (String)null);
        }
        return newEleList;
    }

    @Override
    public void readSolutionFromGDX(String gamsPath, String gamsGdxFile, String comment, List<String> varList, List<String> equList, boolean checkSolution) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.readSolutionFromGDX(osUser, gamsPath, gamsGdxFile, comment, varList, equList, checkSolution);
    }

    @Override
    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, List<String> varList, List<String> equList, boolean checkSolution) throws IxException {
        GAMSParameter status;
        this.assertTimeseriesIsLockedInDB();
        this.checkSolution();
        this.getMESSAGEspecs();
        LinkedList<String> importVarList = new LinkedList<String>();
        LinkedList<String> importEquList = new LinkedList<String>();
        this.checkOut(user, false);
        for (String aSet : this.reqIdxSets) {
            if (this.hasSet(aSet)) continue;
            this.initializeSet(aSet);
        }
        for (String aVarName : this.reqVars) {
            if (!this.hasVar(aVarName)) {
                this.initializeVar(aVarName);
            }
            importVarList.add(aVarName);
        }
        for (String aEquName : this.reqEqus) {
            if (!this.hasEqu(aEquName)) {
                this.initializeEqu(aEquName);
            }
            importEquList.add(aEquName);
        }
        if (!this.newItemList.isEmpty()) {
            this.commit(user, "initializing variables and equations required for MESSAGE scheme");
        } else {
            this.checkIn(null);
        }
        if (varList != null && !varList.isEmpty()) {
            for (String aVarName : varList) {
                if (importVarList.contains(aVarName)) continue;
                importVarList.add(aVarName);
            }
        }
        if (equList != null && !equList.isEmpty()) {
            for (String aEquName : equList) {
                if (importEquList.contains(aEquName)) continue;
                importEquList.add(aEquName);
            }
        }
        boolean solNonOpt = false;
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase gamsDB = ws.addDatabaseFromGDX(gamsGdxFile);
        try {
            status = gamsDB.getParameter("status");
        }
        catch (GAMSException e) {
            this.discardChanges();
            throw new IxException("no parameter 'status' in the gdx file, did not import the solution!");
        }
        for (GAMSParameterRecord rec : status) {
            if (rec.getKeys()[1].equals("modelstat") && rec.getValue() != 1.0) {
                solNonOpt = true;
                continue;
            }
            if (!rec.getKeys()[1].equals("solvestat") || !(rec.getValue() > 2.0) || rec.getValue() == 8.0) continue;
            solNonOpt = true;
        }
        if (solNonOpt) {
            if (checkSolution) {
                this.discardChanges();
                throw new IxException("MESSAGEix model did not solve to optimality, did not import the solution!");
            }
            log.error("WARNING - you are importing a non-optimal solution of a MESSAGEix run!");
        }
        super.readSolFromGDX(gamsPath, gamsGdxFile, comment, importVarList, importEquList);
    }

    @Override
    public void checkOut(String user, boolean timeseriesOnly, boolean checkSolution) throws IxException {
        boolean updated;
        super.checkOut(user, timeseriesOnly, checkSolution);
        if (!timeseriesOnly && (updated = this.initializeMsgSetsParameters(true))) {
            this.commit(String.format("updating MsgScenario to MESSAGE specifications version %s", MESSAGEspecs.getMsgVersion()));
            super.checkOut(user, timeseriesOnly, checkSolution);
        }
    }

    @Override
    public void commit(String annotation) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.commit(user, annotation);
    }

    @Override
    public void commit(String user, String annotation) throws IxException {
        this.assignMessageSetList();
        super.commit(user, annotation);
    }

    @Override
    public void toGDX(String gamsPath, String gamsGdxFile) throws IxException {
        this.toGDX(gamsPath, gamsGdxFile, false);
    }

    @Override
    public void toGDX(String gamsPath, String gamsGdxFile, boolean includeVarEqu) throws IxException {
        this.assertTimeseriesIsLockedInDB();
        this.assignMessageSetList();
        this.state = ScenarioState.NEW;
        this.initializeMsgSetsParameters(true);
        log.info("writing data to gdx...");
        GAMSDatabase gamsDB = this.makeGamsDB(gamsPath);
        this.getMESSAGEspecs();
        HashMap<String, Integer> msgVersion = MESSAGEspecs.getMsgVersion();
        HashMap<String, Integer> msgItemDefaultDim = MESSAGEspecs.getItemDefaultDim();
        GAMSParameter ixVersion = gamsDB.addParameter("MESSAGE_ix_version", 1);
        String[] versionNumTypes = new String[]{"major", "minor"};
        for (String aType : versionNumTypes) {
            Vector<String> vd = new Vector<String>();
            vd.add(aType);
            ((GAMSParameterRecord)ixVersion.addRecord(vd)).setValue((double)((Integer)msgVersion.get(aType)).intValue());
        }
        this.logMemStats("Writing sets...");
        this.writeSetsToGDX(gamsDB);
        this.logMemStats("Writing mapping sets...");
        this.writeMappingSetsToGDX(gamsDB);
        for (String name : this.reqSets) {
            if (this.hasSet(name)) continue;
            gamsDB.addSet(name, ((Integer)msgItemDefaultDim.get(name)).intValue());
        }
        this.logMemStats("Writing parameters...");
        this.writeParametersToGDX(gamsDB);
        if (includeVarEqu) {
            this.logMemStats("Writing variables...");
            this.writeVariablesToGDX(gamsDB);
            this.logMemStats("Writing equations...");
            this.writeEquationsToGDX(gamsDB);
        }
        this.logMemStats("Exporting...");
        gamsDB.export(gamsGdxFile);
        this.loadScenFromDB(this.runId);
        this.checkIn(null);
        log.info("done writing data to gdx!");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void writeParametersToGDX(GAMSDatabase gamsDB) throws IxException {
        resources = new HashSet<String>();
        renewables = new HashSet<String>();
        resGradeMap = new HashMap<Vector<String>, LinkedList<String>>();
        stocks = new HashSet<String>();
        for (Element ele : this.getSet("level_resource").getElements()) {
            resources.add(ele.getKey(0));
        }
        for (Element ele : this.getSet("level_renewable").getElements()) {
            renewables.add(ele.getKey(0));
        }
        for (Element ele : this.getSet("level_stocks").getElements()) {
            stocks.add(ele.getKey(0));
        }
        map_resource = gamsDB.addSet("map_resource", 4);
        map_stocks = gamsDB.addSet("map_stocks", 4);
        map_commodity = gamsDB.addSet("map_commodity", 5);
        map_tec = gamsDB.addSet("map_tec", 3);
        map_tec_mode = gamsDB.addSet("map_tec_mode", 4);
        map_tec_time = gamsDB.addSet("map_tec_time", 4);
        map_relation = gamsDB.addSet("map_relation", 3);
        map_land = gamsDB.addSet("map_land", 3);
        inv_tec = gamsDB.addSet("inv_tec", 1);
        renewable_tec = gamsDB.addSet("renewable_tec", 1);
        is_bound_extraction_up = gamsDB.addSet("is_bound_extraction_up", 4);
        is_bound_new_capacity_up = gamsDB.addSet("is_bound_new_capacity_up", 3);
        is_bound_new_capacity_lo = gamsDB.addSet("is_bound_new_capacity_lo", 3);
        is_bound_total_capacity_up = gamsDB.addSet("is_bound_total_capacity_up", 3);
        is_bound_total_capacity_lo = gamsDB.addSet("is_bound_total_capacity_lo", 3);
        is_bound_activity_up = gamsDB.addSet("is_bound_activity_up", 5);
        is_dynamic_new_capacity_up = gamsDB.addSet("is_dynamic_new_capacity_up", 3);
        is_dynamic_new_capacity_lo = gamsDB.addSet("is_dynamic_new_capacity_lo", 3);
        is_dynamic_activity_up = gamsDB.addSet("is_dynamic_activity_up", 4);
        is_dynamic_activity_lo = gamsDB.addSet("is_dynamic_activity_lo", 4);
        is_bound_emission = gamsDB.addSet("is_bound_emission", 4);
        is_dynamic_land_scen_up = gamsDB.addSet("is_dynamic_land_scen_up", 3);
        is_dynamic_land_scen_lo = gamsDB.addSet("is_dynamic_land_scen_lo", 3);
        is_dynamic_land_up = gamsDB.addSet("is_dynamic_land_up", 3);
        is_dynamic_land_lo = gamsDB.addSet("is_dynamic_land_lo", 3);
        is_relation_upper = gamsDB.addSet("is_relation_upper", 3);
        is_relation_lower = gamsDB.addSet("is_relation_lower", 3);
        is_fixed_extraction = gamsDB.addSet("is_fixed_extraction", 4);
        is_fixed_stock = gamsDB.addSet("is_fixed_stock", 4);
        is_fixed_new_capacity = gamsDB.addSet("is_fixed_new_capacity", 3);
        is_fixed_capacity = gamsDB.addSet("is_fixed_capacity", 4);
        is_fixed_activity = gamsDB.addSet("is_fixed_activity", 6);
        is_fixed_land = gamsDB.addSet("is_fixed_land", 3);
        for (Parameter par : this.parList.values()) {
            name = par.name;
            this.logMemStats(String.format("Writing parameter [%s]...", new Object[]{name}));
            gamsPar = gamsDB.addParameter(name, par.dim.intValue());
            clearCache = par.loadItemElementsFromDB();
            if (par.dim == 0) {
                ((GAMSParameterRecord)gamsPar.addRecord(new Vector<E>())).setValue(par.getScalarValue().doubleValue());
            } else {
                elements = par.getElements();
                MsgScenario.log.debug(String.format("Parameter [%s]: elements %d", new Object[]{name, elements.size()}));
lbl60:
                // 44 sources

                block98: for (Element ele : elements) {
                    vd = this.getStringVector(ele.getVector());
                    try {
                        ((GAMSParameterRecord)gamsPar.addRecord(vd)).setValue(ele.getValue().doubleValue());
                        var48_48 = name;
                        var49_50 = -1;
                        switch (var48_48.hashCode()) {
                            case -1335432629: {
                                if (!var48_48.equals("demand")) break;
                                var49_50 = 0;
                                break;
                            }
                            case 867898475: {
                                if (!var48_48.equals("resource_volume")) break;
                                var49_50 = 1;
                                break;
                            }
                            case 100358090: {
                                if (!var48_48.equals("input")) break;
                                var49_50 = 2;
                                break;
                            }
                            case -1005512447: {
                                if (!var48_48.equals("output")) break;
                                var49_50 = 3;
                                break;
                            }
                            case 1913125340: {
                                if (!var48_48.equals("relation_new_capacity")) break;
                                var49_50 = 4;
                                break;
                            }
                            case -62286856: {
                                if (!var48_48.equals("relation_total_capacity")) break;
                                var49_50 = 5;
                                break;
                            }
                            case -865032718: {
                                if (!var48_48.equals("relation_activity")) break;
                                var49_50 = 6;
                                break;
                            }
                            case 621682523: {
                                if (!var48_48.equals("inv_cost")) break;
                                var49_50 = 7;
                                break;
                            }
                            case -1393832718: {
                                if (!var48_48.equals("bound_extraction_up")) break;
                                var49_50 = 8;
                                break;
                            }
                            case -289876128: {
                                if (!var48_48.equals("bound_new_capacity_up")) break;
                                var49_50 = 9;
                                break;
                            }
                            case -289876408: {
                                if (!var48_48.equals("bound_new_capacity_lo")) break;
                                var49_50 = 10;
                                break;
                            }
                            case -61546684: {
                                if (!var48_48.equals("bound_total_capacity_up")) break;
                                var49_50 = 11;
                                break;
                            }
                            case -61546964: {
                                if (!var48_48.equals("bound_total_capacity_lo")) break;
                                var49_50 = 12;
                                break;
                            }
                            case -1656177526: {
                                if (!var48_48.equals("bound_activity_up")) break;
                                var49_50 = 13;
                                break;
                            }
                            case -288839386: {
                                if (!var48_48.equals("initial_new_capacity_up")) break;
                                var49_50 = 14;
                                break;
                            }
                            case 1367199145: {
                                if (!var48_48.equals("growth_new_capacity_up")) break;
                                var49_50 = 15;
                                break;
                            }
                            case -288839666: {
                                if (!var48_48.equals("initial_new_capacity_lo")) break;
                                var49_50 = 16;
                                break;
                            }
                            case 1367198865: {
                                if (!var48_48.equals("growth_new_capacity_lo")) break;
                                var49_50 = 17;
                                break;
                            }
                            case -790339248: {
                                if (!var48_48.equals("initial_activity_up")) break;
                                var49_50 = 18;
                                break;
                            }
                            case 2005811027: {
                                if (!var48_48.equals("growth_activity_up")) break;
                                var49_50 = 19;
                                break;
                            }
                            case -790339528: {
                                if (!var48_48.equals("initial_activity_lo")) break;
                                var49_50 = 20;
                                break;
                            }
                            case 2005810747: {
                                if (!var48_48.equals("growth_activity_lo")) break;
                                var49_50 = 21;
                                break;
                            }
                            case 232192808: {
                                if (!var48_48.equals("bound_emission")) break;
                                var49_50 = 22;
                                break;
                            }
                            case 1412190625: {
                                if (!var48_48.equals("land_cost")) break;
                                var49_50 = 23;
                                break;
                            }
                            case 833745014: {
                                if (!var48_48.equals("land_input")) break;
                                var49_50 = 24;
                                break;
                            }
                            case 254645717: {
                                if (!var48_48.equals("land_output")) break;
                                var49_50 = 25;
                                break;
                            }
                            case 1964981352: {
                                if (!var48_48.equals("initial_land_scen_up")) break;
                                var49_50 = 26;
                                break;
                            }
                            case -1548673339: {
                                if (!var48_48.equals("growth_land_scen_up")) break;
                                var49_50 = 27;
                                break;
                            }
                            case 1964981072: {
                                if (!var48_48.equals("initial_land_scen_lo")) break;
                                var49_50 = 28;
                                break;
                            }
                            case -1548673619: {
                                if (!var48_48.equals("growth_land_scen_lo")) break;
                                var49_50 = 29;
                                break;
                            }
                            case -260337804: {
                                if (!var48_48.equals("initial_land_up")) break;
                                var49_50 = 30;
                                break;
                            }
                            case -1181717137: {
                                if (!var48_48.equals("dynamic_land_up")) break;
                                var49_50 = 31;
                                break;
                            }
                            case 426960631: {
                                if (!var48_48.equals("growth_land_up")) break;
                                var49_50 = 32;
                                break;
                            }
                            case -260338084: {
                                if (!var48_48.equals("initial_land_lo")) break;
                                var49_50 = 33;
                                break;
                            }
                            case -1181717417: {
                                if (!var48_48.equals("dynamic_land_lo")) break;
                                var49_50 = 34;
                                break;
                            }
                            case 426960351: {
                                if (!var48_48.equals("growth_land_lo")) break;
                                var49_50 = 35;
                                break;
                            }
                            case 1203325087: {
                                if (!var48_48.equals("relation_upper")) break;
                                var49_50 = 36;
                                break;
                            }
                            case 1194990334: {
                                if (!var48_48.equals("relation_lower")) break;
                                var49_50 = 37;
                                break;
                            }
                            case 601087378: {
                                if (!var48_48.equals("fixed_extraction")) break;
                                var49_50 = 38;
                                break;
                            }
                            case 1405082251: {
                                if (!var48_48.equals("fixed_stock")) break;
                                var49_50 = 39;
                                break;
                            }
                            case -250826908: {
                                if (!var48_48.equals("fixed_new_capacity")) break;
                                var49_50 = 40;
                                break;
                            }
                            case -1717141211: {
                                if (!var48_48.equals("fixed_capacity")) break;
                                var49_50 = 41;
                                break;
                            }
                            case 989683578: {
                                if (!var48_48.equals("fixed_activity")) break;
                                var49_50 = 42;
                                break;
                            }
                            case 1707666390: {
                                if (!var48_48.equals("fixed_land")) break;
                                var49_50 = 43;
                            }
                        }
                        switch (var49_50) {
                            case 0: {
                                this.addToMappingSet((GAMSSymbol)map_commodity, vd);
                                ** break;
                            }
                            case 1: {
                                nodeCom = this.getSubVector(vd, new int[]{0, 1});
                                gradeList = (LinkedList<String>)resGradeMap.get(nodeCom);
                                if (gradeList == null) {
                                    gradeList = new LinkedList<String>();
                                }
                                gradeList.add(vd.get(2));
                                resGradeMap.put(nodeCom, (LinkedList<String>)gradeList);
                                ** break;
                            }
                            case 2: 
                            case 3: {
                                this.addToMappingSet((GAMSSymbol)map_commodity, this.getSubVector(vd, new int[]{5, 6, 7, 3, 9}));
                                if (stocks.contains(vd.get(7))) {
                                    this.addToMappingSet((GAMSSymbol)map_stocks, this.getSubVector(vd, new int[]{0, 6, 7, 3}));
                                }
                                if (name.equals("input") && resources.contains(vd.get(7))) {
                                    resVd = this.getSubVector(vd, new int[]{0, 6});
                                    gradeList = (List)resGradeMap.get(resVd);
                                    if (gradeList == null) {
                                        throw new IxException(String.format(" the resource-commodity '%s' at node '%s' does not have a resource volume assigned for any grade!", new Object[]{vd.get(7), vd.get(0)}));
                                    }
                                    resVd.add((String)gradeList.get(0));
                                    resVd.add(vd.get(3));
                                    for (String aGrd : gradeList) {
                                        resVd.set(2, aGrd);
                                        this.addToMappingSet((GAMSSymbol)map_resource, resVd);
                                    }
                                }
                                if (name.equals("input") && renewables.contains(vd.get(7))) {
                                    this.addToMappingSet((GAMSSymbol)renewable_tec, this.getSubVector(vd, new int[]{1}));
                                }
                                this.addToMappingSet((GAMSSymbol)map_tec, this.getSubVector(vd, new int[]{0, 1, 3}));
                                this.addToMappingSet((GAMSSymbol)map_tec_mode, this.getSubVector(vd, new int[]{0, 1, 3, 4}));
                                this.addToMappingSet((GAMSSymbol)map_tec_time, this.getSubVector(vd, new int[]{0, 1, 3, 8}));
                                ** break;
                            }
                            case 4: 
                            case 5: {
                                this.addToMappingSet((GAMSSymbol)map_relation, this.getSubVector(vd, new int[]{0, 1, 2}));
                                this.addToMappingSet((GAMSSymbol)map_tec, this.getSubVector(vd, new int[]{1, 3, 2}));
                                ** break;
                            }
                            case 6: {
                                this.addToMappingSet((GAMSSymbol)map_relation, this.getTecVector(vd));
                                vdTec = this.getSubVector(vd, new int[]{3, 4, 5});
                                this.addToMappingSet((GAMSSymbol)map_tec, vdTec);
                                vdTec.add(vd.get(6));
                                this.addToMappingSet((GAMSSymbol)map_tec_mode, vdTec);
                                vdTec.set(3, "year");
                                this.addToMappingSet((GAMSSymbol)map_tec_time, vdTec);
                                ** break;
                            }
                            case 7: {
                                this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd, new int[]{1}));
                                ** break;
                            }
                            case 8: {
                                is_bound_extraction_up.addRecord(vd);
                                ** break;
                            }
                            case 9: {
                                is_bound_new_capacity_up.addRecord(vd);
                                this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd, new int[]{1}));
                                ** break;
                            }
                            case 10: {
                                is_bound_new_capacity_lo.addRecord(vd);
                                this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd, new int[]{1}));
                                ** break;
                            }
                            case 11: {
                                is_bound_total_capacity_up.addRecord(vd);
                                this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd, new int[]{1}));
                                ** break;
                            }
                            case 12: {
                                is_bound_total_capacity_lo.addRecord(vd);
                                this.addToMappingSet((GAMSSymbol)inv_tec, this.getSubVector(vd, new int[]{1}));
                                ** break;
                            }
                            case 13: {
                                is_bound_activity_up.addRecord(vd);
                                ** break;
                            }
                            case 14: {
                                is_dynamic_new_capacity_up.addRecord(vd);
                                ** break;
                            }
                            case 15: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_new_capacity_up, vd);
                                ** break;
                            }
                            case 16: {
                                is_dynamic_new_capacity_lo.addRecord(vd);
                                ** break;
                            }
                            case 17: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_new_capacity_lo, vd);
                                ** break;
                            }
                            case 18: {
                                is_dynamic_activity_up.addRecord(vd);
                                ** break;
                            }
                            case 19: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_activity_up, vd);
                                ** break;
                            }
                            case 20: {
                                is_dynamic_activity_lo.addRecord(vd);
                                ** break;
                            }
                            case 21: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_activity_lo, vd);
                                ** break;
                            }
                            case 22: {
                                is_bound_emission.addRecord(vd);
                                ** break;
                            }
                            case 23: {
                                this.addToMappingSet((GAMSSymbol)map_land, vd);
                                ** break;
                            }
                            case 24: 
                            case 25: {
                                this.addToMappingSet((GAMSSymbol)map_land, this.getSubVector(vd, new int[]{0, 1, 2}));
                                ** break;
                            }
                            case 26: {
                                is_dynamic_land_scen_up.addRecord(vd);
                                ** break;
                            }
                            case 27: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_scen_up, vd);
                                ** break;
                            }
                            case 28: {
                                is_dynamic_land_scen_lo.addRecord(vd);
                                ** break;
                            }
                            case 29: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_scen_lo, vd);
                                ** break;
                            }
                            case 30: {
                                is_dynamic_land_up.addRecord(vd);
                                ** break;
                            }
                            case 31: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_up, this.getSubVector(vd, new int[]{0, 2, 3}));
                                ** break;
                            }
                            case 32: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_up, vd);
                                ** break;
                            }
                            case 33: {
                                is_dynamic_land_lo.addRecord(vd);
                                ** break;
                            }
                            case 34: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_lo, this.getSubVector(vd, new int[]{0, 2, 3}));
                                ** break;
                            }
                            case 35: {
                                this.addToMappingSet((GAMSSymbol)is_dynamic_land_lo, vd);
                                ** break;
                            }
                            case 36: {
                                is_relation_upper.addRecord(vd);
                                ** break;
                            }
                            case 37: {
                                is_relation_lower.addRecord(vd);
                                ** break;
                            }
                            case 38: {
                                is_fixed_extraction.addRecord(vd);
                                ** break;
                            }
                            case 39: {
                                is_fixed_stock.addRecord(vd);
                                ** break;
                            }
                            case 40: {
                                is_fixed_new_capacity.addRecord(vd);
                                ** break;
                            }
                            case 41: {
                                is_fixed_capacity.addRecord(vd);
                                ** break;
                            }
                            case 42: {
                                is_fixed_activity.addRecord(vd);
                                ** break;
                            }
                            case 43: {
                                is_fixed_land.addRecord(vd);
                                this.addToMappingSet((GAMSSymbol)map_land, vd);
                                continue block98;
                            }
                            ** default:
lbl432:
                            // 1 sources

                            continue block98;
                        }
                    }
                    catch (GAMSException e) {
                        message = String.format("error writing parameter '%s' to gdx!", new Object[]{name});
                        MsgScenario.log.error(message, (Throwable)e);
                        throw new IxException(message);
                    }
                    finally {
                        this.state = ScenarioState.DEFAULT;
                    }
                }
            }
            if (!clearCache) continue;
            par.clearCache();
        }
    }

    @Override
    protected void writeMappingSetsToGDX(GAMSDatabase gamsDB) throws IxException {
        super.writeMappingSetsToGDX(gamsDB);
        block12: for (Set set : this.setList.values()) {
            GAMSSet gamsSet = gamsDB.getSet(set.name);
            switch (set.name) {
                case "cat_tec": {
                    for (String ele : this.tecs) {
                        try {
                            Vector<String> vd = new Vector<String>();
                            vd.add("all");
                            vd.add(ele);
                            gamsSet.addRecord(vd);
                        }
                        catch (GAMSException e) {
                            String message = "error writing category 'all' of set 'cat_tec' to gdx!";
                            log.error(message, (Throwable)e);
                            throw new IxException(message, e);
                        }
                    }
                    continue block12;
                }
                case "type_tec_land": {
                    try {
                        Vector<String> vd = new Vector<String>();
                        vd.add("all");
                        gamsSet.addRecord(vd);
                        break;
                    }
                    catch (GAMSException e) {
                        String message = "error writing category 'all' of set 'type_tec_land' to gdx!";
                        log.error(message, (Throwable)e);
                        throw new IxException(message, e);
                    }
                }
            }
        }
    }

    private void addToMappingSet(GAMSSymbol gamsItem, Vector<String> vector) {
        String[] list = vector.toArray(new String[0]);
        try {
            gamsItem.findRecord(list);
        }
        catch (GAMSException e) {
            gamsItem.addRecord(vector);
        }
    }

    private Vector<String> getSubVector(Vector<String> vd, int ... idx) {
        Vector<String> retval = new Vector<String>();
        for (int i : idx) {
            retval.add(vd.get(i));
        }
        return retval;
    }

    private Vector<String> getTecVector(Vector<String> vd) {
        Vector<String> retval = new Vector<String>();
        for (int i = 0; i < 3; ++i) {
            retval.add(i, vd.get(i));
        }
        return retval;
    }

    @Override
    protected void copyFrom(TimeSeries source) throws IxException {
        super.copyFrom(source);
        if (source instanceof MsgScenario) {
            MsgScenario sourceScenario = (MsgScenario)source;
            this.nodes = new TreeSet<String>((SortedSet<String>)sourceScenario.nodes);
            this.tecs = new TreeSet<String>((SortedSet<String>)sourceScenario.tecs);
            this.years = new LinkedList<Integer>(sourceScenario.years);
            this.times = new TreeSet<String>((SortedSet<String>)sourceScenario.times);
            this.emissions = new TreeSet<String>((SortedSet<String>)sourceScenario.emissions);
            this.reqIdxSets = new LinkedList<String>(sourceScenario.reqIdxSets);
            this.reqSets = new LinkedList<String>(sourceScenario.reqSets);
            this.reqPars = new LinkedList<String>(sourceScenario.reqPars);
            this.reqVars = new LinkedList<String>(sourceScenario.reqVars);
            this.reqEqus = new LinkedList<String>(sourceScenario.reqEqus);
            this.indexSetsMap = new HashMap<String, List<String>>(sourceScenario.indexSetsMap);
            this.indexNamesMap = new HashMap<String, List<String>>(sourceScenario.indexNamesMap);
            this.hasMESSAGEspecs = sourceScenario.hasMESSAGEspecs;
            this.tecParList = new LinkedList<String>(sourceScenario.tecParList);
            this.tecActParList = new LinkedList<String>(sourceScenario.tecActParList);
        }
    }

    @Override
    public void removeSolution(int firstYear) throws IxException {
        throw new IxException("You cannot pass a year when removing the solution of a MESSAGE-scheme Scenario!");
    }

    @Override
    public void removeSolution() throws IxException {
        super.removeSolution(this.getFirstModelYear());
    }

    @Override
    public void removeSolution(String user) throws IxException {
        super.removeSolution(this.getFirstModelYear(), user);
    }
}

