/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.AutoRollback;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.exceptions.IxNotFoundException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.MsgScenario;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.ScenarioDbStatus;
import at.ac.iiasa.ixmp.objects.ScenarioState;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.objects.Variable;
import at.ac.iiasa.ixmp.rest.v2_1.dto.LockInfoDTO;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSEquation;
import com.gams.api.GAMSEquationRecord;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSParameterRecord;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSetRecord;
import com.gams.api.GAMSVariable;
import com.gams.api.GAMSVariableRecord;
import com.gams.api.GAMSWorkspace;
import com.gams.api.GAMSWorkspaceInfo;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scenario
extends TimeSeries {
    private static final Logger log = LoggerFactory.getLogger(Scenario.class);
    public static final String MESSAGE_SCHEME = "MESSAGE";
    protected String scheme = null;
    protected int seqItemId = 0;
    private Map<Integer, String> idKeyMap = new HashMap<Integer, String>();
    private Map<String, Integer> keyIdMap = new HashMap<String, Integer>();
    private java.util.Set<String> keyUnique = new HashSet<String>();
    private int seqKeyId = -1;
    private Map<Integer, String> idCommentMap = new HashMap<Integer, String>();
    private Map<String, Integer> commentIdMap = new HashMap<String, Integer>();
    private int seqCommentId = -1;
    protected Map<String, Item> itemList = new LinkedHashMap<String, Item>();
    protected Map<String, IndexSet> idxsetList = new LinkedHashMap<String, IndexSet>();
    protected Map<String, Set> setList = new LinkedHashMap<String, Set>();
    protected Map<String, Parameter> parList = new LinkedHashMap<String, Parameter>();
    protected Map<String, Variable> varList = new LinkedHashMap<String, Variable>();
    protected Map<String, Equation> equList = new LinkedHashMap<String, Equation>();
    private Map<Integer, String> newKeyList = new HashMap<Integer, String>();
    private Map<Integer, String> newCommentList = new HashMap<Integer, String>();
    protected java.util.Set<Item> newItemList = new LinkedHashSet<Item>();
    private java.util.Set<String> removedItemList = new LinkedHashSet<String>();

    public Scenario(Platform mp, String model, String scenario, Boolean isNew, String scheme, String annotation) throws IxException {
        super(mp, model, scenario, true, annotation);
        this.type = "Scenario";
        this.scheme = scheme;
        this.addKey("scalar");
    }

    public Scenario(Platform mp, String model, String scenario) throws IxException {
        super(mp, model, scenario);
        this.loadScenFromDB(this.runId);
    }

    public Scenario(Platform mp, String model, String scenario, int version) throws IxException {
        super(mp, model, scenario, version);
        this.loadScenFromDB(this.runId);
    }

    public Scenario(Platform mp, int runId) throws IxException {
        super(mp, runId);
        this.loadScenFromDB(runId);
    }

    public Scenario(Platform mp, Scenario sourceScenario, String model, String scenario, String annotation) throws IxException {
        super(mp, model, scenario, true, annotation);
        if (mp == sourceScenario.getMp()) {
            this.loadScenFromDB(sourceScenario.getMp().getDb(), sourceScenario.getRunId());
        } else {
            this.copyFrom(sourceScenario);
        }
    }

    public Scenario(Platform mp, String user, Scenario sourceScenario, String model, String scenario, String scheme, String annotation, boolean keepSolution, Integer firstYear) throws IxException {
        super(mp, model, scenario, true, annotation);
        boolean isSameDB;
        boolean bl = isSameDB = mp == sourceScenario.getMp();
        if (isSameDB) {
            this.loadScenFromDB(sourceScenario.getMp().getDb(), sourceScenario.getRunId());
        } else {
            this.copyFrom(sourceScenario, keepSolution);
        }
        this.state = ScenarioState.NEW;
        String commit = String.format("clone Scenario from '%s|%s', version: %d", sourceScenario.getModel(), sourceScenario.getScenario(), sourceScenario.getVersion());
        this.commit(user, commit, isSameDB ? sourceScenario : null, keepSolution, firstYear);
    }

    protected void loadScenFromDB(int runId) throws IxException {
        this.loadScenFromDB(this.getMp().getDb(), runId);
    }

    protected void loadScenFromDB(DbDAO db, int runId) throws IxException {
        this.type = "Scenario";
        try {
            this.scheme = db.getScheme(runId);
            if (db.isDefaultVersion(runId)) {
                log.info(String.format("loading default Scenario '%s|%s' (version: %d, runid: %d)...", this.model, this.scenario, this.version, runId));
            } else {
                log.info(String.format("loading Scenario '%s|%s' by version id (version: %d, runid: %d)...", this.model, this.scenario, this.version, runId));
            }
            this.state = ScenarioState.NEW;
            this.seqItemId = db.getSeqItemId(runId);
            this.seqKeyId = db.getKeyIdList(runId, this);
            this.seqCommentId = db.getCommentIdList(runId, this);
            db.getIndexSets(this, runId);
            db.getItemList(this, runId, "SET");
            db.getItemList(this, runId, "PAR");
            db.getItemList(this, runId, "VAR");
            db.getItemList(this, runId, "EQU");
            ScenarioDbStatus dbStatus = db.getStatus(runId);
            switch (dbStatus) {
                case NONE: {
                    this.state = ScenarioState.UNAVAILABLE;
                    break;
                }
                case LOCKED_IN_DB: {
                    this.state = ScenarioState.CHECKED_OUT_FOR_TIMESERIES_UPDATE;
                    break;
                }
                case AVAILABLE_IN_DB: {
                    this.state = ScenarioState.DEFAULT;
                    break;
                }
                case FROZEN_IN_DB: {
                    this.state = ScenarioState.FROZEN;
                }
            }
            log.info("done loading Scenario from the database!");
            log.info(String.format("Loaded: %d sets, %d parameters, %d variables and %d equations", this.setList.size(), this.parList.size(), this.varList.size(), this.equList.size()));
        }
        catch (IxException e) {
            String error = "There was a problem loading the Scenario from the database!";
            log.error(error, (Throwable)e);
            throw new IxException(error);
        }
    }

    public Boolean isScheme(String pScheme) {
        return Objects.equals(this.scheme, pScheme);
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getKeyId(String key) throws IxException {
        if (!this.keyIdMap.containsKey(key)) {
            throw new IxException(String.format("The key '%s' is not defined in the Scenario!", key));
        }
        return this.keyIdMap.get(key);
    }

    public String getKeyIdString(Integer keyId) {
        return this.idKeyMap.get(keyId);
    }

    public int addKey(String key) throws IxException {
        if (key.contains(".")) {
            throw new IxException(String.format("The key '%s' must not contain a '.'!", key));
        }
        if (this.keyIdMap.containsKey(key)) {
            return this.keyIdMap.get(key);
        }
        String lowercasedKey = key.toLowerCase();
        if (this.keyUnique.contains(lowercasedKey)) {
            throw new IxException(String.format("A key with the same lower-case spelling already exists, please rename '%s'!", key));
        }
        this.keyUnique.add(lowercasedKey);
        ++this.seqKeyId;
        this.idKeyMap.put(this.seqKeyId, key);
        this.keyIdMap.put(key, this.seqKeyId);
        if (this.isChangeLogged().booleanValue()) {
            this.newKeyList.put(this.seqKeyId, key);
        }
        return this.seqKeyId;
    }

    public void addKeyFromDB(int keyId, String key) {
        this.keyUnique.add(key.toLowerCase());
        this.idKeyMap.put(keyId, key);
        this.keyIdMap.put(key, keyId);
    }

    public Vector<Integer> getKeyIdVector(String ... keys) throws IxException {
        Vector<Integer> eleVector = new Vector<Integer>(keys.length);
        for (String aKey : keys) {
            eleVector.add(this.addKey(aKey));
        }
        return eleVector;
    }

    int addComment(String comment) {
        if (this.commentIdMap.containsKey(comment)) {
            return this.commentIdMap.get(comment);
        }
        ++this.seqCommentId;
        this.idCommentMap.put(this.seqCommentId, comment);
        this.commentIdMap.put(comment, this.seqCommentId);
        if (this.isChangeLogged().booleanValue()) {
            this.newCommentList.put(this.seqCommentId, comment);
        }
        return this.seqCommentId;
    }

    public void addCommentFromDB(int commentId, String comment) {
        this.idCommentMap.put(commentId, comment);
        this.commentIdMap.put(comment, commentId);
    }

    String getCommentString(Integer commentId) {
        return this.idCommentMap.get(commentId);
    }

    int getNextItemId() {
        return this.seqItemId++;
    }

    void checkIndexSet(String name) throws IxException {
        if (!name.equals("*") && !this.hasIndexSet(name)) {
            throw new IxException(String.format("There exists no index set '%s'!", name));
        }
    }

    void checkIndexSetEle(String setName, int keyId) throws IxException {
        if (!setName.equals("*")) {
            this.checkIndexSet(setName);
            this.getIndexSet(setName).checkIndexSetKey(keyId);
        }
    }

    public void addCatEle(String setName, String cat, String key) throws IxException {
        throw new IxException("this function can only be used for MESSAGE-scheme scenarios!");
    }

    public String[] getCatEle(String setName, String cat) throws IxException {
        throw new IxException("this function can only be used for MESSAGE-scheme scenarios!");
    }

    public List<String> getIdxSets(String name) throws IxException {
        return this.getItem(name).getIdxSets();
    }

    public List<String> getIdxNames(String name) throws IxException {
        return this.getItem(name).getIdxNames();
    }

    public Scenario clone(Platform target, CloneParams params) throws IxException {
        this.assertTimeSeriesIsLockedInDB(true);
        if (params.newModel == null || params.newScenario == null) {
            throw new IxException("Please provide a model and scenario name for the cloned Scenario!");
        }
        Scenario cloned = this.isScheme(MESSAGE_SCHEME) != false ? new MsgScenario(target, params.user, (MsgScenario)this, params.newModel, params.newScenario, this.annotation, params.keepSolution, params.firstYear) : new Scenario(target, params.user, this, params.newModel, params.newScenario, this.scheme, this.annotation, params.keepSolution, params.firstYear);
        if (cloned.version == 1) {
            cloned.setAsDefaultVersion();
        }
        if (params.keepMetadata) {
            Map<String, Serializable> meta = this.getMeta(true);
            cloned.setMeta(meta);
        }
        return cloned;
    }

    public Scenario clone(Platform target, String newModel, String newScenario, String annotation, boolean keepSolution) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        return this.clone(target, osUser, newModel, newScenario, annotation, keepSolution, null);
    }

    public Scenario clone(Platform target, String newModel, String newScenario, String annotation, boolean keepSolution, int firstYear) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        return this.clone(target, osUser, newModel, newScenario, annotation, keepSolution, firstYear);
    }

    Scenario clone(Platform target, String user, String newModel, String newScenario, String annotation, boolean keepSolution, Integer firstYear) throws IxException {
        CloneParams params = CloneParams.builder().newModel(newModel).newScenario(newScenario).annotation(annotation).keepSolution(keepSolution).firstYear(firstYear).user(user).build();
        return this.clone(target, params);
    }

    public Scenario clone(String user, String newModel, String newScenario, String annotation, boolean keepSolution) throws IxException {
        return this.clone(this.getMp(), user, newModel, newScenario, annotation, keepSolution, null);
    }

    protected void addToItemList(Item pItem) {
        this.itemList.put(pItem.name, pItem);
        if (pItem instanceof IndexSet) {
            this.idxsetList.put(pItem.name, (IndexSet)pItem);
        } else if (pItem instanceof Set) {
            this.setList.put(pItem.name, (Set)pItem);
        } else if (pItem instanceof Parameter) {
            this.parList.put(pItem.name, (Parameter)pItem);
        } else if (pItem instanceof Variable) {
            this.varList.put(pItem.name, (Variable)pItem);
        } else if (pItem instanceof Equation) {
            this.equList.put(pItem.name, (Equation)pItem);
        }
    }

    public boolean hasItem(String pName) {
        boolean retval = false;
        if (this.itemList.containsKey(pName)) {
            retval = true;
        }
        return retval;
    }

    public Item getItem(String pName) throws IxException {
        if (!this.hasItem(pName)) {
            throw new IxException(String.format("No item %s exists in this Scenario!", pName));
        }
        return this.itemList.get(pName);
    }

    public List<Element> getItemElements(String pName) throws IxException {
        if (!this.hasItem(pName)) {
            throw new IxException(String.format("No item %s exists in this Scenario!", pName));
        }
        return this.getItem(pName).getElements();
    }

    private void removeFromItemList(Item item) {
        this.itemList.remove(item.name);
        if (item instanceof IndexSet) {
            this.idxsetList.remove(item.name);
        } else if (item instanceof Set) {
            this.setList.remove(item.name);
        } else if (item instanceof Parameter) {
            this.parList.remove(item.name);
        } else if (item instanceof Variable) {
            this.varList.remove(item.name);
        } else if (item instanceof Equation) {
            this.equList.remove(item.name);
        }
    }

    public String[] getIndexSetKeys(String pName) throws IxException {
        if (!this.hasIndexSet(pName)) {
            throw new IxException(String.format("No index set %s exists in this Scenario!", pName));
        }
        return this.getIndexSet(pName).getIndexSetKeys();
    }

    public List<Integer> getIndexSetKeyIds(String pName) throws IxException {
        if (!this.hasIndexSet(pName)) {
            throw new IxException(String.format("No index set %s exists in this Scenario!", pName));
        }
        return this.getIndexSet(pName).getIndexSetKeyIds();
    }

    private void checkItemAsIndexSet(String pIdxSet) throws IxException {
        for (Item aItem : this.itemList.values()) {
            for (String aIdxSet : aItem.getIdxSets()) {
                if (!aIdxSet.equals(pIdxSet)) continue;
                throw new IxException(String.format("The index set '%s' is used by %s, delete this item first!", pIdxSet, aItem.getTypeName()));
            }
        }
    }

    void removeAllEleByIndex(String pIndexSet, int pKeyId) throws IxException {
        log.info("cleaning all occurences of element '" + this.getKeyIdString(pKeyId) + "' in index set '" + pIndexSet + "'...");
        for (Item aItem : this.itemList.values()) {
            if (aItem.getDim() == 0) continue;
            int idx = 0;
            int i = 0;
            HashSet<Integer> idxList = new HashSet<Integer>();
            for (String string : aItem.getIdxSets()) {
                if (string.equals(pIndexSet)) {
                    idxList.add(idx);
                }
                ++idx;
            }
            HashSet<Element> removedEleList = new HashSet<Element>();
            for (Element ele : aItem.getElements()) {
                Iterator iterator = idxList.iterator();
                while (iterator.hasNext()) {
                    int aIdx = (Integer)iterator.next();
                    if (!ele.checkKeyAtIndex(aIdx, (Integer)pKeyId)) continue;
                    removedEleList.add(ele);
                    ++i;
                }
            }
            if (aItem instanceof Set) {
                Set set = (Set)aItem;
                for (Element ele : removedEleList) {
                    set.removeElement(ele);
                }
            } else if (aItem instanceof Parameter) {
                Parameter parameter = (Parameter)aItem;
                for (Element ele : removedEleList) {
                    parameter.removeElement(ele);
                }
            }
            if (i == 1) {
                log.info(String.format(" removed 1 element from %s", aItem.getTypeName()));
                continue;
            }
            if (i <= true) continue;
            log.info(String.format(" removed %d elements from %s", i, aItem.getTypeName()));
        }
    }

    public List<String> getIndexSetList() {
        LinkedList<String> setNameList = new LinkedList<String>();
        for (IndexSet aSet : this.idxsetList.values()) {
            setNameList.add(aSet.name);
        }
        return setNameList;
    }

    public List<String> getSetList() {
        LinkedList<String> setNameList = new LinkedList<String>();
        for (IndexSet indexSet : this.idxsetList.values()) {
            setNameList.add(indexSet.name);
        }
        for (Set set : this.setList.values()) {
            setNameList.add(set.name);
        }
        return setNameList;
    }

    public boolean hasIndexSet(String name) {
        boolean retval = false;
        if (this.idxsetList.containsKey(name)) {
            retval = true;
        }
        return retval;
    }

    public IndexSet getIndexSet(String name) throws IxException {
        if (!this.hasIndexSet(name)) {
            throw new IxException(String.format("No IndexSet '%s' exists in this Scenario!", name));
        }
        return this.idxsetList.get(name);
    }

    public boolean hasSet(String name) {
        return this.idxsetList.containsKey(name) || this.setList.containsKey(name);
    }

    public Set getSet(String name) throws IxException {
        return this.getSet(name, true);
    }

    public Set getSet(String name, boolean load) throws IxException {
        if (this.hasIndexSet(name)) {
            return this.idxsetList.get(name);
        }
        if (!this.hasSet(name)) {
            throw new IxException(String.format("No Set '%s' exists in this Scenario!", name));
        }
        Set set = this.setList.get(name);
        if (load) {
            set.loadItemElementsFromDB();
        }
        return set;
    }

    public Set initializeSet(String name, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.hasItem(name)) {
            throw new IxException("An Item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets == null || indexSets.isEmpty()) {
            IndexSet aSet = new IndexSet(this.getMp(), this, name);
            if (this.isChangeLogged().booleanValue()) {
                this.newItemList.add(aSet);
                this.changeLogList.add(new ChangelogEntry("initialize index set", name));
            }
            return aSet;
        }
        this.checkIndexSetsNames(indexSets, indexNames);
        Set aSet = new Set(this.getMp(), this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aSet);
            this.changeLogList.add(new ChangelogEntry("initialize set", name));
        }
        return aSet;
    }

    public void removeSet(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        if (this.hasIndexSet(name)) {
            IndexSet aSet = this.getIndexSet(name);
            this.checkItemAsIndexSet(aSet.name);
            if (this.isChangeLogged().booleanValue()) {
                for (Element ele : aSet.getElements()) {
                    this.addToChangelog("delete set element", name, ele.getConcatKey());
                }
                this.addToChangelog("remove index set", name, null);
            }
            this.removedItemList.add(name);
            this.removeFromItemList(aSet);
            log.info(String.format("removed Set '%s' from the Scenario", name));
        } else if (this.hasSet(name)) {
            Set aItem = this.getSet(name);
            if (this.isChangeLogged().booleanValue()) {
                for (Element ele : aItem.getElements()) {
                    this.addToChangelog("delete set element", name, ele.getConcatKey());
                }
                this.addToChangelog("remove set", name, null);
            }
            this.removedItemList.add(name);
            this.removeFromItemList(aItem);
            log.info(String.format("removed Set '%s' from the Scenario", name));
        } else {
            throw new IxException(String.format("There exists no Set '%s'!", name));
        }
    }

    public List<String> getParList() {
        LinkedList<String> parNameList = new LinkedList<String>();
        for (Parameter aPar : this.parList.values()) {
            parNameList.add(aPar.name);
        }
        return parNameList;
    }

    public boolean hasPar(String name) {
        return this.parList.containsKey(name);
    }

    public Parameter getPar(String name) throws IxException {
        return this.getPar(name, true);
    }

    public Parameter getPar(String name, boolean load) throws IxException {
        if (!this.hasPar(name)) {
            throw new IxNotFoundException(String.format("There is no parameter '%s'!", name));
        }
        Parameter parameter = this.parList.get(name);
        if (load) {
            parameter.loadItemElementsFromDB();
        }
        return parameter;
    }

    public Parameter initializePar(String name, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.hasItem(name)) {
            throw new IxException(String.format("An item with the name '%s' already exists!", name));
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        Parameter aPar = new Parameter(this.getMp(), this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aPar);
            this.changeLogList.add(new ChangelogEntry("initialize parameter", name));
        }
        return aPar;
    }

    public void removePar(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Parameter aPar = this.getPar(name);
        if (this.isChangeLogged().booleanValue()) {
            if (aPar.getDim() > 0) {
                for (Element ele : aPar.getElements()) {
                    this.addToChangelog("delete parameter element", name, ele.getConcatKey(), null, ele.getValue());
                }
                this.addToChangelog("remove parameter", name, null);
            } else {
                this.addToChangelog("remove scalar", name, null, null, aPar.getScalarValue());
            }
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aPar);
        log.info(String.format("removed Parameter '%s' from the Scenario", name));
    }

    public List<String> getVarList() {
        return new LinkedList<String>(this.varList.keySet());
    }

    public boolean hasVar(String name) {
        return this.varList.containsKey(name);
    }

    public Variable getVar(String name) throws IxException {
        return this.getVar(name, true);
    }

    public Variable getVar(String name, boolean load) throws IxException {
        if (!this.hasVar(name)) {
            throw new IxException(String.format("There exists no variable '%s'!", name));
        }
        Variable variable = this.varList.get(name);
        if (load) {
            variable.loadItemElementsFromDB();
        }
        return variable;
    }

    public Variable initializeVar(String name, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.hasItem(name)) {
            throw new IxException(String.format("An item with the name '%s' already exists!", name));
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        Variable aVar = new Variable(this.getMp(), this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aVar);
            this.changeLogList.add(new ChangelogEntry("initialize variable", name));
        }
        return aVar;
    }

    public void removeVar(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Variable aVar = this.getVar(name);
        if (this.isChangeLogged().booleanValue()) {
            this.addToChangelog("remove variable", name, null);
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aVar);
        log.info(String.format("removed Variable '%s' from the Scenario", name));
    }

    public List<String> getEquList() {
        return new LinkedList<String>(this.equList.keySet());
    }

    public boolean hasEqu(String name) {
        return this.equList.containsKey(name);
    }

    public Equation getEqu(String name) throws IxException {
        return this.getEqu(name, true);
    }

    public Equation getEqu(String name, boolean load) throws IxException {
        if (!this.hasEqu(name)) {
            throw new IxException(String.format("There exists no equation '%s'!", name));
        }
        Equation equation = this.equList.get(name);
        if (load) {
            equation.loadItemElementsFromDB();
        }
        return equation;
    }

    public Equation initializeEqu(String name, List<String> indexSets, List<String> indexNames) throws IxException {
        if (this.hasItem(name)) {
            throw new IxException("An item with the name '" + name + "' already exists!");
        }
        this.assertTimeSeriesIsEditable(false);
        if (indexSets != null && indexNames != null) {
            this.checkIndexSetsNames(indexSets, indexNames);
        }
        Equation aEqu = new Equation(this.getMp(), this, name, indexSets, indexNames);
        if (this.isChangeLogged().booleanValue()) {
            this.newItemList.add(aEqu);
            this.changeLogList.add(new ChangelogEntry("initialize equation", name));
        }
        return aEqu;
    }

    public void removeEqu(String name) throws IxException {
        this.assertTimeSeriesIsEditable(false);
        Equation aEqu = this.getEqu(name);
        if (this.isChangeLogged().booleanValue()) {
            this.addToChangelog("remove equation", name, null);
        }
        this.removedItemList.add(name);
        this.removeFromItemList(aEqu);
        log.info("removed equation '" + name + "' from the Scenario");
    }

    private void checkIndexSetsNames(List<String> indexSets, List<String> indexNames) throws IxException {
        if (indexSets.size() != indexNames.size()) {
            throw new IxException("The dimensionality of index sets and index names doesn't match!");
        }
        for (String idxSet : indexSets) {
            this.checkIndexSet(idxSet);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (String idxName : indexNames) {
            if (nameSet.contains(idxName)) {
                throw new IxException("The index names are not unique!");
            }
            nameSet.add(idxName);
        }
    }

    public int getUnitId(String unit) throws IxException {
        return this.getMp().getUnitId(unit);
    }

    public String getUnitName(int unitId) throws IxException {
        return this.getMp().getUnit(unitId);
    }

    public boolean hasSolution() throws IxException {
        for (Variable aVar : this.varList.values()) {
            if (!aVar.hasElements()) continue;
            return true;
        }
        for (Equation aEqu : this.equList.values()) {
            if (!aEqu.hasElements()) continue;
            return true;
        }
        return false;
    }

    public void checkSolution() throws IxException {
        if (this.hasSolution()) {
            throw new IxException("This Scenario has elements in a variable or equation! Use 'removeSolution()' or clone(False)'before editing!");
        }
    }

    public void removeSolution() throws IxException {
        this.removeSolution(null);
    }

    public void removeSolution(int firstYear) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.removeSolution(firstYear, osUser);
    }

    public void removeSolution(String user) throws IxException {
        this.removeSolution(null, user);
    }

    public void removeSolution(Integer firstYear, String user) throws IxException {
        this.assertTimeseriesIsLockedInDB();
        if (this.varList.isEmpty() && this.equList.isEmpty()) {
            log.info("this Scenario does not have any initialized variables or equations");
        } else {
            TimeSeries.TsCache.CacheKey<String, String, String, String> key;
            this.checkOut(user, false, false);
            boolean hasSol = false;
            for (Variable aVar : this.varList.values()) {
                if (!aVar.removeAllElements()) continue;
                hasSol = true;
            }
            for (Equation aEqu : this.equList.values()) {
                if (!aEqu.removeAllElements()) continue;
                hasSol = true;
            }
            this.preloadAllTimeseries();
            HashMap toBeRemoved = new HashMap();
            for (Map.Entry<TimeSeries.TsCache.CacheKey<String, String, String, String>, Map<Integer, Double>> entry : this.getTimeseriesCache().getCache().entrySet()) {
                key = entry.getKey();
                Map<Integer, Double> yearlyValues = entry.getValue();
                List yearsToRemove = yearlyValues.keySet().stream().filter(year -> firstYear == null || year >= firstYear).collect(Collectors.toList());
                if (yearsToRemove.isEmpty()) continue;
                hasSol = true;
                toBeRemoved.put(key, yearsToRemove);
            }
            for (Map.Entry<TimeSeries.TsCache.CacheKey<String, String, String, String>, Map<Integer, Double>> entry : toBeRemoved.entrySet()) {
                key = entry.getKey();
                List value = (List)((Object)entry.getValue());
                this.removeTimeseries(key.getNode(), key.getKey(), key.getSubannual(), value, key.getUnit());
            }
            if (hasSol) {
                this.commit(user, "remove all solution elements");
            } else {
                log.info("this Scenario does not contain any elements in a Variable or Equation");
                this.checkIn(user);
            }
        }
    }

    public void readSolutionFromGDX(String gamsPath, String gamsGdxFile, String comment, List<String> varList, List<String> equList, boolean checkSolution) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.readSolutionFromGDX(osUser, gamsPath, gamsGdxFile, comment, varList, equList, checkSolution);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment) throws IxException {
        this.readSolutionFromGDX(user, gamsPath, gamsGdxFile, comment, false);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, boolean checkSolution) throws IxException {
        this.readSolutionFromGDX(user, gamsPath, gamsGdxFile, comment, null, null, checkSolution);
    }

    public void readSolutionFromGDX(String user, String gamsPath, String gamsGdxFile, String comment, List<String> varList, List<String> equList, boolean checkSolution) throws IxException {
        this.readSolFromGDX(gamsPath, gamsGdxFile, comment, varList, equList);
    }

    public void fromGDX(String gamsPath, String gamsGdxFile, List<String> importSetList, List<String> importParList, List<String> importVarList, List<String> importEquList) throws IxException {
        File workingDirectory;
        if (importParList == null) {
            importParList = new LinkedList<String>(this.parList.keySet());
        }
        if (importVarList == null) {
            importVarList = new LinkedList<String>(this.varList.keySet());
        }
        if (importEquList == null) {
            importEquList = new LinkedList<String>(this.equList.keySet());
        }
        if (!(workingDirectory = new File(gamsPath)).exists() && !workingDirectory.mkdir()) {
            throw new IxException("Cannot create working directory");
        }
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase gamsDB = ws.addDatabaseFromGDX(gamsGdxFile);
        if (importSetList != null) {
            this.internalSetsFromGDX(gamsDB, importSetList);
        } else {
            this.internalSetsFromGDX(gamsDB, new LinkedList<String>(this.idxsetList.keySet()));
            this.internalSetsFromGDX(gamsDB, new LinkedList<String>(this.setList.keySet()));
        }
        this.internalParametersFromGDX(gamsDB, importParList);
        this.internalVariablesFromGDX(gamsDB, importVarList);
        this.internalEquationsFromGDX(gamsDB, importEquList);
    }

    private void internalParametersFromGDX(GAMSDatabase gamsDB, List<String> importParList) throws IxException {
        for (String name : importParList) {
            try {
                Parameter par = this.getPar(name);
                GAMSParameter gamsPar = gamsDB.getParameter(name);
                for (GAMSParameterRecord rec : gamsPar) {
                    LinkedList<String> keys = new LinkedList<String>(Arrays.asList(rec.getKeys()));
                    if (keys.isEmpty()) {
                        par.addElement(rec.getValue(), "n/a");
                        continue;
                    }
                    this.getMp().getUnitId("n/a", true, "GDX import");
                    par.addElement(keys, (Double)rec.getValue(), "n/a");
                }
            }
            catch (GAMSException e) {
                log.warn("Cannot import parameter from GDX", (Throwable)e);
            }
        }
    }

    private void internalSetsFromGDX(GAMSDatabase gamsDB, List<String> importSetList) throws IxException {
        for (String name : importSetList) {
            try {
                Set set = this.getSet(name);
                GAMSSet gamsSet = gamsDB.getSet(name);
                for (GAMSSetRecord rec : gamsSet) {
                    set.addElement(new LinkedList<String>(Arrays.asList(rec.getKeys())));
                }
            }
            catch (GAMSException e) {
                log.warn("Cannot import set from GDX", (Throwable)e);
            }
        }
    }

    protected void readSolFromGDX(String gamsPath, String gamsGdxFile, String comment, List<String> importVarList, List<String> importEquList) throws IxException {
        this.assertTimeseriesIsLockedInDB();
        this.checkSolution();
        if (importVarList == null || importVarList.isEmpty()) {
            if (this.varList.isEmpty()) {
                throw new IxException("There are no initialized variables in this Scenario!");
            }
            importVarList = new LinkedList<String>();
            importVarList.addAll(this.varList.keySet());
        }
        if (importEquList == null || importEquList.isEmpty()) {
            importEquList = new LinkedList<String>();
            importEquList.addAll(this.equList.keySet());
        }
        this.checkOut(false);
        log.info("importing results from gdx solution file...");
        File workingDirectory = new File(gamsPath);
        workingDirectory.mkdir();
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        GAMSDatabase gamsDB = ws.addDatabaseFromGDX(gamsGdxFile);
        this.internalVariablesFromGDX(gamsDB, importVarList);
        this.internalEquationsFromGDX(gamsDB, importEquList);
        DbDAO db = this.getMp().getDb();
        try (Connection dbConn = db.getPooledConn();
             AutoRollback tm = new AutoRollback(dbConn);){
            int annotationId = db.assignAnnotationId(dbConn);
            db.setUpdUserDate(dbConn, this.runId);
            String script = "import solution from GDX";
            for (Variable var : this.varList.values()) {
                db.saveItemElementsToDB(dbConn, var, this.runId);
            }
            for (Equation equ : this.equList.values()) {
                db.saveItemElementsToDB(dbConn, equ, this.runId);
            }
            comment = comment == null ? String.format("source file: '%s/%s'", gamsPath, gamsGdxFile) : String.format("%s; source file: '%s/%s'", comment, gamsPath, gamsGdxFile);
            db.writeAnnotation(dbConn, this.runId, "ok", annotationId, script, comment);
            db.writeChangeLog(dbConn, annotationId, this.changeLogList, this.runId);
            tm.commit();
            log.info(String.format("done importing solution from file '%s/%s' to database (runid: %d, version: %d)!", gamsPath, gamsGdxFile, this.runId, this.version));
        }
        catch (IxException | SQLException e) {
            String message = "There was a problem writing to the database - no changes were saved!";
            log.error(message, (Throwable)e);
            try {
                this.discardChanges();
            }
            catch (IxException e2) {
                log.error(e2.getMessage());
            }
            throw new IxException(message, e);
        }
        for (Variable var : this.varList.values()) {
            var.clearCache();
        }
        for (Equation equ : this.equList.values()) {
            equ.clearCache();
        }
        this.checkIn();
        this.changeLogList = new LinkedList();
    }

    private void internalEquationsFromGDX(GAMSDatabase gamsDB, List<String> importEquList) throws IxException {
        for (String aName : importEquList) {
            GAMSEquation x;
            Equation equ = this.getEqu(aName);
            try {
                x = gamsDB.getEquation(aName);
            }
            catch (GAMSException e) {
                log.error(String.format("equation '%s' not found in gdx!", aName));
                continue;
            }
            int cnt = 0;
            for (GAMSEquationRecord rec : x) {
                int dim = rec.getKeys().length;
                if (dim > 0) {
                    Vector<Integer> eleVector = new Vector<Integer>();
                    eleVector.add(this.addKey(rec.getKeys()[0]));
                    for (int i = 1; i < dim; ++i) {
                        eleVector.add(this.addKey(rec.getKeys()[i]));
                    }
                    equ.addElement(eleVector, rec.getLevel(), rec.getMarginal());
                } else {
                    equ.addElement(rec.getLevel(), rec.getMarginal());
                }
                ++cnt;
            }
            if (cnt == 0) {
                log.info(String.format("no elements for equation '%s' found in gdx", aName));
                continue;
            }
            if (cnt == 1) {
                log.info(String.format("imported a scalar for equation '%s' from gdx", aName));
                this.changeLogList.add(new ChangelogEntry("import a scalar for equation", aName));
                continue;
            }
            log.info(String.format("imported %d elements for equation '%s' from gdx", cnt, aName));
            this.changeLogList.add(new ChangelogEntry(String.format("import %d elements for equation", cnt), aName));
        }
    }

    private void internalVariablesFromGDX(GAMSDatabase gamsDB, List<String> importVarList) throws IxException {
        for (String aName : importVarList) {
            GAMSVariable x;
            Variable var = this.getVar(aName);
            try {
                x = gamsDB.getVariable(aName);
            }
            catch (GAMSException e) {
                log.error(String.format("variable '%s' not found in gdx!", aName));
                continue;
            }
            int cnt = 0;
            for (GAMSVariableRecord rec : x) {
                int dim = rec.getKeys().length;
                if (dim > 0) {
                    Vector<Integer> eleVector = new Vector<Integer>();
                    eleVector.add(this.addKey(rec.getKeys()[0]));
                    for (int i = 1; i < dim; ++i) {
                        eleVector.add(this.addKey(rec.getKeys()[i]));
                    }
                    var.addElement(eleVector, rec.getLevel(), rec.getMarginal());
                } else {
                    var.addElement(rec.getLevel(), rec.getMarginal());
                }
                ++cnt;
            }
            if (cnt == 0) {
                log.info(String.format("no elements for variable '%s' found in gdx", aName));
                continue;
            }
            if (cnt == 1) {
                log.info(String.format("imported a scalar for variable '%s' from gdx", aName));
                this.changeLogList.add(new ChangelogEntry("import a scalar for variable", aName));
                continue;
            }
            log.info(String.format("imported %d elements for variable '%s' from gdx", cnt, aName));
            this.changeLogList.add(new ChangelogEntry("import " + cnt + " elements for variable", aName));
        }
    }

    protected Vector<String> getStringVector(Vector<Integer> eleVector) {
        Vector<String> retval = new Vector<String>();
        for (Integer keyId : eleVector) {
            retval.add(this.getKeyIdString(keyId));
        }
        return retval;
    }

    protected Vector<String> getStringVector(Integer keyId) {
        Vector<String> retval = new Vector<String>();
        retval.add(this.getKeyIdString(keyId));
        return retval;
    }

    public void toGDX(String gamsPath, String gamsGdxFile) throws IxException {
        this.toGDX(gamsPath, gamsGdxFile, false);
    }

    protected void logMemStats(String msg) {
        if (log.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            log.debug(String.format("%s (total: %d, free: %d)", msg, totalMemory, freeMemory));
        }
    }

    public void toGDX(String gamsPath, String gamsGdxFile, boolean includeVarEqu) throws IxException {
        this.assertTimeseriesIsLockedInDB();
        log.info("writing data to gdx...");
        GAMSDatabase gamsDB = this.makeGamsDB(gamsPath);
        this.writeSetsToGDX(gamsDB);
        this.writeMappingSetsToGDX(gamsDB);
        this.writeParametersToGDX(gamsDB);
        if (includeVarEqu) {
            this.writeVariablesToGDX(gamsDB);
            this.writeEquationsToGDX(gamsDB);
        }
        gamsDB.export(gamsGdxFile);
        log.info("done writing data to gdx!");
    }

    protected GAMSDatabase makeGamsDB(String gamsPath) {
        File workingDirectory = new File(gamsPath);
        if (workingDirectory.mkdir()) {
            log.debug(String.format("Directory %s was created", workingDirectory));
        }
        GAMSWorkspaceInfo wsInfo = new GAMSWorkspaceInfo();
        wsInfo.setWorkingDirectory(workingDirectory.getAbsolutePath());
        GAMSWorkspace ws = new GAMSWorkspace(wsInfo);
        return ws.addDatabase();
    }

    protected void writeEquationsToGDX(GAMSDatabase gamsDB) throws IxException {
        for (Equation equation : this.equList.values()) {
            boolean clearCache = equation.loadItemElementsFromDB();
            GAMSEquation aGamsEqu = gamsDB.addEquation(equation.name, equation.dim.intValue(), GAMSGlobals.EquType.E);
            if (equation.dim == 0) {
                try {
                    GAMSEquationRecord aEquEle = (GAMSEquationRecord)aGamsEqu.addRecord(new Vector());
                    aEquEle.setLevel(equation.getScalarLevel().doubleValue());
                    aEquEle.setMarginal(equation.getScalarMarginal().doubleValue());
                }
                catch (IxException e) {
                    log.error(String.format("error writing equation %s' (as scalar) to gdx!", equation.name), (Throwable)e);
                    throw new IxException(String.format("error writing equation %s' (as scalar) to gdx!", equation.name));
                }
            } else {
                for (Element ele : equation.getElements()) {
                    Vector<String> vd = this.getStringVector(ele.getVector());
                    try {
                        GAMSEquationRecord aEquEle = (GAMSEquationRecord)aGamsEqu.addRecord(vd);
                        aEquEle.setLevel(ele.getLevel().doubleValue());
                        aEquEle.setMarginal(ele.getMarginal().doubleValue());
                    }
                    catch (Exception e) {
                        String msg = String.format("error writing equation '%s' to gdx!", equation.name);
                        log.error(msg, (Throwable)e);
                        throw new IxException(msg);
                    }
                }
            }
            if (!clearCache) continue;
            equation.clearCache();
        }
    }

    protected void writeVariablesToGDX(GAMSDatabase gamsDB) throws IxException {
        for (Variable variable : this.varList.values()) {
            boolean clearCache = variable.loadItemElementsFromDB();
            GAMSVariable aGamsVar = gamsDB.addVariable(variable.name, variable.dim.intValue(), GAMSGlobals.VarType.FREE);
            if (variable.dim == 0) {
                try {
                    GAMSVariableRecord aVarEle = (GAMSVariableRecord)aGamsVar.addRecord(new Vector());
                    aVarEle.setLevel(variable.getScalarLevel().doubleValue());
                    aVarEle.setMarginal(variable.getScalarMarginal().doubleValue());
                }
                catch (IxException e) {
                    log.error(String.format("error writing variable %s' (as scalar) to gdx!", variable.name), (Throwable)e);
                    throw new IxException(String.format("error writing variable %s' (as scalar) to gdx!", variable.name));
                }
            } else {
                for (Element ele : variable.getElements()) {
                    Vector<String> vd = this.getStringVector(ele.getVector());
                    try {
                        GAMSVariableRecord aVarEle = (GAMSVariableRecord)aGamsVar.addRecord(vd);
                        aVarEle.setLevel(ele.getLevel().doubleValue());
                        aVarEle.setMarginal(ele.getMarginal().doubleValue());
                    }
                    catch (GAMSException e) {
                        String msg = String.format("error writing variable '%s' to gdx!", variable.name);
                        log.error(msg, (Throwable)e);
                        throw new IxException(msg);
                    }
                }
            }
            if (!clearCache) continue;
            variable.clearCache();
        }
    }

    protected void writeParametersToGDX(GAMSDatabase gamsDB) throws IxException {
        for (Parameter parameter : this.parList.values()) {
            String name = parameter.name;
            this.logMemStats(String.format("Writing parameter [%s]...", name));
            boolean clearCache = parameter.loadItemElementsFromDB();
            GAMSParameter aGamsPar = gamsDB.addParameter(name, parameter.dim.intValue());
            if (parameter.dim == 0) {
                try {
                    ((GAMSParameterRecord)aGamsPar.addRecord(new Vector())).setValue(parameter.getScalarValue().doubleValue());
                }
                catch (IxException e) {
                    String message = String.format("error writing scalar %s' to gdx!", name);
                    log.error(message, (Throwable)e);
                    throw new IxException(message);
                }
            } else {
                for (Element ele : parameter.getElements()) {
                    Vector<String> vd = this.getStringVector(ele.getVector());
                    try {
                        ((GAMSParameterRecord)aGamsPar.addRecord(vd)).setValue(ele.getValue().doubleValue());
                    }
                    catch (GAMSException e) {
                        String message = String.format("error writing parameter '%s' to gdx!", name);
                        log.error(message, (Throwable)e);
                        throw new IxException(message, e);
                    }
                }
            }
            if (!clearCache) continue;
            parameter.clearCache();
        }
    }

    protected void writeMappingSetsToGDX(GAMSDatabase gamsDB) throws IxException {
        for (Set set : this.setList.values()) {
            int dim = Math.max(1, set.idxSets.size());
            GAMSSet gamsSet = gamsDB.addSet(set.name, dim);
            for (Element ele : set.getElements()) {
                Vector<String> vd = this.getStringVector(ele.getVector());
                try {
                    gamsSet.addRecord(vd);
                }
                catch (GAMSException e) {
                    String message = String.format("error writing mapping set '%s' to gdx!", set.name);
                    log.error(message, (Throwable)e);
                    throw new IxException(message);
                }
            }
        }
    }

    protected void writeSetsToGDX(GAMSDatabase gamsDB) throws IxException {
        for (IndexSet set : this.idxsetList.values()) {
            GAMSSet aGamsSet = gamsDB.addSet(set.name, 1);
            for (int keyId : set.getIndexSetKeyIds()) {
                Vector<String> vd = this.getStringVector(keyId);
                try {
                    aGamsSet.addRecord(vd);
                }
                catch (GAMSException e) {
                    String message = String.format("error writing index set '%s' to gdx!", set.name);
                    log.error(message, (Throwable)e);
                    throw new IxException(message, e);
                }
            }
        }
    }

    @Override
    public void checkOut(String user, boolean timeseriesOnly) throws IxException {
        this.checkOut(user, timeseriesOnly, true);
    }

    protected void checkOut(String user, boolean timeseriesOnly, boolean checkSolution) throws IxException {
        if (checkSolution && !timeseriesOnly) {
            this.checkSolution();
        }
        super.checkOut(user, timeseriesOnly);
    }

    @Override
    public void commit(String annotation) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.commit(user, annotation);
    }

    @Override
    public void commit(String user, String annotation) throws IxException {
        this.commit(user, annotation, null, true, null);
    }

    protected void commit(String user, String annotation, Scenario sourceScen, boolean keepSolution, Integer firstYear) throws IxException {
        this.commit(user, annotation, sourceScen, keepSolution, keepSolution, firstYear);
    }

    protected void commit(String user, String annotation, Scenario sourceScen, boolean keepSolution, boolean keepTimeSeries, Integer firstYear) throws IxException {
        if (this.state == ScenarioState.DEFAULT) {
            throw new IxException("this Scenario is not checked out, no changes to be committed!");
        }
        int sourceRunId = -1;
        if (sourceScen != null) {
            sourceRunId = sourceScen.getRunId();
        }
        DbDAO db = this.getMp().getDb();
        this.preCommit();
        try (Connection dbConn = db.getPooledConn();
             AutoRollback tm = new AutoRollback(dbConn);){
            String script = null;
            if (this.runId == -1) {
                this.runId = db.assignRunId(dbConn, this.model, this.scenario, this.scheme, annotation, user);
                this.version = db.getVersion(dbConn, this.runId);
            }
            db.saveSeqItemId(dbConn, this.seqItemId, this.runId);
            if (this.state.isChangeLogged()) {
                script = "commit changes to Scenario";
                log.info(String.format("committing changes of Scenario '%s|%s' to the database (runid: %d)...", this.model, this.scenario, this.runId));
                db.createKeysInDB(dbConn, this.newKeyList, this.runId);
                db.saveCommentsInDB(dbConn, this.newCommentList, this.runId);
                db.saveIdxSetToDB(dbConn, this.idxsetList.values(), this.runId);
                db.removeItemFromDB(dbConn, this.removedItemList, "SET", this.runId);
                db.removeItemFromDB(dbConn, this.removedItemList, "PAR", this.runId);
                db.removeItemFromDB(dbConn, this.removedItemList, "VAR", this.runId);
                db.removeItemFromDB(dbConn, this.removedItemList, "EQU", this.runId);
                LinkedHashSet<Item> newSetList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newParList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newVarList = new LinkedHashSet<Item>();
                LinkedHashSet<Item> newEquList = new LinkedHashSet<Item>();
                for (Item aItem : this.newItemList) {
                    if (aItem instanceof IndexSet) continue;
                    if (aItem instanceof Set) {
                        newSetList.add(aItem);
                        continue;
                    }
                    if (aItem instanceof Parameter) {
                        newParList.add(aItem);
                        continue;
                    }
                    if (aItem instanceof Variable) {
                        newVarList.add(aItem);
                        continue;
                    }
                    if (!(aItem instanceof Equation)) continue;
                    newEquList.add(aItem);
                }
                db.createItemInDB(dbConn, newSetList, "SET", this.runId);
                db.createItemInDB(dbConn, newParList, "PAR", this.runId);
                db.createItemInDB(dbConn, newVarList, "VAR", this.runId);
                db.createItemInDB(dbConn, newEquList, "EQU", this.runId);
                LinkedList<IndexSet> updatedIndexSets = new LinkedList<IndexSet>();
                for (Item aItem : this.itemList.values()) {
                    if (!aItem.hasUpdatedElements() && !aItem.hasUpdatedComments()) continue;
                    if (aItem instanceof IndexSet) {
                        updatedIndexSets.add((IndexSet)aItem);
                        continue;
                    }
                    if (aItem.hasUpdatedElement) {
                        db.saveItemElementsToDB(dbConn, aItem, this.runId);
                    }
                    if (!aItem.hasUpdatedComments()) continue;
                    db.saveItemCommentsToDB(dbConn, aItem, this.runId);
                }
                db.saveIdxSetToDB(dbConn, updatedIndexSets, this.runId);
            } else if (this.state == ScenarioState.NEW) {
                script = "save new Scenario";
                log.info(String.format("saving Scenario '%s|%s' to database (runid: %d)...", this.model, this.scenario, this.runId));
                db.createKeysInDB(dbConn, this.idKeyMap, this.runId);
                log.debug(String.format("run id: %d - saved key-id map", this.runId));
                db.saveCommentsInDB(dbConn, this.idCommentMap, this.runId);
                log.debug(String.format("run id: %d - saved comments-id map", this.runId));
                db.saveIdxSetToDB(dbConn, this.idxsetList.values(), this.runId);
                db.createSetInDB(dbConn, this.setList.values(), this.runId);
                for (Set set : this.setList.values()) {
                    if (sourceRunId != -1) {
                        db.cloneItemBlobInDB(dbConn, sourceRunId, set.getTypeForDB(), set.getName(), this.runId);
                        continue;
                    }
                    db.saveItemElementsToDB(dbConn, set, this.runId);
                    db.saveItemCommentsToDB(dbConn, set, this.runId);
                }
                db.createParInDB(dbConn, this.parList.values(), this.runId);
                for (Parameter par : this.parList.values()) {
                    if (sourceRunId != -1) {
                        db.cloneItemBlobInDB(dbConn, sourceRunId, par.getTypeForDB(), par.getName(), this.runId);
                        log.debug(String.format("run id: %d - cloned %s directly in database", this.runId, par.getTypeName()));
                        continue;
                    }
                    db.saveItemElementsToDB(dbConn, par, this.runId);
                    db.saveItemCommentsToDB(dbConn, par, this.runId);
                    log.debug(String.format("run id: %d - saved %s", this.runId, par.getTypeName()));
                }
                db.createVarInDB(dbConn, this.varList.values(), this.runId);
                db.createEquInDB(dbConn, this.equList.values(), this.runId);
                if (keepSolution) {
                    for (Variable var : this.varList.values()) {
                        if (sourceRunId != -1) {
                            db.cloneItemBlobInDB(dbConn, sourceRunId, var.getTypeForDB(), var.getName(), this.runId);
                            log.debug(String.format("run id: %d - cloned %s directly in IXMP database", this.runId, var.getTypeName()));
                            continue;
                        }
                        db.saveItemElementsToDB(dbConn, var, this.runId);
                        db.saveItemCommentsToDB(dbConn, var, this.runId);
                        log.debug(String.format("run id: %d - saved %s", this.runId, var.getTypeName()));
                    }
                    for (Equation equ : this.equList.values()) {
                        if (sourceRunId != -1) {
                            db.cloneItemBlobInDB(dbConn, sourceRunId, equ.getTypeForDB(), equ.getName(), this.runId);
                            log.debug(String.format("run id: %d - cloned %s directly in IXMP database", this.runId, equ.getTypeName()));
                            continue;
                        }
                        db.saveItemElementsToDB(dbConn, equ, this.runId);
                        db.saveItemCommentsToDB(dbConn, equ, this.runId);
                        log.debug(String.format("run id: %d - saved %s", this.runId, equ.getTypeName()));
                    }
                }
                if (sourceRunId != -1) {
                    db.cloneTimeseriesInDB(dbConn, sourceRunId, true, null, this.runId);
                    if (keepTimeSeries) {
                        db.cloneTimeseriesInDB(dbConn, sourceRunId, false, null, this.runId);
                    } else if (firstYear != null) {
                        db.cloneTimeseriesInDB(dbConn, sourceRunId, false, firstYear, this.runId);
                    }
                }
            }
            if (sourceRunId == -1) {
                this.persistTimeseriesCaches(dbConn);
            }
            this.finalizeCommit(dbConn, script, annotation, user);
            tm.commit();
        }
        catch (IxException | SQLException e) {
            throw new IxException("There was a problem writing data to the IXMP database - no changes were saved!", e);
        }
        this.checkIn(user);
    }

    @Override
    public void discardChanges(String user) throws IxException {
        if (this.state == ScenarioState.NEW) {
            throw new IxException("This Scenario was not yet saved to the database - no changes to discard!");
        }
        if (this.state == ScenarioState.DEFAULT) {
            throw new IxException("This Scenario is not checked out - no changes to discard!");
        }
        LockInfoDTO lockInfo = this.getMp().getDb().getLockInfo(this.runId);
        if (lockInfo != null && !lockInfo.getLockUser().equals(user)) {
            throw new IxException(String.format("Unlocking is only allowed for the user who locked a Scenario (user: %s)", lockInfo.getLockUser()));
        }
        log.info("discarding all changes...");
        this.loadScenFromDB(this.runId);
        this.checkIn(user);
    }

    @Override
    protected void checkIn(String user) throws IxException {
        super.checkIn(user);
        this.newKeyList = new HashMap<Integer, String>();
        this.newCommentList = new HashMap<Integer, String>();
        this.newItemList = new LinkedHashSet<Item>();
        this.removedItemList = new LinkedHashSet<String>();
    }

    private void copyFrom(TimeSeries source, boolean keepSolution) throws IxException {
        super.copyFrom(source);
        if (source instanceof Scenario) {
            Scenario sourceScenario = (Scenario)source;
            this.scheme = sourceScenario.scheme;
            this.seqItemId = sourceScenario.seqItemId;
            this.idKeyMap = new HashMap<Integer, String>(sourceScenario.idKeyMap);
            this.keyIdMap = new HashMap<String, Integer>(sourceScenario.keyIdMap);
            this.keyUnique = new HashSet<String>(sourceScenario.keyUnique);
            this.seqKeyId = sourceScenario.seqKeyId;
            this.idCommentMap = new HashMap<Integer, String>(sourceScenario.idCommentMap);
            this.commentIdMap = new HashMap<String, Integer>(sourceScenario.commentIdMap);
            this.seqCommentId = sourceScenario.seqCommentId;
            for (String key : sourceScenario.idxsetList.keySet()) {
                this.addToItemList(sourceScenario.idxsetList.get(key).copyTo(this));
            }
            for (String key : sourceScenario.setList.keySet()) {
                this.addToItemList(sourceScenario.setList.get(key).copyTo(this));
            }
            for (String key : sourceScenario.parList.keySet()) {
                this.addToItemList(sourceScenario.parList.get(key).copyTo(this));
            }
            for (String key : sourceScenario.varList.keySet()) {
                this.addToItemList(sourceScenario.varList.get(key).copyTo(this, keepSolution));
            }
            for (String key : sourceScenario.equList.keySet()) {
                this.addToItemList(sourceScenario.equList.get(key).copyTo(this, keepSolution));
            }
            log.info(String.format("Copied: %d sets, %d parameters, %d variables and %d equations", this.setList.size(), this.parList.size(), this.varList.size(), this.equList.size()));
        }
    }

    @Override
    protected void copyFrom(TimeSeries source) throws IxException {
        this.copyFrom(source, true);
    }

    public void setMeta(String name, Serializable value) throws IxException {
        this.setMeta(Collections.singletonMap(name, value));
    }

    public void setMeta(Map<String, Serializable> metadata) throws IxException {
        if (this.state == ScenarioState.NEW || this.state == ScenarioState.UNAVAILABLE) {
            throw new IxException("Cannot save meta indicators for unsaved scenario");
        }
        this.getMp().setMeta(this.getModel(), this.getScenario(), Long.valueOf(this.getVersion()), metadata);
    }

    public void setMetaStr(String name, String value) throws IxException {
        this.setMeta(name, (Serializable)((Object)value));
    }

    public void setMetaNum(String name, double value) throws IxException {
        this.setMeta(name, BigDecimal.valueOf(value));
    }

    public void setMetaNum(String name, long value) throws IxException {
        this.setMeta(name, BigDecimal.valueOf(value));
    }

    public void setMetaNum(String name, int value) throws IxException {
        this.setMeta(name, BigDecimal.valueOf(value));
    }

    public void setMetaBool(String name, boolean value) throws IxException {
        this.setMeta(name, Boolean.valueOf(value));
    }

    public void removeMeta(String name) throws IxException {
        this.removeMeta(Collections.singletonList(name));
    }

    public void removeMeta(List<String> names) throws IxException {
        if (this.state == ScenarioState.NEW || this.state == ScenarioState.UNAVAILABLE) {
            throw new IxException("Cannot remove meta indicators from unsaved scenario");
        }
        this.getMp().removeMeta(this.getModel(), this.getScenario(), Long.valueOf(this.getVersion()), names);
    }

    public Map<String, Serializable> getMeta() throws IxException {
        return this.getMeta(false);
    }

    public Map<String, Serializable> getMeta(boolean strict) throws IxException {
        return this.getMp().getMeta(this.getModel(), this.getScenario(), Long.valueOf(this.getVersion()), strict);
    }

    public static class CloneParams {
        private String newModel;
        private String newScenario;
        private String annotation;
        private boolean keepSolution;
        private Integer firstYear;
        private String user;
        private boolean keepMetadata;

        private static boolean $default$keepSolution() {
            return false;
        }

        private static String $default$user() {
            return System.getProperty("user.name", "(unknown)");
        }

        private static boolean $default$keepMetadata() {
            return true;
        }

        CloneParams(String newModel, String newScenario, String annotation, boolean keepSolution, Integer firstYear, String user, boolean keepMetadata) {
            this.newModel = newModel;
            this.newScenario = newScenario;
            this.annotation = annotation;
            this.keepSolution = keepSolution;
            this.firstYear = firstYear;
            this.user = user;
            this.keepMetadata = keepMetadata;
        }

        public static CloneParamsBuilder builder() {
            return new CloneParamsBuilder();
        }

        public String getNewModel() {
            return this.newModel;
        }

        public String getNewScenario() {
            return this.newScenario;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public boolean isKeepSolution() {
            return this.keepSolution;
        }

        public Integer getFirstYear() {
            return this.firstYear;
        }

        public String getUser() {
            return this.user;
        }

        public boolean isKeepMetadata() {
            return this.keepMetadata;
        }

        public void setNewModel(String newModel) {
            this.newModel = newModel;
        }

        public void setNewScenario(String newScenario) {
            this.newScenario = newScenario;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        public void setKeepSolution(boolean keepSolution) {
            this.keepSolution = keepSolution;
        }

        public void setFirstYear(Integer firstYear) {
            this.firstYear = firstYear;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setKeepMetadata(boolean keepMetadata) {
            this.keepMetadata = keepMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloneParams)) {
                return false;
            }
            CloneParams other = (CloneParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newModel = this.getNewModel();
            String other$newModel = other.getNewModel();
            if (this$newModel == null ? other$newModel != null : !this$newModel.equals(other$newModel)) {
                return false;
            }
            String this$newScenario = this.getNewScenario();
            String other$newScenario = other.getNewScenario();
            if (this$newScenario == null ? other$newScenario != null : !this$newScenario.equals(other$newScenario)) {
                return false;
            }
            String this$annotation = this.getAnnotation();
            String other$annotation = other.getAnnotation();
            if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
                return false;
            }
            if (this.isKeepSolution() != other.isKeepSolution()) {
                return false;
            }
            Integer this$firstYear = this.getFirstYear();
            Integer other$firstYear = other.getFirstYear();
            if (this$firstYear == null ? other$firstYear != null : !((Object)this$firstYear).equals(other$firstYear)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            return this.isKeepMetadata() == other.isKeepMetadata();
        }

        protected boolean canEqual(Object other) {
            return other instanceof CloneParams;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newModel = this.getNewModel();
            result = result * 59 + ($newModel == null ? 43 : $newModel.hashCode());
            String $newScenario = this.getNewScenario();
            result = result * 59 + ($newScenario == null ? 43 : $newScenario.hashCode());
            String $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            result = result * 59 + (this.isKeepSolution() ? 79 : 97);
            Integer $firstYear = this.getFirstYear();
            result = result * 59 + ($firstYear == null ? 43 : ((Object)$firstYear).hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            result = result * 59 + (this.isKeepMetadata() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "Scenario.CloneParams(newModel=" + this.getNewModel() + ", newScenario=" + this.getNewScenario() + ", annotation=" + this.getAnnotation() + ", keepSolution=" + this.isKeepSolution() + ", firstYear=" + this.getFirstYear() + ", user=" + this.getUser() + ", keepMetadata=" + this.isKeepMetadata() + ")";
        }

        public static class CloneParamsBuilder {
            private String newModel;
            private String newScenario;
            private String annotation;
            private boolean keepSolution$set;
            private boolean keepSolution$value;
            private Integer firstYear;
            private boolean user$set;
            private String user$value;
            private boolean keepMetadata$set;
            private boolean keepMetadata$value;

            CloneParamsBuilder() {
            }

            public CloneParamsBuilder newModel(String newModel) {
                this.newModel = newModel;
                return this;
            }

            public CloneParamsBuilder newScenario(String newScenario) {
                this.newScenario = newScenario;
                return this;
            }

            public CloneParamsBuilder annotation(String annotation) {
                this.annotation = annotation;
                return this;
            }

            public CloneParamsBuilder keepSolution(boolean keepSolution) {
                this.keepSolution$value = keepSolution;
                this.keepSolution$set = true;
                return this;
            }

            public CloneParamsBuilder firstYear(Integer firstYear) {
                this.firstYear = firstYear;
                return this;
            }

            public CloneParamsBuilder user(String user) {
                this.user$value = user;
                this.user$set = true;
                return this;
            }

            public CloneParamsBuilder keepMetadata(boolean keepMetadata) {
                this.keepMetadata$value = keepMetadata;
                this.keepMetadata$set = true;
                return this;
            }

            public CloneParams build() {
                boolean keepSolution$value = this.keepSolution$value;
                if (!this.keepSolution$set) {
                    keepSolution$value = CloneParams.$default$keepSolution();
                }
                String user$value = this.user$value;
                if (!this.user$set) {
                    user$value = CloneParams.$default$user();
                }
                boolean keepMetadata$value = this.keepMetadata$value;
                if (!this.keepMetadata$set) {
                    keepMetadata$value = CloneParams.$default$keepMetadata();
                }
                return new CloneParams(this.newModel, this.newScenario, this.annotation, keepSolution$value, this.firstYear, user$value, keepMetadata$value);
            }

            public String toString() {
                return "Scenario.CloneParams.CloneParamsBuilder(newModel=" + this.newModel + ", newScenario=" + this.newScenario + ", annotation=" + this.annotation + ", keepSolution$value=" + this.keepSolution$value + ", firstYear=" + this.firstYear + ", user$value=" + this.user$value + ", keepMetadata$value=" + this.keepMetadata$value + ")";
            }
        }
    }
}

