/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Set
extends Item {
    Set(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames) {
        super(mp);
        this.initializeIXItem(scenario, name, "set");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Set(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames, String scheme) {
        super(mp);
        this.initializeIXItem(scenario, name, "set");
        this.setIXitemIdDims(indexSets, indexNames, scheme);
        scenario.addToItemList(this);
    }

    public Set(Platform mp, Scenario scenario, String name, int itemId, int dim) {
        super(mp);
        this.initializeIXItem(scenario, name, "set", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    protected Set(Platform mp) {
        super(mp);
    }

    public void addElement(String key) throws IxException {
        this.addElement(this.getKeyIdVector(key), (String)null);
    }

    public void addElement(String key, String comment) throws IxException {
        this.addElement(this.getKeyIdVector(key), comment);
    }

    public void addElement(List<String> pKeyList) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList));
    }

    public void addElement(List<String> pKeyList, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pComment);
    }

    public void addElement(Vector<Integer> pEleVector) throws IxException {
        this.addElement(pEleVector, (String)null);
    }

    public void addElement(Vector<Integer> keyVector, String comment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        Element ele = (Element)this.eleMap.get(keyVector);
        if (ele == null) {
            ele = new Element(this, keyVector);
            this.addItemElement(ele, comment);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add set element", this.name, ele.getConcatKey());
            }
        }
        if (comment != null) {
            this.addItemComment(ele, comment);
        }
    }

    public void removeElement(String pEleKey) throws IxException {
        this.removeElement(this.getKeyIdVector(pEleKey));
    }

    public void removeElement(List<String> pKeyList) throws IxException {
        this.removeElement(this.getKeyIdVector(pKeyList));
    }

    public void removeElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException(String.format("The set '%s' does not have an element '%s', cannot be removed!", this.name, this.getConcatKey(pEleVector)));
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(Element pEle) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (this.hasElement(pEle.getVector())) {
            this.hasUpdatedElement = true;
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("delete set element", this.name, pEle.getConcatKey());
            }
            super.removeItemElement(pEle);
        }
    }

    public boolean isIndexSet() {
        return this.dim == 0;
    }

    List<Map<Object, Object>> toJsonList(Map<String, List<String>> eleListFilter) throws IxException {
        LinkedList<Map<Object, Object>> jsonList = new LinkedList<Map<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            jsonList.add(this.toMap(ele, "set"));
        }
        return jsonList;
    }

    @Override
    protected Item createInstance(Platform platform) {
        return new Set(platform);
    }
}

