/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.utils;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.utils.RegionUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVUtils {
    private static final Logger log = LoggerFactory.getLogger(CSVUtils.class);

    public static void loadTimeseriesFromCSV(TimeSeries ts, String filename) throws IxException {
        Platform mp = ts.getMp();
        try (CSVParser parser = new CSVParser((Reader)new FileReader(filename), CSVFormat.DEFAULT);){
            LinkedHashMap<Integer, String> years = new LinkedHashMap<Integer, String>();
            int index = 0;
            for (CSVRecord record : parser) {
                if (index == 0) {
                    int yearIndex = 0;
                    for (String year : record) {
                        if (yearIndex >= 5) {
                            years.put(yearIndex, year);
                        }
                        ++yearIndex;
                    }
                } else if (Objects.equals(ts.getModel(), record.get(0)) && Objects.equals(ts.getScenario(), record.get(1))) {
                    String region = record.get(2);
                    RegionUtils.addRegionIfNotExists(mp, region);
                    String variable = record.get(3);
                    String unit = record.get(4);
                    LinkedHashMap<Integer, Double> yearlyValues = new LinkedHashMap<Integer, Double>(years.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getValue()), e -> Double.parseDouble(record.get(((Integer)e.getKey()).intValue())))));
                    ts.removeTimeseries(region, variable, null, new LinkedList<Integer>(yearlyValues.keySet()), unit);
                    ts.addTimeseries(region, variable, null, yearlyValues, unit, 0);
                }
                ++index;
            }
            log.info(String.format("Loaded %d timeseries entries from %s", index, filename));
        }
        catch (IOException e2) {
            String message = "Could not load timeseries from file!";
            log.error(message, (Throwable)e2);
            throw new IxException(message, e2);
        }
    }
}

