/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import java.io.File;
import java.io.IOException;

public class GAMSGlobals {
    public static final int MAXDIM = 20;
    public static final int STR_LEN = 256;
    public static final int MAX_NO_IDIR = 40;
    public static final String EMPTY_STRING = new String();
    public static final String GAMS_CALLSTR = "gams";
    public static final String CHECKPOINT_FILE_EXTENSION = ".g00";
    public static final String GAMS_FILE_EXTENSION = ".gms";
    public static final String GDX_FILE_EXTENSION = ".gdx";
    public static final String LOG_FILE_EXTENSION = ".log";
    public static final String OPT_FILE_EXTENSION = ".opt";
    public static final String OUTPUT_FILE_EXTENSION = ".lst";
    public static final String PARAMETER_FILE_EXTENSION = ".pf";
    public static final String JOB_NAME_PREFIX = "gjo";
    public static final String DB_NAME_PREFIX = "gdb";
    public static final String CP_NAME_PREFIX = "gcp";
    public static final String MI_NAME_PREFIX = "gmi";
    public static final String WINDOW_EXEC_EXTENSION = ".exe";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static String scratchFilePrefix = "_gams_java_";
    public static String workingDirectory = System.getProperty("java.io.tmpdir");
    static final String GAMS_OPTION_FILE = "optgams.def";
    static final String GAMS_LOG_FILE = "gamslog.dat";
    static final String GAMS_SOLVERCONTR_FILE = "gamscntr.dat";
    static final String GAMS_CONVERT_OPT_FILE = "convert.opt";
    static final String GAMS_CONVERTD_OPT_FILE = "convertd.opt";
    static final String GAMS_STMP_TXT_FILE = "gamsstmp.txt";

    public static OSType getOSType() {
        if (OS_NAME.indexOf("win") >= 0) {
            return OSType.WINDOWS;
        }
        if (OS_NAME.indexOf("nix") >= 0) {
            return OSType.UNIX;
        }
        if (OS_NAME.indexOf("nux") >= 0) {
            return OSType.LINUX;
        }
        if (OS_NAME.indexOf("mac") >= 0) {
            return OSType.MAC;
        }
        if (OS_NAME.indexOf("sunos") >= 0) {
            return OSType.SOLARIS;
        }
        return OSType.UNKNOWN;
    }

    public static ArchType getArchType() {
        ArchType archType = ArchType.UNKNOWN;
        archType = System.getProperty("os.arch").toLowerCase().indexOf("64") >= 0 || System.getProperty("os.arch").toLowerCase().indexOf("sparcv9") >= 0 ? ArchType.ARCH_64_BITS : ArchType.ARCH_32_BITS;
        return archType;
    }

    public static void setScratchFilePrefix(String string) {
        scratchFilePrefix = string;
    }

    public static void setWorkingDirectory(String string) {
        workingDirectory = string;
    }

    static String getGAMSCmpFile() {
        if (GAMSGlobals.getOSType() == OSType.WINDOWS) {
            return "gmscmpNT.txt";
        }
        return "gmscmpun.txt";
    }

    static String getPathOfACallString(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (String string3 : string.split(PATH_SEPARATOR)) {
            File file;
            if (string3.endsWith(FILE_SEPARATOR)) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (!string3.endsWith(string2) || !(file = new File(string3 = string3.substring(0, string3.lastIndexOf(string2)))).isDirectory()) continue;
            File file2 = new File(string3);
            return GAMSGlobals.getCanonicalPath(file2);
        }
        return null;
    }

    static String getCanonicalPath(File file) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugLevel {
        OFF("off"),
        KEEP_FILES("keepfiles"),
        SHOW_LOG("showlog"),
        VERBOSE("verbose"),
        UNDEFINED_LEVEL("undefined");

        private final String message;

        public static DebugLevel lookup(int n) {
            if (n >= 0 && n < DebugLevel.values().length - 1) {
                return DebugLevel.values()[n];
            }
            return UNDEFINED_LEVEL;
        }

        public boolean equals(DebugLevel debugLevel) {
            return this.value() == debugLevel.value();
        }

        public boolean isLowerThan(DebugLevel debugLevel) {
            return this.value() < debugLevel.value();
        }

        public boolean isHigherThan(DebugLevel debugLevel) {
            return this.value() > debugLevel.value();
        }

        public int value() {
            return this.ordinal();
        }

        public static DebugLevel lookup(String string) {
            DebugLevel[] debugLevelArray = DebugLevel.values();
            DebugLevel debugLevel = UNDEFINED_LEVEL;
            for (int i = 0; i < debugLevelArray.length; ++i) {
                if (!string.equals(debugLevelArray[i].message())) continue;
                debugLevel = debugLevelArray[i];
                break;
            }
            return debugLevel;
        }

        public String message() {
            return this.message;
        }

        private DebugLevel(String string2) {
            this.message = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitCodeMessage {
        RETURN(0, "normal return"),
        SOLVER_TO_BE_CALLED(1, "solver is to be called"),
        COMPILATION_ERROR(2, "there was a compilation error"),
        EXECUTION_ERROR(3, "there was an execution error"),
        SYSTEM_LIMIT_REACHED(4, "system limits were reached"),
        FILE_ERROR(5, "there was a file error"),
        PARAMETER_ERROR(6, "there was a parameter error"),
        LICENSING_ERROR(7, "there was a licensing error"),
        GAMS_SYSTEM_ERROR(8, "there was a GAMS system error"),
        GAMS_NOT_STARTED(9, "GAMS cold not be started"),
        OUT_OF_MEMORY(10, "out of memory"),
        OUT_OF_DISK(11, "out of disk"),
        COULD_NOT_CREATE_SCRATCH_DIR(109, "could not create process/scratch directory"),
        TOO_MANY_SCRATCH_DIRS(110, "too many process/scratch directories "),
        COULD_NOT_DELETEL_SCRATCH_DIR(112, "could not delete process/scratch directory"),
        COULD_NOT_WRITE_GAMSNEXT_SCRIPT(113, "could not write the \"gamsnext\" script"),
        COULD_NOT_WRITE_PARAMETER_FILE(114, "could not write the \"parameter\" file"),
        COULD_NOT_SPAWN_GAMS_CMEX(400, "could not spawn the GAMS language compiler (gamscmex)"),
        CURRENT_DIR_NOT_FOUND(401, "current directory (curdir) does not exist"),
        CURRENT_DIR_NOT_SET(402, "could not set current directory (curdir)"),
        BLANK_IN_SYSTEM_DIR(404, "blank in system directory (UNIX only)"),
        BLANK_IN_CURRENT_DIR(405, "blank in current directory (UNIX only)"),
        BLANK_IN_SCRATCH_EXTENSION(406, "blank in scratch extension (scrext)"),
        UNEXPECTED_CMEXRC(407, "unexpected cmexRC"),
        PROCESS_DIR_NOT_FOUND(408, "could not find the process directory (procdir)"),
        CMEX_LIB_NOT_FOUND(409, "CMEX library not found (experimental)"),
        CMEX_LIB_ENTRYPOINT_NOT_FOUND(410, "entry point in CMEX library not found (experimental)"),
        BLANK_IN_PROCESS_DIR(411, "blank in process directory (UNIX only)"),
        BLANK_IN_SCRATCH_DIR(412, "blank in scratch directory (UNIX only)"),
        COULD_NOT_ADD_PATH(909, "could not add path/unknown UNIX environment/cannot set environment variable"),
        INCORRECT_COMMAND_LINE_PARAMETER(1000, "driver error: incorrect command line parameter for gams.exe"),
        COULD_NOT_INSTALL_INTERRUPT_HANDLER(2000, "internal error: could not install interrupt handler"),
        COULD_NOT_GET_CURRENT_DIR(3000, "driver error: problems getting current directory"),
        CMEX_NOT_FOUND(4000, "driver error: internal error: GAMS compile and execute module not found"),
        OPTION_NOT_FOUND(5000, "driver error: internal error: Cannot load option handling library"),
        UNDEFINED_EXIT_CODE(Integer.MAX_VALUE, "undefined GAMS exit code");

        private final int value;
        private final String message;

        public static ExitCodeMessage lookup(int n) {
            ExitCodeMessage[] exitCodeMessageArray = ExitCodeMessage.values();
            ExitCodeMessage exitCodeMessage = UNDEFINED_EXIT_CODE;
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < exitCodeMessageArray.length) {
                if (exitCodeMessageArray[n2].value() == n) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                exitCodeMessage = exitCodeMessageArray[n2];
            }
            return exitCodeMessage;
        }

        public String message() {
            return this.message;
        }

        public int value() {
            return this.value;
        }

        private ExitCodeMessage(int n2, String string2) {
            this.value = n2;
            this.message = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateAction {
        UPPER(1),
        LOWER(2),
        FIXED(3),
        PRIMAL(4),
        DUAL(5),
        UNDEFINED_ACTION(6);

        private final int value;

        public static UpdateAction lookup(int n) {
            UpdateAction[] updateActionArray = UpdateAction.values();
            UpdateAction updateAction = UNDEFINED_ACTION;
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < updateActionArray.length) {
                if (updateActionArray[n2].value() == n) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                updateAction = updateActionArray[n2];
            }
            return updateAction;
        }

        public int value() {
            return this.value;
        }

        private UpdateAction(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModelStat {
        OPTIMAL_GLOBAL(1),
        OPTIMAL_LOCAL(2),
        UNBOUNDED(3),
        INFEASIBLE_GLOBAL(4),
        INFEASIBLE_LOCAL(5),
        INFEASIBLE_INTERMED(6),
        FEASIBLE(7),
        INTEGER(8),
        NON_INTEGER_INTERMED(9),
        INTEGER_INFEASIBLE(10),
        LICENSE_ERROR(11),
        ERROR_UNKNOWN(12),
        ERROR_NO_SOLUTION(13),
        NO_SOLUTION_RETURNED(14),
        SOLVED_UNIQUE(15),
        SOLVED(16),
        SOLVED_SINGULAR(17),
        UNBOUNDED_NO_SOLUTION(18),
        INFEASIBLE_NO_SOLUTION(19),
        UNDEFINED_STAT(20);

        private final int value;

        public static ModelStat lookup(int n) {
            ModelStat[] modelStatArray = ModelStat.values();
            ModelStat modelStat = UNDEFINED_STAT;
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < modelStatArray.length) {
                if (modelStatArray[n2].value() == n) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                modelStat = modelStatArray[n2];
            }
            return modelStat;
        }

        public int value() {
            return this.value;
        }

        private ModelStat(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SolveStat {
        NORMAL(1),
        ITERATION(2),
        RESOURCE(3),
        SOLVER(4),
        EVAL_ERROR(5),
        CAPABILITY(6),
        LICENSE(7),
        USER(8),
        SETUP_ERR(9),
        SOLVER_ERR(10),
        INTERNAL_ERR(11),
        SKIPPED(12),
        SYSTEM_ERR(13),
        UNDEFINED_STAT(14);

        private final int value;

        public static SolveStat lookup(int n) {
            SolveStat[] solveStatArray = SolveStat.values();
            SolveStat solveStat = UNDEFINED_STAT;
            boolean bl = false;
            int n2 = 0;
            while (!bl && n2 < solveStatArray.length) {
                if (solveStatArray[n2].value() == n) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                solveStat = solveStatArray[n2];
            }
            return solveStat;
        }

        public int value() {
            return this.value;
        }

        private SolveStat(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VarType {
        UNKNOWN,
        BINARY,
        INTEGER,
        POSITIVE,
        NEGATIVE,
        FREE,
        SOS1,
        SOS2,
        SEMICONT,
        SEMIINT,
        UNDEFINED_TYPE;


        public static VarType lookup(int n) {
            if (n >= 0 && n < VarType.values().length - 1) {
                return VarType.values()[n];
            }
            return UNDEFINED_TYPE;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EquType {
        E,
        G,
        L,
        N,
        X,
        C,
        UNDEFINED_TYPE;


        public static EquType lookup(int n) {
            if (n >= 0 && n < EquType.values().length - 1) {
                return EquType.values()[n];
            }
            return UNDEFINED_TYPE;
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialValues {
        UNDEFINED(1.0E300),
        NAN(Double.NaN),
        PLUS_INF(Double.POSITIVE_INFINITY),
        MINUS_INF(Double.NEGATIVE_INFINITY),
        EPS(Double.MIN_VALUE),
        ACRONYM(1.0E301),
        UNDEFINED_VALUE(0.0);

        private double value;

        public static double[] doubleValues() {
            int n = SpecialValues.values().length;
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = SpecialValues.values()[i].value();
            }
            return dArray;
        }

        public static SpecialValues lookup(double d) {
            SpecialValues[] specialValuesArray = SpecialValues.values();
            SpecialValues specialValues = UNDEFINED_VALUE;
            boolean bl = false;
            int n = 0;
            while (!bl && n < specialValuesArray.length) {
                if (specialValuesArray[n].value() == d) {
                    bl = true;
                    continue;
                }
                ++n;
            }
            if (bl) {
                specialValues = specialValuesArray[n];
            }
            return specialValues;
        }

        void setValue(double d) {
            this.value = d;
        }

        public double value() {
            return this.value;
        }

        private SpecialValues(double d) {
            this.value = d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        SET,
        PAR,
        VAR,
        EQU,
        ALIAS,
        MAX,
        UNDEFINED_TYPE;


        public static DataType lookup(int n) {
            if (n >= 0 && n < DataType.values().length - 1) {
                return DataType.values()[n];
            }
            return UNDEFINED_TYPE;
        }

        public boolean equals(DataType dataType) {
            return this.value() == dataType.value();
        }

        public int value() {
            return this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArchType {
        ARCH_32_BITS,
        ARCH_64_BITS,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSType {
        WINDOWS,
        UNIX,
        LINUX,
        MAC,
        SOLARIS,
        UNKNOWN;

    }
}

