/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSCheckpoint;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSEquation;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSJob;
import com.gams.api.GAMSModelInstanceOpt;
import com.gams.api.GAMSModifier;
import com.gams.api.GAMSOptions;
import com.gams.api.GAMSParameter;
import com.gams.api.GAMSSet;
import com.gams.api.GAMSSymbol;
import com.gams.api.GAMSVariable;
import com.gams.api.gevm;
import com.gams.api.gmom;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class GAMSModelInstance {
    private gevm GEV;
    private gmom GMO;
    private GAMSCheckpoint miCheckpoint;
    private String miModelInstanceName;
    private String miScrDir;
    private GAMSDatabase miSyncDB;
    private List<GAMSModifier> miModifiers;
    private boolean miInstantiated;
    private boolean miLogAvailable;
    private String miSelectedSolver = GAMSGlobals.EMPTY_STRING;
    private boolean _disposed = false;

    GAMSModelInstance(GAMSCheckpoint gAMSCheckpoint) {
        this(gAMSCheckpoint, null);
    }

    GAMSModelInstance(GAMSCheckpoint gAMSCheckpoint, String string) {
        assert (gAMSCheckpoint != null);
        gAMSCheckpoint.cpWorkspace.debugMessage("--- Entering GAMSModelInstance constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        if (string == null) {
            this.miModelInstanceName = gAMSCheckpoint.cpWorkspace.verifyModelInstanceName(GAMSGlobals.EMPTY_STRING);
        } else {
            if (gAMSCheckpoint.cpWorkspace.containsMI(string)) {
                throw new GAMSException("GAMSModelInstance with name [" + string + "] already exists");
            }
            this.miModelInstanceName = string;
        }
        this.miCheckpoint = gAMSCheckpoint;
        this.miScrDir = this.miCheckpoint.cpWorkspace.workingDirectory() + GAMSGlobals.FILE_SEPARATOR + this.miModelInstanceName;
        this.miSyncDB = new GAMSDatabase(this.miCheckpoint.cpWorkspace);
        this.miSyncDB.dbRecordLock = true;
        this._disposed = false;
        this.GEV = this.createGEVObject(this.miCheckpoint.cpWorkspace.systemDirectory());
        this.GMO = this.createGMOObject(this.miCheckpoint.cpWorkspace.systemDirectory());
        this.miModifiers = new ArrayList<GAMSModifier>();
        this.miInstantiated = false;
    }

    GAMSModelInstance(GAMSModelInstance gAMSModelInstance) {
        this(gAMSModelInstance, null);
    }

    GAMSModelInstance(GAMSModelInstance gAMSModelInstance, String string) {
        File file;
        assert (gAMSModelInstance != null);
        gAMSModelInstance.miCheckpoint.cpWorkspace.debugMessage("--- Entering GAMSModelInstance constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        if (gAMSModelInstance._disposed) {
            throw new GAMSException("Could not copy the instance, source GAMSModelInstance has already been disposed");
        }
        if (!gAMSModelInstance.miInstantiated) {
            throw new GAMSException("Could not copy the instnace, source GAMSModelInstance is not instantiated");
        }
        if (string == null) {
            this.miModelInstanceName = gAMSModelInstance.miCheckpoint.cpWorkspace.verifyModelInstanceName(GAMSGlobals.EMPTY_STRING);
        } else {
            if (gAMSModelInstance.miCheckpoint.cpWorkspace.containsMI(string)) {
                throw new GAMSException("Source GAMSModelInstance with name [" + string + "] already exists");
            }
            this.miModelInstanceName = string;
        }
        this.miCheckpoint = gAMSModelInstance.miCheckpoint;
        if (!this.miCheckpoint.cpWorkspace.workingDirectory().endsWith(GAMSGlobals.FILE_SEPARATOR)) {
            this.miScrDir = this.miScrDir + GAMSGlobals.FILE_SEPARATOR;
        }
        if ((file = new File(this.miCheckpoint.cpWorkspace.workingDirectory(), this.miModelInstanceName)).exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.miScrDir = file.getAbsolutePath();
        this.miSyncDB = this.miCheckpoint.cpWorkspace.addDatabase(gAMSModelInstance.SyncDB());
        this.GEV = this.createGEVObject(this.miCheckpoint.cpWorkspace.systemDirectory());
        this.GMO = this.createGMOObject(this.miCheckpoint.cpWorkspace.systemDirectory());
        this.miModifiers = new ArrayList<GAMSModifier>();
        for (GAMSModifier stringArray2 : gAMSModelInstance.miModifiers) {
            if (stringArray2.mDataSymbol == null) {
                this.miModifiers.add(new GAMSModifier(this.miSyncDB.getParameter(stringArray2.getGamsSymbol().getName()), stringArray2.getUpdateType()));
                continue;
            }
            if (stringArray2.getGamsSymbol() instanceof GAMSVariable) {
                this.miModifiers.add(new GAMSModifier(this.miSyncDB.getVariable(stringArray2.getGamsSymbol().getName()), stringArray2.mUpdateAction, this.miSyncDB.getParameter(stringArray2.getDataSymbol().getName()), stringArray2.getUpdateType()));
                continue;
            }
            if (stringArray2.getGamsSymbol() instanceof GAMSEquation) {
                this.miModifiers.add(new GAMSModifier(this.miSyncDB.getEquation(stringArray2.getGamsSymbol().getName()), stringArray2.mUpdateAction, this.miSyncDB.getParameter(stringArray2.getDataSymbol().getName()), stringArray2.getUpdateType()));
                continue;
            }
            throw new GAMSException("Unexpected Symbol as Modifier");
        }
        String[] stringArray3 = new String[]{GAMSGlobals.EMPTY_STRING};
        if (gAMSModelInstance.GEV.DuplicateScratchDir(this.miScrDir, new File(this.miScrDir, "gamslog.dat").getAbsolutePath(), stringArray3) != 0) {
            throw new GAMSException("Could not create GAMSModelInstance, duplicated scratch directory");
        }
        if (this.GEV.InitEnvironmentLegacy(stringArray3[0]) != 0) {
            throw new GAMSException("Could not initialize GAMSModelInstance");
        }
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        this.GMO.RegisterEnvironment(this.GEV.GetgevPtr(), stringArray);
        if (this.GMO.LoadDataLegacy(stringArray) != 0) {
            throw new GAMSException("Could not load GAMSModelInstance : " + stringArray);
        }
        this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().RegisterGMO(this.GMO.GetgmoPtr()));
        this.miLogAvailable = gAMSModelInstance.miLogAvailable;
        this.miSelectedSolver = gAMSModelInstance.miSelectedSolver;
        String string2 = gAMSModelInstance.GMO.NameOptFile();
        File file2 = new File(string2);
        String string3 = GAMSGlobals.EMPTY_STRING;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n + 1);
        }
        File file3 = new File(file2.getParent(), this.miSelectedSolver + "." + string3);
        this.GMO.NameOptFileSet(file3.getAbsolutePath());
        this.miInstantiated = true;
        this.miSyncDB.dbSymbolLock = true;
        this.miSyncDB.dbRecordLock = false;
    }

    public GAMSModelInstance copyModelInstance() {
        return new GAMSModelInstance(this, null);
    }

    public GAMSModelInstance copyModelInstance(String string) {
        return new GAMSModelInstance(this, string);
    }

    private gevm createGEVObject(String string) {
        gevm gevm2 = new gevm();
        String[] stringArray = new String[]{""};
        if (gevm2.CreateD(string, stringArray) != 1) {
            throw new GAMSException("gev instance could not create the directorty [" + string + "]");
        }
        return gevm2;
    }

    private gmom createGMOObject(String string) {
        gmom gmom2 = new gmom();
        String[] stringArray = new String[]{""};
        if (gmom2.CreateD(string, stringArray) != 1) {
            throw new GAMSException("gmo instance could not create the directorty [" + string + "]");
        }
        return gmom2;
    }

    public void instantiate(String string, GAMSModifier ... gAMSModifierArray) {
        this.instantiate(string, (GAMSOptions)null, gAMSModifierArray);
    }

    /*
     * WARNING - void declaration
     */
    public void instantiate(String string, GAMSOptions gAMSOptions, GAMSModifier ... gAMSModifierArray) {
        void var9_34;
        void var9_30;
        if (string == null) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] with a null modelDefinition could not be instantiated");
        }
        if (gAMSModifierArray == null) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] with null modfiers could not be instantiated");
        }
        for (GAMSModifier stringArray2 : gAMSModifierArray) {
            if (stringArray2 != null) continue;
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] with a null modfier could not be instantiated");
        }
        if (this._disposed) {
            throw new GAMSException("this GAMSModelInstance has already been disposed, resources are no longer available");
        }
        if (this.miInstantiated) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] is already instantiated");
        }
        GAMSOptions gAMSOptions2 = new GAMSOptions(this.miCheckpoint.cpWorkspace, gAMSOptions, null);
        int[] nArray = new int[]{0};
        double[] dArray = new double[]{0.0};
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().Info(1, nArray, dArray, stringArray));
        if (nArray[0] > 0) {
            throw new GAMSException("SyncDB of [" + this.miModelInstanceName + "] with unique elements. No AddRecord allowed prior to Instantiate");
        }
        boolean bl = false;
        for (GAMSModifier gAMSModifier : gAMSModifierArray) {
            if (gAMSModifier.mGamsSymbol.symDatabase != this.miSyncDB) {
                throw new GAMSException("GAMSSymbol [" + gAMSModifier.mGamsSymbol.getName() + "] is not part of SyncDB");
            }
            this.miModifiers.add(gAMSModifier);
            if (gAMSModifier.mGamsSymbol instanceof GAMSSet) {
                throw new GAMSException("GAMSSet object cannot be used as GAMSModifier");
            }
            if (!(gAMSModifier.mGamsSymbol instanceof GAMSParameter)) continue;
            bl = true;
        }
        if (gAMSModifierArray.length > 0 && gAMSModifierArray.length < this.miSyncDB.getNumberOfSymbols()) {
            void var9_14;
            boolean bl2 = false;
            for (GAMSSymbol<?> gAMSSymbol : this.miSyncDB) {
                if (!(gAMSSymbol instanceof GAMSParameter)) continue;
                ++var9_14;
            }
            if (gAMSModifierArray.length < var9_14) {
                for (GAMSSymbol<?> gAMSSymbol : this.miSyncDB) {
                    if (!(gAMSSymbol instanceof GAMSParameter)) continue;
                    boolean bl3 = false;
                    GAMSModifier[] gAMSModifierArray2 = gAMSModifierArray;
                    int n = gAMSModifierArray2.length;
                    for (int i = 0; i < n; ++i) {
                        GAMSModifier gAMSModifier = gAMSModifierArray2[i];
                        if (gAMSSymbol.symPtr != gAMSModifier.mGamsSymbol.symPtr) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    throw new GAMSException("Parameter [" + gAMSSymbol.getName() + "] is not a modifier");
                }
            }
        }
        String string2 = "option limrow=0, limcol=0;\n";
        String[] stringArray2 = string.split("\\s+");
        String string3 = stringArray2[1];
        string3 = string3.substring(0, Math.min(3, string3.length())).equalsIgnoreCase("min") || string3.substring(0, Math.min(3, string3.length())).equalsIgnoreCase("max") ? stringArray2[4] : stringArray2[2];
        if (!gAMSOptions2.CFG.AlgCapability(gAMSOptions2.CFG.AlgNumber("convertd"), gAMSOptions2.CFG.ModelTypeNumber(string3))) {
            throw new GAMSException("invalid model type [" + string3 + "] from [" + string + "]");
        }
        String string4 = string2 + "option " + string3 + " = convertd;";
        if (bl) {
            void var9_27;
            void var9_18;
            String string5 = string4 + "Set s__(*) /'s0'/;\n";
            for (GAMSModifier gAMSModifier : gAMSModifierArray) {
                void var9_23;
                void var9_20;
                int n;
                if (!(gAMSModifier.mGamsSymbol instanceof GAMSParameter)) continue;
                String string6 = (String)var9_18 + "Parameter s__" + gAMSModifier.mGamsSymbol.getName() + "(s__";
                for (n = 0; n < gAMSModifier.mGamsSymbol.getDimension(); ++n) {
                    String string7 = (String)var9_20 + ",*";
                }
                String string8 = (String)var9_20 + "); s__" + gAMSModifier.mGamsSymbol.getName() + "(s__";
                for (n = 0; n < gAMSModifier.mGamsSymbol.getDimension(); ++n) {
                    String string9 = (String)var9_23 + ",s__";
                }
                String string10 = (String)var9_23 + ") = Eps ;\n";
            }
            String string11 = (String)var9_18 + "Set dict(*,*,*) /\n's__'.'scenario'.''";
            for (GAMSModifier gAMSModifier : gAMSModifierArray) {
                if (!(gAMSModifier.mGamsSymbol instanceof GAMSParameter)) continue;
                String string12 = (String)var9_27 + ",\n'" + gAMSModifier.mGamsSymbol.getName() + "'.'param'.'s__" + gAMSModifier.mGamsSymbol.getName() + "'";
            }
            String string13 = (String)var9_27 + "/;\n";
        }
        String string14 = string.split(" ")[0];
        String string16 = (String)var9_30 + string14 + ".solvelink=2; " + string14 + ".integer1=234; \n";
        string16 = string16 + "solve " + string;
        if (bl) {
            String string17 = string16 + " scenario dict;";
        }
        GAMSJob gAMSJob = GAMSJob.fromString(this.miCheckpoint.cpWorkspace, (String)var9_34, this.miCheckpoint);
        gAMSOptions2.setScrDir(this.miScrDir);
        if (!this.miCheckpoint.cpWorkspace.getDebugLevel().isLowerThan(GAMSGlobals.DebugLevel.SHOW_LOG)) {
            gAMSOptions2.setLogOption(3);
            this.miLogAvailable = false;
        } else {
            gAMSOptions2.setLogOption(2);
            this.miLogAvailable = true;
        }
        File file = new File(this.miScrDir);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, "gamslog.dat");
        gAMSOptions2.setLogFile(file2.getAbsolutePath());
        gAMSOptions2.setSolverCntr("gamscntr.dat");
        gAMSJob.run(gAMSOptions2, false);
        if (this.GEV.InitEnvironmentLegacy(this.miScrDir + GAMSGlobals.FILE_SEPARATOR + gAMSOptions2.getSolverCntr()) != 0) {
            throw new GAMSException("Could not initialize a GAMSModelInstance object from [" + this.miScrDir + GAMSGlobals.FILE_SEPARATOR + gAMSOptions2.getSolverCntr() + "]");
        }
        this.GEV.SetIntOpt("Integer1", gAMSOptions2.getInteger1());
        String[] stringArray3 = new String[]{GAMSGlobals.EMPTY_STRING};
        this.GMO.RegisterEnvironment(this.GEV.GetgevPtr(), stringArray3);
        if (this.GMO.LoadDataLegacy(stringArray3) != 0) {
            throw new GAMSException("Could not load a GAMSModelInstance object : " + stringArray3[0]);
        }
        this.miSelectedSolver = gAMSOptions2.getSelectedSolvers(this.GMO.ModelType());
        String string18 = this.GMO.NameOptFile();
        String string19 = new File(string18).getParent();
        int n = string18.lastIndexOf(46);
        String string20 = n >= 0 ? string18.substring(n, string18.length()) : GAMSGlobals.EMPTY_STRING;
        File file3 = new File(string19, this.miSelectedSolver + string20);
        this.GMO.NameOptFileSet(file3.getAbsolutePath());
        this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().InitFromDict(this.GMO.GetgmoPtr()));
        gAMSOptions2.dispose();
        this.miInstantiated = true;
        this.miSyncDB.dbSymbolLock = true;
        this.miSyncDB.dbRecordLock = false;
    }

    public void solve() {
        this.solve(SymbolUpdateType.BASECASE, null, null);
    }

    public void solve(SymbolUpdateType symbolUpdateType) {
        this.solve(symbolUpdateType, null, null);
    }

    public void solve(PrintStream printStream) {
        this.solve(SymbolUpdateType.BASECASE, printStream, null);
    }

    public void solve(GAMSModelInstanceOpt gAMSModelInstanceOpt) {
        this.solve(SymbolUpdateType.BASECASE, null, gAMSModelInstanceOpt);
    }

    public void solve(SymbolUpdateType symbolUpdateType, PrintStream printStream) {
        this.solve(symbolUpdateType, printStream, null);
    }

    public void solve(SymbolUpdateType symbolUpdateType, GAMSModelInstanceOpt gAMSModelInstanceOpt) {
        this.solve(symbolUpdateType, null, gAMSModelInstanceOpt);
    }

    public void solve(PrintStream printStream, GAMSModelInstanceOpt gAMSModelInstanceOpt) {
        this.solve(SymbolUpdateType.BASECASE, printStream, gAMSModelInstanceOpt);
    }

    /*
     * WARNING - void declaration
     */
    public void solve(SymbolUpdateType symbolUpdateType, PrintStream printStream, GAMSModelInstanceOpt gAMSModelInstanceOpt) {
        Closeable closeable;
        Object object;
        void var8_11;
        int n;
        if (!(symbolUpdateType.equals(SymbolUpdateType.ZERO) || symbolUpdateType.equals(SymbolUpdateType.BASECASE) || symbolUpdateType.equals(SymbolUpdateType.ACCUMULATE))) {
            throw new GAMSException("updateType [" + (Object)((Object)symbolUpdateType) + "] is not a valid type for solve statement");
        }
        if (this._disposed) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] has already been disposed, resources are no longer available");
        }
        int n2 = 0;
        if (gAMSModelInstanceOpt != null) {
            n2 = gAMSModelInstanceOpt.miOptNoMatchLimit;
        }
        if (!this.miInstantiated) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] is not yet instantiated");
        }
        this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().InitUpdate(this.GMO.GetgmoPtr()));
        int n3 = 0;
        int[] nArray = new int[]{0};
        for (GAMSModifier object22 : this.miModifiers) {
            n = symbolUpdateType.value();
            if (!object22.getUpdateType().equals(SymbolUpdateType.INHERIT)) {
                n = object22.getUpdateType().value();
            }
            if (object22.mGamsSymbol instanceof GAMSParameter) {
                this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().UpdateModelSymbol(object22.mGamsSymbol.getSymPtr(), 0, object22.mGamsSymbol.getSymPtr(), n, nArray));
            } else {
                this.miSyncDB.checkForGMDError(this.SyncDB().GMD().UpdateModelSymbol(object22.mGamsSymbol.getSymPtr(), object22.mUpdateAction.value(), object22.getDataSymbol().getSymPtr(), n, nArray));
            }
            if ((n3 += nArray[0]) <= n2) continue;
            throw new GAMSException("Unmatched record limit exceeded while processing modifier [" + object22.mGamsSymbol.symName + "], for more info check the parameter GAMSModelInstanceOpt.miOptNoMatchLimit");
        }
        Object object3 = new long[]{0L};
        if (this.miLogAvailable && printStream != null) {
            this.GEV.SwitchLogStat(0, "", false, "", false, "", 0L, (long[])object3);
            this.GEV.RestoreLogStat((long[])object3);
        }
        if (printStream == System.out) {
            this.GEV.SwitchLogStat(3, this.GEV.GetStrOpt("NameLogFile"), false, this.GEV.GetStrOpt("NameStaFile"), false, null, 0L, (long[])object3);
        }
        String string = this.miSelectedSolver;
        if (gAMSModelInstanceOpt != null && gAMSModelInstanceOpt.miOptSolver != null) {
            String string2 = gAMSModelInstanceOpt.miOptSolver;
        }
        int n4 = n = this.GMO.OptFile();
        String string3 = this.GMO.NameOptFile();
        if (gAMSModelInstanceOpt != null && gAMSModelInstanceOpt.miOptOptFile != -1) {
            n = gAMSModelInstanceOpt.miOptOptFile;
        }
        this.GMO.OptFileSet(n);
        File file = new File(this.miCheckpoint.cpWorkspace.workingDirectory(), (String)var8_11 + "." + this.miCheckpoint.cpWorkspace.optFileExtension(n));
        this.GMO.NameOptFileSet(file.getAbsolutePath());
        this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().CallSolver((String)var8_11));
        if (gAMSModelInstanceOpt != null && gAMSModelInstanceOpt.miOptDebug) {
            object = null;
            try {
                object = new File(this.miScrDir, "convert.opt");
                closeable = new BufferedWriter(new FileWriter(((File)object).getAbsoluteFile()));
                ((Writer)closeable).write("gams " + this.miScrDir + GAMSGlobals.FILE_SEPARATOR + "gams.gms" + GAMSGlobals.LINE_SEPARATOR);
                ((BufferedWriter)closeable).close();
                object = new File(this.miScrDir, "convertd.opt");
                closeable = new BufferedWriter(new FileWriter((File)object));
                ((Writer)closeable).write("jacobian " + this.miScrDir + GAMSGlobals.FILE_SEPARATOR + "jacobian.gdx" + GAMSGlobals.LINE_SEPARATOR);
                ((Writer)closeable).write("dictmap " + this.miScrDir + GAMSGlobals.FILE_SEPARATOR + "dictmap.gdx" + GAMSGlobals.LINE_SEPARATOR);
                ((BufferedWriter)closeable).close();
            }
            catch (IOException iOException) {
                throw new GAMSException("Problem writing file [" + ((File)object).getName() + "] into [" + ((File)object).getParent() + "] directory.");
            }
            this.GMO.OptFileSet(1);
            this.GMO.NameOptFileSet(new File(this.miScrDir, "convert.opt").getAbsolutePath());
            this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().CallSolver("convert"));
            this.GMO.NameOptFileSet(new File(this.miCheckpoint.cpWorkspace.workingDirectory(), "convertd.opt").getAbsolutePath());
            this.miSyncDB.checkForGMDError(this.miSyncDB.GMD().CallSolver("convertd"));
        }
        this.GMO.OptFileSet(n4);
        this.GMO.NameOptFileSet(string3);
        if (printStream == System.out) {
            this.GEV.RestoreLogStat((long[])object3);
        }
        if (printStream != null && printStream != System.out) {
            if (this.miLogAvailable) {
                this.GEV.SwitchLogStat(0, "", false, "", false, null, 0L, (long[])object3);
                try {
                    String string4;
                    object = new FileInputStream(this.GEV.GetStrOpt("NameLogFile"));
                    closeable = new BufferedReader(new InputStreamReader((InputStream)object));
                    while ((string4 = ((BufferedReader)closeable).readLine()) != null) {
                        printStream.println(string4);
                    }
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    throw (GAMSException)new GAMSException("Could not read log file [NameLogFile]").initCause(iOException);
                }
                this.GEV.RestoreLogStat((long[])object3);
            } else {
                printStream.println("No solver log available");
            }
        }
    }

    public String getName() {
        return this.miModelInstanceName;
    }

    public GAMSDatabase SyncDB() {
        return this.miSyncDB;
    }

    public GAMSGlobals.ModelStat getModelStatus() {
        if (this._disposed) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] has already been disposed, resources are no longer available");
        }
        return GAMSGlobals.ModelStat.lookup(this.GMO.ModelStat());
    }

    public GAMSGlobals.SolveStat getSolveStatus() {
        if (this._disposed) {
            throw new GAMSException("GAMSModelInstance [" + this.miModelInstanceName + "] has already been disposed, resources are no longer available");
        }
        return GAMSGlobals.SolveStat.lookup(this.GMO.SolveStat());
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            super.finalize();
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean bl) {
        if (!this._disposed) {
            if (bl) {
                if (this.GMO != null) {
                    this.miCheckpoint.cpWorkspace.debugMessage("--- GAMSModelInstance.dispose(true) : free GMO resources used by non-java library.", 3);
                    this.GMO.Free();
                }
                if (this.GEV != null) {
                    this.miCheckpoint.cpWorkspace.debugMessage("--- GAMSModelInstance.dispose(true) : free GEV resources used by non-java library.", 3);
                    this.GEV.Free();
                }
            }
            this._disposed = true;
        }
    }

    public void interrupt() {
        this.GEV.TerminateRaise();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SymbolUpdateType {
        ZERO,
        BASECASE,
        ACCUMULATE,
        INHERIT,
        UNDEFINED_TYPE;


        public static SymbolUpdateType lookup(int n) {
            if (n >= 0 && n < SymbolUpdateType.values().length - 1) {
                return SymbolUpdateType.values()[n];
            }
            return UNDEFINED_TYPE;
        }

        public boolean equals(SymbolUpdateType symbolUpdateType) {
            return this.value() == symbolUpdateType.value();
        }

        public int value() {
            return this.ordinal();
        }
    }
}

