/*
 * Decompiled with CFR 0.152.
 */
package com.gams.api;

import com.gams.api.GAMSCheckpoint;
import com.gams.api.GAMSDatabase;
import com.gams.api.GAMSException;
import com.gams.api.GAMSGlobals;
import com.gams.api.GAMSJob;
import com.gams.api.GAMSModelInstance;
import com.gams.api.GAMSOptions;
import com.gams.api.GAMSWorkspaceInfo;
import com.gams.api.signal;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GAMSWorkspace {
    private String wsWorkingDirectory = null;
    private String wsSystemDirectory = null;
    private boolean wsIsUsingTmpWorkingDir = false;
    private GAMSGlobals.DebugLevel wsDebugLevel = GAMSGlobals.DebugLevel.OFF;
    private int wsIntDebugLevel = this.wsDebugLevel.value();
    private Object debugLock = new Object();
    private Map<String, GAMSJob> wsJobs;
    private Map<String, GAMSDatabase> wsDatabases;
    private Map<String, GAMSCheckpoint> wsCheckpoints;
    private Map<String, GAMSModelInstance> wsModelInstances;
    private int wsJobCount = 0;
    private int wsDBCount = 0;
    private int wsCPCount = 0;
    private int wsMICount = 0;
    private String wsGAMSVersion = GAMSGlobals.EMPTY_STRING;
    private int wsGAMSRelease;
    private int wsGAMSSubRel;
    private int wsGAMSGoldRel;
    private static final String API_VERSION = "24.8.3";
    private static int API_MAJOR_RELEASE = Integer.valueOf("24.8.3".split("\\.")[0]);
    private static int API_SUB_RELEASE = Integer.valueOf("24.8.3".split("\\.")[1]);
    private static int API_GOLD_RELEASE = Integer.valueOf("24.8.3".split("\\.")[2]);

    public GAMSWorkspace() {
        this(null, null, GAMSGlobals.DebugLevel.OFF);
    }

    public GAMSWorkspace(GAMSWorkspaceInfo gAMSWorkspaceInfo) {
        if (gAMSWorkspaceInfo == null) {
            throw new GAMSException("Error creating a workspace from a NULL GAMSWorkspaceInfo instance.");
        }
        this.initializeAttributes(gAMSWorkspaceInfo.workingDirectory, gAMSWorkspaceInfo.systemDirectory, gAMSWorkspaceInfo.debugLevel);
    }

    public GAMSWorkspace(String string, String string2, GAMSGlobals.DebugLevel debugLevel) {
        this.initializeAttributes(string, string2, debugLevel);
    }

    private void initializeAttributes(String string, String string2, GAMSGlobals.DebugLevel debugLevel) {
        this.debugMessage("--- Entering GAMSWorkspace constructor ---", GAMSGlobals.DebugLevel.VERBOSE.value());
        if (debugLevel == null) {
            this.setDebugLevel(GAMSGlobals.DebugLevel.OFF);
        } else {
            this.setDebugLevel(debugLevel);
        }
        String string3 = System.getenv("GAMSOOAPIDEBUG");
        if (string3 != null) {
            this.setDebugLevel(GAMSGlobals.DebugLevel.lookup(string3.toLowerCase()));
        }
        this.wsWorkingDirectory = this.verifyWorkingDirectory(string);
        this.wsSystemDirectory = this.verifySystemDirectory(string2);
        this.wsCheckpoints = Collections.synchronizedMap(new HashMap());
        this.wsModelInstances = Collections.synchronizedMap(new HashMap());
        this.wsDatabases = Collections.synchronizedMap(new HashMap());
        this.wsJobs = Collections.synchronizedMap(new HashMap());
        this.getVersionInfo();
    }

    private void getVersionInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.wsSystemDirectory + GAMSGlobals.FILE_SEPARATOR + "gams");
        arrayList.add("audit");
        arrayList.add("lo=3");
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.directory(new File(this.wsWorkingDirectory));
        try {
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            StringBuffer stringBuffer = new StringBuffer(GAMSGlobals.EMPTY_STRING);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            bufferedReader.close();
            int n = process.waitFor();
            try {
                this.wsGAMSVersion = stringBuffer.toString().split("\\s+")[1];
                String[] stringArray = this.wsGAMSVersion.split("\\.");
                this.wsGAMSRelease = Integer.parseInt(stringArray[0]);
                this.wsGAMSSubRel = Integer.parseInt(stringArray[1]);
                this.wsGAMSGoldRel = Integer.parseInt(stringArray[2]);
            }
            catch (Exception exception) {
                String[] stringArray = stringBuffer.toString().split("\\s+");
                if (stringArray.length < 5) {
                    throw new GAMSException("Error retrieving GAMS release information");
                }
                this.wsGAMSVersion = stringArray[4];
                String[] stringArray2 = this.wsGAMSVersion.split("\\.");
                if (stringArray2.length != 3) {
                    throw new GAMSException("Error retrieving GAMS release information");
                }
                this.wsGAMSRelease = Integer.parseInt(stringArray2[0]);
                this.wsGAMSSubRel = Integer.parseInt(stringArray2[1]);
                this.wsGAMSGoldRel = Integer.parseInt(stringArray2[2]);
            }
            process.destroy();
            if (n != 0) {
                throw new GAMSException("Error retrieving GAMS release information");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw (GAMSException)new GAMSException("Could not successfully retrieve GAMS release information").initCause(numberFormatException);
        }
        catch (IOException iOException) {
            throw (GAMSException)new GAMSException("Could not successfully retrieve GAMS release information").initCause(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw (GAMSException)new GAMSException("Could not successfully retrieve GAMS release information").initCause(interruptedException);
        }
        if (!this.wsGAMSVersion.equals(API_VERSION)) {
            System.out.println("--- Warning: The GAMS version [" + this.wsGAMSVersion + "] differs from the API version [" + API_VERSION + "].");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String verifyWorkingDirectory(String string) {
        this.wsIsUsingTmpWorkingDir = false;
        if (string == null) {
            string = GAMSGlobals.workingDirectory;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date();
            File file = new File(string, simpleDateFormat.format(date).toString());
            if (file.mkdir()) {
                this.wsIsUsingTmpWorkingDir = true;
                return this.getCanonicalPath(file);
            }
            file = new File(string);
            return this.getCanonicalPath(file);
        }
        if (string.trim().equals(GAMSGlobals.EMPTY_STRING)) {
            throw new GAMSException("directory path with empty string does not exist!");
        }
        String string2 = this.getCanonicalPath(new File(string));
        File file = new File(string2);
        if (file.exists()) {
            if (!file.isDirectory()) throw new GAMSException("[" + string + "] is not a directory!");
            return this.getCanonicalPath(file);
        }
        if (!file.mkdir()) throw new GAMSException("could not create directory [" + string + "], not a valid working directory!");
        return this.getCanonicalPath(file);
    }

    private String getCanonicalPath(File file) {
        String string = null;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    private String findGAMS() {
        String string = this.searchGAMSIn(System.getenv("PATH"));
        if (string != null && this.wsDebugLevel == GAMSGlobals.DebugLevel.OFF) {
            return string;
        }
        String string2 = this.findGAMSFromAlternativeEnvironment();
        if (string2 != null && this.wsDebugLevel == GAMSGlobals.DebugLevel.OFF) {
            return string2;
        }
        if (string != null) {
            if (string2 != null && !string.equals(string2)) {
                String string3 = null;
                switch (GAMSGlobals.getOSType()) {
                    case WINDOWS: {
                        string3 = "window registry [gams.location]";
                        break;
                    }
                    case MAC: {
                        string3 = "DYLD_LIBRARY PATH environment variable";
                        break;
                    }
                    default: {
                        string3 = "LD_LIBRARY PATH environment variable";
                    }
                }
                System.out.println("--- Warning: Found a GAMS system directory [" + string + "] from PATH environment variable");
                System.out.println("---          and another [" + string2 + "] from " + string3 + ". The latter is ignored.");
            }
            return string;
        }
        return string2;
    }

    private String findGAMSFromAlternativeEnvironment() {
        String[] stringArray = new String[]{GAMSGlobals.EMPTY_STRING};
        GAMSGlobals.OSType oSType = GAMSGlobals.getOSType();
        if (oSType == GAMSGlobals.OSType.UNKNOWN) {
            throw new GAMSException("Could not identify the operating system of the run-time system!");
        }
        if (oSType == GAMSGlobals.OSType.WINDOWS) {
            signal.readGAMSLocationFromWindowRegistry(stringArray);
        } else {
            stringArray[0] = oSType == GAMSGlobals.OSType.MAC ? System.getenv("DYLD_LIBRARY_PATH") : System.getenv("LD_LIBRARY_PATH");
        }
        return this.searchGAMSIn(stringArray[0]);
    }

    private String searchGAMSIn(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = GAMSGlobals.getOSType() == GAMSGlobals.OSType.WINDOWS ? "gams.exe" : "gams";
        for (String string3 : string.split(GAMSGlobals.PATH_SEPARATOR)) {
            File file = new File(string3, string2);
            if (!file.isFile()) continue;
            File file2 = new File(string3);
            return this.getCanonicalPath(file2);
        }
        return null;
    }

    private boolean addToSystemPath(String string) {
        boolean bl = false;
        String string2 = System.getenv("PATH");
        bl = string2 == null ? signal.setEnvironment("PATH", string) : (!string2.startsWith(string + GAMSGlobals.PATH_SEPARATOR) ? signal.setEnvironment("PATH", string + GAMSGlobals.PATH_SEPARATOR + string2) : true);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String verifySystemDirectory(String string) {
        Object object;
        Object object2;
        if (string == null) {
            string = this.findGAMS();
            if (string == null) {
                throw new GAMSException("GAMS system directory is both not specified and not found from your environment!");
            }
        } else {
            if (string.trim().equals(GAMSGlobals.EMPTY_STRING)) {
                throw new GAMSException("directory path with empty string does not exist!");
            }
            object2 = this.getCanonicalPath(new File(string));
            object = new File((String)object2);
            if (!((File)object).exists()) throw new GAMSException("directory [" + string + "] does not exist!");
            if (!((File)object).isDirectory()) throw new GAMSException("[" + string + "] is not a directory!");
            string = this.getCanonicalPath((File)object);
        }
        if (!((File)(object2 = new File(string, "optgams.def"))).exists()) {
            throw new GAMSException("Either the directory [" + string + "] is not a valid GAMS system directory, or file [" + "optgams.def" + "] under the directory is missing!");
        }
        object = GAMSGlobals.EMPTY_STRING;
        String string2 = GAMSGlobals.EMPTY_STRING;
        String string3 = GAMSGlobals.EMPTY_STRING;
        GAMSGlobals.OSType oSType = GAMSGlobals.getOSType();
        if (oSType == GAMSGlobals.OSType.UNKNOWN) {
            throw new GAMSException("Could not identify the operating system of the run-time system!");
        }
        if (oSType == GAMSGlobals.OSType.WINDOWS) {
            string2 = ".dll";
        } else if (oSType == GAMSGlobals.OSType.MAC) {
            object = "lib";
            string2 = ".dylib";
        } else {
            object = "lib";
            string2 = ".so";
        }
        File file = new File(string, (String)object + "joatdclib64" + string2);
        GAMSGlobals.ArchType archType = GAMSGlobals.getArchType();
        if (archType == GAMSGlobals.ArchType.ARCH_32_BITS) {
            if (file.exists()) {
                throw new GAMSException("Expect 32-bit GAMS system in [" + string + "], but found 64-bit instead!");
            }
        } else if (archType == GAMSGlobals.ArchType.ARCH_64_BITS) {
            string3 = "64";
            if (!file.exists()) {
                throw new GAMSException("Expect 64-bit GAMS system in [" + string + "], but found 32-bit instead!");
            }
        }
        if (!string.equalsIgnoreCase(this.wsWorkingDirectory)) {
            String[] stringArray;
            for (String string4 : stringArray = new String[]{"gamsxdc", "gdxdc", "gmdcc", "joatdc", "optdc"}) {
                File file2 = new File(this.wsWorkingDirectory, (String)object + string4 + "lib" + string3 + string2);
                if (!file2.exists()) continue;
                System.out.println("--- Warning: Found library [" + (String)object + string4 + "lib" + string3 + string2 + "] in the Working Directory [" + this.wsWorkingDirectory + "].");
                System.out.println("---          This could cause a problem when it is a different version than");
                System.out.println("---          the one in the System Directory [" + string + "].");
            }
        }
        if (GAMSGlobals.getOSType() != GAMSGlobals.OSType.WINDOWS) return string;
        this.addToSystemPath(string);
        return string;
    }

    private boolean hasValidDirectories() {
        return this.wsWorkingDirectory != null && this.wsSystemDirectory != null;
    }

    private String callLib(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            throw new GAMSException("Model name is either a null or empty string");
        }
        assert (string != null);
        assert (this.hasValidDirectories()) : this.getClass() + ": directories are not properly initialized";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.wsSystemDirectory + GAMSGlobals.FILE_SEPARATOR + string + "lib");
        arrayList.add(string2);
        arrayList.add(this.wsWorkingDirectory);
        assert (arrayList != null && arrayList.size() > 0) : this.getClass() + ": lib process arguments are not properly initialized";
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        try {
            Process process = processBuilder.start();
            if (this.wsDebugLevel.isHigherThan(GAMSGlobals.DebugLevel.KEEP_FILES)) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string3 = null;
                System.out.println("JavaAPI Standard Output::");
                while ((string3 = bufferedReader.readLine()) != null) {
                    System.out.println(string3);
                }
                System.out.println();
            }
            process.waitFor();
            int n = process.exitValue();
            if (n != 0) {
                throw new GAMSException(string + "lib unsuccessfully terminates with exit code : " + n);
            }
            process.destroy();
        }
        catch (IOException iOException) {
            throw (GAMSException)new GAMSException("Could not successfully run [" + string + "lib]").initCause(iOException);
        }
        catch (InterruptedException interruptedException) {
            throw (GAMSException)new GAMSException("Could not wait until [" + string + "lib] finishes execution").initCause(interruptedException);
        }
        return string2 + ".gms";
    }

    public GAMSJob addJobFromGamsLib(String string) {
        String string2 = this.callLib("gams", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromTestLib(String string) {
        String string2 = this.callLib("test", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromDataLib(String string) {
        String string2 = this.callLib("data", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromFinLib(String string) {
        String string2 = this.callLib("fin", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromEmpLib(String string) {
        String string2 = this.callLib("emp", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromApiLib(String string) {
        String string2 = this.callLib("api", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromNoaLib(String string) {
        String string2 = this.callLib("noa", string);
        GAMSJob gAMSJob = this.addJobFromFile(string2);
        return gAMSJob;
    }

    public GAMSJob addJobFromFile(String string) {
        GAMSJob gAMSJob = GAMSJob.fromFile(this, string, null, null);
        return gAMSJob;
    }

    public GAMSJob addJobFromFile(String string, String string2) {
        return GAMSJob.fromFile(this, string, string2, null);
    }

    public GAMSJob addJobFromFile(String string, GAMSCheckpoint gAMSCheckpoint, String string2) {
        return GAMSJob.fromFile(this, string, string2, gAMSCheckpoint);
    }

    public GAMSDatabase addDatabaseFromGDX(String string) {
        return this.addDatabaseFromGDX(string, null);
    }

    public GAMSDatabase addDatabaseFromGDX(String string, String string2) {
        File file;
        if (string == null || string.length() == 0) {
            throw new GAMSException("Could not create GAMSDatabase instance a null or empty file name");
        }
        if (!string.endsWith(".gdx")) {
            string = string + ".gdx";
        }
        if ((file = new File(string)).getParent() == null) {
            file = new File(this.wsWorkingDirectory, string);
        }
        if (!file.exists()) {
            throw new GAMSException("Could not create GAMSDatabase instance from non-existing gdx file [" + string + "]");
        }
        string = file.getAbsolutePath();
        return new GAMSDatabase(string, this, string2);
    }

    GAMSDatabase addDatabaseFromForcedNameGDX(String string, String string2) {
        return new GAMSDatabase(string, this, string2, true);
    }

    synchronized String verifyCheckpointName(String string) {
        if (string == null || string.length() == 0) {
            string = GAMSGlobals.scratchFilePrefix + "gcp" + new Integer(++this.wsCPCount).toString();
        }
        boolean bl = false;
        while (bl = this.wsCheckpoints.containsKey(string)) {
            if (this.wsCPCount >= Integer.MAX_VALUE) {
                throw new GAMSException("The enumeration of a checkpoint name reaches its maximum limit!");
            }
            string = GAMSGlobals.scratchFilePrefix + "gcp" + new Integer(++this.wsCPCount).toString();
        }
        if (bl) {
            throw new GAMSException("GAMSCheckpoint instance with name [" + string + "] already exists!");
        }
        this.wsCheckpoints.put(string, null);
        return string;
    }

    synchronized String verifyDatabaseName(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            string = GAMSGlobals.scratchFilePrefix + "gdb" + new Integer(++this.wsDBCount).toString();
        }
        boolean bl2 = false;
        while (bl2 = this.wsDatabases.containsKey(string)) {
            if (this.wsDBCount >= Integer.MAX_VALUE) {
                throw new GAMSException("The enumeration of a database name reaches its maximum limit!");
            }
            string = GAMSGlobals.scratchFilePrefix + "gdb" + new Integer(++this.wsDBCount).toString();
        }
        if (!bl2) {
            this.wsDatabases.put(string, null);
        } else if (!bl) {
            throw new GAMSException("GAMSDatabase instance with name [" + string + "] already exists!");
        }
        return string;
    }

    synchronized String verifyJobName(String string) {
        if (string == null || string.length() == 0) {
            string = GAMSGlobals.scratchFilePrefix + "gjo" + new Integer(++this.wsJobCount).toString();
        }
        boolean bl = false;
        while (bl = this.containsJob(string)) {
            if (this.wsJobCount >= Integer.MAX_VALUE) {
                throw new GAMSException("The enumeration of a job name reaches its maximum limit!");
            }
            string = GAMSGlobals.scratchFilePrefix + "gjo" + new Integer(++this.wsJobCount).toString();
        }
        if (bl) {
            throw new GAMSException("GAMSJob instance with name [" + string + "] already exists!");
        }
        this.wsJobs.put(string, null);
        return string;
    }

    synchronized String verifyModelInstanceName(String string) {
        if (string == null || string.length() == 0) {
            string = GAMSGlobals.scratchFilePrefix + "gmi" + new Integer(++this.wsMICount).toString();
        }
        boolean bl = false;
        while (bl = this.containsMI(string)) {
            if (this.wsJobCount >= Integer.MAX_VALUE) {
                throw new GAMSException("The enumeration of a job name reaches its maximum limit!");
            }
            string = GAMSGlobals.scratchFilePrefix + "gmi" + new Integer(++this.wsMICount).toString();
        }
        if (!bl) {
            this.wsModelInstances.put(string, null);
        }
        return string;
    }

    boolean containsJob(String string) {
        return this.wsJobs.containsKey(string);
    }

    boolean containsMI(String string) {
        return this.wsModelInstances.containsKey(string);
    }

    String optFileExtension(int n) {
        if (n < 2) {
            return "opt";
        }
        if (n < 10) {
            return "op" + n;
        }
        if (n < 100) {
            return "o" + n;
        }
        return GAMSGlobals.EMPTY_STRING + n;
    }

    public GAMSJob addJobFromString(String string) {
        return this.addJobFromString(string, null, null);
    }

    public GAMSJob addJobFromString(String string, GAMSCheckpoint gAMSCheckpoint) {
        return this.addJobFromString(string, gAMSCheckpoint, null);
    }

    public GAMSJob addJobFromString(String string, GAMSCheckpoint gAMSCheckpoint, String string2) {
        if (string == null || string.length() == 0) {
            throw new GAMSException("Could not add job from a null or empty string");
        }
        GAMSJob gAMSJob = GAMSJob.fromString(this, string, gAMSCheckpoint, string2);
        return gAMSJob;
    }

    boolean existsDBName(String string) {
        return this.wsDatabases.containsKey(string);
    }

    public GAMSDatabase addDatabase() {
        return this.addDatabase((String)null);
    }

    public GAMSDatabase addDatabase(String string) {
        return new GAMSDatabase(this, string);
    }

    public GAMSDatabase addDatabase(GAMSDatabase gAMSDatabase) {
        return new GAMSDatabase(this, gAMSDatabase);
    }

    public GAMSDatabase addDatabase(GAMSDatabase gAMSDatabase, String string) {
        return new GAMSDatabase(this, gAMSDatabase, string);
    }

    public GAMSCheckpoint addCheckpoint() {
        return this.addCheckpoint(null);
    }

    public GAMSCheckpoint addCheckpoint(String string) {
        GAMSCheckpoint gAMSCheckpoint = new GAMSCheckpoint(this, string);
        return gAMSCheckpoint;
    }

    public GAMSOptions addOptions() {
        return new GAMSOptions(this);
    }

    public GAMSOptions addOptions(GAMSOptions gAMSOptions) {
        return new GAMSOptions(this, gAMSOptions, null);
    }

    public GAMSOptions addOptions(String string) {
        return new GAMSOptions(this, null, string);
    }

    public String workingDirectory() {
        return this.wsWorkingDirectory;
    }

    public String systemDirectory() {
        return this.wsSystemDirectory;
    }

    public boolean isUsingTmpWorkingDirectory() {
        return this.wsIsUsingTmpWorkingDir;
    }

    public GAMSGlobals.DebugLevel getDebugLevel() {
        return this.wsDebugLevel;
    }

    public void setDebugLevel(GAMSGlobals.DebugLevel debugLevel) {
        this.wsDebugLevel = debugLevel;
        this.wsIntDebugLevel = debugLevel.value();
    }

    public String getGAMSVersion() {
        return this.wsGAMSVersion;
    }

    public int getMajorReleaseNumber() {
        return this.wsGAMSRelease;
    }

    public int getMinorReleaseNumber() {
        return this.wsGAMSSubRel;
    }

    public int getGoldReleaseNumber() {
        return this.wsGAMSGoldRel;
    }

    public static String getAPIVersion() {
        return API_VERSION;
    }

    public static int getAPIMajorReleaseNumber() {
        return API_MAJOR_RELEASE;
    }

    public static int getAPIMinorReleaseNumber() {
        return API_SUB_RELEASE;
    }

    public static int getAPIGoldReleaseNumber() {
        return API_GOLD_RELEASE;
    }

    public void setMyEPS(double d) {
        GAMSGlobals.SpecialValues.EPS.setValue(d);
    }

    public void finalize() throws Throwable {
        try {
            if (this.wsIntDebugLevel < 1 && this.wsIsUsingTmpWorkingDir) {
                String[] stringArray;
                this.debugMessage("--- GAMSWorkspace.finalize() : deleting temporary working directory.", 3);
                File file = new File(this.wsWorkingDirectory);
                for (String string : stringArray = file.list()) {
                    File file2 = new File(file, string);
                    try {
                        file2.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean debugMessage(String string, int n) {
        if (this.wsIntDebugLevel >= n) {
            Object object = this.debugLock;
            synchronized (object) {
                System.out.println(string);
                System.out.flush();
            }
            return true;
        }
        return false;
    }
}

