-- FIX CONSTRAINT NAMES

-- backup
CREATE TABLE annotation_log_copy AS (SELECT * FROM annotation_log) WITH DATA;
CREATE TABLE change_log_copy AS (SELECT * FROM change_log) WITH DATA;
CREATE TABLE ix_set_copy AS (SELECT * FROM ix_set) WITH DATA;
CREATE TABLE ix_set_dim_copy AS (SELECT * FROM ix_set_dim) WITH DATA;
CREATE TABLE ix_set_blobstore_copy AS (SELECT * FROM ix_set_blobstore) WITH DATA;
CREATE TABLE ix_par_copy AS (SELECT * FROM ix_par) WITH DATA;
CREATE TABLE ix_par_dim_copy AS (SELECT * FROM ix_par_dim) WITH DATA;
CREATE TABLE ix_par_blobstore_copy AS (SELECT * FROM ix_par_blobstore) WITH DATA;
CREATE TABLE ix_var_copy AS (SELECT * FROM ix_var) WITH DATA;
CREATE TABLE ix_var_dim_copy AS (SELECT * FROM ix_var_dim) WITH DATA;
CREATE TABLE ix_var_blobstore_copy AS (SELECT * FROM ix_var_blobstore) WITH DATA;
CREATE TABLE ix_equ_copy AS (SELECT * FROM ix_equ) WITH DATA;
CREATE TABLE ix_equ_dim_copy AS (SELECT * FROM ix_equ_dim) WITH DATA;
CREATE TABLE ix_equ_blobstore_copy AS (SELECT * FROM ix_equ_blobstore) WITH DATA;
CREATE TABLE ix_key_copy AS (SELECT * FROM ix_key) WITH DATA;
CREATE TABLE ix_idxset_copy AS (SELECT * FROM ix_idxset) WITH DATA;
CREATE TABLE iamc_tsinfo_copy AS (SELECT * FROM iamc_tsinfo) WITH DATA;
CREATE TABLE iamc_tsdata_copy AS (SELECT * FROM iamc_tsdata) WITH DATA;

-- drop tables
DROP VIEW iamc_overview;
DROP TABLE change_log;
DROP TABLE annotation_log;
DROP TABLE ix_set_blobstore;
DROP TABLE ix_set_dim;
DROP TABLE ix_set;
DROP TABLE ix_par_blobstore;
DROP TABLE ix_par_dim;
DROP TABLE ix_par;
DROP TABLE ix_var_blobstore;
DROP TABLE ix_var_dim;
DROP TABLE ix_var;
DROP TABLE ix_equ_blobstore;
DROP TABLE ix_equ_dim;
DROP TABLE ix_equ;
DROP TABLE ix_key;
DROP TABLE ix_idxset;
DROP TABLE iamc_tsdata;
DROP TABLE iamc_tsinfo;

-- create tables
CREATE TABLE annotation_log (
    annotationid INTEGER                          NOT NULL,
    status       VARCHAR(128)                     NOT NULL,
    runid        INTEGER,
    script       VARCHAR(128)                     NOT NULL,
    cre_user     VARCHAR(128) DEFAULT '(unknown)' NOT NULL,
    cre_date     TIMESTAMP    DEFAULT NOW()       NOT NULL,
    upd_user     VARCHAR(64),
    upd_date     TIMESTAMP,
    text         VARCHAR(512),
    interface    VARCHAR(20)
);
ALTER TABLE annotation_log ADD CONSTRAINT annotation_log_pk PRIMARY KEY (annotationid);
ALTER TABLE annotation_log ADD CONSTRAINT annotation_log_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE change_log (
    annotationid INTEGER      NOT NULL,
    runid        INTEGER      NOT NULL,
    operation    VARCHAR(64)  NOT NULL,
    item         VARCHAR(256) NOT NULL,
    key          VARCHAR(512),
    val_prev     DOUBLE,
    val_new      DOUBLE,
    seq          INTEGER
);
ALTER TABLE change_log ADD CONSTRAINT change_log_annotationid_fk FOREIGN KEY (annotationid) REFERENCES annotation_log (annotationid) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE change_log ADD CONSTRAINT change_log_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_key (
    runid INTEGER      NOT NULL,
    keyid INTEGER      NOT NULL,
    key   VARCHAR(256) NOT NULL
);
ALTER TABLE ix_key ADD CONSTRAINT ix_key_pk PRIMARY KEY (runid, keyid);
ALTER TABLE ix_key ADD CONSTRAINT ix_key_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_idxset (
    runid    INTEGER     NOT NULL,
    name     VARCHAR(64) NOT NULL,
    ele_blob BLOB,
    itemid   INTEGER     NOT NULL,
    com_blob BLOB
);
ALTER TABLE ix_idxset ADD CONSTRAINT ix_idxset_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_idxset ADD CONSTRAINT ix_idxset_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_set (
    runid  INTEGER           NOT NULL,
    name   VARCHAR(64)       NOT NULL,
    dim    INTEGER DEFAULT 0 NOT NULL,
    itemid INTEGER
);
ALTER TABLE ix_set ADD CONSTRAINT ix_set_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_set ADD CONSTRAINT ix_set_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_set_dim (
    runid    INTEGER     NOT NULL,
    name     VARCHAR(64) NOT NULL,
    idx      INTEGER     NOT NULL,
    idx_set  VARCHAR(64) NOT NULL,
    idx_name VARCHAR(64) NOT NULL
);
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_set (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE ix_set_dim ADD CONSTRAINT ix_set_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_set_blobstore (
    runid    INTEGER      NOT NULL,
    name     VARCHAR(256) NOT NULL,
    ele_blob BLOB,
    com_blob BLOB
);
ALTER TABLE ix_set_blobstore ADD CONSTRAINT ix_set_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_set_blobstore ADD CONSTRAINT ix_set_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_set (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_par (
    runid  INTEGER           NOT NULL,
    name   VARCHAR(64)       NOT NULL,
    dim    INTEGER DEFAULT 0 NOT NULL,
    itemid INTEGER
);
ALTER TABLE ix_par ADD CONSTRAINT ix_par_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_par ADD CONSTRAINT ix_par_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_par_dim (
    runid    INTEGER     NOT NULL,
    name     VARCHAR(64) NOT NULL,
    idx      INTEGER     NOT NULL,
    idx_set  VARCHAR(64) NOT NULL,
    idx_name VARCHAR(64) NOT NULL
);
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_par (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE ix_par_dim ADD CONSTRAINT ix_par_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_par_blobstore (
    runid    INTEGER      NOT NULL,
    name     VARCHAR(256) NOT NULL,
    ele_blob BLOB,
    com_blob BLOB
);
ALTER TABLE ix_par_blobstore ADD CONSTRAINT ix_par_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_par_blobstore ADD CONSTRAINT ix_par_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_par (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_var (
    runid  INTEGER           NOT NULL,
    name   VARCHAR(64)       NOT NULL,
    dim    INTEGER DEFAULT 0 NOT NULL,
    itemid INTEGER
);
ALTER TABLE ix_var ADD CONSTRAINT ix_var_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_var ADD CONSTRAINT ix_var_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_var_dim (
    runid    INTEGER     NOT NULL,
    name     VARCHAR(64) NOT NULL,
    idx      INTEGER     NOT NULL,
    idx_set  VARCHAR(64) NOT NULL,
    idx_name VARCHAR(64) NOT NULL
);
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_var (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE ix_var_dim ADD CONSTRAINT ix_var_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_var_blobstore (
    runid    INTEGER      NOT NULL,
    name     VARCHAR(256) NOT NULL,
    ele_blob BLOB,
    com_blob BLOB
);
ALTER TABLE ix_var_blobstore ADD CONSTRAINT ix_var_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_var_blobstore ADD CONSTRAINT ix_var_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_var (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_equ (
    runid  INTEGER           NOT NULL,
    name   VARCHAR(64)       NOT NULL,
    dim    INTEGER DEFAULT 0 NOT NULL,
    itemid INTEGER
);
ALTER TABLE ix_equ ADD CONSTRAINT ix_equ_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_equ ADD CONSTRAINT ix_equ_runid_fk FOREIGN KEY (runid) REFERENCES run (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_equ_dim (
    runid    INTEGER     NOT NULL,
    name     VARCHAR(64) NOT NULL,
    idx      INTEGER     NOT NULL,
    idx_set  VARCHAR(64) NOT NULL,
    idx_name VARCHAR(64) NOT NULL
);
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_pk PRIMARY KEY (runid, name, idx);
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_equ (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;
ALTER TABLE ix_equ_dim ADD CONSTRAINT ix_equ_dim_runid_idx_set_fk FOREIGN KEY (runid, idx_set) REFERENCES ix_idxset (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE TABLE ix_equ_blobstore (
    runid    INTEGER      NOT NULL,
    name     VARCHAR(256) NOT NULL,
    ele_blob BLOB,
    com_blob BLOB
);
ALTER TABLE ix_equ_blobstore ADD CONSTRAINT ix_equ_blobstore_pk PRIMARY KEY (runid, name);
ALTER TABLE ix_equ_blobstore ADD CONSTRAINT ix_equ_blobstore_runid_name_fk FOREIGN KEY (runid, name) REFERENCES ix_equ (runid, name) ON UPDATE CASCADE ON DELETE CASCADE;

-- switch primary and unique keys
CREATE TABLE iamc_tsinfo (
    tsid  INTEGER           NOT NULL,
    runid INTEGER           NOT NULL,
    node  INTEGER           NOT NULL,
    key   INTEGER           NOT NULL,
    time  INTEGER           NOT NULL,
    meta  INTEGER DEFAULT 0 NOT NULL
);
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_pk UNIQUE (tsid);
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_uk1 UNIQUE (runid, node, key, time);
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_runid_fk FOREIGN KEY (runid) REFERENCES run(id) ON DELETE CASCADE;
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_key_fk FOREIGN KEY (key) REFERENCES iamc_key(keyid) ON DELETE CASCADE;
ALTER TABLE iamc_tsinfo ADD CONSTRAINT iamc_tsinfo_node_fk FOREIGN KEY (node) REFERENCES iamc_nodes(id) ON DELETE CASCADE;

CREATE TABLE iamc_tsdata (
    tsid  INTEGER NOT NULL,
    year  INTEGER NOT NULL,
    value DOUBLE  NOT NULL
);
ALTER TABLE iamc_tsdata ADD CONSTRAINT iamc_tsdata_pk UNIQUE (tsid,year);
ALTER TABLE iamc_tsdata ADD CONSTRAINT iamc_tsdata_tsid_fk FOREIGN KEY (tsid) REFERENCES iamc_tsinfo(tsid) ON DELETE CASCADE;

-- fill data
INSERT INTO annotation_log SELECT * FROM annotation_log_copy;
INSERT INTO change_log SELECT * FROM change_log_copy;
INSERT INTO ix_key SELECT * FROM ix_key_copy;
INSERT INTO ix_idxset SELECT * FROM ix_idxset_copy;
INSERT INTO ix_set SELECT * FROM ix_set_copy;
INSERT INTO ix_set_dim SELECT * FROM ix_set_dim_copy;
INSERT INTO ix_set_blobstore SELECT * FROM ix_set_blobstore_copy;
INSERT INTO ix_par SELECT * FROM ix_par_copy;
INSERT INTO ix_par_dim SELECT * FROM ix_par_dim_copy;
INSERT INTO ix_par_blobstore SELECT * FROM ix_par_blobstore_copy;
INSERT INTO ix_var SELECT * FROM ix_var_copy;
INSERT INTO ix_var_dim SELECT * FROM ix_var_dim_copy;
INSERT INTO ix_var_blobstore SELECT * FROM ix_var_blobstore_copy;
INSERT INTO ix_equ SELECT * FROM ix_equ_copy;
INSERT INTO ix_equ_dim SELECT * FROM ix_equ_dim_copy;
INSERT INTO ix_equ_blobstore SELECT * FROM ix_equ_blobstore_copy;
INSERT INTO iamc_tsinfo SELECT * FROM iamc_tsinfo_copy;
INSERT INTO iamc_tsdata SELECT * FROM iamc_tsdata_copy;
COMMIT;

-- cleanup
DROP TABLE change_log_copy;
DROP TABLE annotation_log_copy;
DROP TABLE ix_key_copy;
DROP TABLE ix_idxset_copy;
DROP TABLE ix_set_copy;
DROP TABLE ix_set_dim_copy;
DROP TABLE ix_set_blobstore_copy;
DROP TABLE ix_par_copy;
DROP TABLE ix_par_dim_copy;
DROP TABLE ix_par_blobstore_copy;
DROP TABLE ix_var_copy;
DROP TABLE ix_var_dim_copy;
DROP TABLE ix_var_blobstore_copy;
DROP TABLE ix_equ_copy;
DROP TABLE ix_equ_dim_copy;
DROP TABLE ix_equ_blobstore_copy;
DROP TABLE iamc_tsinfo_copy;
DROP TABLE iamc_tsdata_copy;

CREATE VIEW iamc_overview (model, scenario, region, variable, unit, time, year, value, meta, version, isdefault) AS
SELECT m.name, s.name, n.name, k.keystring, u.name, i.time, d.year, d.value, i.meta, r.version, CASE cast(rd.id AS BOOLEAN) WHEN TRUE THEN 'True' ELSE ' ' END isdefault
FROM iamc_key k
INNER JOIN ix_unit u ON u.id = k.unitid
INNER JOIN iamc_tsinfo i ON i.key = k.keyid
INNER JOIN run r ON r.id = i.runid
LEFT JOIN run_default rd ON rd.id = r.id
INNER JOIN model m ON m.id = r.model_id
INNER JOIN scenario s ON s.id = r.scen_id
INNER JOIN iamc_nodes n ON i.node = n.id
INNER JOIN iamc_tsdata d ON i.tsid = d.tsid;
