CREATE TABLE downloads (
    id          NUMBER         NOT NULL,
    filename    VARCHAR2(256)  NOT NULL,
    description VARCHAR2(1000) NOT NULL,
    filesize    NUMBER DEFAULT 0,
    content     BLOB,
    CONSTRAINT downloads_pk PRIMARY KEY (id),
    CONSTRAINT downloads_uk UNIQUE (filename)
);

CREATE TABLE downloads_audit (
    action    VARCHAR2(256)        NOT NULL,
    timestamp DATE DEFAULT SYSDATE NOT NULL,
    username  VARCHAR2(128),
    text      VARCHAR2(1000)
);

CREATE SEQUENCE downloads_seq;