import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#account_name DataAzurermBatchPool#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#name DataAzurermBatchPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#resource_group_name DataAzurermBatchPool#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#timeouts DataAzurermBatchPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBatchPoolTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolAutoScale extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get evaluationInterval(): string;
    /**
     * @stability stable
     */
    get formula(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolCertificate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get storeLocation(): string;
    /**
     * @stability stable
     */
    get storeName(): string;
    /**
     * @stability stable
     */
    get visibility(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolContainerConfigurationContainerRegistries extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get registryServer(): string;
    /**
     * @stability stable
     */
    get userName(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolContainerConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get containerImageNames(): string[];
    /**
     * @stability stable
     */
    get containerRegistries(): any;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolFixedScale extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resizeTimeout(): string;
    /**
     * @stability stable
     */
    get targetDedicatedNodes(): number;
    /**
     * @stability stable
     */
    get targetLowPriorityNodes(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRules extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    get sourceAddressPrefix(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfigurationEndpointConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    get frontendPortRange(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get networkSecurityGroupRules(): any;
    /**
     * @stability stable
     */
    get protocol(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolNetworkConfiguration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endpointConfiguration(): any;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStartTaskResourceFile extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoStorageContainerName(): string;
    /**
     * @stability stable
     */
    get blobPrefix(): string;
    /**
     * @stability stable
     */
    get fileMode(): string;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    get httpUrl(): string;
    /**
     * @stability stable
     */
    get storageContainerUrl(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStartTaskUserIdentityAutoUser extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get elevationLevel(): string;
    /**
     * @stability stable
     */
    get scope(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStartTaskUserIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoUser(): any;
    /**
     * @stability stable
     */
    get userName(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStartTask extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get commandLine(): string;
    /**
     * @stability stable
     */
    get commonEnvironmentProperties(): any;
    /**
     * @stability stable
     */
    get environment(): any;
    /**
     * @stability stable
     */
    get maxTaskRetryCount(): number;
    /**
     * @stability stable
     */
    get resourceFile(): any;
    /**
     * @stability stable
     */
    get taskRetryMaximum(): number;
    /**
     * @stability stable
     */
    get userIdentity(): any;
    /**
     * @stability stable
     */
    get waitForSuccess(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolStorageImageReference extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermBatchPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html#read DataAzurermBatchPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBatchPoolTimeoutsToTerraform(struct?: DataAzurermBatchPoolTimeoutsOutputReference | DataAzurermBatchPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBatchPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBatchPoolTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html azurerm_batch_pool}.
 *
 * @stability stable
 */
export declare class DataAzurermBatchPool extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/batch_pool.html azurerm_batch_pool} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBatchPoolConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    autoScale(index: string): DataAzurermBatchPoolAutoScale;
    /**
     * @stability stable
     */
    certificate(index: string): DataAzurermBatchPoolCertificate;
    /**
     * @stability stable
     */
    containerConfiguration(index: string): DataAzurermBatchPoolContainerConfiguration;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    fixedScale(index: string): DataAzurermBatchPoolFixedScale;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxTasksPerNode(): number;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkConfiguration(index: string): DataAzurermBatchPoolNetworkConfiguration;
    /**
     * @stability stable
     */
    get nodeAgentSkuId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    startTask(index: string): DataAzurermBatchPoolStartTask;
    /**
     * @stability stable
     */
    storageImageReference(index: string): DataAzurermBatchPoolStorageImageReference;
    /**
     * @stability stable
     */
    get vmSize(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBatchPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBatchPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBatchPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
