import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DevTestLinuxVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#allow_claim DevTestLinuxVirtualMachine#allow_claim}.
     *
     * @stability stable
     */
    readonly allowClaim?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#disallow_public_ip_address DevTestLinuxVirtualMachine#disallow_public_ip_address}.
     *
     * @stability stable
     */
    readonly disallowPublicIpAddress?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#lab_name DevTestLinuxVirtualMachine#lab_name}.
     *
     * @stability stable
     */
    readonly labName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#lab_subnet_name DevTestLinuxVirtualMachine#lab_subnet_name}.
     *
     * @stability stable
     */
    readonly labSubnetName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#lab_virtual_network_id DevTestLinuxVirtualMachine#lab_virtual_network_id}.
     *
     * @stability stable
     */
    readonly labVirtualNetworkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#location DevTestLinuxVirtualMachine#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#name DevTestLinuxVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#notes DevTestLinuxVirtualMachine#notes}.
     *
     * @stability stable
     */
    readonly notes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#password DevTestLinuxVirtualMachine#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#resource_group_name DevTestLinuxVirtualMachine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#size DevTestLinuxVirtualMachine#size}.
     *
     * @stability stable
     */
    readonly size: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#ssh_key DevTestLinuxVirtualMachine#ssh_key}.
     *
     * @stability stable
     */
    readonly sshKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#storage_type DevTestLinuxVirtualMachine#storage_type}.
     *
     * @stability stable
     */
    readonly storageType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#tags DevTestLinuxVirtualMachine#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#username DevTestLinuxVirtualMachine#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * gallery_image_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#gallery_image_reference DevTestLinuxVirtualMachine#gallery_image_reference}
     *
     * @stability stable
     */
    readonly galleryImageReference: DevTestLinuxVirtualMachineGalleryImageReference;
    /**
     * inbound_nat_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#inbound_nat_rule DevTestLinuxVirtualMachine#inbound_nat_rule}
     *
     * @stability stable
     */
    readonly inboundNatRule?: DevTestLinuxVirtualMachineInboundNatRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#timeouts DevTestLinuxVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DevTestLinuxVirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export interface DevTestLinuxVirtualMachineGalleryImageReference {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#offer DevTestLinuxVirtualMachine#offer}.
     *
     * @stability stable
     */
    readonly offer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#publisher DevTestLinuxVirtualMachine#publisher}.
     *
     * @stability stable
     */
    readonly publisher: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#sku DevTestLinuxVirtualMachine#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#version DevTestLinuxVirtualMachine#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
export declare function devTestLinuxVirtualMachineGalleryImageReferenceToTerraform(struct?: DevTestLinuxVirtualMachineGalleryImageReferenceOutputReference | DevTestLinuxVirtualMachineGalleryImageReference): any;
/**
 * @stability stable
 */
export declare class DevTestLinuxVirtualMachineGalleryImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestLinuxVirtualMachineGalleryImageReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestLinuxVirtualMachineGalleryImageReference | undefined);
    private _offer?;
    /**
     * @stability stable
     */
    get offer(): string;
    /**
     * @stability stable
     */
    set offer(value: string);
    /**
     * @stability stable
     */
    get offerInput(): string | undefined;
    private _publisher?;
    /**
     * @stability stable
     */
    get publisher(): string;
    /**
     * @stability stable
     */
    set publisher(value: string);
    /**
     * @stability stable
     */
    get publisherInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestLinuxVirtualMachineInboundNatRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#backend_port DevTestLinuxVirtualMachine#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#protocol DevTestLinuxVirtualMachine#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
}
export declare function devTestLinuxVirtualMachineInboundNatRuleToTerraform(struct?: DevTestLinuxVirtualMachineInboundNatRule): any;
/**
 * @stability stable
 */
export interface DevTestLinuxVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#create DevTestLinuxVirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#delete DevTestLinuxVirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#read DevTestLinuxVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html#update DevTestLinuxVirtualMachine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function devTestLinuxVirtualMachineTimeoutsToTerraform(struct?: DevTestLinuxVirtualMachineTimeoutsOutputReference | DevTestLinuxVirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class DevTestLinuxVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestLinuxVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestLinuxVirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html azurerm_dev_test_linux_virtual_machine}.
 *
 * @stability stable
 */
export declare class DevTestLinuxVirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_linux_virtual_machine.html azurerm_dev_test_linux_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DevTestLinuxVirtualMachineConfig);
    private _allowClaim?;
    /**
     * @stability stable
     */
    get allowClaim(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowClaim(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowClaim(): void;
    /**
     * @stability stable
     */
    get allowClaimInput(): boolean | cdktf.IResolvable | undefined;
    private _disallowPublicIpAddress?;
    /**
     * @stability stable
     */
    get disallowPublicIpAddress(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disallowPublicIpAddress(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisallowPublicIpAddress(): void;
    /**
     * @stability stable
     */
    get disallowPublicIpAddressInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labName?;
    /**
     * @stability stable
     */
    get labName(): string;
    /**
     * @stability stable
     */
    set labName(value: string);
    /**
     * @stability stable
     */
    get labNameInput(): string | undefined;
    private _labSubnetName?;
    /**
     * @stability stable
     */
    get labSubnetName(): string;
    /**
     * @stability stable
     */
    set labSubnetName(value: string);
    /**
     * @stability stable
     */
    get labSubnetNameInput(): string | undefined;
    private _labVirtualNetworkId?;
    /**
     * @stability stable
     */
    get labVirtualNetworkId(): string;
    /**
     * @stability stable
     */
    set labVirtualNetworkId(value: string);
    /**
     * @stability stable
     */
    get labVirtualNetworkIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _notes?;
    /**
     * @stability stable
     */
    get notes(): string;
    /**
     * @stability stable
     */
    set notes(value: string);
    /**
     * @stability stable
     */
    resetNotes(): void;
    /**
     * @stability stable
     */
    get notesInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): string;
    /**
     * @stability stable
     */
    set size(value: string);
    /**
     * @stability stable
     */
    get sizeInput(): string | undefined;
    private _sshKey?;
    /**
     * @stability stable
     */
    get sshKey(): string;
    /**
     * @stability stable
     */
    set sshKey(value: string);
    /**
     * @stability stable
     */
    resetSshKey(): void;
    /**
     * @stability stable
     */
    get sshKeyInput(): string | undefined;
    private _storageType?;
    /**
     * @stability stable
     */
    get storageType(): string;
    /**
     * @stability stable
     */
    set storageType(value: string);
    /**
     * @stability stable
     */
    get storageTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get uniqueIdentifier(): string;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _galleryImageReference;
    /**
     * @stability stable
     */
    get galleryImageReference(): DevTestLinuxVirtualMachineGalleryImageReferenceOutputReference;
    /**
     * @stability stable
     */
    putGalleryImageReference(value: DevTestLinuxVirtualMachineGalleryImageReference): void;
    /**
     * @stability stable
     */
    get galleryImageReferenceInput(): DevTestLinuxVirtualMachineGalleryImageReference | undefined;
    private _inboundNatRule?;
    /**
     * @stability stable
     */
    get inboundNatRule(): DevTestLinuxVirtualMachineInboundNatRule[];
    /**
     * @stability stable
     */
    set inboundNatRule(value: DevTestLinuxVirtualMachineInboundNatRule[]);
    /**
     * @stability stable
     */
    resetInboundNatRule(): void;
    /**
     * @stability stable
     */
    get inboundNatRuleInput(): DevTestLinuxVirtualMachineInboundNatRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DevTestLinuxVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DevTestLinuxVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DevTestLinuxVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
