import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FirewallNetworkRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#action FirewallNetworkRuleCollection#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#azure_firewall_name FirewallNetworkRuleCollection#azure_firewall_name}.
     *
     * @stability stable
     */
    readonly azureFirewallName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#name FirewallNetworkRuleCollection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#priority FirewallNetworkRuleCollection#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#resource_group_name FirewallNetworkRuleCollection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#rule FirewallNetworkRuleCollection#rule}
     *
     * @stability stable
     */
    readonly rule: FirewallNetworkRuleCollectionRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#timeouts FirewallNetworkRuleCollection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FirewallNetworkRuleCollectionTimeouts;
}
/**
 * @stability stable
 */
export interface FirewallNetworkRuleCollectionRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#description FirewallNetworkRuleCollection#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#destination_addresses FirewallNetworkRuleCollection#destination_addresses}.
     *
     * @stability stable
     */
    readonly destinationAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#destination_fqdns FirewallNetworkRuleCollection#destination_fqdns}.
     *
     * @stability stable
     */
    readonly destinationFqdns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#destination_ip_groups FirewallNetworkRuleCollection#destination_ip_groups}.
     *
     * @stability stable
     */
    readonly destinationIpGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#destination_ports FirewallNetworkRuleCollection#destination_ports}.
     *
     * @stability stable
     */
    readonly destinationPorts: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#name FirewallNetworkRuleCollection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#protocols FirewallNetworkRuleCollection#protocols}.
     *
     * @stability stable
     */
    readonly protocols: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#source_addresses FirewallNetworkRuleCollection#source_addresses}.
     *
     * @stability stable
     */
    readonly sourceAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#source_ip_groups FirewallNetworkRuleCollection#source_ip_groups}.
     *
     * @stability stable
     */
    readonly sourceIpGroups?: string[];
}
export declare function firewallNetworkRuleCollectionRuleToTerraform(struct?: FirewallNetworkRuleCollectionRule): any;
/**
 * @stability stable
 */
export interface FirewallNetworkRuleCollectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#create FirewallNetworkRuleCollection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#delete FirewallNetworkRuleCollection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#read FirewallNetworkRuleCollection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html#update FirewallNetworkRuleCollection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function firewallNetworkRuleCollectionTimeoutsToTerraform(struct?: FirewallNetworkRuleCollectionTimeoutsOutputReference | FirewallNetworkRuleCollectionTimeouts): any;
/**
 * @stability stable
 */
export declare class FirewallNetworkRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallNetworkRuleCollectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallNetworkRuleCollectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html azurerm_firewall_network_rule_collection}.
 *
 * @stability stable
 */
export declare class FirewallNetworkRuleCollection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_network_rule_collection.html azurerm_firewall_network_rule_collection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FirewallNetworkRuleCollectionConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _azureFirewallName?;
    /**
     * @stability stable
     */
    get azureFirewallName(): string;
    /**
     * @stability stable
     */
    set azureFirewallName(value: string);
    /**
     * @stability stable
     */
    get azureFirewallNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): FirewallNetworkRuleCollectionRule[];
    /**
     * @stability stable
     */
    set rule(value: FirewallNetworkRuleCollectionRule[]);
    /**
     * @stability stable
     */
    get ruleInput(): FirewallNetworkRuleCollectionRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FirewallNetworkRuleCollectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FirewallNetworkRuleCollectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FirewallNetworkRuleCollectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
