import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#double_encryption_enabled KustoCluster#double_encryption_enabled}.
     *
     * @stability stable
     */
    readonly doubleEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#enable_disk_encryption KustoCluster#enable_disk_encryption}.
     *
     * @stability stable
     */
    readonly enableDiskEncryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#enable_purge KustoCluster#enable_purge}.
     *
     * @stability stable
     */
    readonly enablePurge?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#enable_streaming_ingest KustoCluster#enable_streaming_ingest}.
     *
     * @stability stable
     */
    readonly enableStreamingIngest?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#engine KustoCluster#engine}.
     *
     * @stability stable
     */
    readonly engine?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#language_extensions KustoCluster#language_extensions}.
     *
     * @stability stable
     */
    readonly languageExtensions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#location KustoCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#name KustoCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#resource_group_name KustoCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#tags KustoCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#trusted_external_tenants KustoCluster#trusted_external_tenants}.
     *
     * @stability stable
     */
    readonly trustedExternalTenants?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#zones KustoCluster#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#identity KustoCluster#identity}
     *
     * @stability stable
     */
    readonly identity?: KustoClusterIdentity;
    /**
     * optimized_auto_scale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#optimized_auto_scale KustoCluster#optimized_auto_scale}
     *
     * @stability stable
     */
    readonly optimizedAutoScale?: KustoClusterOptimizedAutoScale;
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#sku KustoCluster#sku}
     *
     * @stability stable
     */
    readonly sku: KustoClusterSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#timeouts KustoCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoClusterTimeouts;
    /**
     * virtual_network_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#virtual_network_configuration KustoCluster#virtual_network_configuration}
     *
     * @stability stable
     */
    readonly virtualNetworkConfiguration?: KustoClusterVirtualNetworkConfiguration;
}
/**
 * @stability stable
 */
export interface KustoClusterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#identity_ids KustoCluster#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#type KustoCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function kustoClusterIdentityToTerraform(struct?: KustoClusterIdentityOutputReference | KustoClusterIdentity): any;
/**
 * @stability stable
 */
export declare class KustoClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoClusterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoClusterIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KustoClusterOptimizedAutoScale {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#maximum_instances KustoCluster#maximum_instances}.
     *
     * @stability stable
     */
    readonly maximumInstances: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#minimum_instances KustoCluster#minimum_instances}.
     *
     * @stability stable
     */
    readonly minimumInstances: number;
}
export declare function kustoClusterOptimizedAutoScaleToTerraform(struct?: KustoClusterOptimizedAutoScaleOutputReference | KustoClusterOptimizedAutoScale): any;
/**
 * @stability stable
 */
export declare class KustoClusterOptimizedAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoClusterOptimizedAutoScale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoClusterOptimizedAutoScale | undefined);
    private _maximumInstances?;
    /**
     * @stability stable
     */
    get maximumInstances(): number;
    /**
     * @stability stable
     */
    set maximumInstances(value: number);
    /**
     * @stability stable
     */
    get maximumInstancesInput(): number | undefined;
    private _minimumInstances?;
    /**
     * @stability stable
     */
    get minimumInstances(): number;
    /**
     * @stability stable
     */
    set minimumInstances(value: number);
    /**
     * @stability stable
     */
    get minimumInstancesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KustoClusterSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#capacity KustoCluster#capacity}.
     *
     * @stability stable
     */
    readonly capacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#name KustoCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function kustoClusterSkuToTerraform(struct?: KustoClusterSkuOutputReference | KustoClusterSku): any;
/**
 * @stability stable
 */
export declare class KustoClusterSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoClusterSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoClusterSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KustoClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#create KustoCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#delete KustoCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#read KustoCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#update KustoCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoClusterTimeoutsToTerraform(struct?: KustoClusterTimeoutsOutputReference | KustoClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KustoClusterVirtualNetworkConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#data_management_public_ip_id KustoCluster#data_management_public_ip_id}.
     *
     * @stability stable
     */
    readonly dataManagementPublicIpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#engine_public_ip_id KustoCluster#engine_public_ip_id}.
     *
     * @stability stable
     */
    readonly enginePublicIpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html#subnet_id KustoCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function kustoClusterVirtualNetworkConfigurationToTerraform(struct?: KustoClusterVirtualNetworkConfigurationOutputReference | KustoClusterVirtualNetworkConfiguration): any;
/**
 * @stability stable
 */
export declare class KustoClusterVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoClusterVirtualNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoClusterVirtualNetworkConfiguration | undefined);
    private _dataManagementPublicIpId?;
    /**
     * @stability stable
     */
    get dataManagementPublicIpId(): string;
    /**
     * @stability stable
     */
    set dataManagementPublicIpId(value: string);
    /**
     * @stability stable
     */
    get dataManagementPublicIpIdInput(): string | undefined;
    private _enginePublicIpId?;
    /**
     * @stability stable
     */
    get enginePublicIpId(): string;
    /**
     * @stability stable
     */
    set enginePublicIpId(value: string);
    /**
     * @stability stable
     */
    get enginePublicIpIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html azurerm_kusto_cluster}.
 *
 * @stability stable
 */
export declare class KustoCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_cluster.html azurerm_kusto_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoClusterConfig);
    /**
     * @stability stable
     */
    get dataIngestionUri(): string;
    private _doubleEncryptionEnabled?;
    /**
     * @stability stable
     */
    get doubleEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set doubleEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDoubleEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get doubleEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableDiskEncryption?;
    /**
     * @stability stable
     */
    get enableDiskEncryption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableDiskEncryption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableDiskEncryption(): void;
    /**
     * @stability stable
     */
    get enableDiskEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePurge?;
    /**
     * @stability stable
     */
    get enablePurge(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePurge(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePurge(): void;
    /**
     * @stability stable
     */
    get enablePurgeInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStreamingIngest?;
    /**
     * @stability stable
     */
    get enableStreamingIngest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableStreamingIngest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableStreamingIngest(): void;
    /**
     * @stability stable
     */
    get enableStreamingIngestInput(): boolean | cdktf.IResolvable | undefined;
    private _engine?;
    /**
     * @stability stable
     */
    get engine(): string;
    /**
     * @stability stable
     */
    set engine(value: string);
    /**
     * @stability stable
     */
    resetEngine(): void;
    /**
     * @stability stable
     */
    get engineInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _languageExtensions?;
    /**
     * @stability stable
     */
    get languageExtensions(): string[];
    /**
     * @stability stable
     */
    set languageExtensions(value: string[]);
    /**
     * @stability stable
     */
    resetLanguageExtensions(): void;
    /**
     * @stability stable
     */
    get languageExtensionsInput(): string[] | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _trustedExternalTenants?;
    /**
     * @stability stable
     */
    get trustedExternalTenants(): string[];
    /**
     * @stability stable
     */
    set trustedExternalTenants(value: string[]);
    /**
     * @stability stable
     */
    resetTrustedExternalTenants(): void;
    /**
     * @stability stable
     */
    get trustedExternalTenantsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get uri(): string;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): KustoClusterIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: KustoClusterIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): KustoClusterIdentity | undefined;
    private _optimizedAutoScale;
    /**
     * @stability stable
     */
    get optimizedAutoScale(): KustoClusterOptimizedAutoScaleOutputReference;
    /**
     * @stability stable
     */
    putOptimizedAutoScale(value: KustoClusterOptimizedAutoScale): void;
    /**
     * @stability stable
     */
    resetOptimizedAutoScale(): void;
    /**
     * @stability stable
     */
    get optimizedAutoScaleInput(): KustoClusterOptimizedAutoScale | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): KustoClusterSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: KustoClusterSku): void;
    /**
     * @stability stable
     */
    get skuInput(): KustoClusterSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoClusterTimeouts | undefined;
    private _virtualNetworkConfiguration;
    /**
     * @stability stable
     */
    get virtualNetworkConfiguration(): KustoClusterVirtualNetworkConfigurationOutputReference;
    /**
     * @stability stable
     */
    putVirtualNetworkConfiguration(value: KustoClusterVirtualNetworkConfiguration): void;
    /**
     * @stability stable
     */
    resetVirtualNetworkConfiguration(): void;
    /**
     * @stability stable
     */
    get virtualNetworkConfigurationInput(): KustoClusterVirtualNetworkConfiguration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
