import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KustoDatabasePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#client_id KustoDatabasePrincipal#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#cluster_name KustoDatabasePrincipal#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#database_name KustoDatabasePrincipal#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#object_id KustoDatabasePrincipal#object_id}.
     *
     * @stability stable
     */
    readonly objectId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#resource_group_name KustoDatabasePrincipal#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#role KustoDatabasePrincipal#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#type KustoDatabasePrincipal#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#timeouts KustoDatabasePrincipal#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KustoDatabasePrincipalTimeouts;
}
/**
 * @stability stable
 */
export interface KustoDatabasePrincipalTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#create KustoDatabasePrincipal#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#delete KustoDatabasePrincipal#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#read KustoDatabasePrincipal#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html#update KustoDatabasePrincipal#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kustoDatabasePrincipalTimeoutsToTerraform(struct?: KustoDatabasePrincipalTimeoutsOutputReference | KustoDatabasePrincipalTimeouts): any;
/**
 * @stability stable
 */
export declare class KustoDatabasePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KustoDatabasePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KustoDatabasePrincipalTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html azurerm_kusto_database_principal}.
 *
 * @stability stable
 */
export declare class KustoDatabasePrincipal extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kusto_database_principal.html azurerm_kusto_database_principal} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KustoDatabasePrincipalConfig);
    /**
     * @stability stable
     */
    get appId(): string;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    get fullyQualifiedName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KustoDatabasePrincipalTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KustoDatabasePrincipalTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KustoDatabasePrincipalTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
