import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogzMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#company_name LogzMonitor#company_name}.
     *
     * @stability stable
     */
    readonly companyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#enabled LogzMonitor#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#enterprise_app_id LogzMonitor#enterprise_app_id}.
     *
     * @stability stable
     */
    readonly enterpriseAppId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#location LogzMonitor#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#name LogzMonitor#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#resource_group_name LogzMonitor#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#tags LogzMonitor#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * plan block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#plan LogzMonitor#plan}
     *
     * @stability stable
     */
    readonly plan: LogzMonitorPlan;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#timeouts LogzMonitor#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogzMonitorTimeouts;
    /**
     * user block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#user LogzMonitor#user}
     *
     * @stability stable
     */
    readonly user: LogzMonitorUser;
}
/**
 * @stability stable
 */
export interface LogzMonitorPlan {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#billing_cycle LogzMonitor#billing_cycle}.
     *
     * @stability stable
     */
    readonly billingCycle: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#effective_date LogzMonitor#effective_date}.
     *
     * @stability stable
     */
    readonly effectiveDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#plan_id LogzMonitor#plan_id}.
     *
     * @stability stable
     */
    readonly planId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#usage_type LogzMonitor#usage_type}.
     *
     * @stability stable
     */
    readonly usageType: string;
}
export declare function logzMonitorPlanToTerraform(struct?: LogzMonitorPlanOutputReference | LogzMonitorPlan): any;
/**
 * @stability stable
 */
export declare class LogzMonitorPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogzMonitorPlan | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogzMonitorPlan | undefined);
    private _billingCycle?;
    /**
     * @stability stable
     */
    get billingCycle(): string;
    /**
     * @stability stable
     */
    set billingCycle(value: string);
    /**
     * @stability stable
     */
    get billingCycleInput(): string | undefined;
    private _effectiveDate?;
    /**
     * @stability stable
     */
    get effectiveDate(): string;
    /**
     * @stability stable
     */
    set effectiveDate(value: string);
    /**
     * @stability stable
     */
    get effectiveDateInput(): string | undefined;
    private _planId?;
    /**
     * @stability stable
     */
    get planId(): string;
    /**
     * @stability stable
     */
    set planId(value: string);
    /**
     * @stability stable
     */
    get planIdInput(): string | undefined;
    private _usageType?;
    /**
     * @stability stable
     */
    get usageType(): string;
    /**
     * @stability stable
     */
    set usageType(value: string);
    /**
     * @stability stable
     */
    get usageTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogzMonitorTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#create LogzMonitor#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#delete LogzMonitor#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#read LogzMonitor#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#update LogzMonitor#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logzMonitorTimeoutsToTerraform(struct?: LogzMonitorTimeoutsOutputReference | LogzMonitorTimeouts): any;
/**
 * @stability stable
 */
export declare class LogzMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogzMonitorTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogzMonitorTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogzMonitorUser {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#email LogzMonitor#email}.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#first_name LogzMonitor#first_name}.
     *
     * @stability stable
     */
    readonly firstName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#last_name LogzMonitor#last_name}.
     *
     * @stability stable
     */
    readonly lastName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html#phone_number LogzMonitor#phone_number}.
     *
     * @stability stable
     */
    readonly phoneNumber: string;
}
export declare function logzMonitorUserToTerraform(struct?: LogzMonitorUserOutputReference | LogzMonitorUser): any;
/**
 * @stability stable
 */
export declare class LogzMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogzMonitorUser | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogzMonitorUser | undefined);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _firstName?;
    /**
     * @stability stable
     */
    get firstName(): string;
    /**
     * @stability stable
     */
    set firstName(value: string);
    /**
     * @stability stable
     */
    get firstNameInput(): string | undefined;
    private _lastName?;
    /**
     * @stability stable
     */
    get lastName(): string;
    /**
     * @stability stable
     */
    set lastName(value: string);
    /**
     * @stability stable
     */
    get lastNameInput(): string | undefined;
    private _phoneNumber?;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
    /**
     * @stability stable
     */
    set phoneNumber(value: string);
    /**
     * @stability stable
     */
    get phoneNumberInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html azurerm_logz_monitor}.
 *
 * @stability stable
 */
export declare class LogzMonitor extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logz_monitor.html azurerm_logz_monitor} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogzMonitorConfig);
    private _companyName?;
    /**
     * @stability stable
     */
    get companyName(): string;
    /**
     * @stability stable
     */
    set companyName(value: string);
    /**
     * @stability stable
     */
    resetCompanyName(): void;
    /**
     * @stability stable
     */
    get companyNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enterpriseAppId?;
    /**
     * @stability stable
     */
    get enterpriseAppId(): string;
    /**
     * @stability stable
     */
    set enterpriseAppId(value: string);
    /**
     * @stability stable
     */
    resetEnterpriseAppId(): void;
    /**
     * @stability stable
     */
    get enterpriseAppIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get logzOrganizationId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get singleSignOnUrl(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _plan;
    /**
     * @stability stable
     */
    get plan(): LogzMonitorPlanOutputReference;
    /**
     * @stability stable
     */
    putPlan(value: LogzMonitorPlan): void;
    /**
     * @stability stable
     */
    get planInput(): LogzMonitorPlan | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogzMonitorTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogzMonitorTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogzMonitorTimeouts | undefined;
    private _user;
    /**
     * @stability stable
     */
    get user(): LogzMonitorUserOutputReference;
    /**
     * @stability stable
     */
    putUser(value: LogzMonitorUser): void;
    /**
     * @stability stable
     */
    get userInput(): LogzMonitorUser | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
