import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SignalrServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#connectivity_logs_enabled SignalrService#connectivity_logs_enabled}.
     *
     * @stability stable
     */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#location SignalrService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#messaging_logs_enabled SignalrService#messaging_logs_enabled}.
     *
     * @stability stable
     */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#name SignalrService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#resource_group_name SignalrService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#service_mode SignalrService#service_mode}.
     *
     * @stability stable
     */
    readonly serviceMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#tags SignalrService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#cors SignalrService#cors}
     *
     * @stability stable
     */
    readonly cors?: SignalrServiceCors[];
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#features SignalrService#features}
     *
     * @stability stable
     */
    readonly features?: SignalrServiceFeatures[];
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#sku SignalrService#sku}
     *
     * @stability stable
     */
    readonly sku: SignalrServiceSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#timeouts SignalrService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SignalrServiceTimeouts;
    /**
     * upstream_endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#upstream_endpoint SignalrService#upstream_endpoint}
     *
     * @stability stable
     */
    readonly upstreamEndpoint?: SignalrServiceUpstreamEndpoint[];
}
/**
 * @stability stable
 */
export interface SignalrServiceCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#allowed_origins SignalrService#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
}
export declare function signalrServiceCorsToTerraform(struct?: SignalrServiceCors): any;
/**
 * @stability stable
 */
export interface SignalrServiceFeatures {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#flag SignalrService#flag}.
     *
     * @stability stable
     */
    readonly flag: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#value SignalrService#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function signalrServiceFeaturesToTerraform(struct?: SignalrServiceFeatures): any;
/**
 * @stability stable
 */
export interface SignalrServiceSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#capacity SignalrService#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#name SignalrService#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function signalrServiceSkuToTerraform(struct?: SignalrServiceSkuOutputReference | SignalrServiceSku): any;
/**
 * @stability stable
 */
export declare class SignalrServiceSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SignalrServiceSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SignalrServiceSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SignalrServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#create SignalrService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#delete SignalrService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#read SignalrService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#update SignalrService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function signalrServiceTimeoutsToTerraform(struct?: SignalrServiceTimeoutsOutputReference | SignalrServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class SignalrServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SignalrServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SignalrServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SignalrServiceUpstreamEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#category_pattern SignalrService#category_pattern}.
     *
     * @stability stable
     */
    readonly categoryPattern: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#event_pattern SignalrService#event_pattern}.
     *
     * @stability stable
     */
    readonly eventPattern: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#hub_pattern SignalrService#hub_pattern}.
     *
     * @stability stable
     */
    readonly hubPattern: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html#url_template SignalrService#url_template}.
     *
     * @stability stable
     */
    readonly urlTemplate: string;
}
export declare function signalrServiceUpstreamEndpointToTerraform(struct?: SignalrServiceUpstreamEndpoint): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html azurerm_signalr_service}.
 *
 * @stability stable
 */
export declare class SignalrService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service.html azurerm_signalr_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SignalrServiceConfig);
    private _connectivityLogsEnabled?;
    /**
     * @stability stable
     */
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetConnectivityLogsEnabled(): void;
    /**
     * @stability stable
     */
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipAddress(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _messagingLogsEnabled?;
    /**
     * @stability stable
     */
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMessagingLogsEnabled(): void;
    /**
     * @stability stable
     */
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get publicPort(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get serverPort(): number;
    private _serviceMode?;
    /**
     * @stability stable
     */
    get serviceMode(): string;
    /**
     * @stability stable
     */
    set serviceMode(value: string);
    /**
     * @stability stable
     */
    resetServiceMode(): void;
    /**
     * @stability stable
     */
    get serviceModeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _cors?;
    /**
     * @stability stable
     */
    get cors(): SignalrServiceCors[];
    /**
     * @stability stable
     */
    set cors(value: SignalrServiceCors[]);
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): SignalrServiceCors[] | undefined;
    private _features?;
    /**
     * @stability stable
     */
    get features(): SignalrServiceFeatures[];
    /**
     * @stability stable
     */
    set features(value: SignalrServiceFeatures[]);
    /**
     * @stability stable
     */
    resetFeatures(): void;
    /**
     * @stability stable
     */
    get featuresInput(): SignalrServiceFeatures[] | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): SignalrServiceSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: SignalrServiceSku): void;
    /**
     * @stability stable
     */
    get skuInput(): SignalrServiceSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SignalrServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SignalrServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SignalrServiceTimeouts | undefined;
    private _upstreamEndpoint?;
    /**
     * @stability stable
     */
    get upstreamEndpoint(): SignalrServiceUpstreamEndpoint[];
    /**
     * @stability stable
     */
    set upstreamEndpoint(value: SignalrServiceUpstreamEndpoint[]);
    /**
     * @stability stable
     */
    resetUpstreamEndpoint(): void;
    /**
     * @stability stable
     */
    get upstreamEndpointInput(): SignalrServiceUpstreamEndpoint[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
