import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SiteRecoveryProtectionContainerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#name SiteRecoveryProtectionContainer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#recovery_fabric_name SiteRecoveryProtectionContainer#recovery_fabric_name}.
     *
     * @stability stable
     */
    readonly recoveryFabricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#recovery_vault_name SiteRecoveryProtectionContainer#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#resource_group_name SiteRecoveryProtectionContainer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#timeouts SiteRecoveryProtectionContainer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SiteRecoveryProtectionContainerTimeouts;
}
/**
 * @stability stable
 */
export interface SiteRecoveryProtectionContainerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#create SiteRecoveryProtectionContainer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#delete SiteRecoveryProtectionContainer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#read SiteRecoveryProtectionContainer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html#update SiteRecoveryProtectionContainer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function siteRecoveryProtectionContainerTimeoutsToTerraform(struct?: SiteRecoveryProtectionContainerTimeoutsOutputReference | SiteRecoveryProtectionContainerTimeouts): any;
/**
 * @stability stable
 */
export declare class SiteRecoveryProtectionContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SiteRecoveryProtectionContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SiteRecoveryProtectionContainerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html azurerm_site_recovery_protection_container}.
 *
 * @stability stable
 */
export declare class SiteRecoveryProtectionContainer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_protection_container.html azurerm_site_recovery_protection_container} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SiteRecoveryProtectionContainerConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recoveryFabricName?;
    /**
     * @stability stable
     */
    get recoveryFabricName(): string;
    /**
     * @stability stable
     */
    set recoveryFabricName(value: string);
    /**
     * @stability stable
     */
    get recoveryFabricNameInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SiteRecoveryProtectionContainerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SiteRecoveryProtectionContainerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SiteRecoveryProtectionContainerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
