import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualDesktopApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#application_group_id VirtualDesktopApplication#application_group_id}.
     *
     * @stability stable
     */
    readonly applicationGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#command_line_argument_policy VirtualDesktopApplication#command_line_argument_policy}.
     *
     * @stability stable
     */
    readonly commandLineArgumentPolicy: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#command_line_arguments VirtualDesktopApplication#command_line_arguments}.
     *
     * @stability stable
     */
    readonly commandLineArguments?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#description VirtualDesktopApplication#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#friendly_name VirtualDesktopApplication#friendly_name}.
     *
     * @stability stable
     */
    readonly friendlyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#icon_index VirtualDesktopApplication#icon_index}.
     *
     * @stability stable
     */
    readonly iconIndex?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#icon_path VirtualDesktopApplication#icon_path}.
     *
     * @stability stable
     */
    readonly iconPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#name VirtualDesktopApplication#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#path VirtualDesktopApplication#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#show_in_portal VirtualDesktopApplication#show_in_portal}.
     *
     * @stability stable
     */
    readonly showInPortal?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#timeouts VirtualDesktopApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualDesktopApplicationTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualDesktopApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#create VirtualDesktopApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#delete VirtualDesktopApplication#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#read VirtualDesktopApplication#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html#update VirtualDesktopApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualDesktopApplicationTimeoutsToTerraform(struct?: VirtualDesktopApplicationTimeoutsOutputReference | VirtualDesktopApplicationTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualDesktopApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualDesktopApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualDesktopApplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html azurerm_virtual_desktop_application}.
 *
 * @stability stable
 */
export declare class VirtualDesktopApplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_application.html azurerm_virtual_desktop_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualDesktopApplicationConfig);
    private _applicationGroupId?;
    /**
     * @stability stable
     */
    get applicationGroupId(): string;
    /**
     * @stability stable
     */
    set applicationGroupId(value: string);
    /**
     * @stability stable
     */
    get applicationGroupIdInput(): string | undefined;
    private _commandLineArgumentPolicy?;
    /**
     * @stability stable
     */
    get commandLineArgumentPolicy(): string;
    /**
     * @stability stable
     */
    set commandLineArgumentPolicy(value: string);
    /**
     * @stability stable
     */
    get commandLineArgumentPolicyInput(): string | undefined;
    private _commandLineArguments?;
    /**
     * @stability stable
     */
    get commandLineArguments(): string;
    /**
     * @stability stable
     */
    set commandLineArguments(value: string);
    /**
     * @stability stable
     */
    resetCommandLineArguments(): void;
    /**
     * @stability stable
     */
    get commandLineArgumentsInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    /**
     * @stability stable
     */
    get friendlyName(): string;
    /**
     * @stability stable
     */
    set friendlyName(value: string);
    /**
     * @stability stable
     */
    resetFriendlyName(): void;
    /**
     * @stability stable
     */
    get friendlyNameInput(): string | undefined;
    private _iconIndex?;
    /**
     * @stability stable
     */
    get iconIndex(): number;
    /**
     * @stability stable
     */
    set iconIndex(value: number);
    /**
     * @stability stable
     */
    resetIconIndex(): void;
    /**
     * @stability stable
     */
    get iconIndexInput(): number | undefined;
    private _iconPath?;
    /**
     * @stability stable
     */
    get iconPath(): string;
    /**
     * @stability stable
     */
    set iconPath(value: string);
    /**
     * @stability stable
     */
    resetIconPath(): void;
    /**
     * @stability stable
     */
    get iconPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _showInPortal?;
    /**
     * @stability stable
     */
    get showInPortal(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showInPortal(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowInPortal(): void;
    /**
     * @stability stable
     */
    get showInPortalInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualDesktopApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualDesktopApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualDesktopApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
