import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#authorization_key VirtualNetworkGatewayConnection#authorization_key}.
     *
     * @stability stable
     */
    readonly authorizationKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#connection_protocol VirtualNetworkGatewayConnection#connection_protocol}.
     *
     * @stability stable
     */
    readonly connectionProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#dpd_timeout_seconds VirtualNetworkGatewayConnection#dpd_timeout_seconds}.
     *
     * @stability stable
     */
    readonly dpdTimeoutSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#enable_bgp VirtualNetworkGatewayConnection#enable_bgp}.
     *
     * @stability stable
     */
    readonly enableBgp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#express_route_circuit_id VirtualNetworkGatewayConnection#express_route_circuit_id}.
     *
     * @stability stable
     */
    readonly expressRouteCircuitId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#express_route_gateway_bypass VirtualNetworkGatewayConnection#express_route_gateway_bypass}.
     *
     * @stability stable
     */
    readonly expressRouteGatewayBypass?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#local_azure_ip_address_enabled VirtualNetworkGatewayConnection#local_azure_ip_address_enabled}.
     *
     * @stability stable
     */
    readonly localAzureIpAddressEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#local_network_gateway_id VirtualNetworkGatewayConnection#local_network_gateway_id}.
     *
     * @stability stable
     */
    readonly localNetworkGatewayId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#location VirtualNetworkGatewayConnection#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#name VirtualNetworkGatewayConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#peer_virtual_network_gateway_id VirtualNetworkGatewayConnection#peer_virtual_network_gateway_id}.
     *
     * @stability stable
     */
    readonly peerVirtualNetworkGatewayId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#resource_group_name VirtualNetworkGatewayConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#routing_weight VirtualNetworkGatewayConnection#routing_weight}.
     *
     * @stability stable
     */
    readonly routingWeight?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#shared_key VirtualNetworkGatewayConnection#shared_key}.
     *
     * @stability stable
     */
    readonly sharedKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#tags VirtualNetworkGatewayConnection#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#type VirtualNetworkGatewayConnection#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#use_policy_based_traffic_selectors VirtualNetworkGatewayConnection#use_policy_based_traffic_selectors}.
     *
     * @stability stable
     */
    readonly usePolicyBasedTrafficSelectors?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#virtual_network_gateway_id VirtualNetworkGatewayConnection#virtual_network_gateway_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkGatewayId: string;
    /**
     * ipsec_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#ipsec_policy VirtualNetworkGatewayConnection#ipsec_policy}
     *
     * @stability stable
     */
    readonly ipsecPolicy?: VirtualNetworkGatewayConnectionIpsecPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#timeouts VirtualNetworkGatewayConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualNetworkGatewayConnectionTimeouts;
    /**
     * traffic_selector_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#traffic_selector_policy VirtualNetworkGatewayConnection#traffic_selector_policy}
     *
     * @stability stable
     */
    readonly trafficSelectorPolicy?: VirtualNetworkGatewayConnectionTrafficSelectorPolicy;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayConnectionIpsecPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#dh_group VirtualNetworkGatewayConnection#dh_group}.
     *
     * @stability stable
     */
    readonly dhGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#ike_encryption VirtualNetworkGatewayConnection#ike_encryption}.
     *
     * @stability stable
     */
    readonly ikeEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#ike_integrity VirtualNetworkGatewayConnection#ike_integrity}.
     *
     * @stability stable
     */
    readonly ikeIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#ipsec_encryption VirtualNetworkGatewayConnection#ipsec_encryption}.
     *
     * @stability stable
     */
    readonly ipsecEncryption: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#ipsec_integrity VirtualNetworkGatewayConnection#ipsec_integrity}.
     *
     * @stability stable
     */
    readonly ipsecIntegrity: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#pfs_group VirtualNetworkGatewayConnection#pfs_group}.
     *
     * @stability stable
     */
    readonly pfsGroup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#sa_datasize VirtualNetworkGatewayConnection#sa_datasize}.
     *
     * @stability stable
     */
    readonly saDatasize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#sa_lifetime VirtualNetworkGatewayConnection#sa_lifetime}.
     *
     * @stability stable
     */
    readonly saLifetime?: number;
}
export declare function virtualNetworkGatewayConnectionIpsecPolicyToTerraform(struct?: VirtualNetworkGatewayConnectionIpsecPolicyOutputReference | VirtualNetworkGatewayConnectionIpsecPolicy): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayConnectionIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayConnectionIpsecPolicy | undefined);
    private _dhGroup?;
    /**
     * @stability stable
     */
    get dhGroup(): string;
    /**
     * @stability stable
     */
    set dhGroup(value: string);
    /**
     * @stability stable
     */
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    /**
     * @stability stable
     */
    get ikeEncryption(): string;
    /**
     * @stability stable
     */
    set ikeEncryption(value: string);
    /**
     * @stability stable
     */
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    /**
     * @stability stable
     */
    get ikeIntegrity(): string;
    /**
     * @stability stable
     */
    set ikeIntegrity(value: string);
    /**
     * @stability stable
     */
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    /**
     * @stability stable
     */
    get ipsecEncryption(): string;
    /**
     * @stability stable
     */
    set ipsecEncryption(value: string);
    /**
     * @stability stable
     */
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    /**
     * @stability stable
     */
    get ipsecIntegrity(): string;
    /**
     * @stability stable
     */
    set ipsecIntegrity(value: string);
    /**
     * @stability stable
     */
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    /**
     * @stability stable
     */
    get pfsGroup(): string;
    /**
     * @stability stable
     */
    set pfsGroup(value: string);
    /**
     * @stability stable
     */
    get pfsGroupInput(): string | undefined;
    private _saDatasize?;
    /**
     * @stability stable
     */
    get saDatasize(): number;
    /**
     * @stability stable
     */
    set saDatasize(value: number);
    /**
     * @stability stable
     */
    resetSaDatasize(): void;
    /**
     * @stability stable
     */
    get saDatasizeInput(): number | undefined;
    private _saLifetime?;
    /**
     * @stability stable
     */
    get saLifetime(): number;
    /**
     * @stability stable
     */
    set saLifetime(value: number);
    /**
     * @stability stable
     */
    resetSaLifetime(): void;
    /**
     * @stability stable
     */
    get saLifetimeInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#create VirtualNetworkGatewayConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#delete VirtualNetworkGatewayConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#read VirtualNetworkGatewayConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#update VirtualNetworkGatewayConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: VirtualNetworkGatewayConnectionTimeoutsOutputReference | VirtualNetworkGatewayConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VirtualNetworkGatewayConnectionTrafficSelectorPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#local_address_cidrs VirtualNetworkGatewayConnection#local_address_cidrs}.
     *
     * @stability stable
     */
    readonly localAddressCidrs: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html#remote_address_cidrs VirtualNetworkGatewayConnection#remote_address_cidrs}.
     *
     * @stability stable
     */
    readonly remoteAddressCidrs: string[];
}
export declare function virtualNetworkGatewayConnectionTrafficSelectorPolicyToTerraform(struct?: VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference | VirtualNetworkGatewayConnectionTrafficSelectorPolicy): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkGatewayConnectionTrafficSelectorPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkGatewayConnectionTrafficSelectorPolicy | undefined);
    private _localAddressCidrs?;
    /**
     * @stability stable
     */
    get localAddressCidrs(): string[];
    /**
     * @stability stable
     */
    set localAddressCidrs(value: string[]);
    /**
     * @stability stable
     */
    get localAddressCidrsInput(): string[] | undefined;
    private _remoteAddressCidrs?;
    /**
     * @stability stable
     */
    get remoteAddressCidrs(): string[];
    /**
     * @stability stable
     */
    set remoteAddressCidrs(value: string[]);
    /**
     * @stability stable
     */
    get remoteAddressCidrsInput(): string[] | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html azurerm_virtual_network_gateway_connection}.
 *
 * @stability stable
 */
export declare class VirtualNetworkGatewayConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_gateway_connection.html azurerm_virtual_network_gateway_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualNetworkGatewayConnectionConfig);
    private _authorizationKey?;
    /**
     * @stability stable
     */
    get authorizationKey(): string;
    /**
     * @stability stable
     */
    set authorizationKey(value: string);
    /**
     * @stability stable
     */
    resetAuthorizationKey(): void;
    /**
     * @stability stable
     */
    get authorizationKeyInput(): string | undefined;
    private _connectionProtocol?;
    /**
     * @stability stable
     */
    get connectionProtocol(): string;
    /**
     * @stability stable
     */
    set connectionProtocol(value: string);
    /**
     * @stability stable
     */
    resetConnectionProtocol(): void;
    /**
     * @stability stable
     */
    get connectionProtocolInput(): string | undefined;
    private _dpdTimeoutSeconds?;
    /**
     * @stability stable
     */
    get dpdTimeoutSeconds(): number;
    /**
     * @stability stable
     */
    set dpdTimeoutSeconds(value: number);
    /**
     * @stability stable
     */
    resetDpdTimeoutSeconds(): void;
    /**
     * @stability stable
     */
    get dpdTimeoutSecondsInput(): number | undefined;
    private _enableBgp?;
    /**
     * @stability stable
     */
    get enableBgp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBgp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBgp(): void;
    /**
     * @stability stable
     */
    get enableBgpInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteCircuitId?;
    /**
     * @stability stable
     */
    get expressRouteCircuitId(): string;
    /**
     * @stability stable
     */
    set expressRouteCircuitId(value: string);
    /**
     * @stability stable
     */
    resetExpressRouteCircuitId(): void;
    /**
     * @stability stable
     */
    get expressRouteCircuitIdInput(): string | undefined;
    private _expressRouteGatewayBypass?;
    /**
     * @stability stable
     */
    get expressRouteGatewayBypass(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set expressRouteGatewayBypass(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExpressRouteGatewayBypass(): void;
    /**
     * @stability stable
     */
    get expressRouteGatewayBypassInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _localAzureIpAddressEnabled?;
    /**
     * @stability stable
     */
    get localAzureIpAddressEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAzureIpAddressEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAzureIpAddressEnabled(): void;
    /**
     * @stability stable
     */
    get localAzureIpAddressEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localNetworkGatewayId?;
    /**
     * @stability stable
     */
    get localNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    set localNetworkGatewayId(value: string);
    /**
     * @stability stable
     */
    resetLocalNetworkGatewayId(): void;
    /**
     * @stability stable
     */
    get localNetworkGatewayIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peerVirtualNetworkGatewayId?;
    /**
     * @stability stable
     */
    get peerVirtualNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    set peerVirtualNetworkGatewayId(value: string);
    /**
     * @stability stable
     */
    resetPeerVirtualNetworkGatewayId(): void;
    /**
     * @stability stable
     */
    get peerVirtualNetworkGatewayIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _routingWeight?;
    /**
     * @stability stable
     */
    get routingWeight(): number;
    /**
     * @stability stable
     */
    set routingWeight(value: number);
    /**
     * @stability stable
     */
    resetRoutingWeight(): void;
    /**
     * @stability stable
     */
    get routingWeightInput(): number | undefined;
    private _sharedKey?;
    /**
     * @stability stable
     */
    get sharedKey(): string;
    /**
     * @stability stable
     */
    set sharedKey(value: string);
    /**
     * @stability stable
     */
    resetSharedKey(): void;
    /**
     * @stability stable
     */
    get sharedKeyInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _usePolicyBasedTrafficSelectors?;
    /**
     * @stability stable
     */
    get usePolicyBasedTrafficSelectors(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set usePolicyBasedTrafficSelectors(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUsePolicyBasedTrafficSelectors(): void;
    /**
     * @stability stable
     */
    get usePolicyBasedTrafficSelectorsInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkGatewayId?;
    /**
     * @stability stable
     */
    get virtualNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkGatewayId(value: string);
    /**
     * @stability stable
     */
    get virtualNetworkGatewayIdInput(): string | undefined;
    private _ipsecPolicy;
    /**
     * @stability stable
     */
    get ipsecPolicy(): VirtualNetworkGatewayConnectionIpsecPolicyOutputReference;
    /**
     * @stability stable
     */
    putIpsecPolicy(value: VirtualNetworkGatewayConnectionIpsecPolicy): void;
    /**
     * @stability stable
     */
    resetIpsecPolicy(): void;
    /**
     * @stability stable
     */
    get ipsecPolicyInput(): VirtualNetworkGatewayConnectionIpsecPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualNetworkGatewayConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualNetworkGatewayConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualNetworkGatewayConnectionTimeouts | undefined;
    private _trafficSelectorPolicy;
    /**
     * @stability stable
     */
    get trafficSelectorPolicy(): VirtualNetworkGatewayConnectionTrafficSelectorPolicyOutputReference;
    /**
     * @stability stable
     */
    putTrafficSelectorPolicy(value: VirtualNetworkGatewayConnectionTrafficSelectorPolicy): void;
    /**
     * @stability stable
     */
    resetTrafficSelectorPolicy(): void;
    /**
     * @stability stable
     */
    get trafficSelectorPolicyInput(): VirtualNetworkGatewayConnectionTrafficSelectorPolicy | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
