import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#allow_forwarded_traffic VirtualNetworkPeering#allow_forwarded_traffic}.
     *
     * @stability stable
     */
    readonly allowForwardedTraffic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#allow_gateway_transit VirtualNetworkPeering#allow_gateway_transit}.
     *
     * @stability stable
     */
    readonly allowGatewayTransit?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#allow_virtual_network_access VirtualNetworkPeering#allow_virtual_network_access}.
     *
     * @stability stable
     */
    readonly allowVirtualNetworkAccess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#name VirtualNetworkPeering#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#remote_virtual_network_id VirtualNetworkPeering#remote_virtual_network_id}.
     *
     * @stability stable
     */
    readonly remoteVirtualNetworkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#resource_group_name VirtualNetworkPeering#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#use_remote_gateways VirtualNetworkPeering#use_remote_gateways}.
     *
     * @stability stable
     */
    readonly useRemoteGateways?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#virtual_network_name VirtualNetworkPeering#virtual_network_name}.
     *
     * @stability stable
     */
    readonly virtualNetworkName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#timeouts VirtualNetworkPeering#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualNetworkPeeringTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualNetworkPeeringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#create VirtualNetworkPeering#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#delete VirtualNetworkPeering#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#read VirtualNetworkPeering#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html#update VirtualNetworkPeering#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualNetworkPeeringTimeoutsToTerraform(struct?: VirtualNetworkPeeringTimeoutsOutputReference | VirtualNetworkPeeringTimeouts): any;
/**
 * @stability stable
 */
export declare class VirtualNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualNetworkPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualNetworkPeeringTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html azurerm_virtual_network_peering}.
 *
 * @stability stable
 */
export declare class VirtualNetworkPeering extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_network_peering.html azurerm_virtual_network_peering} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualNetworkPeeringConfig);
    private _allowForwardedTraffic?;
    /**
     * @stability stable
     */
    get allowForwardedTraffic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowForwardedTraffic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowForwardedTraffic(): void;
    /**
     * @stability stable
     */
    get allowForwardedTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _allowGatewayTransit?;
    /**
     * @stability stable
     */
    get allowGatewayTransit(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowGatewayTransit(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowGatewayTransit(): void;
    /**
     * @stability stable
     */
    get allowGatewayTransitInput(): boolean | cdktf.IResolvable | undefined;
    private _allowVirtualNetworkAccess?;
    /**
     * @stability stable
     */
    get allowVirtualNetworkAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowVirtualNetworkAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowVirtualNetworkAccess(): void;
    /**
     * @stability stable
     */
    get allowVirtualNetworkAccessInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _remoteVirtualNetworkId?;
    /**
     * @stability stable
     */
    get remoteVirtualNetworkId(): string;
    /**
     * @stability stable
     */
    set remoteVirtualNetworkId(value: string);
    /**
     * @stability stable
     */
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _useRemoteGateways?;
    /**
     * @stability stable
     */
    get useRemoteGateways(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useRemoteGateways(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseRemoteGateways(): void;
    /**
     * @stability stable
     */
    get useRemoteGatewaysInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualNetworkName?;
    /**
     * @stability stable
     */
    get virtualNetworkName(): string;
    /**
     * @stability stable
     */
    set virtualNetworkName(value: string);
    /**
     * @stability stable
     */
    get virtualNetworkNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualNetworkPeeringTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualNetworkPeeringTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualNetworkPeeringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
