from random import random, choice
from time import sleep

female_double = [
    "雪菡",
    "雅妙",
    "宛霞",
    "姝钰",
    "茜惠",
    "觅蕴",
    "依彤",
    "莉菲",
    "晴茹",
    "雅惠",
    "尔楚",
    "依梅",
    "荷菲",
    "怀盈",
    "楚悦",
    "文芝",
    "梓琪",
    "贝韵",
    "慕巧",
    "楚菱",
    "松芬",
    "琪纯",
    "文芸",
    "若娜",
    "丹华",
    "昕霏",
    "宛晴",
    "松樱",
    "璇兰",
    "纹窈",
    "婉慧",
    "青熙",
    "芷雨",
    "蕴宁",
    "清媛",
    "嘉仪",
    "舒瑾",
    "素卿",
    "媛倚",
    "青波",
    "兰璇",
    "筱羽",
    "枫宁",
    "书琴",
    "依清",
    "怡芬",
    "嘉茵",
    "纹珊",
    "清滢",
    "雁楚",
    "希嫣",
    "夏怡",
    "新菱",
    "芷丽",
    "偌瑾",
    "佳禾",
    "昭美",
    "碧恬",
    "芷蕊",
    "文妮",
]
male_double = [
    "泰骞",
    "旭平",
    "秦齐",
    "良清",
    "明泉",
    "德东",
    "锋玮",
    "昊惟",
    "文峥",
    "杉哲",
    "坤灵",
    "熙岩",
    "泽商",
    "晨纶",
    "秦恒",
    "征风",
    "竽磊",
    "炫灿",
    "承彬",
    "奕宗",
    "浩泽",
    "永茂",
    "万信",
    "畅裕",
    "清深",
    "信霖",
    "圣晨",
    "博罗",
    "泽若",
    "宇军",
    "祯卓",
    "秉雄",
    "君启",
    "庆星",
    "珅南",
    "源泽",
    "灏风",
    "思杉",
    "泽明",
    "舒志",
    "林灏",
    "泽元",
    "浚梓",
    "顺远",
    "铭锵",
    "滨义",
    "茂彦",
    "自昊",
    "承文",
    "云诺",
    "若翰",
    "凯泽",
    "鸣哲",
    "慕鸿",
    "瑞若",
    "皓润",
    "浦宇",
    "嘉和",
    "亦茂",
    "忆狄",
]
male_single = [
    "羽",
    "风",
    "奇",
    "明",
    "轩",
    "辰",
    "磊",
    "振",
    "逸",
    "玮",
    "哲",
    "翰",
    "嘉",
    "友",
    "君",
    "世",
    "柏",
    "靖",
    "晨",
    "涛",
    "俊",
    "彤",
    "洋",
    "瑾",
    "朋",
    "晟",
    "诚",
    "尧",
    "峻",
    "瑞",
    "擎",
    "佑",
    "睿",
    "杰",
    "烨",
    "泽",
    "霖",
    "浩",
    "辉",
    "臣",
    "鸿",
    "祺",
    "越",
    "宇",
    "冠",
    "琪",
    "楠",
    "昊",
    "韵",
    "南",
    "文",
    "皓",
    "桦",
    "彬",
    "旭",
    "宸",
    "达",
    "星",
    "乔",
    "征",
    "鹰",
    "喆",
    "震",
    "劭",
    "澎",
    "颔",
    "真",
    "华",
    "焘",
    "社",
    "圣",
    "谚",
    "森",
    "佳",
    "万",
    "晋",
    "鹏",
    "诤",
    "昭",
    "浦",
    "聚",
    "政",
    "畅",
    "歌",
    "立",
    "韩",
    "益",
    "筠",
    "高",
    "崇",
    "雄",
    "帝",
    "琛",
    "承",
    "频",
    "卿",
    "瀚",
    "锦",
    "鑫",
    "珺",
    "登",
    "聪",
    "亨",
    "迅",
    "超",
    "之",
    "稹",
    "阔",
    "丞",
    "砂",
    "韦",
    "科",
    "基",
    "罡",
    "禅",
    "敬",
    "礼",
    "泉",
    "义",
    "刚",
    "意",
    "钊",
    "易",
    "海",
    "恬",
    "澔",
    "飒",
    "炎",
    "缜",
    "景",
    "佚",
    "钧",
    "河",
    "锐",
    "生",
    "钦",
    "儒",
    "彰",
    "耀",
    "胜",
    "纲",
    "骏",
    "来",
    "亿",
    "沧",
    "珑",
    "康",
    "瀛",
    "奕",
    "毅",
    "谊",
    "全",
    "弛",
    "谦",
    "章",
    "理",
    "凌",
    "驹",
    "镇",
    "颜",
    "军",
    "隆",
    "正",
    "垒",
    "殿",
    "庆",
    "兴",
    "俯",
    "豪",
    "舱",
    "凯",
    "广",
    "励",
    "淇",
    "贵",
    "璟",
    "利",
    "彦",
    "福",
    "谱",
    "钢",
    "梁",
    "襦",
    "臻",
    "善",
    "朕",
    "波",
    "光",
    "合",
    "升",
    "国",
    "照",
    "竣",
    "昶",
    "博",
    "强",
    "远",
    "矾",
    "争",
    "烁",
    "川",
    "杉",
    "均",
    "韶",
    "漾",
    "云",
    "澈",
    "单",
    "柒",
    "铸",
    "智",
    "苗",
    "言",
    "旖",
    "晗",
    "晏",
    "杭",
    "济",
    "若",
    "渝",
    "翊",
    "浣",
    "钟",
    "昱",
    "元",
    "岑",
    "铠",
    "寒",
    "衍",
    "坤",
    "昌",
    "瑎",
    "璥",
    "溯",
    "泮",
    "澜",
    "青",
    "浪",
    "茂",
    "初",
    "存",
    "拾",
    "烊",
    "攸",
    "李",
    "贯",
    "燏",
    "晞",
    "峰",
    "志",
    "禛",
    "永",
    "致",
    "旷",
    "咏",
    "中",
    "昂",
    "律",
    "业",
    "忠",
    "桓",
    "林",
    "群",
    "有",
    "宣",
    "蔚",
    "旲",
    "东",
    "州",
    "清",
    "宏",
    "轼",
    "腾",
    "仑",
    "士",
    "颁",
    "略",
    "伟",
    "充",
    "敖",
    "齐",
    "诗",
    "琦",
    "行",
    "亭",
    "洲",
    "庭",
    "马",
    "濮",
    "骢",
    "影",
    "韬",
    "函",
    "克",
    "盛",
    "衡",
    "至",
    "涵",
    "伦",
    "时",
    "映",
    "霆",
    "希",
    "雨",
    "冰",
    "蒙",
    "密",
    "溪",
    "泰",
    "子",
    "辈",
    "冕",
    "帅",
    "淼",
    "曦",
    "语",
    "才",
    "凰",
    "蓝",
    "示",
    "书",
    "卫",
    "魏",
    "武",
    "乐",
    "邦",
    "迈",
    "平",
    "乾",
    "榜",
    "宝",
    "昴",
    "树",
    "材",
    "纪",
    "保",
    "棋",
    "竹",
    "葆",
    "劻",
    "玫",
    "瑜",
    "卓",
    "掣",
    "奎",
    "船",
    "阳",
    "濯",
    "驾",
    "和",
    "航",
    "含",
    "蒲",
    "乒",
    "虚",
]
female_single = [
    "傲",
    "芃",
    "芷",
    "暄",
    "烷",
    "群",
    "杭",
    "秀",
    "贺",
    "卿",
    "旋",
    "雪",
    "漫",
    "蓓",
    "娥",
    "煊",
    "维",
    "涟",
    "钰",
    "弦",
    "蒨",
    "路",
    "逸",
    "智",
    "昊",
    "雅",
    "萱",
    "婷",
    "文",
    "鹤",
    "莉",
    "人",
    "楚",
    "华",
    "惜",
    "洲",
    "瑞",
    "瑜",
    "正",
    "蔚",
    "觅",
    "安",
    "菱",
    "婉",
    "熙",
    "亭",
    "惠",
    "风",
    "茜",
    "月",
    "驰",
    "玮",
    "冉",
    "槽",
    "苑",
    "连",
    "木",
    "卷",
    "潼",
    "越",
    "妍",
    "振",
    "德",
    "籁",
    "芫",
    "兰",
    "萌",
    "易",
    "雁",
    "珞",
    "龙",
    "玲",
    "扬",
    "伊",
    "旭",
    "光",
    "镱",
    "虞",
    "伟",
    "哲",
    "宸",
    "奇",
    "榆",
    "肖",
    "菡",
    "媛",
    "萁",
    "会",
    "晋",
    "枝",
    "葵",
    "荷",
    "颖",
    "桑",
    "优",
    "帆",
    "曼",
    "醉",
    "娇",
    "春",
    "书",
    "林",
    "任",
    "裳",
    "兔",
    "欢",
    "枫",
    "卉",
    "英",
    "雯",
    "阳",
    "槐",
    "佑",
    "梨",
    "楠",
    "辰",
    "芊",
    "翔",
    "普",
    "绮",
    "霞",
    "巧",
    "紫",
    "晴",
    "梅",
    "鸣",
    "花",
    "洁",
    "自",
    "桃",
    "宛",
    "涵",
    "超",
    "依",
    "蓉",
    "霜",
    "卓",
    "冰",
    "妮",
    "嘉",
    "亦",
    "夏",
    "迎",
    "睿",
    "虹",
    "南",
    "豆",
    "凤",
    "琦",
    "恬",
    "昕",
    "秋",
    "曦",
    "馨",
    "柔",
    "荣",
    "影",
    "琪",
    "柳",
    "茵",
    "莲",
    "黛",
    "丝",
    "嫦",
    "尔",
    "谷",
    "筠",
    "灵",
    "碧",
    "蝶",
    "薇",
    "瑾",
    "君",
    "叶",
    "欣",
    "铃",
    "柏",
    "儿",
    "莺",
    "绿",
    "婵",
    "嫣",
    "菊",
    "盼",
    "皎",
    "寻",
    "凉",
    "琼",
    "倚",
    "娟",
    "萍",
    "红",
    "甜",
    "蕾",
    "玫",
    "沛",
    "笛",
    "凌",
    "听",
    "语",
    "新",
    "珠",
    "艺",
    "怜",
    "蓝",
    "痴",
    "丹",
    "煜",
    "笑",
    "思",
    "馥",
    "羽",
    "纹",
    "问",
    "幽",
    "娜",
    "浩",
    "霎",
    "琴",
    "双",
    "怡",
    "映",
    "素",
    "爽",
    "岚",
    "忆",
    "芸",
    "樱",
    "烟",
    "丽",
    "瑶",
    "蕊",
    "慧",
    "念",
    "怀",
    "初",
    "雨",
    "缦",
    "艳",
    "松",
    "茹",
    "靖",
    "芹",
    "珍",
    "趣",
    "沁",
    "令",
    "霄",
    "彤",
    "可",
    "佩",
    "若",
    "玉",
    "彦",
    "歆",
    "韵",
    "翠",
    "瑛",
    "舞",
    "悠",
    "彩",
    "泽",
    "万",
    "冬",
    "芳",
    "菲",
    "乐",
    "彨",
    "诗",
    "颜",
    "姝",
    "鸥",
    "希",
    "露",
    "奕",
    "苒",
    "晓",
    "娴",
    "源",
    "容",
    "颢",
    "静",
    "琳",
    "鸾",
    "溪",
    "贻",
    "筱",
    "芝",
    "梓",
    "潇",
    "娅",
    "宇",
    "然",
    "懿",
    "洛",
    "璟",
    "晨",
    "璇",
    "允",
    "煦",
    "珊",
    "灿",
    "烨",
    "诺",
    "玥",
    "悦",
    "峥",
    "蕴",
    "琬",
    "珚",
    "琰",
    "珂",
    "仪",
    "赫",
    "爱",
    "音",
    "海",
    "漪",
    "滟",
    "瑷",
    "淑",
    "绣",
    "童",
    "采",
    "藐",
    "杏",
    "敏",
    "好",
    "俏",
    "堇",
    "媱",
    "燕",
    "偀",
    "琶",
    "棉",
    "莓",
    "哓",
    "家",
    "银",
    "梦",
    "芥",
    "荫",
    "焓",
    "晗",
    "芯",
    "鹃",
    "璐",
    "飘",
    "娣",
    "倩",
    "真",
    "昭",
    "茗",
    "妹",
    "菁",
    "香",
    "园",
    "环",
    "锦",
    "融",
    "云",
    "莎",
    "咏",
    "璧",
    "滢",
    "眉",
    "澜",
    "纯",
    "凡",
    "聪",
    "晶",
    "育",
    "纨",
    "桂",
    "瑗",
    "毓",
    "贞",
    "佳",
    "芬",
    "宁",
    "青",
    "姣",
    "勤",
    "婕",
    "美",
]
com_surname = [
    "万俟",
    "司马",
    "上官",
    "欧阳",
    "夏侯",
    "诸葛",
    "闻人",
    "东方",
    "赫连",
    "皇甫",
    "尉迟",
    "公羊",
    "澹台",
    "公冶",
    "宗政",
    "濮阳",
    "淳于",
    "单于",
    "太叔",
    "申屠",
    "公孙",
    "仲孙",
    "轩辕",
    "令狐",
    "钟离",
    "宇文",
    "长孙",
    "慕容",
    "鲜于",
    "闾丘",
    "司徒",
    "司空",
    "亓官",
    "司寇",
    "仉督",
    "颛孙",
    "端木",
    "巫马",
    "公西",
    "漆雕",
    "乐正",
    "壤驷",
    "公良",
    "拓跋",
    "夹谷",
    "宰父",
    "谷梁",
    "段干",
    "百里",
    "东郭",
    "南门",
    "呼延",
    "羊舌",
    "微生",
    "梁丘",
    "左丘",
    "东门",
    "西门",
    "南宫",
]

surname = {
    "李": 9200,
    "王": 9000,
    "张": 8500,
    "刘": 6700,
    "陈": 5800,
    "杨": 4000,
    "黄": 3100,
    "孙": 2600,
    "周": 2500,
    "吴": 2400,
    "徐": 1900,
    "赵": 1800,
    "朱": 1500,
    "马": 1500,
    "胡": 1400,
    "郭": 1400,
    "林": 1300,
    "何": 1300,
    "高": 1200,
    "梁": 1100,
    "郑": 1100,
    "罗": 1000,
    "宋": 900,
    "谢": 900,
    "唐": 780,
    "韩": 760,
    "曹": 730,
    "许": 730,
    "邓": 730,
    "萧": 730,
    "冯": 700,
    "曾": 680,
    "程": 660,
    "蔡": 650,
    "彭": 640,
    "潘": 620,
    "袁": 620,
    "于": 600,
    "董": 590,
    "余": 580,
    "苏": 580,
    "叶": 580,
    "吕": 570,
    "魏": 570,
    "蒋": 540,
    "田": 520,
    "杜": 520,
    "丁": 470,
    "沈": 470,
    "姜": 460,
    "范": 460,
    "江": 450,
    "傅": 450,
    "锺": 440,
    "卢": 440,
    "汪": 430,
    "戴": 430,
    "崔": 420,
    "任": 420,
    "陆": 420,
    "廖": 420,
    "姚": 410,
    "方": 410,
    "金": 380,
    "丘": 380,
    "夏": 370,
    "谭": 370,
    "韦": 370,
    "贾": 370,
    "邹": 360,
    "石": 360,
    "熊": 360,
    "孟": 330,
    "秦": 320,
    "阎": 310,
    "薛": 310,
    "侯": 300,
    "雷": 300,
    "白": 280,
    "龙": 280,
    "段": 270,
    "郝": 270,
    "孔": 270,
    "邵": 270,
    "史": 250,
    "毛": 250,
    "常": 240,
    "万": 240,
    "顾": 230,
    "赖": 230,
    "武": 220,
    "康": 220,
    "贺": 220,
    "严": 220,
    "尹": 220,
    "钱": 220,
    "施": 210,
    "牛": 200,
    "洪": 200,
    "龚": 200,
    "汤": 200,
    "陶": 200,
    "黎": 200,
    "温": 190,
    "莫": 190,
    "易": 170,
    "樊": 170,
    "乔": 170,
    "文": 170,
    "安": 170,
    "殷": 170,
    "颜": 170,
    "庄": 160,
    "章": 150,
    "鲁": 150,
    "倪": 140,
    "庞": 140,
    "邢": 140,
    "俞": 140,
    "翟": 140,
    "蓝": 140,
    "聂": 140,
    "齐": 140,
    "向": 140,
    "申": 140,
    "葛": 140,
    "柴": 135,
    "伍": 130,
    "覃": 130,
    "骆": 118,
    "关": 117,
    "焦": 115,
    "柳": 114,
    "欧": 113,
    "祝": 111,
    "纪": 110,
    "尚": 102,
    "毕": 99,
    "耿": 99,
    "芦": 98,
    "左": 97,
    "季": 96,
    "管": 95,
    "符": 94,
    "辛": 90,
    "苗": 89,
    "詹": 89,
    "曲": 88,
    "阳": 49,
    "靳": 88,
    "祁": 86,
    "路": 85,
    "涂": 85,
    "兰": 84,
    "甘": 84,
    "裴": 83,
    "梅": 83,
    "童": 83,
    "翁": 82,
    "霍": 81,
    "游": 81,
    "阮": 81,
    "尤": 80,
    "舒": 80,
    "柯": 80,
    "牟": 80,
    "滕": 78,
    "谷": 75,
    "岳": 72,
    "卜": 72,
    "成": 72,
    "饶": 72,
    "甯": 71,
    "凌": 71,
    "盛": 70,
    "查": 68,
    "单": 68,
    "冉": 67,
    "鲍": 67,
    "华": 67,
    "包": 65,
    "屈": 62,
    "房": 60,
    "喻": 58,
    "解": 55,
    "蒲": 55,
    "卫": 55,
    "简": 55,
    "时": 54,
    "连": 54,
    "车": 54,
    "项": 53,
    "闵": 52,
    "邬": 52,
    "吉": 49,
    "党": 49,
    "司": 48,
    "费": 47,
    "蒙": 47,
    "席": 47,
    "晏": 47,
    "隋": 46,
    "古": 46,
    "强": 46,
    "穆": 45,
    "姬": 44,
    "宫": 44,
    "景": 44,
    "米": 43,
    "麦": 42,
    "谈": 41,
    "柏": 41,
    "瞿": 40,
    "艾": 40,
    "沙": 40,
    "鄢": 39,
    "桂": 39,
    "窦": 38,
    "郁": 38,
    "缪": 38,
    "畅": 37,
    "巩": 37,
    "卓": 36,
    "褚": 36,
    "栾": 36,
    "戚": 36,
    "全": 36,
    "娄": 35,
    "甄": 35,
    "郎": 34,
    "池": 34,
    "丛": 34,
    "边": 34,
    "岑": 34,
    "农": 33,
    "苟": 33,
    "迟": 33,
    "保": 33,
    "商": 32,
    "臧": 31,
    "佘": 31,
    "卞": 31,
    "虞": 31,
    "刁": 30,
    "冷": 30,
    "应": 30,
    "匡": 30,
    "栗": 30,
    "仇": 29,
    "练": 29,
    "楚": 28,
    "揭": 28,
    "师": 28,
    "官": 28,
    "佟": 28,
    "封": 27,
    "燕": 26,
    "桑": 26,
    "巫": 25,
    "敖": 25,
    "原": 25,
    "植": 24,
    "邝": 24,
    "仲": 23,
    "荆": 23,
    "储": 23,
    "宗": 22,
    "楼": 22,
    "干": 22,
    "苑": 22,
    "寇": 21,
    "盖": 20,
    "南": 20,
    "屠": 20,
    "鞠": 20,
    "荣": 20,
    "井": 19,
    "乐": 19,
    "银": 19,
    "奚": 19,
    "明": 19,
    "麻": 19,
    "雍": 18,
    "花": 18,
    "闻": 17,
    "冼": 17,
    "木": 17,
    "郜": 17,
    "廉": 16,
    "衣": 16,
    "蔺": 16,
    "和": 16,
    "冀": 16,
    "占": 16,
    "公": 15,
    "门": 15,
    "帅": 15,
    "利": 15,
    "满": 14,
}


def rand_surname(com_rate=0.001):
    if random() < com_rate:
        return choice(com_surname)
    else:
        dice = int(random() * 117034)
        for i in surname.keys():
            dice -= surname[i]
            if dice <= 0:
                return i


def mingzi(volume=1, female_rate=0.5, single_rate=0.5, com_rate=0.001, show_gender=True, alt_surname=[]):
    data = []
    for i in range(volume):
        if alt_surname == []:
            surname = rand_surname(com_rate=com_rate)
        else:
            surname = choice(alt_surname)

        length = random() < single_rate
        gender = random() >= female_rate

        if gender:
            if length:
                name = surname + choice(male_single)
            else:
                name = surname + choice(male_double)
        else:
            if length:
                name = surname + choice(female_single)
            else:
                name = surname + choice(female_double)

        if show_gender:
            data.append([name, ["女", "男"][gender]])
        else:
            data.append(name)

    return data
