# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LicenseRecordArgs', 'LicenseRecord']

@pulumi.input_type
class LicenseRecordArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 is_perpetual: pulumi.Input[bool],
                 is_unlimited: pulumi.Input[bool],
                 product_license_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 license_count: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 support_end_date: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LicenseRecord resource.
        :param pulumi.Input[str] display_name: (Updatable) License record name.
        :param pulumi.Input[bool] is_perpetual: (Updatable) Specifies if the license record term is perpertual.
        :param pulumi.Input[bool] is_unlimited: (Updatable) Specifies if the license count is unlimited.
        :param pulumi.Input[str] product_license_id: Unique product license identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] expiration_date: (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] license_count: (Updatable) The number of license units added by a user in a license record. Default 1
        :param pulumi.Input[str] product_id: (Updatable) The license record product ID.
        :param pulumi.Input[str] support_end_date: (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_perpetual", is_perpetual)
        pulumi.set(__self__, "is_unlimited", is_unlimited)
        pulumi.set(__self__, "product_license_id", product_license_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if license_count is not None:
            pulumi.set(__self__, "license_count", license_count)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if support_end_date is not None:
            pulumi.set(__self__, "support_end_date", support_end_date)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) License record name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isPerpetual")
    def is_perpetual(self) -> pulumi.Input[bool]:
        """
        (Updatable) Specifies if the license record term is perpertual.
        """
        return pulumi.get(self, "is_perpetual")

    @is_perpetual.setter
    def is_perpetual(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_perpetual", value)

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> pulumi.Input[bool]:
        """
        (Updatable) Specifies if the license count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @is_unlimited.setter
    def is_unlimited(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_unlimited", value)

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> pulumi.Input[str]:
        """
        Unique product license identifier.
        """
        return pulumi.get(self, "product_license_id")

    @product_license_id.setter
    def product_license_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "product_license_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of license units added by a user in a license record. Default 1
        """
        return pulumi.get(self, "license_count")

    @license_count.setter
    def license_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "license_count", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="supportEndDate")
    def support_end_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "support_end_date")

    @support_end_date.setter
    def support_end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_end_date", value)


@pulumi.input_type
class _LicenseRecordState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_perpetual: Optional[pulumi.Input[bool]] = None,
                 is_unlimited: Optional[pulumi.Input[bool]] = None,
                 license_count: Optional[pulumi.Input[int]] = None,
                 license_unit: Optional[pulumi.Input[str]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_license: Optional[pulumi.Input[str]] = None,
                 product_license_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 support_end_date: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LicenseRecord resources.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) License record name.
        :param pulumi.Input[str] expiration_date: (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_perpetual: (Updatable) Specifies if the license record term is perpertual.
        :param pulumi.Input[bool] is_unlimited: (Updatable) Specifies if the license count is unlimited.
        :param pulumi.Input[int] license_count: (Updatable) The number of license units added by a user in a license record. Default 1
        :param pulumi.Input[str] license_unit: The product license unit.
        :param pulumi.Input[str] product_id: (Updatable) The license record product ID.
        :param pulumi.Input[str] product_license: The product license name with which the license record is associated.
        :param pulumi.Input[str] product_license_id: Unique product license identifier.
        :param pulumi.Input[str] state: The current license record state.
        :param pulumi.Input[str] support_end_date: (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_perpetual is not None:
            pulumi.set(__self__, "is_perpetual", is_perpetual)
        if is_unlimited is not None:
            pulumi.set(__self__, "is_unlimited", is_unlimited)
        if license_count is not None:
            pulumi.set(__self__, "license_count", license_count)
        if license_unit is not None:
            pulumi.set(__self__, "license_unit", license_unit)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if product_license is not None:
            pulumi.set(__self__, "product_license", product_license)
        if product_license_id is not None:
            pulumi.set(__self__, "product_license_id", product_license_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if support_end_date is not None:
            pulumi.set(__self__, "support_end_date", support_end_date)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) License record name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isPerpetual")
    def is_perpetual(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies if the license record term is perpertual.
        """
        return pulumi.get(self, "is_perpetual")

    @is_perpetual.setter
    def is_perpetual(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_perpetual", value)

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Specifies if the license count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @is_unlimited.setter
    def is_unlimited(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_unlimited", value)

    @property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of license units added by a user in a license record. Default 1
        """
        return pulumi.get(self, "license_count")

    @license_count.setter
    def license_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "license_count", value)

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @license_unit.setter
    def license_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_unit", value)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record product ID.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="productLicense")
    def product_license(self) -> Optional[pulumi.Input[str]]:
        """
        The product license name with which the license record is associated.
        """
        return pulumi.get(self, "product_license")

    @product_license.setter
    def product_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_license", value)

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique product license identifier.
        """
        return pulumi.get(self, "product_license_id")

    @product_license_id.setter
    def product_license_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "product_license_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current license record state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="supportEndDate")
    def support_end_date(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "support_end_date")

    @support_end_date.setter
    def support_end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_end_date", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class LicenseRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_perpetual: Optional[pulumi.Input[bool]] = None,
                 is_unlimited: Optional[pulumi.Input[bool]] = None,
                 license_count: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_license_id: Optional[pulumi.Input[str]] = None,
                 support_end_date: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the License Record resource in Oracle Cloud Infrastructure License Manager service.

        Creates a new license record for the given product license ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_license_record = oci.license_manager.LicenseRecord("test_license_record",
            display_name=license_record_display_name,
            is_perpetual=license_record_is_perpetual,
            is_unlimited=license_record_is_unlimited,
            product_license_id=test_product_license["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            expiration_date=license_record_expiration_date,
            freeform_tags={
                "bar-key": "value",
            },
            license_count=license_record_license_count,
            product_id=test_product["id"],
            support_end_date=license_record_support_end_date)
        ```

        ## Import

        LicenseRecords can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LicenseManager/licenseRecord:LicenseRecord test_license_record "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) License record name.
        :param pulumi.Input[str] expiration_date: (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_perpetual: (Updatable) Specifies if the license record term is perpertual.
        :param pulumi.Input[bool] is_unlimited: (Updatable) Specifies if the license count is unlimited.
        :param pulumi.Input[int] license_count: (Updatable) The number of license units added by a user in a license record. Default 1
        :param pulumi.Input[str] product_id: (Updatable) The license record product ID.
        :param pulumi.Input[str] product_license_id: Unique product license identifier.
        :param pulumi.Input[str] support_end_date: (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicenseRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the License Record resource in Oracle Cloud Infrastructure License Manager service.

        Creates a new license record for the given product license ID.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_license_record = oci.license_manager.LicenseRecord("test_license_record",
            display_name=license_record_display_name,
            is_perpetual=license_record_is_perpetual,
            is_unlimited=license_record_is_unlimited,
            product_license_id=test_product_license["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            expiration_date=license_record_expiration_date,
            freeform_tags={
                "bar-key": "value",
            },
            license_count=license_record_license_count,
            product_id=test_product["id"],
            support_end_date=license_record_support_end_date)
        ```

        ## Import

        LicenseRecords can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LicenseManager/licenseRecord:LicenseRecord test_license_record "id"
        ```

        :param str resource_name: The name of the resource.
        :param LicenseRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicenseRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_perpetual: Optional[pulumi.Input[bool]] = None,
                 is_unlimited: Optional[pulumi.Input[bool]] = None,
                 license_count: Optional[pulumi.Input[int]] = None,
                 product_id: Optional[pulumi.Input[str]] = None,
                 product_license_id: Optional[pulumi.Input[str]] = None,
                 support_end_date: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicenseRecordArgs.__new__(LicenseRecordArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["expiration_date"] = expiration_date
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_perpetual is None and not opts.urn:
                raise TypeError("Missing required property 'is_perpetual'")
            __props__.__dict__["is_perpetual"] = is_perpetual
            if is_unlimited is None and not opts.urn:
                raise TypeError("Missing required property 'is_unlimited'")
            __props__.__dict__["is_unlimited"] = is_unlimited
            __props__.__dict__["license_count"] = license_count
            __props__.__dict__["product_id"] = product_id
            if product_license_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_license_id'")
            __props__.__dict__["product_license_id"] = product_license_id
            __props__.__dict__["support_end_date"] = support_end_date
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["license_unit"] = None
            __props__.__dict__["product_license"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(LicenseRecord, __self__).__init__(
            'oci:LicenseManager/licenseRecord:LicenseRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            expiration_date: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_perpetual: Optional[pulumi.Input[bool]] = None,
            is_unlimited: Optional[pulumi.Input[bool]] = None,
            license_count: Optional[pulumi.Input[int]] = None,
            license_unit: Optional[pulumi.Input[str]] = None,
            product_id: Optional[pulumi.Input[str]] = None,
            product_license: Optional[pulumi.Input[str]] = None,
            product_license_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            support_end_date: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'LicenseRecord':
        """
        Get an existing LicenseRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) License record name.
        :param pulumi.Input[str] expiration_date: (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_perpetual: (Updatable) Specifies if the license record term is perpertual.
        :param pulumi.Input[bool] is_unlimited: (Updatable) Specifies if the license count is unlimited.
        :param pulumi.Input[int] license_count: (Updatable) The number of license units added by a user in a license record. Default 1
        :param pulumi.Input[str] license_unit: The product license unit.
        :param pulumi.Input[str] product_id: (Updatable) The license record product ID.
        :param pulumi.Input[str] product_license: The product license name with which the license record is associated.
        :param pulumi.Input[str] product_license_id: Unique product license identifier.
        :param pulumi.Input[str] state: The current license record state.
        :param pulumi.Input[str] support_end_date: (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[str] time_updated: The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicenseRecordState.__new__(_LicenseRecordState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_perpetual"] = is_perpetual
        __props__.__dict__["is_unlimited"] = is_unlimited
        __props__.__dict__["license_count"] = license_count
        __props__.__dict__["license_unit"] = license_unit
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["product_license"] = product_license
        __props__.__dict__["product_license_id"] = product_license_id
        __props__.__dict__["state"] = state
        __props__.__dict__["support_end_date"] = support_end_date
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return LicenseRecord(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where the license record is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) License record name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[str]:
        """
        (Updatable) The license record end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12`
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPerpetual")
    def is_perpetual(self) -> pulumi.Output[bool]:
        """
        (Updatable) Specifies if the license record term is perpertual.
        """
        return pulumi.get(self, "is_perpetual")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> pulumi.Output[bool]:
        """
        (Updatable) Specifies if the license count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="licenseCount")
    def license_count(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of license units added by a user in a license record. Default 1
        """
        return pulumi.get(self, "license_count")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> pulumi.Output[str]:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The license record product ID.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productLicense")
    def product_license(self) -> pulumi.Output[str]:
        """
        The product license name with which the license record is associated.
        """
        return pulumi.get(self, "product_license")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> pulumi.Output[str]:
        """
        Unique product license identifier.
        """
        return pulumi.get(self, "product_license_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current license record state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportEndDate")
    def support_end_date(self) -> pulumi.Output[str]:
        """
        (Updatable) The license record support end date in [RFC 3339](https://tools.ietf.org/html/rfc3339) date format. Example: `2018-09-12` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "support_end_date")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the license record was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the license record was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

