# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate_data=None, certificate_id=None, compartment_id=None, defined_tags=None, display_name=None, extensions=None, freeform_tags=None, id=None, is_trust_verification_disabled=None, issued_by=None, issuer_names=None, private_key_data=None, public_key_infos=None, serial_number=None, signature_algorithm=None, state=None, subject_names=None, time_created=None, time_not_valid_after=None, time_not_valid_before=None, version=None):
        if certificate_data and not isinstance(certificate_data, str):
            raise TypeError("Expected argument 'certificate_data' to be a str")
        pulumi.set(__self__, "certificate_data", certificate_data)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if extensions and not isinstance(extensions, list):
            raise TypeError("Expected argument 'extensions' to be a list")
        pulumi.set(__self__, "extensions", extensions)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_trust_verification_disabled and not isinstance(is_trust_verification_disabled, bool):
            raise TypeError("Expected argument 'is_trust_verification_disabled' to be a bool")
        pulumi.set(__self__, "is_trust_verification_disabled", is_trust_verification_disabled)
        if issued_by and not isinstance(issued_by, str):
            raise TypeError("Expected argument 'issued_by' to be a str")
        pulumi.set(__self__, "issued_by", issued_by)
        if issuer_names and not isinstance(issuer_names, list):
            raise TypeError("Expected argument 'issuer_names' to be a list")
        pulumi.set(__self__, "issuer_names", issuer_names)
        if private_key_data and not isinstance(private_key_data, str):
            raise TypeError("Expected argument 'private_key_data' to be a str")
        pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_infos and not isinstance(public_key_infos, list):
            raise TypeError("Expected argument 'public_key_infos' to be a list")
        pulumi.set(__self__, "public_key_infos", public_key_infos)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if signature_algorithm and not isinstance(signature_algorithm, str):
            raise TypeError("Expected argument 'signature_algorithm' to be a str")
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subject_names and not isinstance(subject_names, list):
            raise TypeError("Expected argument 'subject_names' to be a list")
        pulumi.set(__self__, "subject_names", subject_names)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_not_valid_after and not isinstance(time_not_valid_after, str):
            raise TypeError("Expected argument 'time_not_valid_after' to be a str")
        pulumi.set(__self__, "time_not_valid_after", time_not_valid_after)
        if time_not_valid_before and not isinstance(time_not_valid_before, str):
            raise TypeError("Expected argument 'time_not_valid_before' to be a str")
        pulumi.set(__self__, "time_not_valid_before", time_not_valid_before)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> str:
        """
        The data of the SSL certificate.
        """
        return pulumi.get(self, "certificate_data")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SSL certificate's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name of the SSL certificate.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def extensions(self) -> Sequence['outputs.GetCertificateExtensionResult']:
        """
        Additional attributes associated with users or public keys for managing relationships between Certificate Authorities.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SSL certificate.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isTrustVerificationDisabled")
    def is_trust_verification_disabled(self) -> bool:
        """
        This indicates whether trust verification was disabled during the creation of SSL certificate. If `true` SSL certificate trust verification was disabled and this SSL certificate is most likely self-signed.
        """
        return pulumi.get(self, "is_trust_verification_disabled")

    @property
    @pulumi.getter(name="issuedBy")
    def issued_by(self) -> str:
        return pulumi.get(self, "issued_by")

    @property
    @pulumi.getter(name="issuerNames")
    def issuer_names(self) -> Sequence['outputs.GetCertificateIssuerNameResult']:
        """
        The issuer of the certificate.
        """
        return pulumi.get(self, "issuer_names")

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> str:
        return pulumi.get(self, "private_key_data")

    @property
    @pulumi.getter(name="publicKeyInfos")
    def public_key_infos(self) -> Sequence['outputs.GetCertificatePublicKeyInfoResult']:
        """
        Information about the public key and the algorithm used by the public key.
        """
        return pulumi.get(self, "public_key_infos")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        A unique, positive integer assigned by the Certificate Authority (CA). The issuer name and serial number identify a unique certificate.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        """
        The identifier for the cryptographic algorithm used by the Certificate Authority (CA) to sign this certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the SSL certificate.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subjectNames")
    def subject_names(self) -> Sequence['outputs.GetCertificateSubjectNameResult']:
        """
        The entity to be secured by the certificate.
        """
        return pulumi.get(self, "subject_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the certificate was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeNotValidAfter")
    def time_not_valid_after(self) -> str:
        """
        The date and time the certificate will expire, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_after")

    @property
    @pulumi.getter(name="timeNotValidBefore")
    def time_not_valid_before(self) -> str:
        """
        The date and time the certificate will become valid, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_not_valid_before")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the encoded certificate.
        """
        return pulumi.get(self, "version")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_data=self.certificate_data,
            certificate_id=self.certificate_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            extensions=self.extensions,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_trust_verification_disabled=self.is_trust_verification_disabled,
            issued_by=self.issued_by,
            issuer_names=self.issuer_names,
            private_key_data=self.private_key_data,
            public_key_infos=self.public_key_infos,
            serial_number=self.serial_number,
            signature_algorithm=self.signature_algorithm,
            state=self.state,
            subject_names=self.subject_names,
            time_created=self.time_created,
            time_not_valid_after=self.time_not_valid_after,
            time_not_valid_before=self.time_not_valid_before,
            version=self.version)


def get_certificate(certificate_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of an SSL certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.Waas.get_certificate(certificate_id=test_certificate_oci_waas_certificate["id"])
    ```


    :param str certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SSL certificate used in the WAAS policy. This number is generated when the certificate is added to the policy.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_data=pulumi.get(__ret__, 'certificate_data'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        extensions=pulumi.get(__ret__, 'extensions'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_trust_verification_disabled=pulumi.get(__ret__, 'is_trust_verification_disabled'),
        issued_by=pulumi.get(__ret__, 'issued_by'),
        issuer_names=pulumi.get(__ret__, 'issuer_names'),
        private_key_data=pulumi.get(__ret__, 'private_key_data'),
        public_key_infos=pulumi.get(__ret__, 'public_key_infos'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        signature_algorithm=pulumi.get(__ret__, 'signature_algorithm'),
        state=pulumi.get(__ret__, 'state'),
        subject_names=pulumi.get(__ret__, 'subject_names'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_not_valid_after=pulumi.get(__ret__, 'time_not_valid_after'),
        time_not_valid_before=pulumi.get(__ret__, 'time_not_valid_before'),
        version=pulumi.get(__ret__, 'version'))
def get_certificate_output(certificate_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of an SSL certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.Waas.get_certificate(certificate_id=test_certificate_oci_waas_certificate["id"])
    ```


    :param str certificate_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SSL certificate used in the WAAS policy. This number is generated when the certificate is added to the policy.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Waas/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        certificate_data=pulumi.get(__response__, 'certificate_data'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        extensions=pulumi.get(__response__, 'extensions'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_trust_verification_disabled=pulumi.get(__response__, 'is_trust_verification_disabled'),
        issued_by=pulumi.get(__response__, 'issued_by'),
        issuer_names=pulumi.get(__response__, 'issuer_names'),
        private_key_data=pulumi.get(__response__, 'private_key_data'),
        public_key_infos=pulumi.get(__response__, 'public_key_infos'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        signature_algorithm=pulumi.get(__response__, 'signature_algorithm'),
        state=pulumi.get(__response__, 'state'),
        subject_names=pulumi.get(__response__, 'subject_names'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_not_valid_after=pulumi.get(__response__, 'time_not_valid_after'),
        time_not_valid_before=pulumi.get(__response__, 'time_not_valid_before'),
        version=pulumi.get(__response__, 'version')))
