# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopUtilizedProductLicensesResult',
    'AwaitableGetTopUtilizedProductLicensesResult',
    'get_top_utilized_product_licenses',
    'get_top_utilized_product_licenses_output',
]

@pulumi.output_type
class GetTopUtilizedProductLicensesResult:
    """
    A collection of values returned by getTopUtilizedProductLicenses.
    """
    def __init__(__self__, compartment_id=None, id=None, is_compartment_id_in_subtree=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetTopUtilizedProductLicensesItemResult']:
        """
        Collection of top utilized product licenses.
        """
        return pulumi.get(self, "items")


class AwaitableGetTopUtilizedProductLicensesResult(GetTopUtilizedProductLicensesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopUtilizedProductLicensesResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            items=self.items)


def get_top_utilized_product_licenses(compartment_id: Optional[str] = None,
                                      is_compartment_id_in_subtree: Optional[bool] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopUtilizedProductLicensesResult:
    """
    This data source provides the list of Top Utilized Product Licenses in Oracle Cloud Infrastructure License Manager service.

    Retrieves the top utilized product licenses for a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_top_utilized_product_licenses = oci.LicenseManager.get_top_utilized_product_licenses(compartment_id=compartment_id,
        is_compartment_id_in_subtree=top_utilized_product_license_is_compartment_id_in_subtree)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getTopUtilizedProductLicenses:getTopUtilizedProductLicenses', __args__, opts=opts, typ=GetTopUtilizedProductLicensesResult).value

    return AwaitableGetTopUtilizedProductLicensesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__ret__, 'items'))
def get_top_utilized_product_licenses_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                             is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopUtilizedProductLicensesResult]:
    """
    This data source provides the list of Top Utilized Product Licenses in Oracle Cloud Infrastructure License Manager service.

    Retrieves the top utilized product licenses for a given compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_top_utilized_product_licenses = oci.LicenseManager.get_top_utilized_product_licenses(compartment_id=compartment_id,
        is_compartment_id_in_subtree=top_utilized_product_license_is_compartment_id_in_subtree)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LicenseManager/getTopUtilizedProductLicenses:getTopUtilizedProductLicenses', __args__, opts=opts, typ=GetTopUtilizedProductLicensesResult)
    return __ret__.apply(lambda __response__: GetTopUtilizedProductLicensesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__response__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__response__, 'items')))
