"""Add data capacity

Revision ID: 0b3a8e2ca9c1
Revises: a19721f73cfb
Create Date: 2025-03-17 11:53:34.527465

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "0b3a8e2ca9c1"
down_revision = "a19721f73cfb"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "experiment_records",
        sa.Column("id", mysql.BIGINT(unsigned=True), nullable=False),
        sa.Column("workspace_id", mysql.BIGINT(unsigned=True), nullable=False),
        sa.Column("uid", sa.String(length=100), nullable=False),
        sa.Column(
            "data_usage",
            mysql.BIGINT(unsigned=True),
            server_default="0",
            nullable=False,
            comment="data usage in bytes",
        ),
        sa.Column(
            "created_at",
            sa.DateTime(),
            server_default=sa.text("CURRENT_TIMESTAMP"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(),
            server_default=sa.text("CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["workspace_id"],
            ["workspaces.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_experiment_records_uid"), "experiment_records", ["uid"], unique=False
    )
    op.add_column(
        "workspaces",
        sa.Column(
            "input_data_usage",
            mysql.BIGINT(unsigned=True),
            nullable=False,
            comment="data usage in bytes",
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("workspaces", "input_data_usage")
    op.drop_index(op.f("ix_experiment_records_uid"), table_name="experiment_records")
    op.drop_table("experiment_records")
    # ### end Alembic commands ###
