"""This is a wrapper module for Aspose.Imaging .NET assembly"""

from typing import Any

def get_pyinstaller_hook_dirs() -> Any:
  """Function required by PyInstaller. Returns paths to module 
  PyInstaller hooks. Not intended to be called explicitly."""
    ...

"""The namespace is the core for nested namespaces and the most basic objects used for Aspose.Imaging processing."""
from typing import List, Optional, Dict, Iterable
import enum
import aspose.pycore
import aspose.pydrawing
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.avif
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class Blend:
    '''Defines a blend pattern. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class. The number of elements in the factor and blend arrays will be equal to 1.'''
        ...
    
    @overload
    def __init__(self, count: int):
        '''Initializes a new instance of the  class with the specified number of factors and positions.
        
        :param count: The number of elements in the factor and position arrays.'''
        ...
    
    @property
    def factors(self) -> List[float]:
        '''Gets the array of blend factors for the gradient.'''
        ...
    
    @factors.setter
    def factors(self, value : List[float]):
        '''Sets the array of blend factors for the gradient.'''
        ...
    
    @property
    def positions(self) -> List[float]:
        '''Gets the array of blend positions for the gradient.'''
        ...
    
    @positions.setter
    def positions(self, value : List[float]):
        '''Sets the array of blend positions for the gradient.'''
        ...
    
    ...

class Brush(DisposableObject):
    '''The base brush class.'''
    
    def deep_clone(self) -> aspose.imaging.Brush:
        '''Creates a new deep clone of the current .
        
        :returns: A new  which is the deep clone of this  instance.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def opacity(self) -> float:
        '''Gets the brush opacity. The value should be between 0 and 1. Value of 0 means that brush is fully visible, value of 1 means the brush is fully opaque.'''
        ...
    
    @opacity.setter
    def opacity(self, value : float):
        '''Sets the brush opacity. The value should be between 0 and 1. Value of 0 means that brush is fully visible, value of 1 means the brush is fully opaque.'''
        ...
    
    ...

class BuildVersionInfo:
    '''Contains the current build version information.'''
    
    @classmethod
    @property
    def ASSEMBLY_VERSION(cls) -> str:
        ...
    
    @classmethod
    @property
    def FILE_VERSION(cls) -> str:
        ...
    
    @classmethod
    @property
    def PRODUCT(cls) -> str:
        '''The product title.'''
        ...
    
    @classmethod
    @property
    def PRODUCT_MAJOR(cls) -> int:
        ...
    
    @classmethod
    @property
    def PRODUCT_MINOR(cls) -> int:
        ...
    
    @classmethod
    @property
    def RELEASE_DATE(cls) -> DateTime:
        ...
    
    ...

class Cache:
    '''Contains cache settings.'''
    
    @staticmethod
    def set_defaults():
        '''Sets the  settings to defaults.'''
        ...
    
    @classmethod
    @property
    def exact_reallocate_only(cls) -> bool:
        ...
    
    @classmethod
    @exact_reallocate_only.setter
    def exact_reallocate_only(cls, value : bool):
        ...
    
    @classmethod
    @property
    def cache_folder(cls) -> str:
        ...
    
    @classmethod
    @cache_folder.setter
    def cache_folder(cls, value : str):
        ...
    
    @classmethod
    @property
    def allocated_memory_bytes_count(cls) -> int:
        ...
    
    @classmethod
    @property
    def allocated_disk_bytes_count(cls) -> int:
        ...
    
    @classmethod
    @property
    def max_memory_for_cache(cls) -> int:
        ...
    
    @classmethod
    @max_memory_for_cache.setter
    def max_memory_for_cache(cls, value : int):
        ...
    
    @classmethod
    @property
    def max_disk_space_for_cache(cls) -> int:
        ...
    
    @classmethod
    @max_disk_space_for_cache.setter
    def max_disk_space_for_cache(cls, value : int):
        ...
    
    @classmethod
    @property
    def cache_type(cls) -> aspose.imaging.CacheType:
        ...
    
    @classmethod
    @cache_type.setter
    def cache_type(cls, value : aspose.imaging.CacheType):
        ...
    
    ...

class CmykColor:
    '''The CMYK color of pixel.'''
    
    def __init__(self):
        ...
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixels: List[int]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from 32-bit ARGB color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param argb_pixels: The pixels of 32-bit ARGB format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixel: int) -> aspose.imaging.CmykColor:
        '''The conversion from 32-bit ARGB to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param argb_pixel: The pixel of 32-bit ARGB format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_color(cmyk_pixels: List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the ARGB colors.'''
        ...
    
    @overload
    @staticmethod
    def to_color(cmyk_pixel: aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixel: The pixels of CMYKColor type in CMYK format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixels: List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixel: aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixel: The pixel of CMYKColor type in CMYK format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixels: List[aspose.imaging.CmykColor], cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixel: aspose.imaging.CmykColor, cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixel: The pixel of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The .'''
        ...
    
    @staticmethod
    def from_params(cyan: int, magenta: int, yellow: int, black: int) -> aspose.imaging.CmykColor:
        '''Creates a  structure from a 32-bit cyan, magenta, yellow and black values.
        This method is deprecated. Please use more effective .
        
        :param cyan: The cyan component. Valid values are 0 through 255.
        :param magenta: The magenta component. Valid values are 0 through 255.
        :param yellow: The yellow component. Valid values are 0 through 255.
        :param black: The black component. Valid values are 0 through 255.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_colors(cmyk_pixels: List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the ARGB colors.'''
        ...
    
    @staticmethod
    def to_argb32(cmyk_pixels: List[aspose.imaging.CmykColor]) -> List[int]:
        '''The conversion from CMYKColor to 32-bit ARGB Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the 32-bit ARGB color.'''
        ...
    
    @staticmethod
    def to_cmyk_color(argb_pixel: int) -> aspose.imaging.CmykColor:
        '''The conversion from 32-bit ARGB to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param argb_pixel: The pixel of 32-bit ARGB format.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_colors_with_def_icc(cmyk_pixels: List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_color_with_def_icc(cmyk_pixels: aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixel of CMYKColor type in CMYK format.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_colors_with_icc(cmyk_pixels: List[aspose.imaging.CmykColor], cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_color_with_icc(cmyk_pixels: aspose.imaging.CmykColor, cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param cmyk_pixels: The pixel of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_cmyk_colors(argb_pixels: List[int]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from 32-bit ARGB color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param argb_pixels: The pixels of 32-bit ARGB format.
        :returns: The .'''
        ...
    
    def to_value(self) -> int:
        '''The to value.
        
        :returns: The long CMYK value.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.CmykColor:
        '''Gets the empty.'''
        ...
    
    @property
    def c(self) -> byte:
        '''Gets the cyan component value of this  structure.'''
        ...
    
    @property
    def m(self) -> byte:
        '''Gets the magenta component value of this  structure.'''
        ...
    
    @property
    def y(self) -> byte:
        '''Gets the yellow component value of this  structure.'''
        ...
    
    @property
    def k(self) -> byte:
        '''Gets the black component value of this  structure.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    ...

class CmykColorHelper:
    '''Helper methods to work with CMYK color presented as a signed 32-bit integer value.
    Provides the similar API as the  struct.
    It's more lightweight because CMYK color is presented just as Int32 rather than structure with internal fields.
    Please prefer to use static methods of this class when possible instead of the deprecated
    struct.'''
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param argb_pixels: The ARGB colors presented as 32-bit integer values.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixel: int) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param argb_pixel: The ARGB color presented as a 32-bit integer value.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(pixel: aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(pixels: List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_argb(cmyk_pixels: List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        ...
    
    @overload
    @staticmethod
    def to_argb(cmyk_pixel: int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        ...
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixels: List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with default profiles.
        
        :param cmyk_pixels: The CMYK pixels presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        ...
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixels: List[int], cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with custom profiles.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB colors.'''
        ...
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixel: int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB Color using Icc conversion with default profiles.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        ...
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixel: int, cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color using Icc conversion with custom profile.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB color.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[aspose.imaging.Color], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[int], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel: aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(argb: int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel: aspose.imaging.Color, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(argb: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param argb: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixels: List[int], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(argb: int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value in KCMY byte order with inverted channel values.'''
        ...
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixel: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    @staticmethod
    def get_c(cmyk: int) -> int:
        '''Gets the cyan component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The cyan component value.'''
        ...
    
    @staticmethod
    def get_m(cmyk: int) -> int:
        '''Gets the magenta component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The magenta component value.'''
        ...
    
    @staticmethod
    def get_y(cmyk: int) -> int:
        '''Gets the yellow component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The yellow component value.'''
        ...
    
    @staticmethod
    def get_k(cmyk: int) -> int:
        '''Gets the black component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The black component value.'''
        ...
    
    @staticmethod
    def from_components(cyan: int, magenta: int, yellow: int, black: int) -> int:
        '''Creates CMYK from a 32-bit cyan, magenta, yellow and black values.
        
        :param cyan: The cyan component. Valid values are 0 through 255.
        :param magenta: The magenta component. Valid values are 0 through 255.
        :param yellow: The yellow component. Valid values are 0 through 255.
        :param black: The black component. Valid values are 0 through 255.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def to_cmyk_array(argb_pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param argb_pixels: The ARGB colors presented as 32-bit integer values.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def to_cmyk_bytes(argb_pixels: List[int], start_index: int, length: int) -> bytes:
        '''Converts ARGB to CMYK.
        
        :param argb_pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :returns: The CMYK colors presented as a byte array.'''
        ...
    
    @staticmethod
    def to_cmyka_bytes(argb_pixels: List[int], start_index: int, length: int) -> bytes:
        '''Converts ARGB to CMYKA (with transparency).
        
        :param argb_pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :returns: The CMYK colors presented as a byte array.'''
        ...
    
    @staticmethod
    def to_cmyk_color(pixel: aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def to_cmyk_colors(pixels: List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def to_argb_colors(cmyk_pixels: List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        ...
    
    @staticmethod
    def to_argb_color(cmyk_pixel: int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        ...
    
    @staticmethod
    def to_argb32(cmyk_pixels: List[int]) -> List[int]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def to_argb_colors_with_def_icc(cmyk_pixels: List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with default profiles.
        
        :param cmyk_pixels: The CMYK pixels presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        ...
    
    @staticmethod
    def to_argb_colors_with_icc(cmyk_pixels: List[int], cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with custom profiles.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB colors.'''
        ...
    
    @staticmethod
    def to_argb_color_with_def_icc(cmyk_pixel: int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB Color using Icc conversion with default profiles.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        ...
    
    @staticmethod
    def to_argb_color_with_icc(cmyk_pixel: int, cmyk_icc_stream: io.RawIOBase, rgb_icc_stream: io.RawIOBase) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color using Icc conversion with custom profile.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB color.'''
        ...
    
    @staticmethod
    def to_cmyk_array_with_icc(pixels: List[aspose.imaging.Color], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def argb_32_to_cmyk_array_with_icc(pixels: List[int], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def argb_32_to_psd_cmyk_array_with_icc(pixels: List[int], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    @staticmethod
    def to_cmyk_icc_bytes(pixels: List[int], start_index: int, length: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> bytes:
        '''Converts RGB to CMYK using custom ICC profiles.
        
        :param pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :param rgb_icc_stream: The RGB profile stream.
        :param cmyk_icc_stream: The CMYK profile stream.
        :returns: The CMYK colors presented as a byte array.'''
        ...
    
    @staticmethod
    def to_cmyka_icc_bytes(pixels: List[int], start_index: int, length: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> bytes:
        '''Converts RGB to CMYKA (with alpha) using custom ICC profiles.
        
        :param pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :param rgb_icc_stream: The RGB profile stream.
        :param cmyk_icc_stream: The CMYK profile stream.
        :returns: The CMYK colors presented as a byte array.'''
        ...
    
    @staticmethod
    def to_cmyk_array_with_def_icc(pixels: List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def argb_32_to_cmyk_array(pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        ...
    
    @staticmethod
    def argb_32_to_psd_cmyk_array(pixels: List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    @staticmethod
    def to_cmyk_with_def_icc(pixel: aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def argb_32_to_cmyk(argb: int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def argb_32_to_psd_cmyk(argb: int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value in KCMY byte order with inverted channel values.'''
        ...
    
    @staticmethod
    def to_cmyk_with_icc(pixel: aspose.imaging.Color, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def argb_32_to_cmyk_with_icc(argb: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param argb: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        ...
    
    @staticmethod
    def argb_32_to_psd_cmyk_with_icc(pixel: int, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        ...
    
    ...

class Color:
    '''The color of the pixel.'''
    
    def __init__(self):
        ...
    
    @overload
    @staticmethod
    def from_argb(argb: int) -> aspose.imaging.Color:
        '''Creates a  structure from a 32-bit ARGB value.
        
        :param argb: A value specifying the 32-bit ARGB value.
        :returns: The  structure that this method creates.'''
        ...
    
    @overload
    @staticmethod
    def from_argb(alpha: int, red: int, green: int, blue: int) -> aspose.imaging.Color:
        '''Creates a  structure from the four ARGB component (alpha, red, green, and blue) values. Although this method allows a 32-bit value to be passed for each component, the value of each component is limited to 8 bits.
        
        :param alpha: The alpha component. Valid values are 0 through 255.
        :param red: The red component. Valid values are 0 through 255.
        :param green: The green component. Valid values are 0 through 255.
        :param blue: The blue component. Valid values are 0 through 255.
        :returns: The  that this method creates.'''
        ...
    
    @overload
    @staticmethod
    def from_argb(alpha: int, base_color: aspose.imaging.Color) -> aspose.imaging.Color:
        '''Creates a  structure from the specified  structure, but with the new specified alpha value. Although this method allows a 32-bit value to be passed for the alpha value, the value is limited to 8 bits.
        
        :param alpha: The alpha value for the new . Valid values are 0 through 255.
        :param base_color: The  from which to create the new .
        :returns: The  that this method creates.'''
        ...
    
    @overload
    @staticmethod
    def from_argb(red: int, green: int, blue: int) -> aspose.imaging.Color:
        '''Creates a  structure from the specified 8-bit color values (red, green, and blue). The alpha value is implicitly 255 (fully opaque). Although this method allows a 32-bit value to be passed for each color component, the value of each component is limited to 8 bits.
        
        :param red: The red component value for the new . Valid values are 0 through 255.
        :param green: The green component value for the new . Valid values are 0 through 255.
        :param blue: The blue component value for the new . Valid values are 0 through 255.
        :returns: The  that this method creates.'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(pixels: List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The [].'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk(pixel: aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel: aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The [].'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels: List[aspose.imaging.Color], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The .'''
        ...
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel: aspose.imaging.Color, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The .'''
        ...
    
    @staticmethod
    def from_known_color(color: aspose.imaging.KnownColor) -> aspose.imaging.Color:
        '''Creates a  structure from the specified predefined color.
        
        :param color: An element of the  enumeration.
        :returns: The  that this method creates.'''
        ...
    
    @staticmethod
    def from_name(name: str) -> aspose.imaging.Color:
        '''Creates a  structure from the specified name of a predefined color.
        
        :param name: A string that is the name of a predefined color. Valid names are the same as the names of the elements of the  enumeration.
        :returns: The  that this method creates.'''
        ...
    
    @staticmethod
    def to_cmyk_color(pixel: aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_cmyk_color_with_def_icc(pixel: aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The .'''
        ...
    
    @staticmethod
    def to_cmyk_colors_with_def_icc(pixels: List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The [].'''
        ...
    
    @staticmethod
    def to_cmyk_colors_with_icc(pixels: List[aspose.imaging.Color], rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The [].'''
        ...
    
    @staticmethod
    def to_cmyk_color_with_icc(pixel: aspose.imaging.Color, rgb_icc_stream: io.RawIOBase, cmyk_icc_stream: io.RawIOBase) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective .
        
        :param pixel: The pixel of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The [].'''
        ...
    
    def get_brightness(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) brightness value for this  structure.
        
        :returns: The brightness of this . The brightness ranges from 0.0 through 1.0, where 0.0 represents black and 1.0 represents white.'''
        ...
    
    def get_hue(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) hue value, in degrees, for this  structure.
        
        :returns: The hue, in degrees, of this . The hue is measured in degrees, ranging from 0.0 through 360.0, in HSB color space.'''
        ...
    
    def get_saturation(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) saturation value for this  structure.
        
        :returns: The saturation of this . The saturation ranges from 0.0 through 1.0, where 0.0 is grayscale and 1.0 is the most saturated.'''
        ...
    
    def to_argb(self) -> int:
        '''Gets the 32-bit ARGB value of this  structure.
        
        :returns: The 32-bit ARGB value of this .'''
        ...
    
    def to_known_color(self) -> aspose.imaging.KnownColor:
        '''Gets the  value of this  structure.
        
        :returns: An element of the  enumeration, if the  is created from a predefined color by using either the  method or the  method; otherwise, 0.'''
        ...
    
    @staticmethod
    def to_cmyk_colors(pixels: List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective .
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The [].'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.Color:
        '''Gets an empty .'''
        ...
    
    @classmethod
    @property
    def transparent(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def alice_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def antique_white(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def aqua(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def aquamarine(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def azure(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def beige(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def bisque(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def black(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def blanched_almond(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def blue(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def blue_violet(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def brown(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def burly_wood(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def cadet_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def chartreuse(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def chocolate(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def coral(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def cornflower_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def cornsilk(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def crimson(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def cyan(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def dark_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_cyan(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_goldenrod(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_khaki(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_magenta(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_olive_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_orange(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_orchid(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_red(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_salmon(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_sea_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_slate_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_slate_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_turquoise(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dark_violet(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def deep_pink(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def deep_sky_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dim_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def dodger_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def firebrick(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def floral_white(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def forest_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def fuchsia(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def gainsboro(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def ghost_white(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def gold(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def goldenrod(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def gray(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def green(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def green_yellow(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def honeydew(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def hot_pink(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def indian_red(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def indigo(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def ivory(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def khaki(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def lavender(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def lavender_blush(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def lawn_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def lemon_chiffon(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_coral(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_cyan(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_goldenrod_yellow(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_pink(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_salmon(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_sea_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_sky_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_slate_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_steel_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def light_yellow(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def lime(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def lime_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def linen(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def magenta(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def maroon(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def medium_aquamarine(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_orchid(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_purple(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_sea_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_slate_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_spring_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_turquoise(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def medium_violet_red(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def midnight_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def mint_cream(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def misty_rose(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def moccasin(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def navajo_white(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def navy(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def old_lace(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def olive(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def olive_drab(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def orange(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def orange_red(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def orchid(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def pale_goldenrod(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def pale_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def pale_turquoise(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def pale_violet_red(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def papaya_whip(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def peach_puff(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def peru(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def pink(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def plum(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def powder_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def purple(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def red(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def rosy_brown(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def royal_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def saddle_brown(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def salmon(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def sandy_brown(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def sea_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def sea_shell(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def sienna(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def silver(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def sky_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def slate_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def slate_gray(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def snow(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def spring_green(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def steel_blue(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def tan(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def teal(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def thistle(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def tomato(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def turquoise(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def violet(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def wheat(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def white(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def white_smoke(cls) -> aspose.imaging.Color:
        ...
    
    @classmethod
    @property
    def yellow(cls) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        ...
    
    @classmethod
    @property
    def yellow_green(cls) -> aspose.imaging.Color:
        ...
    
    @property
    def r(self) -> byte:
        '''Gets the red component value of this  structure.'''
        ...
    
    @property
    def g(self) -> byte:
        '''Gets the green component value of this  structure.'''
        ...
    
    @property
    def b(self) -> byte:
        '''Gets the blue component value of this  structure.'''
        ...
    
    @property
    def a(self) -> byte:
        '''Gets the alpha component value of this  structure.'''
        ...
    
    @property
    def is_known_color(self) -> bool:
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    @property
    def is_named_color(self) -> bool:
        ...
    
    @property
    def name(self) -> str:
        '''Gets the name of this .'''
        ...
    
    ...

class ColorBlend:
    '''Defines arrays of colors and positions used for interpolating color blending in a multicolor gradient. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, count: int):
        '''Initializes a new instance of the  class with the specified number of colors and positions.
        
        :param count: The number of colors and positions in this .'''
        ...
    
    @property
    def colors(self) -> List[aspose.imaging.Color]:
        '''Gets an array of colors that represents the colors to use at corresponding positions along a gradient.'''
        ...
    
    @colors.setter
    def colors(self, value : List[aspose.imaging.Color]):
        '''Sets an array of colors that represents the colors to use at corresponding positions along a gradient.'''
        ...
    
    @property
    def positions(self) -> List[float]:
        '''Gets the positions along a gradient line.'''
        ...
    
    @positions.setter
    def positions(self, value : List[float]):
        '''Sets the positions along a gradient line.'''
        ...
    
    ...

class ColorMap:
    '''Defines a map for converting colors. Several methods of the  class adjust image colors by using a color-remap table, which is an array of  structures. Not inheritable.'''
    
    def __init__(self):
        ...
    
    @property
    def old_color(self) -> aspose.imaging.Color:
        ...
    
    @old_color.setter
    def old_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def new_color(self) -> aspose.imaging.Color:
        ...
    
    @new_color.setter
    def new_color(self, value : aspose.imaging.Color):
        ...
    
    ...

class ColorMatrix:
    '''Defines a 5 x 5 matrix that contains the coordinates for the RGBA space. Several methods of the  class adjust image colors by using a color matrix. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, new_color_matrix: List[List[float]]):
        '''Initializes a new instance of the  class using the elements in the specified matrix ``newColorMatrix``.
        
        :param new_color_matrix: The values of the elements for the new .'''
        ...
    
    def get(self, row: int, column: int) -> float:
        '''Gets the element at the specified row and column in the .
        
        :param row: The row number.
        :param column: The column number.
        :returns: The element at the specified row and column.'''
        ...
    
    def set(self, row: int, column: int, value: float):
        '''Sets the element at the specified row and column in the .
        
        :param row: The row number.
        :param column: The column number.
        :param value: The element at the specified row and column.'''
        ...
    
    def get_matrix(self) -> List[List[float]]:
        '''Gets the matrix values.
        
        :returns: The matrix values array.'''
        ...
    
    @property
    def matrix00(self) -> float:
        '''Gets the element at the 0 (zero) row and 0 column of this .'''
        ...
    
    @matrix00.setter
    def matrix00(self, value : float):
        '''Sets the element at the 0 (zero) row and 0 column of this .'''
        ...
    
    @property
    def matrix01(self) -> float:
        '''Gets the element at the 0 (zero) row and first column of this .'''
        ...
    
    @matrix01.setter
    def matrix01(self, value : float):
        '''Sets the element at the 0 (zero) row and first column of this .'''
        ...
    
    @property
    def matrix02(self) -> float:
        '''Gets the element at the 0 (zero) row and second column of this .'''
        ...
    
    @matrix02.setter
    def matrix02(self, value : float):
        '''Sets the element at the 0 (zero) row and second column of this .'''
        ...
    
    @property
    def matrix03(self) -> float:
        '''Gets the element at the 0 (zero) row and third column of this .'''
        ...
    
    @matrix03.setter
    def matrix03(self, value : float):
        '''Sets the element at the 0 (zero) row and third column of this .'''
        ...
    
    @property
    def matrix04(self) -> float:
        '''Gets the element at the 0 (zero) row and fourth column of this .'''
        ...
    
    @matrix04.setter
    def matrix04(self, value : float):
        '''Sets the element at the 0 (zero) row and fourth column of this .'''
        ...
    
    @property
    def matrix10(self) -> float:
        '''Gets the element at the first row and 0 (zero) column of this .'''
        ...
    
    @matrix10.setter
    def matrix10(self, value : float):
        '''Sets the element at the first row and 0 (zero) column of this .'''
        ...
    
    @property
    def matrix11(self) -> float:
        '''Gets the element at the first row and first column of this .'''
        ...
    
    @matrix11.setter
    def matrix11(self, value : float):
        '''Sets the element at the first row and first column of this .'''
        ...
    
    @property
    def matrix12(self) -> float:
        '''Gets the element at the first row and second column of this .'''
        ...
    
    @matrix12.setter
    def matrix12(self, value : float):
        '''Sets the element at the first row and second column of this .'''
        ...
    
    @property
    def matrix13(self) -> float:
        '''Gets the element at the first row and third column of this .'''
        ...
    
    @matrix13.setter
    def matrix13(self, value : float):
        '''Sets the element at the first row and third column of this .'''
        ...
    
    @property
    def matrix14(self) -> float:
        '''Gets the element at the first row and fourth column of this .'''
        ...
    
    @matrix14.setter
    def matrix14(self, value : float):
        '''Sets the element at the first row and fourth column of this .'''
        ...
    
    @property
    def matrix20(self) -> float:
        '''Gets the element at the second row and 0 (zero) column of this .'''
        ...
    
    @matrix20.setter
    def matrix20(self, value : float):
        '''Sets the element at the second row and 0 (zero) column of this .'''
        ...
    
    @property
    def matrix21(self) -> float:
        '''Gets the element at the second row and first column of this .'''
        ...
    
    @matrix21.setter
    def matrix21(self, value : float):
        '''Sets the element at the second row and first column of this .'''
        ...
    
    @property
    def matrix22(self) -> float:
        '''Gets the element at the second row and second column of this .'''
        ...
    
    @matrix22.setter
    def matrix22(self, value : float):
        '''Sets the element at the second row and second column of this .'''
        ...
    
    @property
    def matrix23(self) -> float:
        '''Gets the element at the second row and third column of this .'''
        ...
    
    @matrix23.setter
    def matrix23(self, value : float):
        '''Sets the element at the second row and third column of this .'''
        ...
    
    @property
    def matrix24(self) -> float:
        '''Gets the element at the second row and fourth column of this .'''
        ...
    
    @matrix24.setter
    def matrix24(self, value : float):
        '''Sets the element at the second row and fourth column of this .'''
        ...
    
    @property
    def matrix30(self) -> float:
        '''Gets the element at the third row and 0 (zero) column of this .'''
        ...
    
    @matrix30.setter
    def matrix30(self, value : float):
        '''Sets the element at the third row and 0 (zero) column of this .'''
        ...
    
    @property
    def matrix31(self) -> float:
        '''Gets the element at the third row and first column of this .'''
        ...
    
    @matrix31.setter
    def matrix31(self, value : float):
        '''Sets the element at the third row and first column of this .'''
        ...
    
    @property
    def matrix32(self) -> float:
        '''Gets the element at the third row and second column of this .'''
        ...
    
    @matrix32.setter
    def matrix32(self, value : float):
        '''Sets the element at the third row and second column of this .'''
        ...
    
    @property
    def matrix33(self) -> float:
        '''Gets the element at the third row and third column of this .'''
        ...
    
    @matrix33.setter
    def matrix33(self, value : float):
        '''Sets the element at the third row and third column of this .'''
        ...
    
    @property
    def matrix34(self) -> float:
        '''Gets the element at the third row and fourth column of this .'''
        ...
    
    @matrix34.setter
    def matrix34(self, value : float):
        '''Sets the element at the third row and fourth column of this .'''
        ...
    
    @property
    def matrix40(self) -> float:
        '''Gets the element at the fourth row and 0 (zero) column of this .'''
        ...
    
    @matrix40.setter
    def matrix40(self, value : float):
        '''Sets the element at the fourth row and 0 (zero) column of this .'''
        ...
    
    @property
    def matrix41(self) -> float:
        '''Gets the element at the fourth row and first column of this .'''
        ...
    
    @matrix41.setter
    def matrix41(self, value : float):
        '''Sets the element at the fourth row and first column of this .'''
        ...
    
    @property
    def matrix42(self) -> float:
        '''Gets the element at the fourth row and second column of this .'''
        ...
    
    @matrix42.setter
    def matrix42(self, value : float):
        '''Sets the element at the fourth row and second column of this .'''
        ...
    
    @property
    def matrix43(self) -> float:
        '''Gets the element at the fourth row and third column of this .'''
        ...
    
    @matrix43.setter
    def matrix43(self, value : float):
        '''Sets the element at the fourth row and third column of this .'''
        ...
    
    @property
    def matrix44(self) -> float:
        '''Gets the element at the fourth row and fourth column of this .'''
        ...
    
    @matrix44.setter
    def matrix44(self, value : float):
        '''Sets the element at the fourth row and fourth column of this .'''
        ...
    
    @classmethod
    @property
    def MATRIX_DIMENSION_ELEMENTS_COUNT(cls) -> int:
        ...
    
    @classmethod
    @property
    def MATRIX_DIMENSIONS_COUNT(cls) -> int:
        ...
    
    @classmethod
    @property
    def MATRIX_TOTAL_ELEMENTS_COUNT(cls) -> int:
        ...
    
    ...

class ColorPalette(IColorPalette):
    '''Defines an array of colors that make up a color palette. The colors are 32-bit ARGB colors. Not inheritable.'''
    
    @overload
    def __init__(self, argb_32_entries: List[int], is_compact_palette: bool):
        '''Initializes a new instance of the  class.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        ...
    
    @overload
    def __init__(self, argb_32_entries: List[int]):
        '''Initializes a new instance of the  class and IsCompactPalette is false.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.'''
        ...
    
    @overload
    def __init__(self, entries: List[aspose.imaging.Color], is_compact_palette: bool):
        '''Initializes a new instance of the  class.
        
        :param entries: The color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        ...
    
    @overload
    def __init__(self, entries: List[aspose.imaging.Color]):
        '''Initializes a new instance of the  class and IsCompactPalette is false.
        
        :param entries: The color palette entries.'''
        ...
    
    @overload
    @staticmethod
    def copy_palette(color_palette: aspose.imaging.IColorPalette, use_compact_palette: bool) -> aspose.imaging.ColorPalette:
        '''Copies the palette.
        
        :param color_palette: The color palette.
        :param use_compact_palette: Indicating whether compact palette.
        :returns: The newly created and copied palette or null if null palette passed.'''
        ...
    
    @overload
    @staticmethod
    def copy_palette(color_palette: aspose.imaging.IColorPalette) -> aspose.imaging.ColorPalette:
        '''Copies the palette.
        
        :param color_palette: The color palette.
        :returns: The newly created and copied palette or null if null palette passed.'''
        ...
    
    @overload
    def get_nearest_color_index(self, argb_32_color: int) -> int:
        '''Gets the index of the nearest color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        ...
    
    @overload
    def get_nearest_color_index(self, color: aspose.imaging.Color) -> int:
        '''Gets the index of the nearest color.
        
        :param color: The color.
        :returns: The index of the nearest color.'''
        ...
    
    @staticmethod
    def create_with_argb_compact(argb_32_entries: List[int], is_compact_palette: bool) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the  class.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        ...
    
    @staticmethod
    def create_with_argb(argb_32_entries: List[int]) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the  class and IsCompactPalette is false.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.'''
        ...
    
    @staticmethod
    def create_with_colors_compact(entries: List[aspose.imaging.Color], is_compact_palette: bool) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the  class.
        
        :param entries: The color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        ...
    
    @staticmethod
    def create_with_colors(entries: List[aspose.imaging.Color]) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the  class and IsCompactPalette is false.
        
        :param entries: The color palette entries.'''
        ...
    
    def get_nearest_argb_index(self, argb_32_color: int) -> int:
        '''Gets the index of the nearest color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        ...
    
    def get_argb_32_color(self, index: int) -> int:
        '''Gets the 32-bit ARGB palette color by index.
        
        :param index: The 32-bit ARGB palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        ...
    
    def get_color(self, index: int) -> aspose.imaging.Color:
        '''Gets the palette color by index.
        
        :param index: The palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        ...
    
    @property
    def entries_count(self) -> int:
        ...
    
    @property
    def argb_32_entries(self) -> List[int]:
        ...
    
    @property
    def entries(self) -> List[aspose.imaging.Color]:
        '''Gets an array of  structures.'''
        ...
    
    @property
    def is_compact_palette(self) -> bool:
        ...
    
    ...

class ColorPaletteHelper:
    '''Helper class for color palettes manipulation.'''
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, entries_count: int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, entries_count: int, palette_mining_method: aspose.imaging.PaletteMiningMethod) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. Palette is about to be optimized for better indexed image quality or taken "AS IS" when PaletteMiningMethod.UseCurrentPalette is used.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :param palette_mining_method: The palette mining method.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, dest_bounds: aspose.imaging.Rectangle, entries_count: int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, dest_bounds: aspose.imaging.Rectangle, entries_count: int, use_image_palette: bool) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, dest_bounds: aspose.imaging.Rectangle, entries_count: int, use_image_palette: bool, alpha_blend_in_color: aspose.imaging.Color) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :param alpha_blend_in_color: The color that should be used as a background color for semi-transparent alpha replacement.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @overload
    @staticmethod
    def get_close_image_palette(image: aspose.imaging.RasterImage, dest_bounds: aspose.imaging.Rectangle, entries_count: int, use_image_palette: bool, alpha_blend_in_color: aspose.imaging.Color, keep_transparency: bool) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :param alpha_blend_in_color: The color that should be used as a background color for semi-transparent alpha replacement.
        :param keep_transparency: If set, it will consider alpha channel bits of the image colors.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @staticmethod
    def create_monochrome() -> aspose.imaging.IColorPalette:
        '''Creates a monochrome color palette containing 2 colors only.
        
        :returns: Color palette for monochrome images.'''
        ...
    
    @staticmethod
    def create_4_bit() -> aspose.imaging.IColorPalette:
        '''Creates the 4 bit color palette.
        
        :returns: The 4 bit color palette.'''
        ...
    
    @staticmethod
    def create_4_bit_grayscale(min_is_white: bool) -> aspose.imaging.IColorPalette:
        '''Creates the 4 bit grayscale palette.
        
        :param min_is_white: if set to ``true`` the palette starts with white color, otherwise it starts with black color.
        :returns: The 4 bit grayscale palette.'''
        ...
    
    @staticmethod
    def create_8_bit() -> aspose.imaging.IColorPalette:
        '''Creates the 8 bit color palette.
        
        :returns: The 8 bit color palette.'''
        ...
    
    @staticmethod
    def create_8_bit_grayscale(min_is_white: bool) -> aspose.imaging.IColorPalette:
        '''Creates the 8 bit grayscale palette.
        
        :param min_is_white: if set to ``true`` the palette starts with white color, otherwise it starts with black color.
        :returns: The 8 bit grayscale palette.'''
        ...
    
    @staticmethod
    def get_close_transparent_image_palette(image: aspose.imaging.RasterImage, entries_count: int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @staticmethod
    def get_close_image_palette_by_method(image: aspose.imaging.RasterImage, entries_count: int, palette_mining_method: aspose.imaging.PaletteMiningMethod) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. Palette is about to be optimized for better indexed image quality or taken "AS IS" when PaletteMiningMethod.UseCurrentPalette is used.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :param palette_mining_method: The palette mining method.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @staticmethod
    def get_close_image_palette_by_rect(image: aspose.imaging.RasterImage, dest_bounds: aspose.imaging.Rectangle, entries_count: int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        ...
    
    @staticmethod
    def get_uniform_color_palette(image: aspose.imaging.RasterImage) -> aspose.imaging.ColorPalette:
        '''Get uniform 256 color palette.
        
        :param image: The image.
        :returns: The .'''
        ...
    
    @staticmethod
    def get_downscale_palette(image: aspose.imaging.RasterImage) -> aspose.imaging.ColorPalette:
        '''Get 256 color palette, composed from upper bits of initial image color values.
        
        :param image: The image.
        :returns: The .'''
        ...
    
    @staticmethod
    def has_transparent_colors(palette: aspose.imaging.IColorPalette) -> bool:
        '''Determines whether the specified palette has transparent colors.
        
        :param palette: The palette.
        :returns: ``true`` if the specified palette has transparent colors; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def create_grayscale(bits: int) -> aspose.imaging.IColorPalette:
        '''Gets the grayscale palette of specified bit count. Allowed bit values are 1, 2, 4, 8.
        
        :param bits: The bit count.
        :returns: Grayscale palette.'''
        ...
    
    ...

class ColorTranslator:
    '''Translates colors to and from GDI+ Color structures. This class cannot be inherited.'''
    
    @staticmethod
    def from_html(html_color: str) -> aspose.imaging.Color:
        '''Takes color from the HTML color.
        
        :param html_color: HTML color.
        :returns: The color.'''
        ...
    
    @staticmethod
    def from_ole(ole_color: int) -> aspose.imaging.Color:
        '''Takes color from the OLE color.
        
        :param ole_color: OLE color.
        :returns: The color.'''
        ...
    
    @staticmethod
    def from_win32(win_32_color: int) -> aspose.imaging.Color:
        '''Takes color from the HTML color.
        
        :param win_32_color: Win32 color.
        :returns: The color.'''
        ...
    
    @staticmethod
    def to_html(c: aspose.imaging.Color) -> str:
        '''Creates HTML color  from the color.
        
        :param c: The color class.
        :returns: The html string color.'''
        ...
    
    @staticmethod
    def to_ole(c: aspose.imaging.Color) -> int:
        '''Translates OLE color to color.
        
        :param c: The color.
        :returns: The OLE color.'''
        ...
    
    @staticmethod
    def to_win32(c: aspose.imaging.Color) -> int:
        '''Translates the color to win32 color.
        
        :param c: The color.
        :returns: The win32 color.'''
        ...
    
    ...

class CustomLineCap:
    '''Encapsulates a custom user-defined line cap.'''
    
    @overload
    def __init__(self, fill_path: aspose.imaging.GraphicsPath, stroke_path: aspose.imaging.GraphicsPath):
        '''Initializes a new instance of the  class with the specified outline and fill.
        
        :param fill_path: A  object that defines the fill for the custom cap.
        :param stroke_path: A  object that defines the outline of the custom cap.'''
        ...
    
    @overload
    def __init__(self, fill_path: aspose.imaging.GraphicsPath, stroke_path: aspose.imaging.GraphicsPath, base_cap: aspose.imaging.LineCap):
        '''Initializes a new instance of the  class from the specified existing  enumeration with the specified outline and fill.
        
        :param fill_path: A  object that defines the fill for the custom cap.
        :param stroke_path: A  object that defines the outline of the custom cap.
        :param base_cap: The line cap from which to create the custom cap.'''
        ...
    
    @overload
    def __init__(self, fill_path: aspose.imaging.GraphicsPath, stroke_path: aspose.imaging.GraphicsPath, base_cap: aspose.imaging.LineCap, base_inset: float):
        '''Initializes a new instance of the  class from the specified existing  enumeration with the specified outline, fill, and inset.
        
        :param fill_path: A  object that defines the fill for the custom cap.
        :param stroke_path: A  object that defines the outline of the custom cap.
        :param base_cap: The line cap from which to create the custom cap.
        :param base_inset: The distance between the cap and the line.'''
        ...
    
    def set_stroke_caps(self, start_cap: aspose.imaging.LineCap, end_cap: aspose.imaging.LineCap):
        '''Sets the caps used to start and end lines that make up this custom cap.
        
        :param start_cap: The  enumeration used at the beginning of a line within this cap.
        :param end_cap: The  enumeration used at the end of a line within this cap.'''
        ...
    
    def get_stroke_caps(self, start_cap: Any, end_cap: Any):
        '''Gets the caps used to start and end lines that make up this custom cap.
        
        :param start_cap: The  enumeration used at the beginning of a line within this cap.
        :param end_cap: The  enumeration used at the end of a line within this cap.'''
        ...
    
    @property
    def fill_path(self) -> aspose.imaging.GraphicsPath:
        ...
    
    @fill_path.setter
    def fill_path(self, value : aspose.imaging.GraphicsPath):
        ...
    
    @property
    def stroke_path(self) -> aspose.imaging.GraphicsPath:
        ...
    
    @stroke_path.setter
    def stroke_path(self, value : aspose.imaging.GraphicsPath):
        ...
    
    @property
    def stroke_join(self) -> aspose.imaging.LineJoin:
        ...
    
    @stroke_join.setter
    def stroke_join(self, value : aspose.imaging.LineJoin):
        ...
    
    @property
    def base_cap(self) -> aspose.imaging.LineCap:
        ...
    
    @base_cap.setter
    def base_cap(self, value : aspose.imaging.LineCap):
        ...
    
    @property
    def base_inset(self) -> float:
        ...
    
    @base_inset.setter
    def base_inset(self, value : float):
        ...
    
    @property
    def width_scale(self) -> float:
        ...
    
    @width_scale.setter
    def width_scale(self, value : float):
        ...
    
    ...

class DataStreamSupporter(DisposableObject):
    '''The data stream container.'''
    
    @overload
    def save(self):
        '''Saves the object's data to the current .'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    ...

class DisposableObject:
    '''Represents disposable object.'''
    
    def __init__(self):
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    ...

class EmbeddedImage(DisposableObject):
    '''The embedded image class'''
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def image(self) -> aspose.imaging.Image:
        '''Gets the image.'''
        ...
    
    ...

class Figure(ObjectWithBounds):
    '''The figure. A container for shapes.'''
    
    def __init__(self):
        '''Initializes a new  instance.
        A constructor required for a JSON deserialization.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object's bounds.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix, pen: aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object's bounds size.
        :returns: The estimated object's bounds.'''
        ...
    
    def transform(self, transform: aspose.imaging.Matrix):
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        ...
    
    def add_shape(self, shape: aspose.imaging.Shape):
        '''Adds a shape to the figure.
        
        :param shape: The shape to add.'''
        ...
    
    def add_shapes(self, shapes: List[aspose.imaging.Shape]):
        '''Adds a range of shapes to the figure.
        
        :param shapes: The shapes to add.'''
        ...
    
    def remove_shape(self, shape: aspose.imaging.Shape):
        '''Removes a shape from the figure.
        
        :param shape: The shape to remove.'''
        ...
    
    def remove_shapes(self, shapes: List[aspose.imaging.Shape]):
        '''Removes a range of shapes from the figure.
        
        :param shapes: The shapes range to remove.'''
        ...
    
    def reverse(self):
        '''Reverses this figure shapes order and shapes point order.'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.'''
        ...
    
    @property
    def shapes(self) -> List[aspose.imaging.Shape]:
        '''Gets the shapes.'''
        ...
    
    @property
    def is_closed(self) -> bool:
        ...
    
    @is_closed.setter
    def is_closed(self, value : bool):
        ...
    
    @property
    def segments(self) -> List[aspose.imaging.ShapeSegment]:
        '''Gets the whole figure segments.'''
        ...
    
    ...

class FileStreamContainer(StreamContainer):
    '''Helper for file stream processing.'''
    
    @overload
    def write(self, bytes: bytes):
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        ...
    
    @overload
    def write(self, buffer: bytes, offset: int, count: int):
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        ...
    
    @overload
    def read(self, bytes: bytes) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        ...
    
    @overload
    def read(self, buffer: bytes, offset: int, count: int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        ...
    
    @overload
    def to_bytes(self) -> bytes:
        '''Converts the stream data to the  array.
        
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def to_bytes(self, position: int, bytes_count: int) -> bytes:
        '''Converts the stream data to the  array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param file_path: The file path to save the stream data to.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer, length: int):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        ...
    
    def flush(self):
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        ...
    
    def write_byte(self, value: byte):
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        ...
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        ...
    
    def seek(self, offset: int, origin: aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type  indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        ...
    
    def seek_begin(self):
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    def save_to_stream(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    def save_to_stream_with_buf_size(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    def save_with_buf_size(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    def save_with_buf_size_and_len(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @staticmethod
    def create_file_stream(file_location: str, is_temporal: bool) -> aspose.imaging.FileStreamContainer:
        '''Creates a new file stream.
        
        :param file_location: The file location.
        :param is_temporal: If set to ``true`` the file stream container is temporal.
        :returns: The file stream container.'''
        ...
    
    @staticmethod
    def open_file_stream(file_location: str) -> aspose.imaging.FileStreamContainer:
        '''Opens an existing file stream. If file stream does not exist the appropriate exception is thrown.
        
        :param file_location: The file location.
        :returns: The file stream container.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def sync_root(self) -> any:
        ...
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @position.setter
    def position(self, value : int):
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def stream(self) -> io.RawIOBase:
        '''Gets the data stream.'''
        ...
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        ...
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @length.setter
    def length(self, value : int):
        '''Sets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def can_read(self) -> bool:
        ...
    
    @property
    def can_seek(self) -> bool:
        ...
    
    @property
    def can_write(self) -> bool:
        ...
    
    @classmethod
    @property
    def READ_WRITE_BYTES_COUNT(cls) -> int:
        ...
    
    @property
    def is_temporal(self) -> bool:
        ...
    
    @is_temporal.setter
    def is_temporal(self, value : bool):
        ...
    
    @property
    def is_created(self) -> bool:
        ...
    
    @property
    def file_path(self) -> str:
        ...
    
    ...

class Font:
    '''Defines a particular format for text, including font face, size, and style attributes. This class cannot be inherited.'''
    
    @overload
    def __init__(self, prototype: aspose.imaging.Font, new_style: aspose.imaging.FontStyle):
        '''Initializes a new  that uses the specified existing  and  enumeration.
        
        :param prototype: The existing  from which to create the new .
        :param new_style: The  to apply to the new . Multiple values of the  enumeration can be combined with the OR operator.'''
        ...
    
    @overload
    def __init__(self, font_name: str, em_size: float):
        '''Initializes a new  using a specified size. The character set is set to , the graphics unit to , the font style to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size, in points, of the new font.'''
        ...
    
    @overload
    def __init__(self, font_name: str, em_size: float, style: aspose.imaging.FontStyle):
        '''Initializes a new  using a specified size and style. The character set is set to , the graphics unit to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size, in points, of the new font.
        :param style: The  of the new font.'''
        ...
    
    @overload
    def __init__(self, font_name: str, em_size: float, unit: aspose.imaging.GraphicsUnit):
        '''Initializes a new  using a specified size and unit. The character set is set to , the style is set to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param unit: The  of the new font.'''
        ...
    
    @overload
    def __init__(self, font_name: str, em_size: float, style: aspose.imaging.FontStyle, unit: aspose.imaging.GraphicsUnit, character_set: aspose.imaging.CharacterSet):
        '''Initializes a new  using a specified size, style, unit, and character set.
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param style: The  of the new font.
        :param unit: The  of the new font.
        :param character_set: A character set to use for this font.'''
        ...
    
    @overload
    def __init__(self, font_name: str, em_size: float, style: aspose.imaging.FontStyle, unit: aspose.imaging.GraphicsUnit):
        '''Initializes a new  using a specified size, style, and unit.
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param style: The  of the new font.
        :param unit: The  of the new font.'''
        ...
    
    @staticmethod
    def create_from_prototype(prototype: aspose.imaging.Font, new_style: aspose.imaging.FontStyle) -> aspose.imaging.Font:
        '''Initializes a new  that uses the specified existing  and  enumeration.
        
        :param prototype: The existing  from which to create the new .
        :param new_style: The  to apply to the new . Multiple values of the  enumeration can be combined with the OR operator.'''
        ...
    
    @staticmethod
    def create_with_size(font_name: str, em_size: float) -> aspose.imaging.Font:
        '''Initializes a new  using a specified size. The character set is set to , the graphics unit to , the font style to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size, in points, of the new font.'''
        ...
    
    @staticmethod
    def create_with_size_style(font_name: str, em_size: float, style: aspose.imaging.FontStyle) -> aspose.imaging.Font:
        '''Initializes a new  using a specified size and style. The character set is set to , the graphics unit to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size, in points, of the new font.
        :param style: The  of the new font.'''
        ...
    
    @staticmethod
    def create_with_size_unit(font_name: str, em_size: float, unit: aspose.imaging.GraphicsUnit) -> aspose.imaging.Font:
        '''Initializes a new  using a specified size and unit. The character set is set to , the style is set to .
        
        :param font_name: A string representation of the  name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param unit: The  of the new font.'''
        ...
    
    def deep_clone(self) -> aspose.imaging.Font:
        '''Creates an exact deep copy of this .
        
        :returns: The  this method creates.'''
        ...
    
    @property
    def bold(self) -> bool:
        '''Gets a value indicating whether this  is bold.'''
        ...
    
    @property
    def character_set(self) -> aspose.imaging.CharacterSet:
        ...
    
    @property
    def italic(self) -> bool:
        '''Gets a value indicating whether this  is italic.'''
        ...
    
    @property
    def name(self) -> str:
        '''Gets the face name of this .'''
        ...
    
    @property
    def strikeout(self) -> bool:
        '''Gets a value indicating whether this  specifies a horizontal line through the font.'''
        ...
    
    @property
    def underline(self) -> bool:
        '''Gets a value indicating whether this  is underlined.'''
        ...
    
    @property
    def style(self) -> aspose.imaging.FontStyle:
        '''Gets style information for this .'''
        ...
    
    @property
    def size(self) -> float:
        '''Gets the em-size of this  measured in the units specified by the  property.'''
        ...
    
    @property
    def unit(self) -> aspose.imaging.GraphicsUnit:
        '''Gets the unit of measure for this .'''
        ...
    
    ...

class FontSettings:
    '''General imaging vector formats renderer font settings.'''
    
    @staticmethod
    def get_fonts_folders() -> List[str]:
        '''Gets a copy of the array that contains the list of folders where Aspose.Words looks for TrueType fonts.
        
        :returns: A copy of the current font locations.'''
        ...
    
    @staticmethod
    def get_default_fonts_folders() -> List[str]:
        '''Gets the default fonts folders.
        
        :returns: Returns system folder'''
        ...
    
    @staticmethod
    def set_fonts_folder(font_folder: str):
        '''This is a shortcut to  for setting only one font directory.
        There are no checks performed on the fonts folder.
        
        :param font_folder: The font folder.'''
        ...
    
    @staticmethod
    def set_fonts_folders(fonts_folders: List[str], recursive: bool):
        '''Sets the folders where TrueType fonts are loaded from and clears all loaded fonts.
        There are no checks performed on the fonts folders.
        
        :param fonts_folders: The fonts folders.
        :param recursive: if set to ``true`` [recursive].'''
        ...
    
    @staticmethod
    def reset():
        '''Resets the fonts folder and default font name to the system default.'''
        ...
    
    @staticmethod
    def update_fonts():
        '''Updates fonts cache for PSD files that contain text layers. This method guarantees that fonts from folder fontsFolder using
        method FontSettings.SetFontsFolder(fontsFolder) or after reset fonts using FontSettings.Reset() will be taken into consideration when processing PSD files. Please use this method each time when
        FontSettings.SetFontsFolder(fontsFolder) or FontSettings.Reset() called for PSD images. Without calling this Method there is no guarantee that fonts will be updated.'''
        ...
    
    @classmethod
    @property
    def get_system_alternative_font(cls) -> bool:
        ...
    
    @classmethod
    @get_system_alternative_font.setter
    def get_system_alternative_font(cls, value : bool):
        ...
    
    @classmethod
    @property
    def default_font_name(cls) -> str:
        ...
    
    @classmethod
    @default_font_name.setter
    def default_font_name(cls, value : str):
        ...
    
    ...

class Graphics:
    '''Represents the graphics according to the graphics engine used in the current assembly.'''
    
    def __init__(self, source_image: aspose.imaging.Image):
        '''Initializes a new instance of the  class.
        
        :param source_image: The source image.'''
        ...
    
    @overload
    def multiply_transform(self, matrix: aspose.imaging.Matrix):
        '''Multiplies the  that represents the local geometric transform of this  by the specified  by prepending the specified .
        
        :param matrix: The  by which to multiply the geometric transform.'''
        ...
    
    @overload
    def multiply_transform(self, matrix: aspose.imaging.Matrix, order: aspose.imaging.MatrixOrder):
        '''Multiplies the  that represents the local geometric transform of this  by the specified  in the specified order.
        
        :param matrix: The  by which to multiply the geometric transform.
        :param order: A  that specifies in which order to multiply the two matrices.'''
        ...
    
    @overload
    def translate_transform(self, dx: float, dy: float):
        '''Translates the local geometric transform by the specified dimensions. This method prepends the translation to the transform.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.'''
        ...
    
    @overload
    def translate_transform(self, dx: float, dy: float, order: aspose.imaging.MatrixOrder):
        '''Translates the local geometric transform by the specified dimensions in the specified order.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.
        :param order: The order (prepend or append) in which to apply the translation.'''
        ...
    
    @overload
    def scale_transform(self, sx: float, sy: float):
        '''Scales the local geometric transform by the specified amounts. This method prepends the scaling matrix to the transform.
        
        :param sx: The amount by which to scale the transform in the x-axis direction.
        :param sy: The amount by which to scale the transform in the y-axis direction.'''
        ...
    
    @overload
    def scale_transform(self, sx: float, sy: float, order: aspose.imaging.MatrixOrder):
        '''Scales the local geometric transform by the specified amounts in the specified order.
        
        :param sx: The amount by which to scale the transform in the x-axis direction.
        :param sy: The amount by which to scale the transform in the y-axis direction.
        :param order: A  that specifies whether to append or prepend the scaling matrix.'''
        ...
    
    @overload
    def rotate_transform(self, angle: float):
        '''Rotates the local geometric transform by the specified amount. This method prepends the rotation to the transform.
        
        :param angle: The angle of rotation.'''
        ...
    
    @overload
    def rotate_transform(self, angle: float, order: aspose.imaging.MatrixOrder):
        '''Rotates the local geometric transform by the specified amount in the specified order.
        
        :param angle: The angle of rotation.
        :param order: A  that specifies whether to append or prepend the rotation matrix.'''
        ...
    
    @overload
    def draw_line(self, pen: aspose.imaging.Pen, point1: aspose.imaging.Point, point2: aspose.imaging.Point):
        '''Draws a line connecting two  structures.
        
        :param pen: that determines the color, width, and style of the line.
        :param point1: structure that represents the first point to connect.
        :param point2: structure that represents the second point to connect.'''
        ...
    
    @overload
    def draw_line(self, pen: aspose.imaging.Pen, point1: aspose.imaging.PointF, point2: aspose.imaging.PointF):
        '''Draws a line connecting two  structures.
        
        :param pen: that determines the color, width, and style of the line.
        :param point1: structure that represents the first point to connect.
        :param point2: structure that represents the second point to connect.'''
        ...
    
    @overload
    def draw_line(self, pen: aspose.imaging.Pen, x1: int, y1: int, x2: int, y2: int):
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        ...
    
    @overload
    def draw_line(self, pen: aspose.imaging.Pen, x1: float, y1: float, x2: float, y2: float):
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        ...
    
    @overload
    def draw_lines(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a series of line segments that connect an array of  structures.
        
        :param pen: that determines the color, width, and style of the line segments.
        :param points: Array of  structures that represent the points to connect.'''
        ...
    
    @overload
    def draw_lines(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a series of line segments that connect an array of  structures.
        
        :param pen: that determines the color, width, and style of the line segments.
        :param points: Array of  structures that represent the points to connect.'''
        ...
    
    @overload
    def fill_rectangle(self, brush: aspose.imaging.Brush, rect: aspose.imaging.Rectangle):
        '''Fills the interior of a rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the rectangle to fill.'''
        ...
    
    @overload
    def fill_rectangle(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF):
        '''Fills the interior of a rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the rectangle to fill.'''
        ...
    
    @overload
    def fill_rectangle(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float):
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        ...
    
    @overload
    def fill_rectangle(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int):
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        ...
    
    @overload
    def fill_rectangles(self, brush: aspose.imaging.Brush, rects: List[aspose.imaging.Rectangle]):
        '''Fills the interiors of a series of rectangles specified by  structures.
        
        :param brush: that determines the characteristics of the fill.
        :param rects: Array of  structures that represent the rectangles to fill.'''
        ...
    
    @overload
    def fill_rectangles(self, brush: aspose.imaging.Brush, rects: List[aspose.imaging.RectangleF]):
        '''Fills the interiors of a series of rectangles specified by  structures.
        
        :param brush: that determines the characteristics of the fill.
        :param rects: Array of  structures that represent the rectangles to fill.'''
        ...
    
    @overload
    def draw_rectangle(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF):
        '''Draws a rectangle specified by a  structure.
        
        :param pen: A  that determines the color, width, and style of the rectangle.
        :param rect: A  structure that represents the rectangle to draw.'''
        ...
    
    @overload
    def draw_rectangle(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle):
        '''Draws a rectangle specified by a  structure.
        
        :param pen: A  that determines the color, width, and style of the rectangle.
        :param rect: A  structure that represents the rectangle to draw.'''
        ...
    
    @overload
    def draw_rectangle(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float):
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: A  that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: The width of the rectangle to draw.
        :param height: The height of the rectangle to draw.'''
        ...
    
    @overload
    def draw_rectangle(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int):
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: Width of the rectangle to draw.
        :param height: Height of the rectangle to draw.'''
        ...
    
    @overload
    def draw_rectangles(self, pen: aspose.imaging.Pen, rects: List[aspose.imaging.RectangleF]):
        '''Draws a series of rectangles specified by  structures.
        
        :param pen: that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of  structures that represent the rectangles to draw.'''
        ...
    
    @overload
    def draw_rectangles(self, pen: aspose.imaging.Pen, rects: List[aspose.imaging.Rectangle]):
        '''Draws a series of rectangles specified by  structures.
        
        :param pen: that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of  structures that represent the rectangles to draw.'''
        ...
    
    @overload
    def draw_ellipse(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF):
        '''Draws an ellipse defined by a bounding .
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param rect: structure that defines the boundaries of the ellipse.'''
        ...
    
    @overload
    def draw_ellipse(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float):
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def draw_ellipse(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle):
        '''Draws an ellipse specified by a bounding  structure.
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param rect: structure that defines the boundaries of the ellipse.'''
        ...
    
    @overload
    def draw_ellipse(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int):
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def draw_polygon(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a polygon defined by an array of  structures.
        
        :param pen: that determines the color, width, and style of the polygon.
        :param points: Array of  structures that represent the vertices of the polygon.'''
        ...
    
    @overload
    def draw_polygon(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a polygon defined by an array of  structures.
        
        :param pen: that determines the color, width, and style of the polygon.
        :param points: Array of  structures that represent the vertices of the polygon.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, point: aspose.imaging.PointF):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that represents the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, x: float, y: float):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect: aspose.imaging.RectangleF):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: structure that specifies the location and size of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle to draw in.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.Rectangle, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.RectangleF, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.Rectangle, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.RectangleF, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The source rectangle.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit to use.
        :param image_attributes: The image attributes to use.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point]):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle, src_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle, src_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF]):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, src_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        ...
    
    @overload
    def draw_image(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, src_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, x: float, y: float, width: float, height: float):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, point: aspose.imaging.Point):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that represents the location of the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, x: int, y: int):
        '''Draws the specified image, using its original physical size, at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, rect: aspose.imaging.Rectangle):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: structure that specifies the location and size of the drawn image.'''
        ...
    
    @overload
    def draw_image(self, source_image: aspose.imaging.Image, x: int, y: int, width: int, height: int):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        ...
    
    @overload
    def draw_image_unscaled(self, source_image: aspose.imaging.Image, point: aspose.imaging.Point):
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that specifies the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image_unscaled(self, source_image: aspose.imaging.Image, x: int, y: int):
        '''Draws the specified image using its original physical size at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        ...
    
    @overload
    def draw_image_unscaled(self, source_image: aspose.imaging.Image, rect: aspose.imaging.Rectangle):
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param rect: that specifies the upper-left corner of the drawn image. The X and Y properties of the rectangle specify the upper-left corner. The Width and Height properties are ignored.'''
        ...
    
    @overload
    def draw_image_unscaled(self, source_image: aspose.imaging.Image, x: int, y: int, width: int, height: int):
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: The parameter is not used.
        :param height: The parameter is not used.'''
        ...
    
    @overload
    def draw_arc(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    @overload
    def draw_arc(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a  structure.
        
        :param pen: that determines the color, width, and style of the arc.
        :param rect: structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    @overload
    def draw_arc(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    @overload
    def draw_arc(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a  structure.
        
        :param pen: that determines the color, width, and style of the arc.
        :param rect: structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    @overload
    def draw_pie(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a  structure and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    @overload
    def draw_pie(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    @overload
    def draw_pie(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a  structure and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    @overload
    def draw_pie(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a cardinal spline through a specified array of  structures. This method uses a default tension of 0.5.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that represent the points that define the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], offset: int, number_of_segments: int):
        '''Draws a cardinal spline through a specified array of  structures. The drawing begins offset from the beginning of the array.
        This method uses a default tension of 0.5.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], offset: int, number_of_segments: int, tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension. The drawing begins offset from the beginning of the array.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a cardinal spline through a specified array of  structures.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], offset: int, number_of_segments: int, tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_closed_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a closed cardinal spline defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def draw_closed_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], tension: float):
        '''Draws a closed cardinal spline defined by an array of  structures using a specified tension. This method uses a default  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_closed_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a closed cardinal spline defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def draw_closed_curve(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], tension: float):
        '''Draws a closed cardinal spline defined by an array of  structures using a specified tension. This method uses a default  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def draw_bezier(self, pen: aspose.imaging.Pen, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float, x4: float, y4: float):
        '''Draws a Bézier spline defined by four ordered pairs of coordinates that represent points.
        
        :param pen: that determines the color, width, and style of the curve.
        :param x1: The x-coordinate of the starting point of the curve.
        :param y1: The y-coordinate of the starting point of the curve.
        :param x2: The x-coordinate of the first control point of the curve.
        :param y2: The y-coordinate of the first control point of the curve.
        :param x3: The x-coordinate of the second control point of the curve.
        :param y3: The y-coordinate of the second control point of the curve.
        :param x4: The x-coordinate of the ending point of the curve.
        :param y4: The y-coordinate of the ending point of the curve.'''
        ...
    
    @overload
    def draw_bezier(self, pen: aspose.imaging.Pen, pt1: aspose.imaging.PointF, pt2: aspose.imaging.PointF, pt3: aspose.imaging.PointF, pt4: aspose.imaging.PointF):
        '''Draws a Bézier spline defined by four  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param pt1: structure that represents the starting point of the curve.
        :param pt2: structure that represents the first control point for the curve.
        :param pt3: structure that represents the second control point for the curve.
        :param pt4: structure that represents the ending point of the curve.'''
        ...
    
    @overload
    def draw_bezier(self, pen: aspose.imaging.Pen, pt1: aspose.imaging.Point, pt2: aspose.imaging.Point, pt3: aspose.imaging.Point, pt4: aspose.imaging.Point):
        '''Draws a Bézier spline defined by four  structures.
        
        :param pen: structure that determines the color, width, and style of the curve.
        :param pt1: structure that represents the starting point of the curve.
        :param pt2: structure that represents the first control point for the curve.
        :param pt3: structure that represents the second control point for the curve.
        :param pt4: structure that represents the ending point of the curve.'''
        ...
    
    @overload
    def draw_beziers(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a series of Bézier splines from an array of  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param points: Array of  structures that represent the points that determine the curve.'''
        ...
    
    @overload
    def draw_beziers(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a series of Bézier splines from an array of  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param points: Array of  structures that represent the points that determine the curve.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, x: float, y: float):
        '''Draws the specified text string at the specified location with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, point: aspose.imaging.PointF):
        '''Draws the specified text string at the specified location with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param point: structure that specifies the upper-left corner of the drawn text.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, x: float, y: float, format: aspose.imaging.StringFormat):
        '''Draws the specified text string at the specified location with the specified  and  objects using the formatting attributes of the specified .
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.
        :param format: that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, point: aspose.imaging.PointF, format: aspose.imaging.StringFormat):
        '''Draws the specified text string at the specified location with the specified  and  objects using the formatting attributes of the specified .
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param point: structure that specifies the upper-left corner of the drawn text.
        :param format: that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, layout_rectangle: aspose.imaging.RectangleF):
        '''Draws the specified text string in the specified rectangle with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param layout_rectangle: structure that specifies the location of the drawn text.'''
        ...
    
    @overload
    def draw_string(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, layout_rectangle: aspose.imaging.RectangleF, format: aspose.imaging.StringFormat):
        '''Draws the specified text string in the specified rectangle with the specified  and  objects using the formatting attributes of the specified .
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param layout_rectangle: structure that specifies the location of the drawn text.
        :param format: that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        ...
    
    @overload
    def fill_ellipse(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def fill_ellipse(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def fill_ellipse(self, brush: aspose.imaging.Brush, rect: aspose.imaging.Rectangle):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def fill_ellipse(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    @overload
    def fill_pie(self, brush: aspose.imaging.Brush, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a  structure and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    @overload
    def fill_pie(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a  structure and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    @overload
    def fill_pie(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    @overload
    def fill_pie(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    @overload
    def fill_polygon(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF]):
        '''Fills the interior of a polygon defined by an array of points specified by  structures and .
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.'''
        ...
    
    @overload
    def fill_polygon(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fill_mode: aspose.imaging.FillMode):
        '''Fills the interior of a polygon defined by an array of points specified by  structures using the specified fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the  enumeration that determines the style of the fill.'''
        ...
    
    @overload
    def fill_polygon(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point]):
        '''Fills the interior of a polygon defined by an array of points specified by  structures and .
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.'''
        ...
    
    @overload
    def fill_polygon(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fill_mode: aspose.imaging.FillMode):
        '''Fills the interior of a polygon defined by an array of points specified by  structures using the specified fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the  enumeration that determines the style of the fill.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF]):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fill_mode: aspose.imaging.FillMode):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fill_mode: Member of the  enumeration that determines how the curve is filled.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fillmode: aspose.imaging.FillMode, tension: float):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode and tension.
        
        :param brush: A  that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point]):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fillmode: aspose.imaging.FillMode):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.'''
        ...
    
    @overload
    def fill_closed_curve(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fillmode: aspose.imaging.FillMode, tension: float):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode and tension.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def reset_transform(self):
        '''Resets the  property to identity.'''
        ...
    
    def begin_update(self):
        '''Starts caching of the following graphics operations. The graphics effects applied afterwards will not be applied immediately instead the EndUpdate will cause applying all the effects at once.'''
        ...
    
    def end_update(self):
        '''Finishes caching of the graphics operations started after BeginUpdate was called. The preceding graphics operations will be applied at once when calling this method.'''
        ...
    
    def clear(self, color: aspose.imaging.Color):
        '''Clears the graphics surface using the specified color.
        
        :param color: The color to clear the graphics surface by.'''
        ...
    
    def draw_line_point_f(self, pen: aspose.imaging.Pen, point1: aspose.imaging.PointF, point2: aspose.imaging.PointF):
        '''Draws a line connecting two  structures.
        
        :param pen: that determines the color, width, and style of the line.
        :param point1: structure that represents the first point to connect.
        :param point2: structure that represents the second point to connect.'''
        ...
    
    def draw_line_by_xy(self, pen: aspose.imaging.Pen, x1: int, y1: int, x2: int, y2: int):
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        ...
    
    def draw_line_f_by_xy(self, pen: aspose.imaging.Pen, x1: float, y1: float, x2: float, y2: float):
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        ...
    
    def draw_lines_f(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a series of line segments that connect an array of  structures.
        
        :param pen: that determines the color, width, and style of the line segments.
        :param points: Array of  structures that represent the points to connect.'''
        ...
    
    def fill_rectangle_f(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF):
        '''Fills the interior of a rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the rectangle to fill.'''
        ...
    
    def fill_rectangle_f_with_brush(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float):
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        ...
    
    def fill_rectangle_with_brush(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int):
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        ...
    
    def fill_rectangles_f(self, brush: aspose.imaging.Brush, rects: List[aspose.imaging.RectangleF]):
        '''Fills the interiors of a series of rectangles specified by  structures.
        
        :param brush: that determines the characteristics of the fill.
        :param rects: Array of  structures that represent the rectangles to fill.'''
        ...
    
    def draw_rectangle_f(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF):
        '''Draws a rectangle specified by a  structure.
        
        :param pen: A  that determines the color, width, and style of the rectangle.
        :param rect: A  structure that represents the rectangle to draw.'''
        ...
    
    def draw_rect_f(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float):
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: A  that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: The width of the rectangle to draw.
        :param height: The height of the rectangle to draw.'''
        ...
    
    def draw_rect(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int):
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: Width of the rectangle to draw.
        :param height: Height of the rectangle to draw.'''
        ...
    
    def draw_rectangles_f(self, pen: aspose.imaging.Pen, rects: List[aspose.imaging.RectangleF]):
        '''Draws a series of rectangles specified by  structures.
        
        :param pen: that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of  structures that represent the rectangles to draw.'''
        ...
    
    def draw_ellipse_f(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF):
        '''Draws an ellipse defined by a bounding .
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param rect: structure that defines the boundaries of the ellipse.'''
        ...
    
    def draw_ellipse_by_xyf(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float):
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    def draw_ellipse_by_xy(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int):
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    def draw_polygon_f(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a polygon defined by an array of  structures.
        
        :param pen: that determines the color, width, and style of the polygon.
        :param points: Array of  structures that represent the vertices of the polygon.'''
        ...
    
    def draw_image_at_point_f(self, source_image: aspose.imaging.Image, point: aspose.imaging.PointF):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that represents the upper-left corner of the drawn image.'''
        ...
    
    def draw_image_at_xyf(self, source_image: aspose.imaging.Image, x: float, y: float):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        ...
    
    def draw_image_rectangle_f(self, source_image: aspose.imaging.Image, rect: aspose.imaging.RectangleF):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: structure that specifies the location and size of the drawn image.'''
        ...
    
    def draw_image_to_rect_with_unit(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        ...
    
    def draw_image_to_rect_f_with_unit(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        ...
    
    def draw_image_dest_rect_with_unit_attribs(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    def draw_image_dest_rect_f_with_unit_attribs(self, source_image: aspose.imaging.Image, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle to draw in.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    def draw_image_src_dest_rects_with_unit(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.Rectangle, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        ...
    
    def draw_image_src_dest_rects_f_with_unit(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.RectangleF, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        ...
    
    def draw_image_src_dst_rects_with_unit_and_attribs(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.Rectangle, rect_destination: aspose.imaging.Rectangle, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        ...
    
    def draw_image_src_dst_rect_f_with_unit_and_attribs(self, source_image: aspose.imaging.Image, rect_source: aspose.imaging.RectangleF, rect_destination: aspose.imaging.RectangleF, graphics_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The source rectangle.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit to use.
        :param image_attributes: The image attributes to use.'''
        ...
    
    def draw_image_points(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point]):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        ...
    
    def draw_image_dest_points_src_rect(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        ...
    
    def draw_image_dest_points_src_rect_with_unit(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle, src_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        ...
    
    def draw_image_dest_points_src_rect_with_unit_and_attribs(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.Point], src_rect: aspose.imaging.Rectangle, src_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        ...
    
    def draw_image_points_f(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF]):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        ...
    
    def draw_image_dest_points_f_src_rect_f(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        ...
    
    def draw_image_dest_point_f_src_rect_f_with_unit(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, src_unit: aspose.imaging.GraphicsUnit):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        ...
    
    def draw_image_dest_point_f_src_rect_f_with_unit_and_attribs(self, image: aspose.imaging.Image, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, src_unit: aspose.imaging.GraphicsUnit, image_attributes: aspose.imaging.ImageAttributes):
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        ...
    
    def draw_image_in_rect_f(self, source_image: aspose.imaging.Image, x: float, y: float, width: float, height: float):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        ...
    
    def draw_image_at_point(self, source_image: aspose.imaging.Image, point: aspose.imaging.Point):
        '''Draws the specified , using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that represents the location of the upper-left corner of the drawn image.'''
        ...
    
    def draw_image_at_xy(self, source_image: aspose.imaging.Image, x: int, y: int):
        '''Draws the specified image, using its original physical size, at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        ...
    
    def draw_image_in_rectangle(self, source_image: aspose.imaging.Image, rect: aspose.imaging.Rectangle):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: structure that specifies the location and size of the drawn image.'''
        ...
    
    def draw_image_in_rect(self, source_image: aspose.imaging.Image, x: int, y: int, width: int, height: int):
        '''Draws the specified  at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        ...
    
    def draw_image_unscaled_to_point(self, source_image: aspose.imaging.Image, point: aspose.imaging.Point):
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param point: structure that specifies the upper-left corner of the drawn image.'''
        ...
    
    def draw_image_unscaled_in_rectangle(self, source_image: aspose.imaging.Image, rect: aspose.imaging.Rectangle):
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param rect: that specifies the upper-left corner of the drawn image. The X and Y properties of the rectangle specify the upper-left corner. The Width and Height properties are ignored.'''
        ...
    
    def draw_image_unscaled_and_clipped(self, source_image: aspose.imaging.Image, rect: aspose.imaging.Rectangle):
        '''Draws the specified image without scaling and clips it, if necessary, to fit in the specified rectangle.
        
        :param source_image: The image to draw with.
        :param rect: The  in which to draw the image.'''
        ...
    
    def draw_arc_xyf(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    def draw_arc_in_rect_f(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a  structure.
        
        :param pen: that determines the color, width, and style of the arc.
        :param rect: structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    def draw_arc_xy(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    def draw_arc_in_rect(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Draws an arc representing a portion of an ellipse specified by a  structure.
        
        :param pen: that determines the color, width, and style of the arc.
        :param rect: structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        ...
    
    def draw_pie_in_rect_f(self, pen: aspose.imaging.Pen, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a  structure and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    def draw_pie_xyf(self, pen: aspose.imaging.Pen, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    def draw_pie_in_rect(self, pen: aspose.imaging.Pen, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Draws a pie shape defined by an ellipse specified by a  structure and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    def draw_pie_xy(self, pen: aspose.imaging.Pen, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        ...
    
    def draw_curve_by_points(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a cardinal spline through a specified array of  structures. This method uses a default tension of 0.5.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def draw_curve_by_point_fs_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that represent the points that define the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_curve_by_points_f_offs_num_segm_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], offset: int, number_of_segments: int, tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension. The drawing begins offset from the beginning of the array.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_curve_by_point_fs(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a cardinal spline through a specified array of  structures.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def draw_curve_by_points_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_curve_by_points_offs_num_segm_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], offset: int, number_of_segments: int, tension: float):
        '''Draws a cardinal spline through a specified array of  structures using a specified tension.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_closed_curve_by_points_f(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a closed cardinal spline defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def draw_closed_curve_by_points_f_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF], tension: float):
        '''Draws a closed cardinal spline defined by an array of  structures using a specified tension. This method uses a default  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_closed_curve_by_points(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a closed cardinal spline defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def draw_closed_curve_by_points_tension(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point], tension: float):
        '''Draws a closed cardinal spline defined by an array of  structures using a specified tension. This method uses a default  fill mode.
        
        :param pen: that determines the color, width, and height of the curve.
        :param points: Array of  structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_bezier_by_points_f(self, pen: aspose.imaging.Pen, pt1: aspose.imaging.PointF, pt2: aspose.imaging.PointF, pt3: aspose.imaging.PointF, pt4: aspose.imaging.PointF):
        '''Draws a Bézier spline defined by four  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param pt1: structure that represents the starting point of the curve.
        :param pt2: structure that represents the first control point for the curve.
        :param pt3: structure that represents the second control point for the curve.
        :param pt4: structure that represents the ending point of the curve.'''
        ...
    
    def draw_bezier_by_points(self, pen: aspose.imaging.Pen, pt1: aspose.imaging.Point, pt2: aspose.imaging.Point, pt3: aspose.imaging.Point, pt4: aspose.imaging.Point):
        '''Draws a Bézier spline defined by four  structures.
        
        :param pen: structure that determines the color, width, and style of the curve.
        :param pt1: structure that represents the starting point of the curve.
        :param pt2: structure that represents the first control point for the curve.
        :param pt3: structure that represents the second control point for the curve.
        :param pt4: structure that represents the ending point of the curve.'''
        ...
    
    def draw_beziers_by_pt_array(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.Point]):
        '''Draws a series of Bézier splines from an array of  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param points: Array of  structures that represent the points that determine the curve.'''
        ...
    
    def draw_beziers_by_pt_array_f(self, pen: aspose.imaging.Pen, points: List[aspose.imaging.PointF]):
        '''Draws a series of Bézier splines from an array of  structures.
        
        :param pen: that determines the color, width, and style of the curve.
        :param points: Array of  structures that represent the points that determine the curve.'''
        ...
    
    def draw_string_at_xy(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, x: float, y: float):
        '''Draws the specified text string at the specified location with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.'''
        ...
    
    def draw_string_at_point_f(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, point: aspose.imaging.PointF):
        '''Draws the specified text string at the specified location with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param point: structure that specifies the upper-left corner of the drawn text.'''
        ...
    
    def draw_string_at_point_f_format(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, point: aspose.imaging.PointF, format: aspose.imaging.StringFormat):
        '''Draws the specified text string at the specified location with the specified  and  objects using the formatting attributes of the specified .
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param point: structure that specifies the upper-left corner of the drawn text.
        :param format: that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        ...
    
    def draw_string_in_rect(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, layout_rectangle: aspose.imaging.RectangleF):
        '''Draws the specified text string in the specified rectangle with the specified  and  objects.
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param layout_rectangle: structure that specifies the location of the drawn text.'''
        ...
    
    def draw_string_in_rect_f(self, s: str, font: aspose.imaging.Font, brush: aspose.imaging.Brush, layout_rectangle: aspose.imaging.RectangleF, format: aspose.imaging.StringFormat):
        '''Draws the specified text string in the specified rectangle with the specified  and  objects using the formatting attributes of the specified .
        
        :param s: String to draw.
        :param font: that defines the text format of the string.
        :param brush: that determines the color and texture of the drawn text.
        :param layout_rectangle: structure that specifies the location of the drawn text.
        :param format: that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        ...
    
    def fill_ellipse_in_rect_f(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse.'''
        ...
    
    def fill_ellipse_at_xywhf(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    def fill_ellipse_in_rect(self, brush: aspose.imaging.Brush, rect: aspose.imaging.Rectangle):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a  structure.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse.'''
        ...
    
    def fill_ellipse_at_xywh(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int):
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        ...
    
    def fill_pie_in_rect(self, brush: aspose.imaging.Brush, rect: aspose.imaging.Rectangle, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a  structure and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    def fill_pie_in_rect_f(self, brush: aspose.imaging.Brush, rect: aspose.imaging.RectangleF, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a  structure and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param rect: structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    def fill_pie_at_xyf(self, brush: aspose.imaging.Brush, x: float, y: float, width: float, height: float, start_angle: float, sweep_angle: float):
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    def fill_pie_at_xy(self, brush: aspose.imaging.Brush, x: int, y: int, width: int, height: int, start_angle: int, sweep_angle: int):
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        ...
    
    def fill_polygon_by_point_f(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF]):
        '''Fills the interior of a polygon defined by an array of points specified by  structures and .
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.'''
        ...
    
    def fill_polygon_by_point_f_fill_mode(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fill_mode: aspose.imaging.FillMode):
        '''Fills the interior of a polygon defined by an array of points specified by  structures using the specified fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the  enumeration that determines the style of the fill.'''
        ...
    
    def fill_polygon_by_point(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point]):
        '''Fills the interior of a polygon defined by an array of points specified by  structures and .
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.'''
        ...
    
    def fill_polygon_by_point_fill_mode(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fill_mode: aspose.imaging.FillMode):
        '''Fills the interior of a polygon defined by an array of points specified by  structures using the specified fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the  enumeration that determines the style of the fill.'''
        ...
    
    def fill_closed_curve_by_point_f(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF]):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def fill_closed_curve_by_point_f_fill_mode(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fillmode: aspose.imaging.FillMode):
        ...
    
    def fill_closed_curve_by_point_f_fill_mode_tension(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.PointF], fillmode: aspose.imaging.FillMode, tension: float):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode and tension.
        
        :param brush: A  that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def fill_closed_curve_by_point(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point]):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures. This method uses a default tension of 0.5 and  fill mode.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.'''
        ...
    
    def fill_closed_curve_by_point_fill_mode(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fillmode: aspose.imaging.FillMode):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.'''
        ...
    
    def fill_closed_curve_by_point_fill_mode_tension(self, brush: aspose.imaging.Brush, points: List[aspose.imaging.Point], fillmode: aspose.imaging.FillMode, tension: float):
        '''Fills the interior of a closed cardinal spline curve defined by an array of  structures using the specified fill mode and tension.
        
        :param brush: that determines the characteristics of the fill.
        :param points: Array of  structures that define the spline.
        :param fillmode: Member of the  enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        ...
    
    def draw_path(self, pen: aspose.imaging.Pen, path: aspose.imaging.GraphicsPath):
        '''Draws a .
        
        :param pen: that determines the color, width, and style of the path.
        :param path: to draw.'''
        ...
    
    def fill_path(self, brush: aspose.imaging.Brush, path: aspose.imaging.GraphicsPath):
        '''Fills the interior of a .
        
        :param brush: that determines the characteristics of the fill.
        :param path: that represents the path to fill.'''
        ...
    
    def fill_region(self, brush: aspose.imaging.Brush, region: aspose.imaging.Region):
        '''Fills the interior of a .
        
        :param brush: that determines the characteristics of the fill.
        :param region: that represents the area to fill.'''
        ...
    
    def measure_string(self, text: str, font: aspose.imaging.Font, layout_area: aspose.imaging.SizeF, string_format: aspose.imaging.StringFormat) -> aspose.imaging.SizeF:
        '''Measures the specified text string with specified parameters
        
        :param text: The text to measure.
        :param font: The font to measure.
        :param layout_area: The layout area.
        :param string_format: The string format.
        :returns: Size in pixels of measured text string'''
        ...
    
    @property
    def dpi_x(self) -> float:
        ...
    
    @property
    def dpi_y(self) -> float:
        ...
    
    @property
    def page_unit(self) -> aspose.imaging.GraphicsUnit:
        ...
    
    @page_unit.setter
    def page_unit(self, value : aspose.imaging.GraphicsUnit):
        ...
    
    @property
    def page_scale(self) -> float:
        ...
    
    @page_scale.setter
    def page_scale(self, value : float):
        ...
    
    @property
    def clip(self) -> aspose.imaging.Region:
        '''Gets the clip region.'''
        ...
    
    @clip.setter
    def clip(self, value : aspose.imaging.Region):
        '''Sets the clip region.'''
        ...
    
    @property
    def transform(self) -> aspose.imaging.Matrix:
        '''Gets a copy of the geometric world transformation for this .'''
        ...
    
    @transform.setter
    def transform(self, value : aspose.imaging.Matrix):
        '''Sets a copy of the geometric world transformation for this .'''
        ...
    
    @property
    def is_in_begin_update_call(self) -> bool:
        ...
    
    @property
    def image(self) -> aspose.imaging.Image:
        '''Gets the image.'''
        ...
    
    @property
    def compositing_quality(self) -> aspose.imaging.CompositingQuality:
        ...
    
    @compositing_quality.setter
    def compositing_quality(self, value : aspose.imaging.CompositingQuality):
        ...
    
    @property
    def interpolation_mode(self) -> aspose.imaging.InterpolationMode:
        ...
    
    @interpolation_mode.setter
    def interpolation_mode(self, value : aspose.imaging.InterpolationMode):
        ...
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        ...
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode):
        ...
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        ...
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint):
        ...
    
    @property
    def paintable_image_options(self) -> aspose.imaging.ImageOptionsBase:
        ...
    
    @paintable_image_options.setter
    def paintable_image_options(self, value : aspose.imaging.ImageOptionsBase):
        ...
    
    ...

class GraphicsPath(ObjectWithBounds):
    '''Represents a series of connected lines and curves. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, figures: List[aspose.imaging.Figure]):
        '''Initializes a new instance of the  class.
        
        :param figures: The figures to initialize from.'''
        ...
    
    @overload
    def __init__(self, figures: List[aspose.imaging.Figure], fill_mode: aspose.imaging.FillMode):
        '''Initializes a new instance of the  class.
        
        :param figures: The figures to initialize from.
        :param fill_mode: The fill mode.'''
        ...
    
    @overload
    def __init__(self, fill_mode: aspose.imaging.FillMode):
        '''Initializes a new instance of the  class.
        
        :param fill_mode: The fill mode.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object's bounds.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix, pen: aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object's bounds size.
        :returns: The estimated object's bounds.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.PointF) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param point: A  that represents the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: int, y: int) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.Point) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param point: A  that represents the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this  in the visible clip region of the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, pt: aspose.imaging.PointF, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param pt: A  that represents the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: int, y: int, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this , using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, pt: aspose.imaging.Point, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param pt: A  that represents the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, x: float, y: float, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, point: aspose.imaging.PointF, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param point: A  that specifies the location to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, x: float, y: float, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, pt: aspose.imaging.PointF, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param pt: A  that specifies the location to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, x: int, y: int, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, point: aspose.imaging.Point, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param point: A  that specifies the location to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, x: int, y: int, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def is_outline_visible(self, pt: aspose.imaging.Point, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param pt: A  that specifies the location to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    @overload
    def flatten(self):
        '''Converts each curve in this path into a sequence of connected line segments.'''
        ...
    
    @overload
    def flatten(self, matrix: aspose.imaging.Matrix):
        '''Applies the specified transform and then converts each curve in this  into a sequence of connected line segments.
        
        :param matrix: A  by which to transform this  before flattening.'''
        ...
    
    @overload
    def flatten(self, matrix: aspose.imaging.Matrix, flatness: float):
        '''Converts each curve in this  into a sequence of connected line segments.
        
        :param matrix: A  by which to transform this  before flattening.
        :param flatness: Specifies the maximum permitted error between the curve and its flattened approximation. A value of 0.25 is the default. Reducing the flatness value will increase the number of line segments in the approximation.'''
        ...
    
    @overload
    def widen(self, pen: aspose.imaging.Pen):
        '''Adds an additional outline to the path.
        
        :param pen: A  that specifies the width between the original outline of the path and the new outline this method creates.'''
        ...
    
    @overload
    def widen(self, pen: aspose.imaging.Pen, matrix: aspose.imaging.Matrix):
        '''Adds an additional outline to the .
        
        :param pen: A  that specifies the width between the original outline of the path and the new outline this method creates.
        :param matrix: A  that specifies a transform to apply to the path before widening.'''
        ...
    
    @overload
    def widen(self, pen: aspose.imaging.Pen, matrix: aspose.imaging.Matrix, flatness: float):
        '''Replaces this  with curves that enclose the area that is filled when this path is drawn by the specified pen.
        
        :param pen: A  that specifies the width between the original outline of the path and the new outline this method creates.
        :param matrix: A  that specifies a transform to apply to the path before widening.
        :param flatness: A value that specifies the flatness for curves.'''
        ...
    
    @overload
    def warp(self, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF):
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this .
        
        :param dest_points: An array of  structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A  that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.'''
        ...
    
    @overload
    def warp(self, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, matrix: aspose.imaging.Matrix):
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this .
        
        :param dest_points: An array of  structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A  that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A  that specifies a geometric transform to apply to the path.'''
        ...
    
    @overload
    def warp(self, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, matrix: aspose.imaging.Matrix, warp_mode: aspose.imaging.WarpMode):
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this .
        
        :param dest_points: An array of  structures that defines a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A  that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A  that specifies a geometric transform to apply to the path.
        :param warp_mode: A  enumeration that specifies whether this warp operation uses perspective or bilinear mode.'''
        ...
    
    @overload
    def warp(self, dest_points: List[aspose.imaging.PointF], src_rect: aspose.imaging.RectangleF, matrix: aspose.imaging.Matrix, warp_mode: aspose.imaging.WarpMode, flatness: float):
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this .
        
        :param dest_points: An array of  structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A  that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A  that specifies a geometric transform to apply to the path.
        :param warp_mode: A  enumeration that specifies whether this warp operation uses perspective or bilinear mode.
        :param flatness: A value from 0 through 1 that specifies how flat the resulting path is. For more information, see the  methods.'''
        ...
    
    @overload
    def add_path(self, adding_path: aspose.imaging.GraphicsPath):
        '''Appends the specified  to this path.
        
        :param adding_path: The  to add.'''
        ...
    
    @overload
    def add_path(self, adding_path: aspose.imaging.GraphicsPath, connect: bool):
        '''Appends the specified  to this path.
        
        :param adding_path: The  to add.
        :param connect: A Boolean value that specifies whether the first figure in the added path is part of the last figure in this path. A value of true specifies that the first figure in the added path is part of the last figure in this path. A value of false specifies that the first figure in the added path is separate from the last figure in this path.'''
        ...
    
    def transform(self, transform: aspose.imaging.Matrix):
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        ...
    
    def reset(self):
        '''Empties the graphics path and sets the  to .'''
        ...
    
    def reverse(self):
        '''Reverses the order of figures, shapes, and points in each shape of this .'''
        ...
    
    def is_visible_xyf(self, x: float, y: float) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_f(self, point: aspose.imaging.PointF) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param point: A  that represents the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xy(self, x: int, y: int) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point(self, point: aspose.imaging.Point) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param point: A  that represents the point to test.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xyf_graphics(self, x: float, y: float, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this  in the visible clip region of the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_f_graphics(self, pt: aspose.imaging.PointF, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param pt: A  that represents the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this; otherwise, false.'''
        ...
    
    def is_visible_xy_graphics(self, x: int, y: int, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this , using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_graphics(self, pt: aspose.imaging.Point, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this .
        
        :param pt: A  that represents the point to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_outline_visible_xyf(self, x: float, y: float, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_point_f(self, point: aspose.imaging.PointF, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param point: A  that specifies the location to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_xyf_graphics(self, x: float, y: float, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_point_f_graphics(self, pt: aspose.imaging.PointF, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param pt: A  that specifies the location to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_xy(self, x: int, y: int, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_point(self, point: aspose.imaging.Point, pen: aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified .
        
        :param point: A  that specifies the location to test.
        :param pen: The  to test.
        :returns: This method returns true if the specified point is contained within the outline of this  when drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_xy_graphics(self, x: int, y: int, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    def is_outline_visible_point_graphics(self, pt: aspose.imaging.Point, pen: aspose.imaging.Pen, graphics: aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this  when drawn with the specified  and using the specified .
        
        :param pt: A  that specifies the location to test.
        :param pen: The  to test.
        :param graphics: The  for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this  as drawn with the specified ; otherwise, false.'''
        ...
    
    def add_figure(self, figure: aspose.imaging.Figure):
        '''Adds a new figure.
        
        :param figure: The figure to add.'''
        ...
    
    def add_figures(self, figures: List[aspose.imaging.Figure]):
        '''Adds new figures.
        
        :param figures: The figures to add.'''
        ...
    
    def remove_figure(self, figure: aspose.imaging.Figure):
        '''Removes a figure.
        
        :param figure: The figure to remove.'''
        ...
    
    def remove_figures(self, figures: List[aspose.imaging.Figure]):
        '''Removes figures.
        
        :param figures: The figures to remove.'''
        ...
    
    def deep_clone(self) -> aspose.imaging.GraphicsPath:
        '''Performs a deep clone of this graphics path.
        
        :returns: A deep clone of the graphics path.'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.'''
        ...
    
    @property
    def fill_mode(self) -> aspose.imaging.FillMode:
        ...
    
    @fill_mode.setter
    def fill_mode(self, value : aspose.imaging.FillMode):
        ...
    
    @property
    def figures(self) -> List[aspose.imaging.Figure]:
        '''Gets the path figures.'''
        ...
    
    ...

class IAdvancedBufferProcessor(IBufferProcessor):
    '''The advanced buffer processor.'''
    
    def finish_row(self):
        '''Finishes the row.'''
        ...
    
    def finish_rows(self, rows_count: int):
        '''Finishes the rows.
        
        :param rows_count: The rows count.'''
        ...
    
    def process_buffer(self, buffer: bytes, buffer_length: int):
        '''Processes the buffer.
        
        :param buffer: The buffer to process.
        :param buffer_length: The buffer length to process.'''
        ...
    
    ...

class IAnimationFrame:
    '''The Animation frame'''
    
    def get_full_frame(self) -> aspose.imaging.RasterImage:
        '''Gets the full frame.
        
        :returns: The RasterImage with full frame'''
        ...
    
    @property
    def frame_time(self) -> int:
        ...
    
    @property
    def frame_top(self) -> int:
        ...
    
    @property
    def frame_left(self) -> int:
        ...
    
    @property
    def use_alpha_blending(self) -> bool:
        ...
    
    @property
    def disposal_method(self) -> aspose.imaging.AnimationDisposalMethods:
        ...
    
    ...

class IBufferProcessor:
    '''The buffer processor.'''
    
    def process_buffer(self, buffer: bytes, buffer_length: int):
        '''Processes the buffer.
        
        :param buffer: The buffer to process.
        :param buffer_length: The buffer length to process.'''
        ...
    
    ...

class IColorConverter:
    '''The color converter.'''
    
    def convert(self, source_format: aspose.imaging.PixelDataFormat, data: bytes, offset: int, bit_start: int, samples_count: int, lines_count: int, dest_format: aspose.imaging.PixelDataFormat, output_data: bytes, output_offset: int) -> int:
        '''Converts the passed data to the output format.
        
        :param source_format: The source format.
        :param data: The source data.
        :param offset: The offset in bytes where data copying should begin.
        :param bit_start: The bit start. Note this value is not byte aligned value instead this is actual bit where copying should begin.
        :param samples_count: The samples count.
        :param lines_count: The lines count.
        :param dest_format: The destination format.
        :param output_data: The output data.
        :param output_offset: The output offset where data copying should start.
        :returns: The converted bytes count.'''
        ...
    
    ...

class IColorPalette:
    '''The color palette interface.'''
    
    @overload
    def get_nearest_color_index(self, argb_32_color: int) -> int:
        '''Gets the index of the nearest 32-bit ARGB color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        ...
    
    @overload
    def get_nearest_color_index(self, color: aspose.imaging.Color) -> int:
        '''Gets the index of the nearest color.
        
        :param color: The color.
        :returns: The index of the nearest color.'''
        ...
    
    def get_argb_32_color(self, index: int) -> int:
        '''Gets the 32-bit ARGB palette color by index.
        
        :param index: The 32-bit ARGB palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        ...
    
    def get_color(self, index: int) -> aspose.imaging.Color:
        '''Gets the palette color by index.
        
        :param index: The palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        ...
    
    @property
    def entries_count(self) -> int:
        ...
    
    @property
    def argb_32_entries(self) -> List[int]:
        ...
    
    @property
    def entries(self) -> List[aspose.imaging.Color]:
        '''Gets an array of  structures.'''
        ...
    
    @property
    def is_compact_palette(self) -> bool:
        ...
    
    ...

class IHasMetadata:
    '''Image metadata interface.'''
    
    ...

class IImageCreator:
    '''The image creator.'''
    
    def create(self, stream_container: aspose.imaging.StreamContainer, image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image instance with ``imageOptions``.
        
        :param stream_container: The stream container to create image data in.
        :param image_options: The image options.
        :param width: width of new image
        :param height: height of new image
        :returns: A new image instance.'''
        ...
    
    ...

class IImageCreatorDescriptor(IImageDescriptor):
    '''The image creator descriptor specifying the creator properties. The creator descriptor is used to overcome
    the necessity to contain each image creator instance in memory and multithreading issues.'''
    
    def can_create(self, image_options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image creator can create a new image using the ``imageOptions``.
        
        :param image_options: The image options.
        :returns: ``True`` if image creator created by this descriptor can create image data using the specified ``imageOptions``; otherwise, ``false``.'''
        ...
    
    def create_instance(self) -> aspose.imaging.IImageCreator:
        '''Creates a new creator instance.
        
        :returns: A new creator instance.'''
        ...
    
    @property
    def supported_format(self) -> aspose.imaging.FileFormat:
        ...
    
    ...

class IImageDescriptor:
    '''The image descriptor. Contains base properties and methods for all other image descriptor types.'''
    
    @property
    def supported_format(self) -> aspose.imaging.FileFormat:
        ...
    
    ...

class IImageExporter:
    '''The image exporter. Can export data from internal Aspose.Imaging format to a specified data format.'''
    
    @overload
    def export(self, image: aspose.imaging.Image, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Exports the specified image data into specified data format.
        
        :param image: The image data to export.
        :param stream: The stream to export data to.
        :param options_base: Options for image export'''
        ...
    
    @overload
    def export(self, image: aspose.imaging.Image, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Exports the specified image data into specified data format.
        
        :param image: The image data to export.
        :param stream: The stream to export data to.
        :param options_base: Options for image export
        :param bounds_rectangle: The bounds rectangle.'''
        ...
    
    ...

class IImageExporterDescriptor(IImageDescriptor):
    '''Represents the image exporter descriptor. The exporter descriptor is used to overcome the necessity to contain each exporter instance
    in memory and multithreading issues.'''
    
    def can_export(self, image: aspose.imaging.Image, options_base: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image exporter can export the specified image to the specified image format specified by save options.
        
        :param image: The image to export.
        :param options_base: The options base.
        :returns: ``True`` if exporter created by this descriptor can export the specified image to the specified file format; otherwise, ``false``.'''
        ...
    
    def create_instance(self) -> aspose.imaging.IImageExporter:
        '''Creates a new exporter instance.
        
        :returns: A new exporter instance.'''
        ...
    
    @property
    def supported_format(self) -> aspose.imaging.FileFormat:
        ...
    
    ...

class IImageLoader:
    '''The image loader.'''
    
    def load(self, stream_container: aspose.imaging.StreamContainer, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Opens a new image with ``loadOptions``.
        
        :param stream_container: The stream container.
        :param load_options: The load options.
        :returns: A newly opened image instance.'''
        ...
    
    ...

class IImageLoaderDescriptor(IImageDescriptor):
    '''The image loader descriptor specifying the loader properties. The loader descriptor is used to overcome
    the necessity to contain each image loader instance in memory and multithreading issues.'''
    
    def can_load(self, stream_container: aspose.imaging.StreamContainer, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image loader can read a new image from the specified stream and optionally using the ``loadOptions``.
        
        :param stream_container: The stream container.
        :param load_options: The file format details specified by ``loadOptions``. The ``loadOptions`` may be null.
        :returns: ``true`` if image loader created by this descriptor can read image from stream; otherwise, ``false``.'''
        ...
    
    def create_instance(self) -> aspose.imaging.IImageLoader:
        '''Creates a new loader instance.
        
        :returns: A new loader instance.'''
        ...
    
    @property
    def supported_format(self) -> aspose.imaging.FileFormat:
        ...
    
    ...

class IIndexedColorConverter:
    '''The color converter for indexed image formats.'''
    
    def fill_indexedto_indexed_map(self, map: bytes, source_format: aspose.imaging.PixelDataFormat, dest_format: aspose.imaging.PixelDataFormat):
        '''Fills the indexed to indexed image conversion map.
        
        :param map: The conversion map.
        :param source_format: The source format.
        :param dest_format: The destination format.'''
        ...
    
    ...

class IKeyedObject:
    '''Represents interface for objects with keys.'''
    
    @property
    def key(self) -> str:
        '''Gets the object key.'''
        ...
    
    ...

class IMultipageImage:
    '''The multipage image interface'''
    
    @property
    def page_count(self) -> int:
        ...
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        ...
    
    ...

class IMultipageImageExt(IMultipageImage):
    '''The extended multipage image interface'''
    
    def add_page(self, page: aspose.imaging.RasterImage):
        '''Adds page to the image.
        
        :param page: The page to add.'''
        ...
    
    @property
    def page_count(self) -> int:
        ...
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        ...
    
    ...

class IObjectWithBounds:
    '''Represents an object with bounds.'''
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the object size.'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the object bounds.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the object width.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the object height.'''
        ...
    
    ...

class IOrderedShape:
    '''Represents an ordered shape. An ordered shape is a continuous set of points having a start point and end point.
    The continuous set of points connected using a specific rule.'''
    
    def reverse(self):
        '''Reverses the order of points for this shape.'''
        ...
    
    @property
    def start_point(self) -> aspose.imaging.PointF:
        ...
    
    @property
    def end_point(self) -> aspose.imaging.PointF:
        ...
    
    @property
    def is_closed(self) -> bool:
        ...
    
    @is_closed.setter
    def is_closed(self, value : bool):
        ...
    
    ...

class IPartialArgb32PixelLoader:
    '''Conforms to the 32-bit ARGB pixels loaded partially.'''
    
    def process(self, pixels_rectangle: aspose.imaging.Rectangle, pixels: List[int], start: aspose.imaging.Point, end: aspose.imaging.Point):
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The 32-bit ARGB pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        ...
    
    ...

class IPartialArgb64PixelLoader(IPartialArgb32PixelLoader):
    '''The 64-bit ARGB pixels loader.'''
    
    def process64(self, pixels_rectangle: aspose.imaging.Rectangle, pixels: List[int], start: aspose.imaging.Point, end: aspose.imaging.Point):
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The 64-bit ARGB pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        ...
    
    def process(self, pixels_rectangle: aspose.imaging.Rectangle, pixels: List[int], start: aspose.imaging.Point, end: aspose.imaging.Point):
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The 32-bit ARGB pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        ...
    
    ...

class IPartialPixelLoader:
    '''Conforms to the pixels loaded partially.'''
    
    def process(self, pixels_rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.Color], start: aspose.imaging.Point, end: aspose.imaging.Point):
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        ...
    
    ...

class IPartialRawDataLoader:
    '''The partial data loader.'''
    
    @overload
    def process(self, rectangle: aspose.imaging.Rectangle, data: bytes, start: aspose.imaging.Point, end: aspose.imaging.Point):
        '''Processes the loaded data.
        
        :param rectangle: The data rectangle.
        :param data: The raw data.
        :param start: The start data point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end data point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        ...
    
    @overload
    def process(self, rectangle: aspose.imaging.Rectangle, data: bytes, start: aspose.imaging.Point, end: aspose.imaging.Point, load_options: aspose.imaging.LoadOptions):
        '''Processes the loaded data.
        
        :param rectangle: The data rectangle.
        :param data: The raw data.
        :param start: The start data point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end data point. If not equal to (right,bottom) meaning that it is not full rectangle we have.
        :param load_options: The load options.'''
        ...
    
    ...

class IRasterImageArgb32PixelLoader(IRasterImageRawDataLoader):
    '''The raster image 32-bit ARGB pixel loader.'''
    
    def load_partial_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Loads 32-bit ARGB pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    ...

class IRasterImageArgb64PixelLoader(IRasterImageRawDataLoader):
    '''The raster image 64-bit ARGB pixel loader.'''
    
    def load_partial_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb64PixelLoader):
        '''Loads 64-bit ARGB pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    ...

class IRasterImagePixelLoader(IRasterImageRawDataLoader):
    '''The raster image pixel loader.'''
    
    def load_partial_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialPixelLoader):
        '''Loads pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    ...

class IRasterImageRawDataLoader:
    '''The raster image raw data loader.'''
    
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    ...

class Image(DataStreamSupporter):
    '''The image is the base class for all type of images.'''
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes metadata.'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        ...
    
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    ...

class ImageAttributes:
    '''An  object contains information about how bitmap and metafile colors are manipulated during rendering. An  object maintains several color-adjustment settings, including color-adjustment matrices, grayscale-adjustment matrices, gamma-correction values, color-map tables, and color-threshold values. During rendering, colors can be corrected, darkened, lightened, and removed. To apply such manipulations, initialize an  object and pass the path of that  object (along with the path of an ) to the DrawImage method.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def set_color_matrix(self, new_color_matrix: aspose.imaging.ColorMatrix):
        '''Sets the color-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.'''
        ...
    
    @overload
    def set_color_matrix(self, new_color_matrix: aspose.imaging.ColorMatrix, flags: aspose.imaging.ColorMatrixFlag):
        '''Sets the color-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param flags: An element of  that specifies the type of image and color that will be affected by the color-adjustment matrix.'''
        ...
    
    @overload
    def set_color_matrix(self, new_color_matrix: aspose.imaging.ColorMatrix, mode: aspose.imaging.ColorMatrixFlag, type: aspose.imaging.ColorAdjustType):
        '''Sets the color-adjustment matrix for a specified category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param mode: An element of  that specifies the type of image and color that will be affected by the color-adjustment matrix.
        :param type: An element of  that specifies the category for which the color-adjustment matrix is set.'''
        ...
    
    @overload
    def clear_color_matrix(self):
        '''Clears the color-adjustment matrix for the default category.'''
        ...
    
    @overload
    def clear_color_matrix(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the color-adjustment matrix for a specified category.
        
        :param type: An element of  that specifies the category for which the color-adjustment matrix is cleared.'''
        ...
    
    @overload
    def set_color_matrices(self, new_color_matrix: aspose.imaging.ColorMatrix, gray_matrix: aspose.imaging.ColorMatrix):
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.'''
        ...
    
    @overload
    def set_color_matrices(self, new_color_matrix: aspose.imaging.ColorMatrix, gray_matrix: aspose.imaging.ColorMatrix, flags: aspose.imaging.ColorMatrixFlag):
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.
        :param flags: An element of  that specifies the type of image and color that will be affected by the color-adjustment and grayscale-adjustment matrices.'''
        ...
    
    @overload
    def set_color_matrices(self, new_color_matrix: aspose.imaging.ColorMatrix, gray_matrix: aspose.imaging.ColorMatrix, mode: aspose.imaging.ColorMatrixFlag, type: aspose.imaging.ColorAdjustType):
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for a specified category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.
        :param mode: An element of  that specifies the type of image and color that will be affected by the color-adjustment and grayscale-adjustment matrices.
        :param type: An element of  that specifies the category for which the color-adjustment and grayscale-adjustment matrices are set.'''
        ...
    
    @overload
    def set_threshold(self, threshold: float):
        '''Sets the threshold (transparency range) for the default category.
        
        :param threshold: A real number that specifies the threshold value.'''
        ...
    
    @overload
    def set_threshold(self, threshold: float, type: aspose.imaging.ColorAdjustType):
        '''Sets the threshold (transparency range) for a specified category.
        
        :param threshold: A threshold value from 0.0 to 1.0 that is used as a breakpoint to sort colors that will be mapped to either a maximum or a minimum value.
        :param type: An element of  that specifies the category for which the color threshold is set.'''
        ...
    
    @overload
    def clear_threshold(self):
        '''Clears the threshold value for the default category.'''
        ...
    
    @overload
    def clear_threshold(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the threshold value for a specified category.
        
        :param type: An element of  that specifies the category for which the threshold is cleared.'''
        ...
    
    @overload
    def set_gamma(self, gamma: float):
        '''Sets the gamma value for the default category.
        
        :param gamma: The gamma correction value.'''
        ...
    
    @overload
    def set_gamma(self, gamma: float, type: aspose.imaging.ColorAdjustType):
        '''Sets the gamma value for a specified category.
        
        :param gamma: The gamma correction value.
        :param type: An element of the  enumeration that specifies the category for which the gamma value is set.'''
        ...
    
    @overload
    def clear_gamma(self):
        '''Disables gamma correction for the default category.'''
        ...
    
    @overload
    def clear_gamma(self, type: aspose.imaging.ColorAdjustType):
        '''Disables gamma correction for a specified category.
        
        :param type: An element of  that specifies the category for which gamma correction is disabled.'''
        ...
    
    @overload
    def set_no_op(self):
        '''Turns off color adjustment for the default category.'''
        ...
    
    @overload
    def set_no_op(self, type: aspose.imaging.ColorAdjustType):
        '''Turns off color adjustment for a specified category.
        
        :param type: An element of  that specifies the category for which color correction is turned off.'''
        ...
    
    @overload
    def clear_no_op(self):
        '''Clears the NoOp setting for the default category.'''
        ...
    
    @overload
    def clear_no_op(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the NoOp setting for a specified category.
        
        :param type: An element of  that specifies the category for which the NoOp setting is cleared.'''
        ...
    
    @overload
    def set_color_key(self, color_low: aspose.imaging.Color, color_high: aspose.imaging.Color):
        '''Sets the color key for the default category.
        
        :param color_low: The low color-key value.
        :param color_high: The high color-key value.'''
        ...
    
    @overload
    def set_color_key(self, color_low: aspose.imaging.Color, color_high: aspose.imaging.Color, type: aspose.imaging.ColorAdjustType):
        '''Sets the color key (transparency range) for a specified category.
        
        :param color_low: The low color-key value.
        :param color_high: The high color-key value.
        :param type: An element of  that specifies the category for which the color key is set.'''
        ...
    
    @overload
    def clear_color_key(self):
        '''Clears the color key (transparency range) for the default category.'''
        ...
    
    @overload
    def clear_color_key(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the color key (transparency range) for a specified category.
        
        :param type: An element of  that specifies the category for which the color key is cleared.'''
        ...
    
    @overload
    def set_output_channel(self, flags: aspose.imaging.ColorChannelFlag):
        '''Sets the CMYK (cyan-magenta-yellow-black) output channel for the default category.
        
        :param flags: An element of  that specifies the output channel.'''
        ...
    
    @overload
    def set_output_channel(self, flags: aspose.imaging.ColorChannelFlag, type: aspose.imaging.ColorAdjustType):
        '''Sets the CMYK (cyan-magenta-yellow-black) output channel for a specified category.
        
        :param flags: An element of  that specifies the output channel.
        :param type: An element of  that specifies the category for which the output channel is set.'''
        ...
    
    @overload
    def clear_output_channel(self):
        '''Clears the CMYK (cyan-magenta-yellow-black) output channel setting for the default category.'''
        ...
    
    @overload
    def clear_output_channel(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the (cyan-magenta-yellow-black) output channel setting for a specified category.
        
        :param type: An element of  that specifies the category for which the output channel setting is cleared.'''
        ...
    
    @overload
    def set_output_channel_color_profile(self, color_profile_filename: str):
        '''Sets the output channel color-profile file for the default category.
        
        :param color_profile_filename: The path name of a color-profile file. If the color-profile file is in the %SystemRoot%\System32\Spool\Drivers\Color directory, this parameter can be the file name. Otherwise, this parameter must be the fully qualified path name.'''
        ...
    
    @overload
    def set_output_channel_color_profile(self, color_profile_filename: str, type: aspose.imaging.ColorAdjustType):
        '''Sets the output channel color-profile file for a specified category.
        
        :param color_profile_filename: The path name of a color-profile file. If the color-profile file is in the %SystemRoot%\System32\Spool\Drivers\Color directory, this parameter can be the file name. Otherwise, this parameter must be the fully qualified path name.
        :param type: An element of  that specifies the category for which the output channel color-profile file is set.'''
        ...
    
    @overload
    def clear_output_channel_color_profile(self):
        '''Clears the output channel color profile setting for the default category.'''
        ...
    
    @overload
    def clear_output_channel_color_profile(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the output channel color profile setting for a specified category.
        
        :param type: An element of  that specifies the category for which the output channel profile setting is cleared.'''
        ...
    
    @overload
    def set_remap_table(self, map: List[aspose.imaging.ColorMap]):
        '''Sets the color-remap table for the default category.
        
        :param map: An array of color pairs of type . Each color pair contains an existing color (the first value) and the color that it will be mapped to (the second value).'''
        ...
    
    @overload
    def set_remap_table(self, map: List[aspose.imaging.ColorMap], type: aspose.imaging.ColorAdjustType):
        '''Sets the color-remap table for a specified category.
        
        :param map: An array of color pairs of type . Each color pair contains an existing color (the first value) and the color that it will be mapped to (the second value).
        :param type: An element of  that specifies the category for which the color-remap table is set.'''
        ...
    
    @overload
    def clear_remap_table(self):
        '''Clears the color-remap table for the default category.'''
        ...
    
    @overload
    def clear_remap_table(self, type: aspose.imaging.ColorAdjustType):
        '''Clears the color-remap table for a specified category.
        
        :param type: An element of  that specifies the category for which the remap table is cleared.'''
        ...
    
    @overload
    def set_wrap_mode(self, mode: aspose.imaging.WrapMode):
        '''Sets the wrap mode that is used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of  that specifies how repeated copies of an image are used to tile an area.'''
        ...
    
    @overload
    def set_wrap_mode(self, mode: aspose.imaging.WrapMode, color: aspose.imaging.Color):
        '''Sets the wrap mode and color used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of  that specifies how repeated copies of an image are used to tile an area.
        :param color: An  object that specifies the color of pixels outside of a rendered image. This color is visible if the mode parameter is set to  and the source rectangle passed to DrawImage is larger than the image itself.'''
        ...
    
    @overload
    def set_wrap_mode(self, mode: aspose.imaging.WrapMode, color: aspose.imaging.Color, clamp: bool):
        '''Sets the wrap mode and color used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of  that specifies how repeated copies of an image are used to tile an area.
        :param color: A color object that specifies the color of pixels outside of a rendered image. This color is visible if the mode parameter is set to  and the source rectangle passed to DrawImage is larger than the image itself.
        :param clamp: This parameter has no effect. Set it to false.'''
        ...
    
    def set_brush_remap_table(self, map: List[aspose.imaging.ColorMap]):
        '''Sets the color-remap table for the brush category.
        
        :param map: An array of  objects.'''
        ...
    
    def clear_brush_remap_table(self):
        '''Clears the brush color-remap table of this  object.'''
        ...
    
    ...

class ImageCreatorsRegistry:
    '''Represents the image creators registry.'''
    
    @staticmethod
    def register(image_creator_descriptor: aspose.imaging.IImageCreatorDescriptor):
        '''Registers the specified image creator descriptor.
        
        :param image_creator_descriptor: The image creator descriptor.'''
        ...
    
    @staticmethod
    def get_first_supported_descriptor(image_options: aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageCreatorDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified.
        
        :param image_options: The image options.
        :returns: The creator descriptor which supports the specified or null if no such descriptor is found.'''
        ...
    
    @staticmethod
    def create_first_supported_creator(image_options: aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageCreator:
        '''Creates the first found creator suitable for the specified.
        
        :param image_options: The image options.
        :returns: The creator which supports the specified or null if no such creator is found.'''
        ...
    
    @staticmethod
    def register_creator(creator_descriptor: aspose.imaging.IImageCreatorDescriptor):
        '''Registers the creator.
        
        :param creator_descriptor: The creator descriptor to register.'''
        ...
    
    @staticmethod
    def unregister_creator(creator_descriptor: aspose.imaging.IImageCreatorDescriptor):
        '''Unregisters the creator.
        
        :param creator_descriptor: The creator descriptor.'''
        ...
    
    @classmethod
    @property
    def registered_formats(cls) -> aspose.imaging.FileFormat:
        ...
    
    @classmethod
    @property
    def registered_descriptors(cls) -> List[aspose.imaging.IImageCreatorDescriptor]:
        ...
    
    ...

class ImageExportersRegistry:
    '''Represents the image exporters registry.'''
    
    @staticmethod
    def register(image_exporter_descriptor: aspose.imaging.IImageExporterDescriptor):
        '''Registers the specified image exporter descriptor.
        
        :param image_exporter_descriptor: The image exporter descriptor.'''
        ...
    
    @staticmethod
    def get_first_supported_descriptor(image: aspose.imaging.Image, options: aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageExporterDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified save options and image.
        
        :param image: The image to export.
        :param options: The options.
        :returns: The exporter descriptor which supports the specified image and save options or null if no such descriptor is found.'''
        ...
    
    @staticmethod
    def create_first_supported_exporter(image: aspose.imaging.Image, options: aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageExporter:
        '''Creates the first found exporter suitable for the specified save options and image.
        
        :param image: The image to export.
        :param options: The save options to use for export.
        :returns: The exporter which supports the specified image and save options or null if no such exporter is found.'''
        ...
    
    @staticmethod
    def register_exporter(exporter_descriptor: aspose.imaging.IImageExporterDescriptor):
        '''Registers the exporter.
        
        :param exporter_descriptor: The exporter descriptor to register.'''
        ...
    
    @staticmethod
    def unregister_exporter(exporter_descriptor: aspose.imaging.IImageExporterDescriptor):
        '''Unregisters the exporter.
        
        :param exporter_descriptor: The exporter descriptor to unregister.'''
        ...
    
    @classmethod
    @property
    def registered_formats(cls) -> aspose.imaging.FileFormat:
        ...
    
    @classmethod
    @property
    def registered_exporter_descriptors(cls) -> List[aspose.imaging.IImageExporterDescriptor]:
        ...
    
    ...

class ImageLoadersRegistry:
    '''Represents the image loaders registry.'''
    
    @staticmethod
    def register(image_loader_descriptor: aspose.imaging.IImageLoaderDescriptor):
        '''Registers the specified image loader descriptor.
        
        :param image_loader_descriptor: The image loader descriptor.'''
        ...
    
    @staticmethod
    def get_first_supported_descriptor_by_type_name(descriptor_type_name: str) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the first supported descriptor by its type name.
        
        :param descriptor_type_name: The descriptor type name.
        :returns: The first found loader descriptor or null if not such descriptor is found.'''
        ...
    
    @staticmethod
    def get_first_supported_descriptor_by_file_format(file_format: aspose.imaging.FileFormat) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the first supported file format by its type name.
        
        :param file_format: The supported descriptor file format.
        :returns: The first found loader descriptor or null if not such descriptor is found.'''
        ...
    
    @staticmethod
    def get_first_supported_descriptor(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified ``stream`` and optionally the ``loadOptions``.
        
        :param stream: The stream.
        :param load_options: The load options.
        :returns: The loader descriptor which supports the specified ``stream`` and ``loadOptions`` or null if no such descriptor is found.'''
        ...
    
    @staticmethod
    def create_first_supported_loader(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.IImageLoader:
        '''Creates the first found loader suitable for the specified ``stream`` and optionally the ``loadOptions``.
        
        :param stream: The stream.
        :param load_options: The load options.
        :returns: The loader which supports the specified ``stream`` and ``loadOptions`` or null if no such loader is found.'''
        ...
    
    @staticmethod
    def register_loader(loader_descriptor: aspose.imaging.IImageLoaderDescriptor):
        '''Registers the loader.
        
        :param loader_descriptor: The loader descriptor to register.'''
        ...
    
    @staticmethod
    def unregister_loader(loader_descriptor: aspose.imaging.IImageLoaderDescriptor):
        '''Unregisters the loader.
        
        :param loader_descriptor: The loader descriptor to unregister.'''
        ...
    
    @classmethod
    @property
    def registered_formats(cls) -> aspose.imaging.FileFormat:
        ...
    
    @classmethod
    @property
    def registered_descriptors(cls) -> List[aspose.imaging.IImageLoaderDescriptor]:
        ...
    
    ...

class ImageOptionsBase(DisposableObject):
    '''The image base options.'''
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def keep_metadata(self) -> bool:
        ...
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool):
        ...
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        ...
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper):
        ...
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        ...
    
    @source.setter
    def source(self, value : aspose.imaging.Source):
        '''Sets the source to create image in.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette.'''
        ...
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        ...
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting):
        ...
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        ...
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        ...
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions):
        ...
    
    @property
    def full_frame(self) -> bool:
        ...
    
    @full_frame.setter
    def full_frame(self, value : bool):
        ...
    
    ...

class ImageResizeSettings:
    '''Image resize settings class'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @property
    def entries_count(self) -> int:
        ...
    
    @entries_count.setter
    def entries_count(self, value : int):
        ...
    
    @property
    def mode(self) -> aspose.imaging.ResizeType:
        '''Gets the interpolation mode.'''
        ...
    
    @mode.setter
    def mode(self, value : aspose.imaging.ResizeType):
        '''Sets the interpolation mode.'''
        ...
    
    @property
    def filter_type(self) -> aspose.imaging.ImageFilterType:
        ...
    
    @filter_type.setter
    def filter_type(self, value : aspose.imaging.ImageFilterType):
        ...
    
    @property
    def color_quantization_method(self) -> aspose.imaging.ColorQuantizationMethod:
        ...
    
    @color_quantization_method.setter
    def color_quantization_method(self, value : aspose.imaging.ColorQuantizationMethod):
        ...
    
    @property
    def color_compare_method(self) -> aspose.imaging.ColorCompareMethod:
        ...
    
    @color_compare_method.setter
    def color_compare_method(self, value : aspose.imaging.ColorCompareMethod):
        ...
    
    ...

class IntRange:
    '''Class for representing sequence of elements'''
    
    @overload
    def __init__(self, start: int, count: int):
        '''Initializes a new instance of the  class.
        
        :param start: The start.
        :param count: The count.'''
        ...
    
    @overload
    def __init__(self, start: int, count: int, delta: int):
        '''Initializes a new instance of the  class.
        
        :param start: The start.
        :param count: The count.
        :param delta: The delta.'''
        ...
    
    @overload
    def __init__(self, range: List[int]):
        '''Initializes a new instance of the  class.
        
        :param range: The range.'''
        ...
    
    @staticmethod
    def get_range(start: int, count: int, delta: int) -> Iterable[int]:
        '''Gets the count range of int elements starting at start
        
        :param start: The start.
        :param count: The count.
        :param delta: The delta.
        :returns: Array of items'''
        ...
    
    def get_array_one_item_from_index(self, index: int) -> List[int]:
        '''Returns one item array from specified index
        
        :param index: The range index.
        :returns: The array of'''
        ...
    
    @property
    def range(self) -> List[int]:
        '''Gets the range.'''
        ...
    
    @range.setter
    def range(self, value : List[int]):
        '''Sets the range.'''
        ...
    
    ...

class License:
    '''Provides methods to license the component.'''
    
    def __init__(self):
        '''Initializes a new instance of the  class.
        Initializes a new instance of this class.'''
        ...
    
    @overload
    def set_license(self, license_name: str):
        '''Licenses the component.
        
        :param license_name: Can be a full or short file name . Use an empty string to switch to evaluation mode.'''
        ...
    
    @overload
    def set_license(self, stream: io.RawIOBase):
        '''Licenses the component.
        
        :param stream: A stream that contains the license.'''
        ...
    
    def set_license_stream(self, stream: io.RawIOBase):
        '''Licenses the component.
        
        :param stream: A stream that contains the license.'''
        ...
    
    ...

class LoadOptions:
    '''Represents the loading options.'''
    
    def __init__(self):
        '''Initializes a new instance of the .'''
        ...
    
    @property
    def data_recovery_mode(self) -> aspose.imaging.DataRecoveryMode:
        ...
    
    @data_recovery_mode.setter
    def data_recovery_mode(self, value : aspose.imaging.DataRecoveryMode):
        ...
    
    @property
    def data_background_color(self) -> aspose.imaging.Color:
        ...
    
    @data_background_color.setter
    def data_background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def use_icc_profile_conversion(self) -> bool:
        ...
    
    @use_icc_profile_conversion.setter
    def use_icc_profile_conversion(self, value : bool):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def concurrent_image_processing(self) -> bool:
        ...
    
    @concurrent_image_processing.setter
    def concurrent_image_processing(self, value : bool):
        ...
    
    ...

class Matrix:
    '''Replaces the GDI+ Matrix.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the Matrix class as the identity matrix.'''
        ...
    
    @overload
    def __init__(self, m11: float, m12: float, m21: float, m22: float, m31: float, m32: float):
        '''Initializes a new instance of the  class.
        
        :param m11: m00     M11     Scale X
        :param m12: m10     M12     Shear Y
        :param m21: m01     M21     Shear X
        :param m22: m11     M22     Scale Y
        :param m31: m02     M31     Translate X
        :param m32: m12     M32     Translate Y'''
        ...
    
    @overload
    def __init__(self, rect: aspose.imaging.RectangleF, plgpts: List[aspose.imaging.PointF]):
        '''Initializes a new instance of the  class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A  structure that represents the rectangle to be transformed.
        :param plgpts: An array of three  structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        ...
    
    @overload
    def __init__(self, rect: aspose.imaging.Rectangle, plgpts: List[aspose.imaging.Point]):
        '''Initializes a new instance of the  class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A  structure that represents the rectangle to be transformed.
        :param plgpts: An array of three  structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        ...
    
    @overload
    def __init__(self, origin: aspose.imaging.Matrix):
        '''Makes a copy of the  class.
        
        :param origin: A base matrix for coping'''
        ...
    
    @overload
    def scale(self, scale_x: float, scale_y: float, order: aspose.imaging.MatrixOrder):
        '''Applies the specified scale vector (scaleX and scaleY) to this  using the specified order.
        
        :param scale_x: The scale X.
        :param scale_y: The scale Y.
        :param order: The order.'''
        ...
    
    @overload
    def scale(self, sx: float, sy: float):
        '''Applies the specified scale vector (scaleX and scaleY) to this Matrix using (default) Prepend order.
        
        :param sx: The sx. The sx. The sx.
        :param sy: The sy. The sy. The sy.'''
        ...
    
    @overload
    def translate(self, offset_x: float, offset_y: float, order: aspose.imaging.MatrixOrder):
        '''Applies the specified translation vector to this Matrix in the specified order.
        
        :param offset_x: The offset X.
        :param offset_y: The offset Y.
        :param order: The order.'''
        ...
    
    @overload
    def translate(self, tx: float, ty: float):
        '''Applies the specified translation vector to this  using (default) Prepend order.
        
        :param tx: The tx. The tx. The tx.
        :param ty: The ty. The ty. The ty.'''
        ...
    
    @overload
    def multiply(self, t_tx: aspose.imaging.Matrix, order: aspose.imaging.MatrixOrder):
        '''Multiplies this Matrix by the matrix specified in the matrix parameter, and in the order specified in the order parameter.
        
        :param t_tx: The tx. The tx. The tx.
        :param order: The order. The order. The order.'''
        ...
    
    @overload
    def multiply(self, t_tx: aspose.imaging.Matrix):
        '''Multiplies this Matrix by the matrix specified in the matrix parameter using (default) Prepend order.
        
        :param t_tx: The matrix to multiply with.'''
        ...
    
    @overload
    def rotate(self, angle: float, order: aspose.imaging.MatrixOrder):
        '''Applies a clockwise rotation of an amount specified in the angle parameter, around the origin (zero x and y coordinates) for this Matrix in the specified order.
        
        :param angle: The rotate angle.
        :param order: The matrix order.'''
        ...
    
    @overload
    def rotate(self, angle: float):
        '''Applies a clockwise rotation of an amount specified in the angle parameter, around the origin (zero x and y coordinates) for this Matrix in the default (Prepend) order.
        
        :param angle: The rotate angle.'''
        ...
    
    @overload
    def rotate_at(self, angle: float, point: aspose.imaging.PointF, order: aspose.imaging.MatrixOrder):
        '''Applies a clockwise rotation about the specified point to this Matrix in the specified order.
        
        :param angle: The angle.
        :param point: The point.
        :param order: The order.'''
        ...
    
    @overload
    def rotate_at(self, angle: float, point: aspose.imaging.PointF):
        '''Applies a clockwise rotation about the specified point to this Matrix in the default (Prepend) order.
        
        :param angle: The angle.
        :param point: The point.'''
        ...
    
    @staticmethod
    def create_with_rect_f(rect: aspose.imaging.RectangleF, plgpts: List[aspose.imaging.PointF]) -> aspose.imaging.Matrix:
        '''Initializes a new instance of the  class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A  structure that represents the rectangle to be transformed.
        :param plgpts: An array of three  structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        ...
    
    @staticmethod
    def create_with_rect(rect: aspose.imaging.Rectangle, plgpts: List[aspose.imaging.Point]) -> aspose.imaging.Matrix:
        '''Initializes a new instance of the  class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A  structure that represents the rectangle to be transformed.
        :param plgpts: An array of three  structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        ...
    
    @staticmethod
    def equals(a: aspose.imaging.Matrix, b: aspose.imaging.Matrix) -> bool:
        '''Determines whether two matrixes are equal.
        
        :param a: The first matrix to compare.
        :param b: The second matrix to compare.
        :returns: True if matrixes are equal.'''
        ...
    
    def get_elements(self) -> List[float]:
        '''Gets the copy of matrix elements.
        
        :returns: A matrix elements copy.'''
        ...
    
    def transform_points(self, points: List[aspose.imaging.PointF]):
        '''Applies the geometric transform represented by this  to a specified array of points.
        
        :param points: The points.'''
        ...
    
    def reset(self):
        '''Resets this Matrix to have the elements of the identity matrix.'''
        ...
    
    @property
    def elements(self) -> List[float]:
        '''Gets an array of floating-point values that represents the elements of this .'''
        ...
    
    @property
    def m11(self) -> float:
        '''Gets the matrix element at first row first column. Represents scale along X axis.'''
        ...
    
    @property
    def m12(self) -> float:
        '''Gets the matrix element at first row second column. Represents shear along Y axis.'''
        ...
    
    @property
    def m21(self) -> float:
        '''Gets the matrix element at second row first column. Represents shear along X axis.'''
        ...
    
    @property
    def m22(self) -> float:
        '''Gets the matrix element at second row second column. Represents scale along Y axis.'''
        ...
    
    @property
    def m31(self) -> float:
        '''Gets the matrix element at third row first column. Represents translation along X axis.'''
        ...
    
    @property
    def m32(self) -> float:
        '''Gets the matrix element at third row first column. Represents translation along Y axis.'''
        ...
    
    @classmethod
    @property
    def TYPE_IDENTITY(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_TRANSLATION(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_UNIFORM_SCALE(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_GENERAL_SCALE(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_MASK_SCALE(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_FLIP(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_QUADRANT_ROTATION(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_GENERAL_ROTATION(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_MASK_ROTATION(cls) -> int:
        ...
    
    @classmethod
    @property
    def TYPE_GENERAL_TRANSFORM(cls) -> int:
        ...
    
    ...

class Metered:
    '''Provides metered methods for integration'''
    
    def __init__(self):
        '''Initializes a new instance of this class.'''
        ...
    
    def set_metered_key(self, public_key: str, private_key: str):
        '''Sets metered public and private key.
        If you purchase metered license, when start application, this API should be called, normally, this is enough.
        However, if always fail to upload consumption data and exceed 24 hours, the license will be set to evaluation status,
        to avoid such case, you should regularly check the license status, if it is evaluation status, call this API again.
        
        :param public_key: public key
        :param private_key: private key'''
        ...
    
    @staticmethod
    def get_consumption_quantity() -> float:
        '''Gets consumption file size
        
        :returns: consumption quantity'''
        ...
    
    @staticmethod
    def get_consumption_credit() -> float:
        '''Gets consumption credit
        
        :returns: consumption quantity'''
        ...
    
    ...

class NonGenericDictionary:
    '''Represents a non generic dictionary.'''
    
    def remove(self, key: any):
        '''Removes the element with the specified key from the
        object.
        
        :param key: The key of the element to remove.'''
        ...
    
    def add(self, key: any, value: any):
        '''Adds an element with the provided key and value to the
        object.
        
        :param key: The
        to use as the key of the element to add.
        :param value: The
        to use as the value of the element to add.'''
        ...
    
    def clear(self):
        '''Removes all elements from the
        object.'''
        ...
    
    @property
    def is_fixed_size(self) -> bool:
        ...
    
    @property
    def is_read_only(self) -> bool:
        ...
    
    @property
    def keys(self) -> list:
        '''Gets an
        object containing the keys of the
        object.'''
        ...
    
    @property
    def values(self) -> list:
        '''Gets an
        object containing the values in the
        object.'''
        ...
    
    ...

class NonGenericList:
    '''Non generic list of objects'''
    
    def __init__(self, list: list):
        '''Initializes a new instance of the  class.
        
        :param list: The list - container of objects.'''
        ...
    
    ...

class ObjectWithBounds:
    '''The object having bounds.'''
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object's bounds.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix, pen: aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object's bounds size.
        :returns: The estimated object's bounds.'''
        ...
    
    def transform(self, transform: aspose.imaging.Matrix):
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.'''
        ...
    
    ...

class OpenTypeFontsCache:
    '''Cache for OpenType fonts that are installed in the system.'''
    
    @staticmethod
    def update_cache():
        ''''''
        ...
    
    ...

class Pen(TransparencySupporter):
    '''Defines an object used to draw lines, curves and figures.'''
    
    @overload
    def __init__(self, color: aspose.imaging.Color):
        '''Initializes a new instance of the  class with the specified color.
        
        :param color: A  structure that indicates the color of this .'''
        ...
    
    @overload
    def __init__(self, color: aspose.imaging.Color, width: float):
        '''Initializes a new instance of the  class with the specified  and  properties.
        
        :param color: A  structure that indicates the color of this .
        :param width: A value indicating the width of this .'''
        ...
    
    @overload
    def __init__(self, brush: aspose.imaging.Brush):
        '''Initializes a new instance of the  class with the specified .
        
        :param brush: A  that determines the fill properties of this .'''
        ...
    
    @overload
    def __init__(self, brush: aspose.imaging.Brush, width: float):
        '''Initializes a new instance of the  class with the specified  and .
        
        :param brush: A  that determines the characteristics of this .
        :param width: The width of the new .'''
        ...
    
    @overload
    def multiply_transform(self, matrix: aspose.imaging.Matrix):
        '''Multiplies the transformation matrix for this  by the specified .
        
        :param matrix: The  object by which to multiply the transformation matrix.'''
        ...
    
    @overload
    def multiply_transform(self, matrix: aspose.imaging.Matrix, order: aspose.imaging.MatrixOrder):
        '''Multiplies the transformation matrix for this  by the specified  in the specified order.
        
        :param matrix: The  by which to multiply the transformation matrix.
        :param order: The order in which to perform the multiplication operation.'''
        ...
    
    @overload
    def translate_transform(self, dx: float, dy: float):
        '''Translates the local geometric transformation by the specified dimensions. This method prepends the translation to the transformation.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.'''
        ...
    
    @overload
    def translate_transform(self, dx: float, dy: float, order: aspose.imaging.MatrixOrder):
        '''Translates the local geometric transformation by the specified dimensions in the specified order.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.
        :param order: The order (prepend or append) in which to apply the translation.'''
        ...
    
    @overload
    def scale_transform(self, sx: float, sy: float):
        '''Scales the local geometric transformation by the specified factors. This method prepends the scaling matrix to the transformation.
        
        :param sx: The factor by which to scale the transformation in the x-axis direction.
        :param sy: The factor by which to scale the transformation in the y-axis direction.'''
        ...
    
    @overload
    def scale_transform(self, sx: float, sy: float, order: aspose.imaging.MatrixOrder):
        '''Scales the local geometric transformation by the specified factors in the specified order.
        
        :param sx: The factor by which to scale the transformation in the x-axis direction.
        :param sy: The factor by which to scale the transformation in the y-axis direction.
        :param order: A  that specifies whether to append or prepend the scaling matrix.'''
        ...
    
    @overload
    def rotate_transform(self, angle: float):
        '''Rotates the local geometric transformation by the specified angle. This method prepends the rotation to the transformation.
        
        :param angle: The angle of rotation.'''
        ...
    
    @overload
    def rotate_transform(self, angle: float, order: aspose.imaging.MatrixOrder):
        '''Rotates the local geometric transformation by the specified angle in the specified order.
        
        :param angle: The angle of rotation.
        :param order: A  that specifies whether to append or prepend the rotation matrix.'''
        ...
    
    @staticmethod
    def create_with_color(color: aspose.imaging.Color) -> aspose.imaging.Pen:
        '''Initializes a new instance of the  class with the specified color.
        
        :param color: A  structure that indicates the color of this .'''
        ...
    
    @staticmethod
    def create_with_color_width(color: aspose.imaging.Color, width: float) -> aspose.imaging.Pen:
        '''Initializes a new instance of the  class with the specified  and  properties.
        
        :param color: A  structure that indicates the color of this .
        :param width: A value indicating the width of this .'''
        ...
    
    @staticmethod
    def create_with_brush(brush: aspose.imaging.Brush) -> aspose.imaging.Pen:
        '''Initializes a new instance of the  class with the specified .
        
        :param brush: A  that determines the fill properties of this .'''
        ...
    
    @staticmethod
    def create_with_brush_width(brush: aspose.imaging.Brush, width: float) -> aspose.imaging.Pen:
        '''Initializes a new instance of the  class with the specified  and .
        
        :param brush: A  that determines the characteristics of this .
        :param width: The width of the new .'''
        ...
    
    def set_line_cap(self, start_cap: aspose.imaging.LineCap, end_cap: aspose.imaging.LineCap, dash_cap: aspose.imaging.DashCap):
        '''Sets the values that determine the style of cap used to end lines drawn by this .
        
        :param start_cap: A  that represents the cap style to use at the beginning of lines drawn with this .
        :param end_cap: A  that represents the cap style to use at the end of lines drawn with this .
        :param dash_cap: A  that represents the cap style to use at the beginning or end of dashed lines drawn with this .'''
        ...
    
    def reset_transform(self):
        '''Resets the geometric transformation matrix for this  to identity.'''
        ...
    
    @property
    def opacity(self) -> float:
        '''Gets the object's opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        ...
    
    @opacity.setter
    def opacity(self, value : float):
        '''Sets the object's opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        ...
    
    @property
    def width(self) -> float:
        '''Gets the width of this , in units of the Graphics object used for drawing.'''
        ...
    
    @width.setter
    def width(self, value : float):
        '''Sets the width of this , in units of the Graphics object used for drawing.'''
        ...
    
    @property
    def start_cap(self) -> aspose.imaging.LineCap:
        ...
    
    @start_cap.setter
    def start_cap(self, value : aspose.imaging.LineCap):
        ...
    
    @property
    def end_cap(self) -> aspose.imaging.LineCap:
        ...
    
    @end_cap.setter
    def end_cap(self, value : aspose.imaging.LineCap):
        ...
    
    @property
    def dash_cap(self) -> aspose.imaging.DashCap:
        ...
    
    @dash_cap.setter
    def dash_cap(self, value : aspose.imaging.DashCap):
        ...
    
    @property
    def line_join(self) -> aspose.imaging.LineJoin:
        ...
    
    @line_join.setter
    def line_join(self, value : aspose.imaging.LineJoin):
        ...
    
    @property
    def custom_start_cap(self) -> aspose.imaging.CustomLineCap:
        ...
    
    @custom_start_cap.setter
    def custom_start_cap(self, value : aspose.imaging.CustomLineCap):
        ...
    
    @property
    def custom_end_cap(self) -> aspose.imaging.CustomLineCap:
        ...
    
    @custom_end_cap.setter
    def custom_end_cap(self, value : aspose.imaging.CustomLineCap):
        ...
    
    @property
    def miter_limit(self) -> float:
        ...
    
    @miter_limit.setter
    def miter_limit(self, value : float):
        ...
    
    @property
    def alignment(self) -> aspose.imaging.PenAlignment:
        '''Gets the alignment for this .'''
        ...
    
    @alignment.setter
    def alignment(self, value : aspose.imaging.PenAlignment):
        '''Sets the alignment for this .'''
        ...
    
    @property
    def transform(self) -> aspose.imaging.Matrix:
        '''Gets a copy of the geometric transformation for this .'''
        ...
    
    @transform.setter
    def transform(self, value : aspose.imaging.Matrix):
        '''Sets a copy of the geometric transformation for this .'''
        ...
    
    @property
    def pen_type(self) -> aspose.imaging.PenType:
        ...
    
    @property
    def color(self) -> aspose.imaging.Color:
        '''Gets the color of this .'''
        ...
    
    @color.setter
    def color(self, value : aspose.imaging.Color):
        '''Sets the color of this .'''
        ...
    
    @property
    def brush(self) -> aspose.imaging.Brush:
        '''Gets the  that determines attributes of this .'''
        ...
    
    @brush.setter
    def brush(self, value : aspose.imaging.Brush):
        '''Sets the  that determines attributes of this .'''
        ...
    
    @property
    def dash_style(self) -> aspose.imaging.DashStyle:
        ...
    
    @dash_style.setter
    def dash_style(self, value : aspose.imaging.DashStyle):
        ...
    
    @property
    def dash_offset(self) -> float:
        ...
    
    @dash_offset.setter
    def dash_offset(self, value : float):
        ...
    
    @property
    def dash_pattern(self) -> List[float]:
        ...
    
    @dash_pattern.setter
    def dash_pattern(self, value : List[float]):
        ...
    
    @property
    def compound_array(self) -> List[float]:
        ...
    
    @compound_array.setter
    def compound_array(self, value : List[float]):
        ...
    
    ...

class PixelDataFormat:
    '''The pixel data format. This is an immutable object.'''
    
    @overload
    @staticmethod
    def get_grayscale_alpha(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets GrayscaleAlpha color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The GrayscaleAlpha color.'''
        ...
    
    @overload
    @staticmethod
    def get_grayscale_alpha(bits_per_sample: int, alpha_channel_bits: int) -> aspose.imaging.PixelDataFormat:
        '''Gets GrayscaleAlpha color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :param alpha_channel_bits: The number of bits per sample in the alpha channel.
        :returns: The GrayscaleAlpha color.'''
        ...
    
    @overload
    @staticmethod
    def get_rgb(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGB color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The RGB color.'''
        ...
    
    @overload
    @staticmethod
    def get_rgb(bits_per_red_channel: int, bits_per_green_channel: int, bits_per_blue_channel: int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGB color with a specified number of bits per sample.
        
        :param bits_per_red_channel: The number of bits per Red channel.
        :param bits_per_green_channel: The number of bits per Green channel.
        :param bits_per_blue_channel: The number of bits per Blue channel.
        :returns: The RGB color.'''
        ...
    
    @overload
    @staticmethod
    def get_rgba(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGBA color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The RGBA color.'''
        ...
    
    @overload
    @staticmethod
    def get_rgba(bits_per_red_channel: int, bits_per_green_channel: int, bits_per_blue_channel: int, bits_per_alpha_channel: int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGBA color with a specified number of bits per sample.
        
        :param bits_per_red_channel: The number of bits per Red channel.
        :param bits_per_green_channel: The number of bits per Green channel.
        :param bits_per_blue_channel: The number of bits per Blue channel.
        :param bits_per_alpha_channel: The number of bits per Alpha channel.
        :returns: The RGBA color.'''
        ...
    
    @overload
    @staticmethod
    def get_y_cb_cr(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCbCr color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The YCbCr color.'''
        ...
    
    @overload
    @staticmethod
    def get_y_cb_cr(bits_per_y: int, bits_per_cb: int, bits_per_cr: int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCbCr color with a specified number of bits per sample.
        
        :param bits_per_y: The number of bits per Y channel.
        :param bits_per_cb: The number of bits per Cb channel.
        :param bits_per_cr: The number of bits per Cr channel.
        :returns: The YCbCr color.'''
        ...
    
    @overload
    @staticmethod
    def get_cmyk(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYK color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The CMYK color.'''
        ...
    
    @overload
    @staticmethod
    def get_cmyk(bits_per_cyan_channel: int, bits_per_magenta_channel: int, bits_per_yellow_channel: int, bits_per_key_channel: int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYK color with a specified number of bits per sample.
        
        :param bits_per_cyan_channel: The number of bits per Cyan channel.
        :param bits_per_magenta_channel: The number of bits per Magenta channel.
        :param bits_per_yellow_channel: The number of bits per Yellow channel.
        :param bits_per_key_channel: The number of bits per Key channel.
        :returns: The CMYK color.'''
        ...
    
    @staticmethod
    def get_grayscale(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets Grayscale color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The Grayscale color.'''
        ...
    
    @staticmethod
    def get_rgb_indexed(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGRA indexed color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGRA color.'''
        ...
    
    @staticmethod
    def get_bgra(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGRA color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGRA color.'''
        ...
    
    @staticmethod
    def get_bgr(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGR color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGR color.'''
        ...
    
    @staticmethod
    def get_cmyka(bits_per_cyan_channel: int, bits_per_magenta_channel: int, bits_per_yellow_channel: int, bits_per_key_channel: int, bits_per_alpha_channel: int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYKA color with a specified number of bits per sample.
        
        :param bits_per_cyan_channel: The number of bits per Cyan channel.
        :param bits_per_magenta_channel: The number of bits per Magenta channel.
        :param bits_per_yellow_channel: The number of bits per Yellow channel.
        :param bits_per_key_channel: The number of bits per Key channel.
        :param bits_per_alpha_channel: The number of bits per Alpha channel.
        :returns: The CMYK color.'''
        ...
    
    @staticmethod
    def get_ycck(bits_per_sample: int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCCK color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The YCCK color.'''
        ...
    
    @staticmethod
    def get_cie_lab(bits_per_l: int, bits_per_a: int, bits_per_b: int) -> aspose.imaging.PixelDataFormat:
        '''Gets CIE Lab color with a specified number of bits per sample.
        
        :param bits_per_l: The number of bits per L channel.
        :param bits_per_a: The number of bits per A channel.
        :param bits_per_b: The number of bits per B channel.
        :returns: The CIE Lab color.'''
        ...
    
    @classmethod
    @property
    def rgb_32_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def cmyk(cls) -> aspose.imaging.PixelDataFormat:
        '''Gets the  defined for 32 bits per pixel with 8 bits for each of the cyan, magenta, yellow and black.'''
        ...
    
    @classmethod
    @property
    def cmyka(cls) -> aspose.imaging.PixelDataFormat:
        '''Gets the acmyk.'''
        ...
    
    @classmethod
    @property
    def rgb_24_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_16_bpp_555(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_16_bpp_565(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_indexed_8_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_indexed_4_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_indexed_2_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_indexed_1_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def y_cb_cr(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def ycck(cls) -> aspose.imaging.PixelDataFormat:
        '''Gets the  defined for 32 bits per pixel with 8 bits for each of the luma, blue-difference, red-difference and black chroma components.'''
        ...
    
    @classmethod
    @property
    def rgba_32_bpp(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def rgb_24_bpp_png(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @classmethod
    @property
    def grayscale_alpha(cls) -> aspose.imaging.PixelDataFormat:
        ...
    
    @property
    def pixel_format(self) -> aspose.imaging.PixelFormat:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def channels_count(self) -> int:
        ...
    
    @property
    def channel_bits(self) -> List[int]:
        ...
    
    @property
    def caption(self) -> str:
        '''Gets the pixel data format caption.'''
        ...
    
    @classmethod
    @property
    def GRAYSCALE16(cls) -> aspose.imaging.PixelDataFormat:
        '''Defined for 16 bits per pixel with up to 16 bits representing grayscale intensity.'''
        ...
    
    @classmethod
    @property
    def grayscale(cls) -> aspose.imaging.PixelDataFormat:
        '''Gets the  defined for 8 bits per pixel with 8 bits representing grayscale intensity in the 0-255 interval.'''
        ...
    
    @classmethod
    @grayscale.setter
    def grayscale(cls, value : aspose.imaging.PixelDataFormat):
        '''Gets the  defined for 8 bits per pixel with 8 bits representing grayscale intensity in the 0-255 interval.'''
        ...
    
    ...

class Point:
    '''Represents an ordered pair of integer x- and y-coordinates that defines a point in a two-dimensional plane.'''
    
    @overload
    def __init__(self, x: int, y: int):
        '''Initializes a new instance of the  structure with the specified coordinates.
        
        :param x: The horizontal position of the point.
        :param y: The vertical position of the point.'''
        ...
    
    @overload
    def __init__(self, size: aspose.imaging.Size):
        '''Initializes a new instance of the  structure from the  structure.
        
        :param size: Contains the new point coordinates.'''
        ...
    
    @overload
    def __init__(self, dw: int):
        '''Initializes a new instance of the  structure using coordinates specified by an integer value.
        
        :param dw: A 32-bit integer that specifies the coordinates for the new point.'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @overload
    def offset(self, point: aspose.imaging.Point):
        '''Translates this  by the specified .
        
        :param point: The  used to offset this .'''
        ...
    
    @overload
    def offset(self, dx: int, dy: int):
        '''Translates this  by the specified amount.
        
        :param dx: The amount to offset the x-coordinate.
        :param dy: The amount to offset the y-coordinate.'''
        ...
    
    @staticmethod
    def create_from_size(size: aspose.imaging.Size) -> aspose.imaging.Point:
        '''Initializes a new instance of the  structure from the  structure.
        
        :param size: Contains the new point coordinates.'''
        ...
    
    @staticmethod
    def create_from_d_word(dw: int) -> aspose.imaging.Point:
        '''Initializes a new instance of the  structure using coordinates specified by an integer value.
        
        :param dw: A 32-bit integer that specifies the coordinates for the new point.'''
        ...
    
    @staticmethod
    def from_long(packed_point: int, x: Any, y: Any):
        '''Deconstruct a Point object packed into a long object to separate X and Y int values.
        
        :param packed_point: The Point object packed into one long value.
        :param x: The extracted from the packed Point X value.
        :param y: The extracted from the packed Point Y value.'''
        ...
    
    @staticmethod
    def add(point: aspose.imaging.Point, size: aspose.imaging.Size) -> aspose.imaging.Point:
        '''Adds the specified  to the specified .
        
        :param point: The  to add to.
        :param size: The  to add to the ``point``.
        :returns: The  that is the result of the addition operation.'''
        ...
    
    @staticmethod
    def subtract(point: aspose.imaging.Point, size: aspose.imaging.Size) -> aspose.imaging.Point:
        '''Returns the result of subtracting specified  from the specified .
        
        :param point: The  to be subtracted from.
        :param size: The  to subtract from the ``point``.
        :returns: The  that is the result of the subtraction operation.'''
        ...
    
    @staticmethod
    def ceiling(point: aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified  to a  by rounding the values of the  to the next higher integer values.
        
        :param point: The  to convert.
        :returns: The  this method converts to.'''
        ...
    
    @staticmethod
    def round(point: aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified  to a  object by rounding the  values to the nearest integer.
        
        :param point: The  to convert.
        :returns: The  this method converts to.'''
        ...
    
    @staticmethod
    def truncate(point: aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified  to a  by truncating the values of the .
        
        :param point: The  to convert.
        :returns: The  this method converts to.'''
        ...
    
    def to_long(self) -> int:
        '''Convert this Point to a single long value, containing X and Y coordinates in high and low bits.
        
        :returns: The Point object packed into one long value.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.Point:
        '''Gets a new instance of the  structure that has  and  values set to zero.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    @property
    def x(self) -> int:
        '''Gets the x-coordinate of this .'''
        ...
    
    @x.setter
    def x(self, value : int):
        '''Sets the x-coordinate of this .'''
        ...
    
    @property
    def y(self) -> int:
        '''Gets the y-coordinate of this .'''
        ...
    
    @y.setter
    def y(self, value : int):
        '''Sets the y-coordinate of this .'''
        ...
    
    ...

class PointF:
    '''Represents an ordered pair of floating-point x- and y-coordinates that defines a point in a two-dimensional plane.'''
    
    @overload
    def __init__(self, x: float, y: float):
        '''Initializes a new instance of the  structure with the specified coordinates.
        
        :param x: The horizontal position of the point.
        :param y: The vertical position of the point.'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @overload
    @staticmethod
    def add(point: aspose.imaging.PointF, size: aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a given  by the specified .
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @overload
    @staticmethod
    def add(point: aspose.imaging.PointF, size: aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a given  by a specified .
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @overload
    @staticmethod
    def subtract(point: aspose.imaging.PointF, size: aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a  by the negative of a specified size.
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @overload
    @staticmethod
    def subtract(point: aspose.imaging.PointF, size: aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a  by the negative of a specified size.
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @staticmethod
    def add_size(point: aspose.imaging.PointF, size: aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a given  by the specified .
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @staticmethod
    def subtract_size(point: aspose.imaging.PointF, size: aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a  by the negative of a specified size.
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @staticmethod
    def add_size_f(point: aspose.imaging.PointF, size: aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a given  by a specified .
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @staticmethod
    def subtract_size_f(point: aspose.imaging.PointF, size: aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a  by the negative of a specified size.
        
        :param point: The  to translate.
        :param size: The  that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated .'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.PointF:
        '''Gets a new instance of the  structure that has  and  values set to zero.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    @property
    def x(self) -> float:
        '''Gets the x-coordinate of this .'''
        ...
    
    @x.setter
    def x(self, value : float):
        '''Sets the x-coordinate of this .'''
        ...
    
    @property
    def y(self) -> float:
        '''Gets the y-coordinate of this .'''
        ...
    
    @y.setter
    def y(self, value : float):
        '''Sets the y-coordinate of this .'''
        ...
    
    ...

class RasterCachedImage(RasterImage):
    '''Represents a raster image supporting raster graphics operations. This image caches pixel data when required.'''
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def rotate(self, angle: float, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Cropping the image.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int, custom_palette: aspose.imaging.IColorPalette):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, partial_raw_data_loader: aspose.imaging.IPartialRawDataLoader, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings) -> bytes:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, dest_image_bounds: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float, window_size: int):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_area: aspose.imaging.Rectangle, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def adjust_gamma(self, gamma_red: float, gamma_green: float, gamma_blue: float):
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        ...
    
    @overload
    def adjust_gamma(self, gamma: float):
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        ...
    
    @overload
    def normalize_angle(self):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.'''
        ...
    
    @overload
    def normalize_angle(self, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def replace_color(self, old_color: aspose.imaging.Color, old_color_diff: byte, new_color: aspose.imaging.Color):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        ...
    
    @overload
    def replace_color(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color: aspose.imaging.Color):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb: int):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes this image instance metadata by setting this  value to .'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: The rotate flip type.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        ...
    
    def get_modify_date(self, use_default: bool) -> DateTime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        ...
    
    def get_default_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def get_default_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        ...
    
    def get_argb_32_pixel(self, x: int, y: int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        ...
    
    def get_pixel(self, x: int, y: int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        ...
    
    def set_argb_32_pixel(self, x: int, y: int, argb_32_color: int):
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        ...
    
    def set_pixel(self, x: int, y: int, color: aspose.imaging.Color):
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        ...
    
    def read_scan_line(self, scan_line_index: int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        ...
    
    def read_argb_32_scan_line(self, scan_line_index: int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        ...
    
    def write_scan_line(self, scan_line_index: int, pixels: List[aspose.imaging.Color]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        ...
    
    def write_argb_32_scan_line(self, scan_line_index: int, argb_32_pixels: List[int]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        ...
    
    def load_partial_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        ...
    
    def load_partial_pixels(self, desired_rectangle: aspose.imaging.Rectangle, pixel_loader: aspose.imaging.IPartialPixelLoader):
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        ...
    
    def load_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        ...
    
    def load_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        ...
    
    def load_partial_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb64PixelLoader):
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        ...
    
    def load_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        ...
    
    def load_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        ...
    
    def load_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        ...
    
    def save_raw_data(self, data: bytes, data_offset: int, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        ...
    
    def save_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        ...
    
    def save_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.Color]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        ...
    
    def save_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.CmykColor]):
        '''Saves the pixels.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        ...
    
    def save_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        ...
    
    def set_resolution(self, dpi_x: float, dpi_y: float):
        '''Sets the resolution for this .
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the .
        :param dpi_y: The vertical resolution, in dots per inch, of the .'''
        ...
    
    def binarize_fixed(self, threshold: byte):
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of 255 will be assigned to it, 0 otherwise.'''
        ...
    
    def binarize_otsu(self):
        '''Binarization of an image with Otsu thresholding'''
        ...
    
    def grayscale(self):
        '''Transformation of an image to its grayscale representation'''
        ...
    
    def adjust_brightness(self, brightness: int):
        '''Adjust of a brightness for image.
        
        :param brightness: Brightness value.'''
        ...
    
    def adjust_contrast(self, contrast: float):
        '''Image contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        ...
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        ...
    
    def filter(self, rectangle: aspose.imaging.Rectangle, options: aspose.imaging.imagefilters.filteroptions.FilterOptionsBase):
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        ...
    
    def replace_argb(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def premultiply_components(self) -> bool:
        ...
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool):
        ...
    
    @property
    def use_raw_data(self) -> bool:
        ...
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool):
        ...
    
    @property
    def update_xmp_data(self) -> bool:
        ...
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool):
        ...
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        ...
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper):
        ...
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        ...
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter):
        ...
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        ...
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter):
        ...
    
    @property
    def raw_fallback_index(self) -> int:
        ...
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int):
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        ...
    
    @property
    def raw_line_size(self) -> int:
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def horizontal_resolution(self) -> float:
        ...
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float):
        ...
    
    @property
    def vertical_resolution(self) -> float:
        ...
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float):
        ...
    
    @property
    def has_transparent_color(self) -> bool:
        ...
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool):
        ...
    
    @property
    def has_alpha(self) -> bool:
        ...
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        ...
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def image_opacity(self) -> float:
        ...
    
    ...

class RasterCachedMultipageImage(RasterCachedImage):
    '''The raster multipage image'''
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def rotate(self, angle: float, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed
        according to rotated rectangle (corner points) projections in other
        case that leaves dimensions untouched and only
        image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Cropping the image.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int, custom_palette: aspose.imaging.IColorPalette):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, partial_raw_data_loader: aspose.imaging.IPartialRawDataLoader, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings) -> bytes:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, dest_image_bounds: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float, window_size: int):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels
        centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels
        centered around this pixel.'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_area: aspose.imaging.Rectangle, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def adjust_gamma(self, gamma_red: float, gamma_green: float, gamma_blue: float):
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        ...
    
    @overload
    def adjust_gamma(self, gamma: float):
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        ...
    
    @overload
    def normalize_angle(self, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def normalize_angle(self):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.'''
        ...
    
    @overload
    def replace_color(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    @overload
    def replace_color(self, old_color: aspose.imaging.Color, old_color_diff: byte, new_color: aspose.imaging.Color):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb: int):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color: aspose.imaging.Color):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        ...
    
    def cache_data(self):
        '''Caches the data private.'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes this image instance metadata by setting this  value to .'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips all pages.
        
        :param rotate_flip_type: The rotate flip type.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        ...
    
    def get_modify_date(self, use_default: bool) -> DateTime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        ...
    
    def get_default_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def get_default_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        ...
    
    def get_argb_32_pixel(self, x: int, y: int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        ...
    
    def get_pixel(self, x: int, y: int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        ...
    
    def set_argb_32_pixel(self, x: int, y: int, argb_32_color: int):
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        ...
    
    def set_pixel(self, x: int, y: int, color: aspose.imaging.Color):
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        ...
    
    def read_scan_line(self, scan_line_index: int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        ...
    
    def read_argb_32_scan_line(self, scan_line_index: int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        ...
    
    def write_scan_line(self, scan_line_index: int, pixels: List[aspose.imaging.Color]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        ...
    
    def write_argb_32_scan_line(self, scan_line_index: int, argb_32_pixels: List[int]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        ...
    
    def load_partial_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        ...
    
    def load_partial_pixels(self, desired_rectangle: aspose.imaging.Rectangle, pixel_loader: aspose.imaging.IPartialPixelLoader):
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        ...
    
    def load_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        ...
    
    def load_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        ...
    
    def load_partial_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb64PixelLoader):
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        ...
    
    def load_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        ...
    
    def load_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        ...
    
    def load_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        ...
    
    def save_raw_data(self, data: bytes, data_offset: int, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        ...
    
    def save_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        ...
    
    def save_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.Color]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        ...
    
    def save_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.CmykColor]):
        '''Saves the pixels.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        ...
    
    def save_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        ...
    
    def set_resolution(self, dpi_x: float, dpi_y: float):
        '''Sets the resolution for this .
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the .
        :param dpi_y: The vertical resolution, in dots per inch, of the .'''
        ...
    
    def binarize_fixed(self, threshold: byte):
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of
        255 will be assigned to it, 0 otherwise.'''
        ...
    
    def binarize_otsu(self):
        '''Binarization of an image with Otsu thresholding'''
        ...
    
    def grayscale(self):
        '''Transformation of an image to its grayscale representation'''
        ...
    
    def adjust_brightness(self, brightness: int):
        '''Adjust of a ``brightness`` for image.
        
        :param brightness: Brightness value.'''
        ...
    
    def adjust_contrast(self, contrast: float):
        '''contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        ...
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        ...
    
    def filter(self, rectangle: aspose.imaging.Rectangle, options: aspose.imaging.imagefilters.filteroptions.FilterOptionsBase):
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        ...
    
    def replace_argb(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    def rotate_flip_all(self, rotate_flip: aspose.imaging.RotateFlipType):
        '''Rotates the flip all.
        
        :param rotate_flip: The rotate flip.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def premultiply_components(self) -> bool:
        ...
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool):
        ...
    
    @property
    def use_raw_data(self) -> bool:
        ...
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool):
        ...
    
    @property
    def update_xmp_data(self) -> bool:
        ...
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool):
        ...
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        ...
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper):
        ...
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        ...
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter):
        ...
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        ...
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter):
        ...
    
    @property
    def raw_fallback_index(self) -> int:
        ...
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int):
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        ...
    
    @property
    def raw_line_size(self) -> int:
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def horizontal_resolution(self) -> float:
        ...
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float):
        ...
    
    @property
    def vertical_resolution(self) -> float:
        ...
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float):
        ...
    
    @property
    def has_transparent_color(self) -> bool:
        ...
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool):
        ...
    
    @property
    def has_alpha(self) -> bool:
        ...
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        ...
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def image_opacity(self) -> float:
        ...
    
    @property
    def page_count(self) -> int:
        ...
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        ...
    
    ...

class RasterImage(Image):
    '''Represents a raster image supporting raster graphics operations.'''
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image with extended options.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def rotate(self, angle: float, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        ...
    
    @overload
    def dither(self, dithering_method: aspose.imaging.DitheringMethod, bits_count: int, custom_palette: aspose.imaging.IColorPalette):
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, partial_raw_data_loader: aspose.imaging.IPartialRawDataLoader, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        ...
    
    @overload
    def get_default_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings) -> bytes:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def load_raw_data(self, rectangle: aspose.imaging.Rectangle, dest_image_bounds: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings, raw_data_loader: aspose.imaging.IPartialRawDataLoader):
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.'''
        ...
    
    @overload
    def binarize_bradley(self, brightness_difference: float, window_size: int):
        '''Binarization of an image using Bradley's adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_area: aspose.imaging.Rectangle, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def blend(self, origin: aspose.imaging.Point, overlay: aspose.imaging.RasterImage, overlay_alpha: byte):
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        ...
    
    @overload
    def adjust_gamma(self, gamma_red: float, gamma_green: float, gamma_blue: float):
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        ...
    
    @overload
    def adjust_gamma(self, gamma: float):
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        ...
    
    @overload
    def normalize_angle(self):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.'''
        ...
    
    @overload
    def normalize_angle(self, resize_proportionally: bool, background_color: aspose.imaging.Color):
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses  and  methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        ...
    
    @overload
    def replace_color(self, old_color: aspose.imaging.Color, old_color_diff: byte, new_color: aspose.imaging.Color):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        ...
    
    @overload
    def replace_color(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color: aspose.imaging.Color):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        ...
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb: int):
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes this image instance metadata by setting this  value to .'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        ...
    
    def get_modify_date(self, use_default: bool) -> DateTime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        ...
    
    def get_default_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        ...
    
    def get_default_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        ...
    
    def get_argb_32_pixel(self, x: int, y: int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        ...
    
    def get_pixel(self, x: int, y: int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        ...
    
    def set_argb_32_pixel(self, x: int, y: int, argb_32_color: int):
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        ...
    
    def set_pixel(self, x: int, y: int, color: aspose.imaging.Color):
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        ...
    
    def read_scan_line(self, scan_line_index: int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        ...
    
    def read_argb_32_scan_line(self, scan_line_index: int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        ...
    
    def write_scan_line(self, scan_line_index: int, pixels: List[aspose.imaging.Color]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        ...
    
    def write_argb_32_scan_line(self, scan_line_index: int, argb_32_pixels: List[int]):
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        ...
    
    def load_partial_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb32PixelLoader):
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        ...
    
    def load_partial_pixels(self, desired_rectangle: aspose.imaging.Rectangle, pixel_loader: aspose.imaging.IPartialPixelLoader):
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        ...
    
    def load_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        ...
    
    def load_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        ...
    
    def load_partial_argb_64_pixels(self, rectangle: aspose.imaging.Rectangle, partial_pixel_loader: aspose.imaging.IPartialArgb64PixelLoader):
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        ...
    
    def load_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        ...
    
    def load_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        ...
    
    def load_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        ...
    
    def save_raw_data(self, data: bytes, data_offset: int, rectangle: aspose.imaging.Rectangle, raw_data_settings: aspose.imaging.RawDataSettings):
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        ...
    
    def save_argb_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        ...
    
    def save_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.Color]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        ...
    
    def save_cmyk_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[aspose.imaging.CmykColor]):
        '''Saves the pixels.
        This method is deprecated. Please use more effective the  method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        ...
    
    def save_cmyk_32_pixels(self, rectangle: aspose.imaging.Rectangle, pixels: List[int]):
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        ...
    
    def set_resolution(self, dpi_x: float, dpi_y: float):
        '''Sets the resolution for this .
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the .
        :param dpi_y: The vertical resolution, in dots per inch, of the .'''
        ...
    
    def binarize_fixed(self, threshold: byte):
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of 255 will be assigned to it, 0 otherwise.'''
        ...
    
    def binarize_otsu(self):
        '''Binarization of an image with Otsu thresholding'''
        ...
    
    def grayscale(self):
        '''Transformation of an image to its grayscale representation'''
        ...
    
    def adjust_brightness(self, brightness: int):
        '''Adjust of a brightness for image.
        
        :param brightness: Brightness value.'''
        ...
    
    def adjust_contrast(self, contrast: float):
        '''Image contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        ...
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        ...
    
    def filter(self, rectangle: aspose.imaging.Rectangle, options: aspose.imaging.imagefilters.filteroptions.FilterOptionsBase):
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        ...
    
    def replace_argb(self, old_color_argb: int, old_color_diff: byte, new_color_argb: int):
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def premultiply_components(self) -> bool:
        ...
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool):
        ...
    
    @property
    def use_raw_data(self) -> bool:
        ...
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool):
        ...
    
    @property
    def update_xmp_data(self) -> bool:
        ...
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool):
        ...
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        ...
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper):
        ...
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        ...
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter):
        ...
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        ...
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter):
        ...
    
    @property
    def raw_fallback_index(self) -> int:
        ...
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int):
        ...
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        ...
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        ...
    
    @property
    def raw_line_size(self) -> int:
        ...
    
    @property
    def is_raw_data_available(self) -> bool:
        ...
    
    @property
    def horizontal_resolution(self) -> float:
        ...
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float):
        ...
    
    @property
    def vertical_resolution(self) -> float:
        ...
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float):
        ...
    
    @property
    def has_transparent_color(self) -> bool:
        ...
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool):
        ...
    
    @property
    def has_alpha(self) -> bool:
        ...
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        ...
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def image_opacity(self) -> float:
        ...
    
    ...

class RawDataSettings:
    '''The raw data settings'''
    
    def __init__(self):
        ...
    
    def clone(self) -> aspose.imaging.RawDataSettings:
        '''Creates a shalow clone.
        
        :returns: A shalow clone.'''
        ...
    
    @property
    def pixel_data_format(self) -> aspose.imaging.PixelDataFormat:
        ...
    
    @pixel_data_format.setter
    def pixel_data_format(self, value : aspose.imaging.PixelDataFormat):
        ...
    
    @property
    def color_palette(self) -> aspose.imaging.IColorPalette:
        ...
    
    @color_palette.setter
    def color_palette(self, value : aspose.imaging.IColorPalette):
        ...
    
    @property
    def dithering_method(self) -> aspose.imaging.DitheringMethods:
        ...
    
    @dithering_method.setter
    def dithering_method(self, value : aspose.imaging.DitheringMethods):
        ...
    
    @property
    def indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        ...
    
    @indexed_color_converter.setter
    def indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter):
        ...
    
    @property
    def custom_color_converter(self) -> aspose.imaging.IColorConverter:
        ...
    
    @custom_color_converter.setter
    def custom_color_converter(self, value : aspose.imaging.IColorConverter):
        ...
    
    @property
    def fallback_index(self) -> int:
        ...
    
    @fallback_index.setter
    def fallback_index(self, value : int):
        ...
    
    @property
    def line_size(self) -> int:
        ...
    
    @line_size.setter
    def line_size(self, value : int):
        ...
    
    ...

class Rectangle:
    '''Stores a set of four integers that represent the location and size of a rectangle.'''
    
    @overload
    def __init__(self, x: int, y: int, width: int, height: int):
        '''Initializes a new instance of the  structure with the specified location and size.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle.
        :param y: The y-coordinate of the upper-left corner of the rectangle.
        :param width: The width of the rectangle.
        :param height: The height of the rectangle.'''
        ...
    
    @overload
    def __init__(self, location: aspose.imaging.Point, size: aspose.imaging.Size):
        '''Initializes a new instance of the  structure with the specified location and size.
        
        :param location: A  that represents the upper-left corner of the rectangular region.
        :param size: A  that represents the width and height of the rectangular region.'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @overload
    @staticmethod
    def inflate(rect: aspose.imaging.Rectangle, x: int, y: int) -> aspose.imaging.Rectangle:
        '''Creates and returns an inflated copy of the specified  structure. The copy is inflated by the specified amount. The original  structure remains unmodified.
        
        :param rect: The  with which to start. This rectangle is not modified.
        :param x: The amount to inflate this  horizontally.
        :param y: The amount to inflate this  vertically.
        :returns: The inflated .'''
        ...
    
    @overload
    def inflate(self, width: int, height: int):
        '''Inflates this  by the specified amount.
        
        :param width: The amount to inflate this  horizontally.
        :param height: The amount to inflate this  vertically.'''
        ...
    
    @overload
    def inflate(self, size: aspose.imaging.Size):
        '''Inflates this  by the specified amount.
        
        :param size: The amount to inflate this rectangle.'''
        ...
    
    @overload
    @staticmethod
    def intersect(a: aspose.imaging.Rectangle, b: aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Returns a third  structure that represents the intersection of two other  structures. If there is no intersection, an empty  is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A  that represents the intersection of ``a`` and ``b``.'''
        ...
    
    @overload
    def intersect(self, rect: aspose.imaging.Rectangle):
        '''Replaces this  with the intersection of itself and the specified .
        
        :param rect: The  with which to intersect.'''
        ...
    
    @overload
    def contains(self, x: int, y: int) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the point defined by ``x`` and ``y`` is contained within this  structure; otherwise false.'''
        ...
    
    @overload
    def contains(self, point: aspose.imaging.Point) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param point: The  to test.
        :returns: This method returns true if the point represented by ``point`` is contained within this  structure; otherwise false.'''
        ...
    
    @overload
    def contains(self, rect: aspose.imaging.Rectangle) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this  structure.
        
        :param rect: The  to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within this  structure; otherwise false.'''
        ...
    
    @overload
    def offset(self, pos: aspose.imaging.Point):
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param pos: Amount to offset the location.'''
        ...
    
    @overload
    def offset(self, x: int, y: int):
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param x: The horizontal offset.
        :param y: The vertical offset.'''
        ...
    
    @staticmethod
    def from_points(point1: aspose.imaging.Point, point2: aspose.imaging.Point) -> aspose.imaging.Rectangle:
        '''Creates a new  from two points specified. Two verticales of the created  will be equal to the passed ``point1`` and ``point2``. These would be typically the opposite vertices.
        
        :param point1: The first  for the new rectangle.
        :param point2: The second  for the new rectangle.
        :returns: A newly created .'''
        ...
    
    @staticmethod
    def ceiling(value: aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified  structure to a  structure by rounding the  values to the next higher integer values.
        
        :param value: The  structure to be converted.
        :returns: Returns a .'''
        ...
    
    @staticmethod
    def truncate(value: aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified  to a  by truncating the  values.
        
        :param value: The  to be converted.
        :returns: A new .'''
        ...
    
    @staticmethod
    def round(value: aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified  to a  by rounding the  values to the nearest integer values.
        
        :param value: The  to be converted.
        :returns: A new .'''
        ...
    
    @staticmethod
    def inflate_rect(rect: aspose.imaging.Rectangle, x: int, y: int) -> aspose.imaging.Rectangle:
        '''Creates and returns an inflated copy of the specified  structure. The copy is inflated by the specified amount. The original  structure remains unmodified.
        
        :param rect: The  with which to start. This rectangle is not modified.
        :param x: The amount to inflate this  horizontally.
        :param y: The amount to inflate this  vertically.
        :returns: The inflated .'''
        ...
    
    @staticmethod
    def intersect_rects(a: aspose.imaging.Rectangle, b: aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Returns a third  structure that represents the intersection of two other  structures. If there is no intersection, an empty  is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A  that represents the intersection of ``a`` and ``b``.'''
        ...
    
    @staticmethod
    def union(a: aspose.imaging.Rectangle, b: aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Gets a  structure that contains the union of two  structures.
        
        :param a: A first rectangle to union.
        :param b: A second rectangle to union.
        :returns: A  structure that bounds the union of the two  structures.'''
        ...
    
    @staticmethod
    def from_left_top_right_bottom(left: int, top: int, right: int, bottom: int) -> aspose.imaging.Rectangle:
        '''Creates a  structure with the specified edge locations.
        
        :param left: The x-coordinate of the upper-left corner of this  structure.
        :param top: The y-coordinate of the upper-left corner of this  structure.
        :param right: The x-coordinate of the lower-right corner of this  structure.
        :param bottom: The y-coordinate of the lower-right corner of this  structure.
        :returns: The new  that this method creates.'''
        ...
    
    def contains_point(self, point: aspose.imaging.Point) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param point: The  to test.
        :returns: This method returns true if the point represented by ``point`` is contained within this  structure; otherwise false.'''
        ...
    
    def contains_rect(self, rect: aspose.imaging.Rectangle) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this  structure.
        
        :param rect: The  to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within this  structure; otherwise false.'''
        ...
    
    def intersects_with(self, rect: aspose.imaging.Rectangle) -> bool:
        '''Determines if this rectangle intersects with ``rect``.
        
        :param rect: The rectangle to test.
        :returns: This method returns true if there is any intersection, otherwise false.'''
        ...
    
    def normalize(self):
        '''Normalizes the rectangle by making it's width and height positive, left less than right and top less than bottom.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.Rectangle:
        '''Gets a new instance of the  structure that has , ,  and  values set to zero.'''
        ...
    
    @property
    def location(self) -> aspose.imaging.Point:
        '''Gets the coordinates of the upper-left corner of this  structure.'''
        ...
    
    @location.setter
    def location(self, value : aspose.imaging.Point):
        '''Sets the coordinates of the upper-left corner of this  structure.'''
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the size of this .'''
        ...
    
    @size.setter
    def size(self, value : aspose.imaging.Size):
        '''Sets the size of this .'''
        ...
    
    @property
    def x(self) -> int:
        '''Gets the x-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @x.setter
    def x(self, value : int):
        '''Sets the x-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @property
    def y(self) -> int:
        '''Gets the y-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @y.setter
    def y(self, value : int):
        '''Sets the y-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the width of this  structure.'''
        ...
    
    @width.setter
    def width(self, value : int):
        '''Sets the width of this  structure.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the height of this  structure.'''
        ...
    
    @height.setter
    def height(self, value : int):
        '''Sets the height of this  structure.'''
        ...
    
    @property
    def left(self) -> int:
        '''Gets the x-coordinate of the left edge of this  structure.'''
        ...
    
    @left.setter
    def left(self, value : int):
        '''Sets the x-coordinate of the left edge of this  structure.'''
        ...
    
    @property
    def top(self) -> int:
        '''Gets the y-coordinate of the top edge of this  structure.'''
        ...
    
    @top.setter
    def top(self, value : int):
        '''Sets the y-coordinate of the top edge of this  structure.'''
        ...
    
    @property
    def right(self) -> int:
        '''Gets the x-coordinate that is the sum of  and  property values of this  structure.'''
        ...
    
    @right.setter
    def right(self, value : int):
        '''Sets the x-coordinate that is the sum of  and  property values of this  structure.'''
        ...
    
    @property
    def bottom(self) -> int:
        '''Gets the y-coordinate that is the sum of the  and  property values of this  structure.'''
        ...
    
    @bottom.setter
    def bottom(self, value : int):
        '''Sets the y-coordinate that is the sum of the  and  property values of this  structure.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    ...

class RectangleF:
    '''Stores a set of four floating-point numbers that represent the location and size of a rectangle.'''
    
    @overload
    def __init__(self, x: float, y: float, width: float, height: float):
        '''Initializes a new instance of the  structure with the specified location and size.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle.
        :param y: The y-coordinate of the upper-left corner of the rectangle.
        :param width: The width of the rectangle.
        :param height: The height of the rectangle.'''
        ...
    
    @overload
    def __init__(self, location: aspose.imaging.PointF, size: aspose.imaging.SizeF):
        '''Initializes a new instance of the  structure with the specified location and size.
        
        :param location: A  that represents the upper-left corner of the rectangular region.
        :param size: A  that represents the width and height of the rectangular region.'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @overload
    @staticmethod
    def inflate(rect: aspose.imaging.RectangleF, x: float, y: float) -> aspose.imaging.RectangleF:
        '''Creates and returns an inflated copy of the specified  structure. The copy is inflated by the specified amount. The original rectangle remains unmodified.
        
        :param rect: The  to be copied. This rectangle is not modified.
        :param x: The amount to inflate the copy of the rectangle horizontally.
        :param y: The amount to inflate the copy of the rectangle vertically.
        :returns: The inflated .'''
        ...
    
    @overload
    def inflate(self, x: float, y: float):
        '''Inflates this  structure by the specified amount.
        
        :param x: The amount to inflate this  structure horizontally.
        :param y: The amount to inflate this  structure vertically.'''
        ...
    
    @overload
    def inflate(self, size: aspose.imaging.SizeF):
        '''Inflates this  by the specified amount.
        
        :param size: The amount to inflate this rectangle.'''
        ...
    
    @overload
    @staticmethod
    def intersect(a: aspose.imaging.RectangleF, b: aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Returns a  structure that represents the intersection of two rectangles. If there is no intersection, and empty  is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A third  structure the size of which represents the overlapped area of the two specified rectangles.'''
        ...
    
    @overload
    def intersect(self, rect: aspose.imaging.RectangleF):
        '''Replaces this  structure with the intersection of itself and the specified  structure.
        
        :param rect: The rectangle to intersect.'''
        ...
    
    @overload
    def contains(self, x: float, y: float) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the point defined by ``x`` and ``y`` is contained within this  structure; otherwise false.'''
        ...
    
    @overload
    def contains(self, point: aspose.imaging.PointF) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param point: The  to test.
        :returns: This method returns true if the point represented by the ``point`` parameter is contained within this  structure; otherwise false.'''
        ...
    
    @overload
    def contains(self, rect: aspose.imaging.RectangleF) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this  structure.
        
        :param rect: The  to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within the rectangular region represented by this ; otherwise false.'''
        ...
    
    @overload
    def offset(self, pos: aspose.imaging.PointF):
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param pos: The amount to offset the location.'''
        ...
    
    @overload
    def offset(self, x: float, y: float):
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param x: The amount to offset the location horizontally.
        :param y: The amount to offset the location vertically.'''
        ...
    
    @staticmethod
    def from_points(point1: aspose.imaging.PointF, point2: aspose.imaging.PointF) -> aspose.imaging.RectangleF:
        '''Creates a new  from two points specified. Two verticles of the created  will be equal to the passed ``point1`` and ``point2``. These would be typically the opposite vertices.
        
        :param point1: The first  for the new rectangle.
        :param point2: The second  for the new rectangle.
        :returns: A newly created .'''
        ...
    
    @staticmethod
    def inflate_rect(rect: aspose.imaging.RectangleF, x: float, y: float) -> aspose.imaging.RectangleF:
        '''Creates and returns an inflated copy of the specified  structure. The copy is inflated by the specified amount. The original rectangle remains unmodified.
        
        :param rect: The  to be copied. This rectangle is not modified.
        :param x: The amount to inflate the copy of the rectangle horizontally.
        :param y: The amount to inflate the copy of the rectangle vertically.
        :returns: The inflated .'''
        ...
    
    @staticmethod
    def intersect_rects(a: aspose.imaging.RectangleF, b: aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Returns a  structure that represents the intersection of two rectangles. If there is no intersection, and empty  is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A third  structure the size of which represents the overlapped area of the two specified rectangles.'''
        ...
    
    @staticmethod
    def union(a: aspose.imaging.RectangleF, b: aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Creates the smallest possible third rectangle that can contain both of two rectangles that form a union.
        
        :param a: A first rectangle to union.
        :param b: A second rectangle to union.
        :returns: A third  structure that contains both of the two rectangles that form the union.'''
        ...
    
    @staticmethod
    def from_left_top_right_bottom(left: float, top: float, right: float, bottom: float) -> aspose.imaging.RectangleF:
        '''Creates a  structure with upper-left corner and lower-right corner at the specified locations.
        
        :param left: The x-coordinate of the upper-left corner of the rectangular region.
        :param top: The y-coordinate of the upper-left corner of the rectangular region.
        :param right: The x-coordinate of the lower-right corner of the rectangular region.
        :param bottom: The y-coordinate of the lower-right corner of the rectangular region.
        :returns: The new  that this method creates.'''
        ...
    
    def normalize(self):
        '''Normalizes the rectangle by making it's width and height positive, left less than right and top less than bottom.'''
        ...
    
    def contains_point_f(self, point: aspose.imaging.PointF) -> bool:
        '''Determines if the specified point is contained within this  structure.
        
        :param point: The  to test.
        :returns: This method returns true if the point represented by the ``point`` parameter is contained within this  structure; otherwise false.'''
        ...
    
    def contains_rect_f(self, rect: aspose.imaging.RectangleF) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this  structure.
        
        :param rect: The  to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within the rectangular region represented by this ; otherwise false.'''
        ...
    
    def intersects_with(self, rect: aspose.imaging.RectangleF) -> bool:
        '''Determines if this rectangle intersects with ``rect``.
        
        :param rect: The rectangle to test.
        :returns: This method returns true if there is any intersection.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.RectangleF:
        '''Gets a new instance of the  structure that has , ,  and  values set to zero.'''
        ...
    
    @property
    def location(self) -> aspose.imaging.PointF:
        '''Gets the coordinates of the upper-left corner of this  structure.'''
        ...
    
    @location.setter
    def location(self, value : aspose.imaging.PointF):
        '''Sets the coordinates of the upper-left corner of this  structure.'''
        ...
    
    @property
    def size(self) -> aspose.imaging.SizeF:
        '''Gets the size of this .'''
        ...
    
    @size.setter
    def size(self, value : aspose.imaging.SizeF):
        '''Sets the size of this .'''
        ...
    
    @property
    def x(self) -> float:
        '''Gets the x-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @x.setter
    def x(self, value : float):
        '''Sets the x-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @property
    def y(self) -> float:
        '''Gets the y-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @y.setter
    def y(self, value : float):
        '''Sets the y-coordinate of the upper-left corner of this  structure.'''
        ...
    
    @property
    def width(self) -> float:
        '''Gets the width of this  structure.'''
        ...
    
    @width.setter
    def width(self, value : float):
        '''Sets the width of this  structure.'''
        ...
    
    @property
    def height(self) -> float:
        '''Gets the height of this  structure.'''
        ...
    
    @height.setter
    def height(self, value : float):
        '''Sets the height of this  structure.'''
        ...
    
    @property
    def left(self) -> float:
        '''Gets the x-coordinate of the left edge of this  structure.'''
        ...
    
    @left.setter
    def left(self, value : float):
        '''Sets the x-coordinate of the left edge of this  structure.'''
        ...
    
    @property
    def top(self) -> float:
        '''Gets the y-coordinate of the top edge of this  structure.'''
        ...
    
    @top.setter
    def top(self, value : float):
        '''Sets the y-coordinate of the top edge of this  structure.'''
        ...
    
    @property
    def right(self) -> float:
        '''Gets the x-coordinate that is the sum of  and  of this  structure.'''
        ...
    
    @right.setter
    def right(self, value : float):
        '''Sets the x-coordinate that is the sum of  and  of this  structure.'''
        ...
    
    @property
    def bottom(self) -> float:
        '''Gets the y-coordinate that is the sum of  and  of this  structure.'''
        ...
    
    @bottom.setter
    def bottom(self, value : float):
        '''Sets the y-coordinate that is the sum of  and  of this  structure.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    ...

class Region:
    '''Describes the interior of a graphics shape composed of rectangles and paths. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new .'''
        ...
    
    @overload
    def __init__(self, rect: aspose.imaging.RectangleF):
        '''Initializes a new  from the specified  structure.
        
        :param rect: A  structure that defines the interior of the new .'''
        ...
    
    @overload
    def __init__(self, rect: aspose.imaging.Rectangle):
        '''Initializes a new  from the specified  structure.
        
        :param rect: A  structure that defines the interior of the new .'''
        ...
    
    @overload
    def __init__(self, path: aspose.imaging.GraphicsPath):
        '''Initializes a new  with the specified .
        
        :param path: A  that defines the new .'''
        ...
    
    @overload
    def intersect(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the intersection of itself with the specified  structure.
        
        :param rect: The  structure to intersect with this .'''
        ...
    
    @overload
    def intersect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the intersection of itself with the specified  structure.
        
        :param rect: The  structure to intersect with this .'''
        ...
    
    @overload
    def intersect(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the intersection of itself with the specified .
        
        :param path: The  to intersect with this .'''
        ...
    
    @overload
    def intersect(self, region: aspose.imaging.Region):
        '''Updates this  to the intersection of itself with the specified .
        
        :param region: The  to intersect with this .'''
        ...
    
    @overload
    def union(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the union of itself and the specified  structure.
        
        :param rect: The  structure to unite with this .'''
        ...
    
    @overload
    def union(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the union of itself and the specified  structure.
        
        :param rect: The  structure to unite with this .'''
        ...
    
    @overload
    def union(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the union of itself and the specified .
        
        :param path: The  to unite with this .'''
        ...
    
    @overload
    def union(self, region: aspose.imaging.Region):
        '''Updates this  to the union of itself and the specified .
        
        :param region: The  to unite with this .'''
        ...
    
    @overload
    def xor(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the union minus the intersection of itself with the specified  structure.
        
        :param rect: The  structure to xor with this .'''
        ...
    
    @overload
    def xor(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the union minus the intersection of itself with the specified  structure.
        
        :param rect: The  structure to xor with this .'''
        ...
    
    @overload
    def xor(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the union minus the intersection of itself with the specified .
        
        :param path: The  to xor with this .'''
        ...
    
    @overload
    def xor(self, region: aspose.imaging.Region):
        '''Updates this  to the union minus the intersection of itself with the specified .
        
        :param region: The  to xor with this .'''
        ...
    
    @overload
    def exclude(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified  structure.
        
        :param rect: The  structure to exclude from this .'''
        ...
    
    @overload
    def exclude(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified  structure.
        
        :param rect: The  structure to exclude from this .'''
        ...
    
    @overload
    def exclude(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified .
        
        :param path: The  to exclude from this .'''
        ...
    
    @overload
    def exclude(self, region: aspose.imaging.Region):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified .
        
        :param region: The  to exclude from this .'''
        ...
    
    @overload
    def complement(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to contain the portion of the specified  structure that does not intersect with this .
        
        :param rect: The  structure to complement this .'''
        ...
    
    @overload
    def complement(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to contain the portion of the specified  structure that does not intersect with this .
        
        :param rect: The  structure to complement this .'''
        ...
    
    @overload
    def complement(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to contain the portion of the specified  that does not intersect with this .
        
        :param path: The  to complement this .'''
        ...
    
    @overload
    def complement(self, region: aspose.imaging.Region):
        '''Updates this  to contain the portion of the specified  that does not intersect with this .
        
        :param region: The  object to complement this  object.'''
        ...
    
    @overload
    def translate(self, dx: float, dy: float):
        '''Offsets the coordinates of this  by the specified amount.
        
        :param dx: The amount to offset this  horizontally.
        :param dy: The amount to offset this  vertically.'''
        ...
    
    @overload
    def translate(self, dx: int, dy: int):
        '''Offsets the coordinates of this  by the specified amount.
        
        :param dx: The amount to offset this  horizontally.
        :param dy: The amount to offset this  vertically.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float) -> bool:
        '''Tests whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: True when the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.PointF) -> bool:
        '''Tests whether the specified  structure is contained within this .
        
        :param point: The  structure to test.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A  that represents a graphics context.
        :returns: True when the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.PointF, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified  structure is contained within this  when drawn using the specified .
        
        :param point: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float, width: float, height: float) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this  object; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, rect: aspose.imaging.RectangleF) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this .
        
        :param rect: The  structure to test.
        :returns: true when any portion of ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: float, y: float, width: float, height: float, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, rect: aspose.imaging.RectangleF, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this  when drawn using the specified .
        
        :param rect: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: int, y: int, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this  object when drawn using the specified  object.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A  that represents a graphics context.
        :returns: true when the specified point is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.Point) -> bool:
        '''Tests whether the specified  structure is contained within this .
        
        :param point: The  structure to test.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, point: aspose.imaging.Point, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified  structure is contained within this  when drawn using the specified .
        
        :param point: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: int, y: int, width: int, height: int) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, rect: aspose.imaging.Rectangle) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this .
        
        :param rect: The  structure to test.
        :returns: This method returns true when any portion of ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, x: int, y: int, width: int, height: int, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    @overload
    def is_visible(self, rect: aspose.imaging.Rectangle, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this  when drawn using the specified .
        
        :param rect: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    @staticmethod
    def create_with_rect_f(rect: aspose.imaging.RectangleF) -> aspose.imaging.Region:
        '''Initializes a new  from the specified  structure.
        
        :param rect: A  structure that defines the interior of the new .'''
        ...
    
    @staticmethod
    def create_with_rect(rect: aspose.imaging.Rectangle) -> aspose.imaging.Region:
        '''Initializes a new  from the specified  structure.
        
        :param rect: A  structure that defines the interior of the new .'''
        ...
    
    @staticmethod
    def create_with_path(path: aspose.imaging.GraphicsPath) -> aspose.imaging.Region:
        '''Initializes a new  with the specified .
        
        :param path: A  that defines the new .'''
        ...
    
    def deep_clone(self) -> aspose.imaging.Region:
        '''Creates an exact deep copy of this .
        
        :returns: The  that this method creates.'''
        ...
    
    def make_infinite(self):
        '''Initializes this  object to an infinite interior.'''
        ...
    
    def make_empty(self):
        '''Initializes this  to an empty interior.'''
        ...
    
    def intersect_rect_f(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the intersection of itself with the specified  structure.
        
        :param rect: The  structure to intersect with this .'''
        ...
    
    def intersect_rect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the intersection of itself with the specified  structure.
        
        :param rect: The  structure to intersect with this .'''
        ...
    
    def intersect_path(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the intersection of itself with the specified .
        
        :param path: The  to intersect with this .'''
        ...
    
    def intersect_rgn(self, region: aspose.imaging.Region):
        '''Updates this  to the intersection of itself with the specified .
        
        :param region: The  to intersect with this .'''
        ...
    
    def union_rect_f(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the union of itself and the specified  structure.
        
        :param rect: The  structure to unite with this .'''
        ...
    
    def union_rect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the union of itself and the specified  structure.
        
        :param rect: The  structure to unite with this .'''
        ...
    
    def union_path(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the union of itself and the specified .
        
        :param path: The  to unite with this .'''
        ...
    
    def union_rgn(self, region: aspose.imaging.Region):
        '''Updates this  to the union of itself and the specified .
        
        :param region: The  to unite with this .'''
        ...
    
    def xor_rect_f(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to the union minus the intersection of itself with the specified  structure.
        
        :param rect: The  structure to xor with this .'''
        ...
    
    def xor_rect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to the union minus the intersection of itself with the specified  structure.
        
        :param rect: The  structure to xor with this .'''
        ...
    
    def xor_path(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to the union minus the intersection of itself with the specified .
        
        :param path: The  to xor with this .'''
        ...
    
    def xor_rgn(self, region: aspose.imaging.Region):
        '''Updates this  to the union minus the intersection of itself with the specified .
        
        :param region: The  to xor with this .'''
        ...
    
    def exclude_rect_f(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified  structure.
        
        :param rect: The  structure to exclude from this .'''
        ...
    
    def exclude_rect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified  structure.
        
        :param rect: The  structure to exclude from this .'''
        ...
    
    def exclude_path(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified .
        
        :param path: The  to exclude from this .'''
        ...
    
    def exclude_rgn(self, region: aspose.imaging.Region):
        '''Updates this  to contain only the portion of its interior that does not intersect with the specified .
        
        :param region: The  to exclude from this .'''
        ...
    
    def complement_rect_f(self, rect: aspose.imaging.RectangleF):
        '''Updates this  to contain the portion of the specified  structure that does not intersect with this .
        
        :param rect: The  structure to complement this .'''
        ...
    
    def complement_rect(self, rect: aspose.imaging.Rectangle):
        '''Updates this  to contain the portion of the specified  structure that does not intersect with this .
        
        :param rect: The  structure to complement this .'''
        ...
    
    def complement_path(self, path: aspose.imaging.GraphicsPath):
        '''Updates this  to contain the portion of the specified  that does not intersect with this .
        
        :param path: The  to complement this .'''
        ...
    
    def complement_rgn(self, region: aspose.imaging.Region):
        '''Updates this  to contain the portion of the specified  that does not intersect with this .
        
        :param region: The  object to complement this  object.'''
        ...
    
    def translate_f(self, dx: float, dy: float):
        '''Offsets the coordinates of this  by the specified amount.
        
        :param dx: The amount to offset this  horizontally.
        :param dy: The amount to offset this  vertically.'''
        ...
    
    def transform(self, matrix: aspose.imaging.Matrix):
        '''Transforms this  by the specified .
        
        :param matrix: The  by which to transform this .'''
        ...
    
    def is_empty(self, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether this  has an empty interior on the specified drawing surface.
        
        :param g: A  that represents a drawing surface.
        :returns: true if the interior of this  is empty when the transformation associated with ``g`` is applied; otherwise, false.'''
        ...
    
    def is_infinite(self, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether this  has an infinite interior on the specified drawing surface.
        
        :param g: A  that represents a drawing surface.
        :returns: true if the interior of this  is infinite when the transformation associated with ``g`` is applied; otherwise, false.'''
        ...
    
    def equals(self, region: aspose.imaging.Region, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified  is identical to this  on the specified drawing surface.
        
        :param region: The  to test.
        :param g: A  that represents a drawing surface.
        :returns: True if the interior of region is identical to the interior of this region when the transformation associated with the ``g`` parameter is applied; otherwise, false.'''
        ...
    
    def is_visible_f(self, x: float, y: float) -> bool:
        '''Tests whether the specified point is contained within this .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: True when the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_f(self, point: aspose.imaging.PointF) -> bool:
        '''Tests whether the specified  structure is contained within this .
        
        :param point: The  structure to test.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_with_graphics_f(self, x: float, y: float, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A  that represents a graphics context.
        :returns: True when the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_f_with_graphics(self, point: aspose.imaging.PointF, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified  structure is contained within this  when drawn using the specified .
        
        :param point: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xywhf(self, x: float, y: float, width: float, height: float) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this  object; otherwise, false.'''
        ...
    
    def is_visible_rect_f(self, rect: aspose.imaging.RectangleF) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this .
        
        :param rect: The  structure to test.
        :returns: true when any portion of ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xywh_graphics_f(self, x: float, y: float, width: float, height: float, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_rect_f_with_graphics(self, rect: aspose.imaging.RectangleF, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this  when drawn using the specified .
        
        :param rect: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_with_graphics(self, x: int, y: int, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this  object when drawn using the specified  object.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A  that represents a graphics context.
        :returns: true when the specified point is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point(self, point: aspose.imaging.Point) -> bool:
        '''Tests whether the specified  structure is contained within this .
        
        :param point: The  structure to test.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_point_with_graphics(self, point: aspose.imaging.Point, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified  structure is contained within this  when drawn using the specified .
        
        :param point: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when ``point`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xywh(self, x: int, y: int, width: int, height: int) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_rect(self, rect: aspose.imaging.Rectangle) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this .
        
        :param rect: The  structure to test.
        :returns: This method returns true when any portion of ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_xywh_graphics(self, x: int, y: int, width: int, height: int, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this  when drawn using the specified .
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this ; otherwise, false.'''
        ...
    
    def is_visible_rect_with_graphics(self, rect: aspose.imaging.Rectangle, g: aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified  structure is contained within this  when drawn using the specified .
        
        :param rect: The  structure to test.
        :param g: A  that represents a graphics context.
        :returns: true when any portion of the ``rect`` is contained within this ; otherwise, false.'''
        ...
    
    ...

class RemoveBackgroundSettings:
    '''The remve background settings'''
    
    def __init__(self):
        ...
    
    @property
    def detection_level(self) -> Optional[int]:
        ...
    
    @detection_level.setter
    def detection_level(self, value : Optional[int]):
        ...
    
    @property
    def bounds(self) -> Optional[aspose.imaging.RectangleF]:
        '''Gets the bounds.'''
        ...
    
    @bounds.setter
    def bounds(self, value : Optional[aspose.imaging.RectangleF]):
        '''Sets the bounds.'''
        ...
    
    @property
    def color1(self) -> Optional[aspose.imaging.Color]:
        '''Gets the color.'''
        ...
    
    @color1.setter
    def color1(self, value : Optional[aspose.imaging.Color]):
        '''Sets the color.'''
        ...
    
    @property
    def color2(self) -> Optional[aspose.imaging.Color]:
        '''Gets the color2.'''
        ...
    
    @color2.setter
    def color2(self, value : Optional[aspose.imaging.Color]):
        '''Sets the color2.'''
        ...
    
    ...

class ResolutionSetting:
    '''The resolution setting for image save options.'''
    
    @overload
    def __init__(self):
        '''Initializes a new instance of the  class.'''
        ...
    
    @overload
    def __init__(self, horizontal_resolution: float, vertical_resolution: float):
        '''Initializes a new instance of the  class.
        
        :param horizontal_resolution: The horizontal resolution.
        :param vertical_resolution: The vertical resolution.'''
        ...
    
    @property
    def horizontal_resolution(self) -> float:
        ...
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float):
        ...
    
    @property
    def vertical_resolution(self) -> float:
        ...
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float):
        ...
    
    ...

class Shape(ObjectWithBounds):
    '''The shape. A continuous set of points connected using a specific rule.'''
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object's bounds.'''
        ...
    
    @overload
    def get_bounds(self, matrix: aspose.imaging.Matrix, pen: aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object's bounds size.
        :returns: The estimated object's bounds.'''
        ...
    
    def transform(self, transform: aspose.imaging.Matrix):
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        ...
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object's bounds.'''
        ...
    
    @property
    def center(self) -> aspose.imaging.PointF:
        '''Gets the shape's center.'''
        ...
    
    @property
    def segments(self) -> List[aspose.imaging.ShapeSegment]:
        '''Gets the shape segments.'''
        ...
    
    @property
    def has_segments(self) -> bool:
        ...
    
    ...

class ShapeSegment:
    '''Represents a shape segment. A segment is a line or curve connecting two points.'''
    
    @property
    def start_point(self) -> aspose.imaging.PointF:
        ...
    
    @property
    def end_point(self) -> aspose.imaging.PointF:
        ...
    
    ...

class Size:
    '''Represents size.'''
    
    @overload
    def __init__(self, point: aspose.imaging.Point):
        '''Initializes a new instance of the  structure from the specified .
        
        :param point: The  from which to initialize this .'''
        ...
    
    @overload
    def __init__(self, width: int, height: int):
        '''Initializes a new instance of the  structure from the specified dimensions.
        
        :param width: The width component of the new .
        :param height: The height component of the new .'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @staticmethod
    def add(size1: aspose.imaging.Size, size2: aspose.imaging.Size) -> aspose.imaging.Size:
        '''Adds the width and height of one  structure to the width and height of another  structure.
        
        :param size1: The first  to add.
        :param size2: The second  to add.
        :returns: A  structure that is the result of the addition operation.'''
        ...
    
    @staticmethod
    def ceiling(size: aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified  structure to a  structure by rounding the values of the  structure to the next higher integer values.
        
        :param size: The  structure to convert.
        :returns: The  structure this method converts to.'''
        ...
    
    @staticmethod
    def subtract(size1: aspose.imaging.Size, size2: aspose.imaging.Size) -> aspose.imaging.Size:
        '''Subtracts the width and height of one  structure from the width and height of another  structure.
        
        :param size1: The  structure on the left side of the subtraction operator.
        :param size2: The  structure on the right side of the subtraction operator.
        :returns: The  that is a result of the subtraction operation.'''
        ...
    
    @staticmethod
    def truncate(size: aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified  structure to a  structure by truncating the values of the  structure to the next lower integer values.
        
        :param size: The  structure to convert.
        :returns: The  structure this method converts to.'''
        ...
    
    @staticmethod
    def round(size: aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified  structure to a  structure by rounding the values of the  structure to the nearest integer values.
        
        :param size: The  structure to convert.
        :returns: The  structure this method converts to.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.Size:
        '''Gets a new instance of the  structure that has  and  values set to zero.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    @property
    def width(self) -> int:
        '''Gets the horizontal component of this .'''
        ...
    
    @width.setter
    def width(self, value : int):
        '''Sets the horizontal component of this .'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the vertical component of this .'''
        ...
    
    @height.setter
    def height(self, value : int):
        '''Sets the vertical component of this .'''
        ...
    
    ...

class SizeF:
    '''Stores an ordered pair of floating-point numbers, typically the width and height of a rectangle.'''
    
    @overload
    def __init__(self, size: aspose.imaging.SizeF):
        '''Initializes a new instance of the  structure from the specified .
        
        :param size: The  from which to create the new .'''
        ...
    
    @overload
    def __init__(self, point: aspose.imaging.PointF):
        '''Initializes a new instance of the  structure from the specified .
        
        :param point: The  from which to initialize this .'''
        ...
    
    @overload
    def __init__(self, width: float, height: float):
        '''Initializes a new instance of the  structure from the specified dimensions.
        
        :param width: The width component of the new .
        :param height: The height component of the new .'''
        ...
    
    @overload
    def __init__(self):
        ...
    
    @staticmethod
    def create_from_size_f(size: aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Initializes a new instance of the  structure from the specified .
        
        :param size: The  from which to create the new .'''
        ...
    
    @staticmethod
    def create_from_point_f(point: aspose.imaging.PointF) -> aspose.imaging.SizeF:
        '''Initializes a new instance of the  structure from the specified .
        
        :param point: The  from which to initialize this .'''
        ...
    
    @staticmethod
    def add(size1: aspose.imaging.SizeF, size2: aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Adds the width and height of one  structure to the width and height of another  structure.
        
        :param size1: The first  to add.
        :param size2: The second  to add.
        :returns: A  structure that is the result of the addition operation.'''
        ...
    
    @staticmethod
    def subtract(size1: aspose.imaging.SizeF, size2: aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Subtracts the width and height of one  structure from the width and height of another  structure.
        
        :param size1: The  structure on the left side of the subtraction operator.
        :param size2: The  structure on the right side of the subtraction operator.
        :returns: The  that is a result of the subtraction operation.'''
        ...
    
    def to_point_f(self) -> aspose.imaging.PointF:
        '''Converts a  to a .
        
        :returns: Returns a  structure.'''
        ...
    
    def to_size(self) -> aspose.imaging.Size:
        '''Converts a  to a  structure with truncated size values.
        
        :returns: Returns a  structure.'''
        ...
    
    @classmethod
    @property
    def empty(cls) -> aspose.imaging.SizeF:
        '''Gets a new instance of the  structure that has  and  values set to zero.'''
        ...
    
    @property
    def is_empty(self) -> bool:
        ...
    
    @property
    def width(self) -> float:
        '''Gets the horizontal component of this .'''
        ...
    
    @width.setter
    def width(self, value : float):
        '''Sets the horizontal component of this .'''
        ...
    
    @property
    def height(self) -> float:
        '''Gets the vertical component of this .'''
        ...
    
    @height.setter
    def height(self, value : float):
        '''Sets the vertical component of this .'''
        ...
    
    ...

class Source:
    '''The source is used to contain all relevant information for an object pipe.'''
    
    def get_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the stream container.
        
        :returns: the stream container.'''
        ...
    
    ...

class SplitStreamContainer(StreamContainer):
    '''Represents split stream container which contains the stream and provides stream processing routines.'''
    
    @overload
    def __init__(self, stream: io.RawIOBase):
        '''Initializes a new instance of the  class.
        
        :param stream: The stream.'''
        ...
    
    @overload
    def __init__(self, stream: io.RawIOBase, dispose_stream: bool):
        '''Initializes a new instance of the  class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        ...
    
    @overload
    def __init__(self, stream: aspose.imaging.StreamContainer, dispose_stream: bool):
        '''Initializes a new instance of the  class.
        
        :param stream: The stream container.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        ...
    
    @overload
    def write(self, bytes: bytes):
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        ...
    
    @overload
    def write(self, buffer: bytes, offset: int, count: int):
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        ...
    
    @overload
    def read(self, bytes: bytes) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        ...
    
    @overload
    def read(self, buffer: bytes, offset: int, count: int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        ...
    
    @overload
    def to_bytes(self) -> bytes:
        '''Converts the stream data to the  array.
        
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def to_bytes(self, position: int, bytes_count: int) -> bytes:
        '''Converts the stream data to the  array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param file_path: The file path to save the stream data to.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer, length: int):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        ...
    
    def flush(self):
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        ...
    
    def write_byte(self, value: byte):
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        ...
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        ...
    
    def seek(self, offset: int, origin: aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type  indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        ...
    
    def seek_begin(self):
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    def save_to_stream(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    def save_to_stream_with_buf_size(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    def save_with_buf_size(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    def save_with_buf_size_and_len(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @staticmethod
    def create_from_stream(stream: io.RawIOBase, dispose_stream: bool) -> aspose.imaging.SplitStreamContainer:
        '''Initializes a new instance of the  class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        ...
    
    @staticmethod
    def create_from_stream_container(stream: aspose.imaging.StreamContainer, dispose_stream: bool) -> aspose.imaging.SplitStreamContainer:
        '''Initializes a new instance of the  class.
        
        :param stream: The stream container.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        ...
    
    def insert(self, position: int, stream: aspose.imaging.StreamContainer, dispose_stream: bool):
        '''Inserts the stream container into specified position.
        
        :param position: The position to insert to.
        :param stream: The stream container to insert.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def sync_root(self) -> any:
        ...
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @position.setter
    def position(self, value : int):
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def stream(self) -> io.RawIOBase:
        '''Gets the data stream.'''
        ...
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        ...
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @length.setter
    def length(self, value : int):
        '''Sets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def can_read(self) -> bool:
        ...
    
    @property
    def can_seek(self) -> bool:
        ...
    
    @property
    def can_write(self) -> bool:
        ...
    
    @classmethod
    @property
    def READ_WRITE_BYTES_COUNT(cls) -> int:
        ...
    
    ...

class StreamContainer(DisposableObject):
    '''Represents stream container which contains the stream and provides stream processing routines.'''
    
    @overload
    def __init__(self, stream: io.RawIOBase):
        '''Initializes a new instance of the  class.
        
        :param stream: The stream.'''
        ...
    
    @overload
    def __init__(self, stream: io.RawIOBase, dispose_stream: bool):
        '''Initializes a new instance of the  class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        ...
    
    @overload
    def write(self, bytes: bytes):
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        ...
    
    @overload
    def write(self, buffer: bytes, offset: int, count: int):
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        ...
    
    @overload
    def read(self, bytes: bytes) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        ...
    
    @overload
    def read(self, buffer: bytes, offset: int, count: int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        ...
    
    @overload
    def to_bytes(self) -> bytes:
        '''Converts the stream data to the  array.
        
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def to_bytes(self, position: int, bytes_count: int) -> bytes:
        '''Converts the stream data to the  array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the  array.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    @overload
    def save(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param file_path: The file path to save the stream data to.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    @overload
    def save(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.'''
        ...
    
    @overload
    def write_to(self, stream_container: aspose.imaging.StreamContainer, length: int):
        '''Copies the contained data to another .
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        ...
    
    def flush(self):
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        ...
    
    def write_byte(self, value: byte):
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        ...
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        ...
    
    def seek(self, offset: int, origin: aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type  indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        ...
    
    def seek_begin(self):
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    def save_to_stream(self, destination_stream: io.RawIOBase):
        '''Saves (copies) the stream's data to the specified stream. Uses default buffer size  and stream  value.
        
        :param destination_stream: The stream to save the data to.'''
        ...
    
    def save_to_stream_with_buf_size(self, destination_stream: io.RawIOBase, buffer_size: int):
        '''Saves (copies) all the stream's data to the specified stream. Uses stream  value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        ...
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream: io.RawIOBase, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    def save_with_buf_size(self, file_path: str, buffer_size: int):
        '''Saves (copies) the stream's data to the specified stream. Uses stream  value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.'''
        ...
    
    def save_with_buf_size_and_len(self, file_path: str, buffer_size: int, length: int):
        '''Saves (copies) the stream's data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default  value is used.
        :param length: The stream data length to copy. By default the length is set to  value.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def sync_root(self) -> any:
        ...
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @position.setter
    def position(self, value : int):
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def stream(self) -> io.RawIOBase:
        '''Gets the data stream.'''
        ...
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        ...
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @length.setter
    def length(self, value : int):
        '''Sets the stream length in bytes. This value is less than the  by the starting stream position passed in the StreamContainer constructor.'''
        ...
    
    @property
    def can_read(self) -> bool:
        ...
    
    @property
    def can_seek(self) -> bool:
        ...
    
    @property
    def can_write(self) -> bool:
        ...
    
    @classmethod
    @property
    def READ_WRITE_BYTES_COUNT(cls) -> int:
        ...
    
    ...

class StringFormat(DisposableObject):
    '''Encapsulates text layout information (such as alignment, orientation and tab stops) display manipulations (such as ellipsis insertion and national digit substitution) and OpenType features. This class cannot be inherited.'''
    
    @overload
    def __init__(self):
        '''Initializes a new  object.'''
        ...
    
    @overload
    def __init__(self, options: aspose.imaging.StringFormatFlags):
        '''Initializes a new  object with the specified  enumeration and language.
        
        :param options: The  enumeration for the new  object.'''
        ...
    
    @overload
    def __init__(self, format: aspose.imaging.StringFormat):
        '''Initializes a new  object from the specified existing  object.
        
        :param format: The  object from which to initialize the new  object.'''
        ...
    
    @staticmethod
    def create_from_flags(options: aspose.imaging.StringFormatFlags) -> aspose.imaging.StringFormat:
        '''Initializes a new  object with the specified  enumeration and language.
        
        :param options: The  enumeration for the new  object.'''
        ...
    
    @staticmethod
    def create_from_format(format: aspose.imaging.StringFormat) -> aspose.imaging.StringFormat:
        '''Initializes a new  object from the specified existing  object.
        
        :param format: The  object from which to initialize the new  object.'''
        ...
    
    def deep_clone(self) -> aspose.imaging.StringFormat:
        '''Creates a deep clone of this  object.
        
        :returns: The deep clone of the current .'''
        ...
    
    def set_tab_stops(self, first_tab_offset: float, tab_stops: List[float]):
        '''Sets tab stops for this  object.
        
        :param first_tab_offset: The number of spaces between the beginning of a line of text and the first tab stop.
        :param tab_stops: An array of distances between tab stops in the units specified by the  property.'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @classmethod
    @property
    def generic_default(cls) -> aspose.imaging.StringFormat:
        ...
    
    @classmethod
    @property
    def generic_typographic(cls) -> aspose.imaging.StringFormat:
        ...
    
    @property
    def format_flags(self) -> aspose.imaging.StringFormatFlags:
        ...
    
    @format_flags.setter
    def format_flags(self, value : aspose.imaging.StringFormatFlags):
        ...
    
    @property
    def alignment(self) -> aspose.imaging.StringAlignment:
        '''Gets text alignment information on the vertical plane.'''
        ...
    
    @alignment.setter
    def alignment(self, value : aspose.imaging.StringAlignment):
        '''Sets text alignment information on the vertical plane.'''
        ...
    
    @property
    def line_alignment(self) -> aspose.imaging.StringAlignment:
        ...
    
    @line_alignment.setter
    def line_alignment(self, value : aspose.imaging.StringAlignment):
        ...
    
    @property
    def hotkey_prefix(self) -> aspose.imaging.HotkeyPrefix:
        ...
    
    @hotkey_prefix.setter
    def hotkey_prefix(self, value : aspose.imaging.HotkeyPrefix):
        ...
    
    @property
    def trimming(self) -> aspose.imaging.StringTrimming:
        '''Gets the  enumeration for this  object.'''
        ...
    
    @trimming.setter
    def trimming(self, value : aspose.imaging.StringTrimming):
        '''Sets the  enumeration for this  object.'''
        ...
    
    @property
    def digit_substitution_method(self) -> aspose.imaging.StringDigitSubstitute:
        ...
    
    @digit_substitution_method.setter
    def digit_substitution_method(self, value : aspose.imaging.StringDigitSubstitute):
        ...
    
    @property
    def digit_substitution_language(self) -> int:
        ...
    
    @digit_substitution_language.setter
    def digit_substitution_language(self, value : int):
        ...
    
    @property
    def first_tab_offset(self) -> float:
        ...
    
    @property
    def tab_stops(self) -> List[float]:
        ...
    
    @property
    def custom_char_ident(self) -> aspose.imaging.PointF:
        ...
    
    @custom_char_ident.setter
    def custom_char_ident(self, value : aspose.imaging.PointF):
        ...
    
    ...

class TransparencySupporter:
    '''The object supporting transparency.'''
    
    def __init__(self):
        ...
    
    @property
    def opacity(self) -> float:
        '''Gets the object's opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        ...
    
    @opacity.setter
    def opacity(self, value : float):
        '''Sets the object's opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        ...
    
    ...

class VectorImage(Image):
    '''The vector image is the base class for all type of vector images.'''
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the specified new width.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image with extended options.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    @overload
    def remove_background(self):
        '''Removes the background.'''
        ...
    
    @overload
    def remove_background(self, settings: aspose.imaging.RemoveBackgroundSettings):
        '''Removes the background.
        
        :param settings: The settings.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes metadata.'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        ...
    
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        ...
    
    def get_embedded_images(self) -> List[aspose.imaging.EmbeddedImage]:
        '''Gets the embedded images.
        
        :returns: Array of images'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def size_f(self) -> aspose.imaging.SizeF:
        ...
    
    @property
    def width_f(self) -> float:
        ...
    
    @property
    def height_f(self) -> float:
        ...
    
    ...

class VectorMultipageImage(VectorImage):
    '''The Vector multipage image'''
    
    @overload
    def save(self):
        '''Saves the image data to the underlying stream.'''
        ...
    
    @overload
    def save(self, file_path: str):
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    @overload
    def save(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    @overload
    def save(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @overload
    def save(self, file_path: str, over_write: bool):
        '''Saves the object's data to the specified file location.
        
        :param file_path: The file path to save the object's data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def can_load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @overload
    @staticmethod
    def create(image_options: aspose.imaging.ImageOptionsBase, width: int, height: int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create(multipage_create_options: aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_images(images: List[aspose.imaging.Image], dispose_images: bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str], throw_exception_on_load_error: bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def create_from_files(files: List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(file_path: str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_file_format(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle: aspose.imaging.Rectangle, pixels: List[int], width: int, height: int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(file_path: str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @overload
    @staticmethod
    def load(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    @overload
    def resize(self, new_width: int, new_height: int):
        '''Resizes the image. The default  is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int):
        '''Resizes the width proportionally. The default  is used.
        
        :param new_width: The new width.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_width_proportionally(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int):
        '''Resizes the height proportionally. The default  is used.
        
        :param new_height: The new height.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        ...
    
    @overload
    def resize_height_proportionally(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    @overload
    def crop(self, rectangle: aspose.imaging.Rectangle):
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        ...
    
    @overload
    def crop(self, left_shift: int, right_shift: int, top_shift: int, bottom_shift: int):
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        ...
    
    @overload
    def remove_background(self, settings: aspose.imaging.RemoveBackgroundSettings):
        '''Removes the background.
        
        :param settings: The settings.'''
        ...
    
    @overload
    def remove_background(self):
        '''Removes the background.'''
        ...
    
    def cache_data(self):
        '''Caches the data and ensures no additional data loading will be performed from the underlying
        .'''
        ...
    
    def save_to_stream(self, stream: io.RawIOBase):
        '''Saves the object's data to the specified stream.
        
        :param stream: The stream to save the object's data to.'''
        ...
    
    @staticmethod
    def can_load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream(stream: io.RawIOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def can_load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        ...
    
    @staticmethod
    def get_file_format_of_stream(stream: io.RawIOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        ...
    
    @staticmethod
    def load_with_options(file_path: str, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream_with_options(stream: io.RawIOBase, load_options: aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def load_stream(stream: io.RawIOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        ...
    
    @staticmethod
    def get_proportional_width(width: int, height: int, new_height: int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        ...
    
    @staticmethod
    def get_proportional_height(width: int, height: int, new_width: int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        ...
    
    def remove_metadata(self):
        '''Removes metadata.'''
        ...
    
    def can_save(self, options: aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        ...
    
    def resize_by_type(self, new_width: int, new_height: int, resize_type: aspose.imaging.ResizeType):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        ...
    
    def resize_by_settings(self, new_width: int, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        ...
    
    def get_default_options(self, args: List[any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        ...
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the  method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        ...
    
    def resize_width_proportionally_settings(self, new_width: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        ...
    
    def resize_height_proportionally_settings(self, new_height: int, settings: aspose.imaging.ImageResizeSettings):
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        ...
    
    def rotate_flip(self, rotate_flip_type: aspose.imaging.RotateFlipType):
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        ...
    
    def rotate(self, angle: float):
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        ...
    
    def save_with_options(self, file_path: str, options: aspose.imaging.ImageOptionsBase):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        ...
    
    def save_with_options_rect(self, file_path: str, options: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the object's data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        ...
    
    def save_to_stream_with_options(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.'''
        ...
    
    def save_to_stream_with_options_rect(self, stream: io.RawIOBase, options_base: aspose.imaging.ImageOptionsBase, bounds_rectangle: aspose.imaging.Rectangle):
        '''Saves the image's data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image's data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        ...
    
    def get_serialized_stream(self, image_options: aspose.imaging.ImageOptionsBase, clipping_rectangle: aspose.imaging.Rectangle, page_number: Any) -> io.RawIOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        ...
    
    def set_palette(self, palette: aspose.imaging.IColorPalette, update_colors: bool):
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color
        indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no
        corresponding palette entries.'''
        ...
    
    def get_embedded_images(self) -> List[aspose.imaging.EmbeddedImage]:
        '''Gets the embedded images.
        
        :returns: Array of images'''
        ...
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        ...
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        ...
    
    @property
    def is_cached(self) -> bool:
        ...
    
    @property
    def bits_per_pixel(self) -> int:
        ...
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        ...
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the  container.'''
        ...
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        ...
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette):
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        ...
    
    @property
    def use_palette(self) -> bool:
        ...
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        ...
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        ...
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        ...
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor):
        ...
    
    @property
    def buffer_size_hint(self) -> int:
        ...
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int):
        ...
    
    @property
    def auto_adjust_palette(self) -> bool:
        ...
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool):
        ...
    
    @property
    def has_background_color(self) -> bool:
        ...
    
    @has_background_color.setter
    def has_background_color(self, value : bool):
        ...
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        ...
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        ...
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color):
        ...
    
    @property
    def size_f(self) -> aspose.imaging.SizeF:
        ...
    
    @property
    def width_f(self) -> float:
        ...
    
    @property
    def height_f(self) -> float:
        ...
    
    @property
    def page_count(self) -> int:
        ...
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        ...
    
    @property
    def default_page(self) -> aspose.imaging.Image:
        ...
    
    ...

class AnimationDisposalMethods(enum.Enum):
    PRESERVE = enum.auto()
    '''Do not dispose. The graphic is to be left in place.'''
    BACKGROUND = enum.auto()
    '''Restore to background color. The area used by the graphic must be restored to the background color.'''
    PREVIOUS = enum.auto()
    '''Restore to previous. The decoder is required to restore the area overwritten by the graphic with what was there prior to rendering the graphic.'''

class CacheType(enum.Enum):
    AUTO = enum.auto()
    '''Specifies auto cache type. The auto cache scheme will try to cache in-memory first then on disk.'''
    CACHE_ON_DISK_ONLY = enum.auto()
    '''The disk cache only.'''
    CACHE_IN_MEMORY_ONLY = enum.auto()
    '''The in-memory cache only.'''

class CharacterSet(enum.Enum):
    ANSI = enum.auto()
    '''1252 Latin 1, 1250 Latin 2, 1256 Arabic character sets'''
    DEFAULT = enum.auto()
    '''The default character set.'''
    SYMBOL = enum.auto()
    '''The symbol character set'''
    SHIFTJIS = enum.auto()
    '''DBCS, 932 Japanese character set.'''
    HANGEUL = enum.auto()
    '''DBCS, 949 Korean character set.'''
    HANGUL = enum.auto()
    '''DBCS, 949 Korean character set.'''
    GB2312 = enum.auto()
    '''DBCS, 936 Simplified Chinese character set.'''
    CHINESE_BIG5 = enum.auto()
    '''DBCS, 950 Traditional Chinese character set.'''
    OEM = enum.auto()
    '''437 MS-DOS Latin 1, 852 MS-DOS Latin 2, 864 MS-DOS Arabic character sets.'''
    JOHAB = enum.auto()
    '''DBCS, 1361 Korean character set.'''
    HEBREW = enum.auto()
    '''1255 Hebrew character set.'''
    ARABIC = enum.auto()
    '''1256 Arabic character set.'''
    GREEK = enum.auto()
    '''1253 Greek character set.'''
    TURKISH = enum.auto()
    '''1254 Turkish character set.'''
    VIETNAMESE = enum.auto()
    '''1258 Vietnamese character set.'''
    THAI = enum.auto()
    '''874 Thai character set.'''
    EASTEUROPE = enum.auto()
    '''1250 Latin 2, Central Europe character set.'''
    RUSSIAN = enum.auto()
    '''1251 Cyrillic (Slavic) character set.'''
    MAC = enum.auto()
    '''10000 Mac Roman, 10029 Mac Central Europe, 10007 Mac Cyrillic character sets.'''
    BALTIC = enum.auto()
    '''1257 Baltic Rim character set.'''

class ColorAdjustType(enum.Enum):
    DEFAULT = enum.auto()
    '''Color adjustment information that is used by all GDI+ objects that do not have their own color adjustment information.'''
    BITMAP = enum.auto()
    '''Color adjustment information for Bitmap objects.'''
    BRUSH = enum.auto()
    '''Color adjustment information for Brush objects.'''
    PEN = enum.auto()
    '''Color adjustment information for Pen objects.'''
    TEXT = enum.auto()
    '''Color adjustment information for text.'''
    COUNT = enum.auto()
    '''The number of types specified.'''
    ANY = enum.auto()
    '''The number of types specified.'''

class ColorChannelFlag(enum.Enum):
    COLOR_CHANNEL_C = enum.auto()
    '''The cyan color channel.'''
    COLOR_CHANNEL_M = enum.auto()
    '''The magenta color channel.'''
    COLOR_CHANNEL_Y = enum.auto()
    '''The yellow color channel.'''
    COLOR_CHANNEL_K = enum.auto()
    '''The black color channel.'''
    COLOR_CHANNEL_LAST = enum.auto()
    '''The last selected channel should be used.'''

class ColorCompareMethod(enum.Enum):
    EUCLIDIAN = enum.auto()
    '''The euclidian method'''

class ColorMatrixFlag(enum.Enum):
    DEFAULT = enum.auto()
    '''All color values, including gray shades, are adjusted by the same color-adjustment matrix.'''
    SKIP_GRAYS = enum.auto()
    '''All colors are adjusted, but gray shades are not adjusted. A gray shade is any color that has the same value for its red, green, and blue components.'''
    ALT_GRAYS = enum.auto()
    '''Only gray shades are adjusted.'''

class ColorQuantizationMethod(enum.Enum):
    NONE = enum.auto()
    '''Nothing color quantization method is used'''
    POPULARITY = enum.auto()
    '''The popularity method'''

class CompositingQuality(enum.Enum):
    INVALID = enum.auto()
    '''Invalid quality.'''
    DEFAULT = enum.auto()
    '''Default quality.'''
    HIGH_SPEED = enum.auto()
    '''High speed, low quality.'''
    HIGH_QUALITY = enum.auto()
    '''High quality, low speed compositing.'''
    GAMMA_CORRECTED = enum.auto()
    '''Gamma correction is used.'''
    ASSUME_LINEAR = enum.auto()
    '''Assume linear values.'''

class DashCap(enum.Enum):
    FLAT = enum.auto()
    '''Specifies a square cap that squares off both ends of each dash.'''
    ROUND = enum.auto()
    '''Specifies a circular cap that rounds off both ends of each dash.'''
    TRIANGLE = enum.auto()
    '''Specifies a triangular cap that points both ends of each dash.'''

class DashStyle(enum.Enum):
    SOLID = enum.auto()
    '''Specifies a solid line.'''
    DASH = enum.auto()
    '''Specifies a line consisting of dashes.'''
    DOT = enum.auto()
    '''Specifies a line consisting of dots.'''
    DASH_DOT = enum.auto()
    '''Specifies a line consisting of a repeating pattern of dash-dot.'''
    DASH_DOT_DOT = enum.auto()
    '''Specifies a line consisting of a repeating pattern of dash-dot-dot.'''
    CUSTOM = enum.auto()
    '''Specifies a user-defined custom dash style.'''

class DataRecoveryMode(enum.Enum):
    NONE = enum.auto()
    '''No data recovery is implied. Whenever the file format has some corrupted data the appropriate exception is thrown.'''
    CONSISTENT_RECOVER = enum.auto()
    '''The consistent recovery mode tries to recover all data as long as corruption does not break the file format and allows correct further processing.'''
    MAXIMAL_RECOVER = enum.auto()
    '''The maximal recovery mode recovers all data even if the file format has corrupted structure and further processing may yield unattended effects.'''

class DitheringMethod(enum.Enum):
    THRESHOLD_DITHERING = enum.auto()
    '''Threshold dithering. Simplest and fastest dithering algorithm.'''
    FLOYD_STEINBERG_DITHERING = enum.auto()
    '''The Floyd-Steinberg dithering. A more complex dithering algorithm, uses nearest neighbors intensity values.'''

class DitheringMethods(enum.Enum):
    PALETTE_IGNORE = enum.auto()
    '''The palette is ignored'''
    PALETTE_CONVERSION = enum.auto()
    '''The palette is not ignored and wise color conversion should be applied.'''
    CUSTOM_CONVERTER = enum.auto()
    '''The custom converter.'''

class FileFormat(enum.Enum):
    UNKNOWN = enum.auto()
    '''Unknown file format.'''
    CUSTOM = enum.auto()
    '''Custom file format.'''
    BMP = enum.auto()
    '''Bmp (Dib) file format.'''
    GIF = enum.auto()
    '''Gif file format.'''
    JPEG = enum.auto()
    '''Jpeg file format.'''
    PNG = enum.auto()
    '''Png file format.'''
    TIFF = enum.auto()
    '''Tiff file format.'''
    PSD = enum.auto()
    '''Psd file format.'''
    PDF = enum.auto()
    '''Pdf file format'''
    ICO = enum.auto()
    '''The ico format'''
    JPEG2000 = enum.auto()
    '''Jpeg2000 file format'''
    DJVU = enum.auto()
    '''Djvu file format'''
    WEBP = enum.auto()
    '''The webp file format'''
    EMF = enum.auto()
    '''The Emf/Emf+ file format'''
    DICOM = enum.auto()
    '''The dicom format'''
    SVG = enum.auto()
    '''SVG file format'''
    WMF = enum.auto()
    '''The Wmf file format'''
    DNG = enum.auto()
    '''The DNG file format'''
    ODG = enum.auto()
    '''The Open document graphic format'''
    EPS = enum.auto()
    '''The Encapsulated PostScript format'''
    CDR = enum.auto()
    '''The CDR file format'''
    CMX = enum.auto()
    '''The CMX file format'''
    OTG = enum.auto()
    '''The otg file format'''
    HTML_5_CANVAS = enum.auto()
    '''The Html5 Canvas format'''
    APNG = enum.auto()
    '''The animated Png file format.'''
    TGA = enum.auto()
    '''The Truevision TGA file format.'''
    DXF = enum.auto()
    '''The AutoCAD Drawing Exchange Format.'''
    EMZ = enum.auto()
    '''The emz, compressed emf'''
    WMZ = enum.auto()
    '''The WMZ, compressed wmf'''
    SVGZ = enum.auto()
    '''The SVGZ, compressed svg'''
    F_ODG = enum.auto()
    '''The fodg, flat odg format'''
    AVIF = enum.auto()
    '''The AVIF file format.'''
    BIG_TIFF = enum.auto()
    '''The Big Tiff format.'''

class FillMode(enum.Enum):
    ALTERNATE = enum.auto()
    '''Specifies the alternate fill mode.'''
    WINDING = enum.auto()
    '''Specifies the winding fill mode.'''

class FontStyle(enum.Enum):
    REGULAR = enum.auto()
    '''Normal text.'''
    BOLD = enum.auto()
    '''Bold text.'''
    ITALIC = enum.auto()
    '''Italic text.'''
    UNDERLINE = enum.auto()
    '''Underlined text.'''
    STRIKEOUT = enum.auto()
    '''Text with a line through the middle.'''

class GraphicsUnit(enum.Enum):
    WORLD = enum.auto()
    '''Specifies the world coordinate system unit as the unit of measure.'''
    DISPLAY = enum.auto()
    '''Specifies the unit of measure of the display device. Typically pixels for video displays, and 1/100 inch for printers.'''
    PIXEL = enum.auto()
    '''Specifies a device pixel as the unit of measure.'''
    POINT = enum.auto()
    '''Specifies a printer's point (1/72 inch) as the unit of measure.'''
    INCH = enum.auto()
    '''Specifies the inch as the unit of measure.'''
    DOCUMENT = enum.auto()
    '''Specifies the document unit (1/300 inch) as the unit of measure.'''
    MILLIMETER = enum.auto()
    '''Specifies the millimeter as the unit of measure.'''

class HatchStyle(enum.Enum):
    HORIZONTAL = enum.auto()
    '''A pattern of horizontal lines.'''
    MIN = enum.auto()
    '''Specifies hatch style Horizontal.'''
    VERTICAL = enum.auto()
    '''A pattern of vertical lines.'''
    FORWARD_DIAGONAL = enum.auto()
    '''A pattern of lines on a diagonal from upper left to lower right.'''
    BACKWARD_DIAGONAL = enum.auto()
    '''A pattern of lines on a diagonal from upper right to lower left.'''
    CROSS = enum.auto()
    '''Specifies horizontal and vertical lines that cross.'''
    LARGE_GRID = enum.auto()
    '''Specifies the hatch style Cross.'''
    MAX = enum.auto()
    '''Specifies hatch style SolidDiamond.'''
    DIAGONAL_CROSS = enum.auto()
    '''A pattern of crisscross diagonal lines.'''
    PERCENT05 = enum.auto()
    '''Specifies a 5-percent hatch. The ratio of foreground color to background color is 5:95.'''
    PERCENT10 = enum.auto()
    '''Specifies a 10-percent hatch. The ratio of foreground color to background color is 10:90.'''
    PERCENT20 = enum.auto()
    '''Specifies a 20-percent hatch. The ratio of foreground color to background color is 20:80.'''
    PERCENT25 = enum.auto()
    '''Specifies a 25-percent hatch. The ratio of foreground color to background color is 25:75.'''
    PERCENT30 = enum.auto()
    '''Specifies a 30-percent hatch. The ratio of foreground color to background color is 30:70.'''
    PERCENT40 = enum.auto()
    '''Specifies a 40-percent hatch. The ratio of foreground color to background color is 40:60.'''
    PERCENT50 = enum.auto()
    '''Specifies a 50-percent hatch. The ratio of foreground color to background color is 50:50.'''
    PERCENT60 = enum.auto()
    '''Specifies a 60-percent hatch. The ratio of foreground color to background color is 60:40.'''
    PERCENT70 = enum.auto()
    '''Specifies a 70-percent hatch. The ratio of foreground color to background color is 70:30.'''
    PERCENT75 = enum.auto()
    '''Specifies a 75-percent hatch. The ratio of foreground color to background color is 75:25.'''
    PERCENT80 = enum.auto()
    '''Specifies a 80-percent hatch. The ratio of foreground color to background color is 80:100.'''
    PERCENT90 = enum.auto()
    '''Specifies a 90-percent hatch. The ratio of foreground color to background color is 90:10.'''
    LIGHT_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points and are spaced 50 percent closer together than ForwardDiagonal, but are not antialiased.'''
    LIGHT_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points and are spaced 50 percent closer together than BackwardDiagonal, but they are not antialiased.'''
    DARK_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points, are spaced 50 percent closer together than, and are twice the width of ForwardDiagonal. This hatch pattern is not antialiased.'''
    DARK_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points, are spaced 50 percent closer together than BackwardDiagonal, and are twice its width, but the lines are not antialiased.'''
    WIDE_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points, have the same spacing as hatch style ForwardDiagonal, and are triple its width, but are not antialiased.'''
    WIDE_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points, have the same spacing as hatch style BackwardDiagonal, and are triple its width, but are not antialiased.'''
    LIGHT_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 50 percent closer together than Vertical.'''
    LIGHT_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 50 percent closer together than Horizontal.'''
    NARROW_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 75 percent closer together than hatch style Vertical (or 25 percent closer together than LightVertical).'''
    NARROW_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 75 percent closer together than hatch style Horizontal (or 25 percent closer together than LightHorizontal).'''
    DARK_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 50 percent closer together than Vertical and are twice its width.'''
    DARK_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 50 percent closer together than Horizontal and are twice the width of Horizontal.'''
    DASHED_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies dashed diagonal lines, that slant to the right from top points to bottom points.'''
    DASHED_UPWARD_DIAGONAL = enum.auto()
    '''Specifies dashed diagonal lines, that slant to the left from top points to bottom points.'''
    DASHED_HORIZONTAL = enum.auto()
    '''Specifies dashed horizontal lines.'''
    DASHED_VERTICAL = enum.auto()
    '''Specifies dashed vertical lines.'''
    SMALL_CONFETTI = enum.auto()
    '''Specifies a hatch that has the appearance of confetti.'''
    LARGE_CONFETTI = enum.auto()
    '''Specifies a hatch that has the appearance of confetti, and is composed of larger pieces than SmallConfetti.'''
    ZIG_ZAG = enum.auto()
    '''Specifies horizontal lines that are composed of zigzags.'''
    WAVE = enum.auto()
    '''Specifies horizontal lines that are composed of tildes.'''
    DIAGONAL_BRICK = enum.auto()
    '''Specifies a hatch that has the appearance of layered bricks that slant to the left from top points to bottom points.'''
    HORIZONTAL_BRICK = enum.auto()
    '''Specifies a hatch that has the appearance of horizontally layered bricks.'''
    WEAVE = enum.auto()
    '''Specifies a hatch that has the appearance of a woven material.'''
    PLAID = enum.auto()
    '''Specifies a hatch that has the appearance of a plaid material.'''
    DIVOT = enum.auto()
    '''Specifies a hatch that has the appearance of divots.'''
    DOTTED_GRID = enum.auto()
    '''Specifies horizontal and vertical lines, each of which is composed of dots, that cross.'''
    DOTTED_DIAMOND = enum.auto()
    '''Specifies forward diagonal and backward diagonal lines, each of which is composed of dots, that cross.'''
    SHINGLE = enum.auto()
    '''Specifies a hatch that has the appearance of diagonally layered shingles that slant to the right from top points to bottom points.'''
    TRELLIS = enum.auto()
    '''Specifies a hatch that has the appearance of a trellis.'''
    SPHERE = enum.auto()
    '''Specifies a hatch that has the appearance of spheres laid adjacent to one another.'''
    SMALL_GRID = enum.auto()
    '''Specifies horizontal and vertical lines that cross and are spaced 50 percent closer together than hatch style Cross.'''
    SMALL_CHECKER_BOARD = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard.'''
    LARGE_CHECKER_BOARD = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard with squares that are twice the size of SmallCheckerBoard.'''
    OUTLINED_DIAMOND = enum.auto()
    '''Specifies forward diagonal and backward diagonal lines that cross but are not antialiased.'''
    SOLID_DIAMOND = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard placed diagonally.'''

class HotkeyPrefix(enum.Enum):
    NONE = enum.auto()
    '''No hot-key prefix.'''
    SHOW = enum.auto()
    '''Display the hot-key prefix.'''
    HIDE = enum.auto()
    '''Do not display the hot-key prefix.'''

class ImageFilterType(enum.Enum):
    NONE = enum.auto()
    '''Nothing filter used'''
    BIG_RECTANGULAR = enum.auto()
    '''The big rectangular filter'''
    SMALL_RECTANGULAR = enum.auto()
    '''The small rectangular filter'''

class InterpolationMode(enum.Enum):
    INVALID = enum.auto()
    '''Invalid interpolation mode.'''
    DEFAULT = enum.auto()
    '''Specifies default mode.'''
    LOW = enum.auto()
    '''Specifies low quality interpolation.'''
    HIGH = enum.auto()
    '''Specifies high quality interpolation.'''
    BILINEAR = enum.auto()
    '''Specifies bilinear interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 50 percent of its original size.'''
    BICUBIC = enum.auto()
    '''Specifies bicubic interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 25 percent of its original size.'''
    NEAREST_NEIGHBOR = enum.auto()
    '''Specifies nearest-neighbor interpolation.'''
    HIGH_QUALITY_BILINEAR = enum.auto()
    '''Specifies high-quality, bilinear interpolation. Prefiltering is performed to ensure high-quality shrinking.'''
    HIGH_QUALITY_BICUBIC = enum.auto()
    '''Specifies high-quality, bicubic interpolation. Prefiltering is performed to ensure high-quality shrinking. This mode produces the highest quality transformed images.'''

class KnownColor(enum.Enum):
    TRANSPARENT = enum.auto()
    '''A system-defined color.'''
    ALICE_BLUE = enum.auto()
    '''A system-defined color.'''
    ANTIQUE_WHITE = enum.auto()
    '''A system-defined color.'''
    AQUA = enum.auto()
    '''A system-defined color.'''
    AQUAMARINE = enum.auto()
    '''A system-defined color.'''
    AZURE = enum.auto()
    '''A system-defined color.'''
    BEIGE = enum.auto()
    '''A system-defined color.'''
    BISQUE = enum.auto()
    '''A system-defined color.'''
    BLACK = enum.auto()
    '''A system-defined color.'''
    BLANCHED_ALMOND = enum.auto()
    '''A system-defined color.'''
    BLUE = enum.auto()
    '''A system-defined color.'''
    BLUE_VIOLET = enum.auto()
    '''A system-defined color.'''
    BROWN = enum.auto()
    '''A system-defined color.'''
    BURLY_WOOD = enum.auto()
    '''A system-defined color.'''
    CADET_BLUE = enum.auto()
    '''A system-defined color.'''
    CHARTREUSE = enum.auto()
    '''A system-defined color.'''
    CHOCOLATE = enum.auto()
    '''A system-defined color.'''
    CORAL = enum.auto()
    '''A system-defined color.'''
    CORNFLOWER_BLUE = enum.auto()
    '''A system-defined color.'''
    CORNSILK = enum.auto()
    '''A system-defined color.'''
    CRIMSON = enum.auto()
    '''A system-defined color.'''
    CYAN = enum.auto()
    '''A system-defined color.'''
    DARK_BLUE = enum.auto()
    '''A system-defined color.'''
    DARK_CYAN = enum.auto()
    '''A system-defined color.'''
    DARK_GOLDENROD = enum.auto()
    '''A system-defined color.'''
    DARK_GRAY = enum.auto()
    '''A system-defined color.'''
    DARK_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_KHAKI = enum.auto()
    '''A system-defined color.'''
    DARK_MAGENTA = enum.auto()
    '''A system-defined color.'''
    DARK_OLIVE_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_ORANGE = enum.auto()
    '''A system-defined color.'''
    DARK_ORCHID = enum.auto()
    '''A system-defined color.'''
    DARK_RED = enum.auto()
    '''A system-defined color.'''
    DARK_SALMON = enum.auto()
    '''A system-defined color.'''
    DARK_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    DARK_SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    DARK_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    DARK_VIOLET = enum.auto()
    '''A system-defined color.'''
    DEEP_PINK = enum.auto()
    '''A system-defined color.'''
    DEEP_SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    DIM_GRAY = enum.auto()
    '''A system-defined color.'''
    DODGER_BLUE = enum.auto()
    '''A system-defined color.'''
    FIREBRICK = enum.auto()
    '''A system-defined color.'''
    FLORAL_WHITE = enum.auto()
    '''A system-defined color.'''
    FOREST_GREEN = enum.auto()
    '''A system-defined color.'''
    FUCHSIA = enum.auto()
    '''A system-defined color.'''
    GAINSBORO = enum.auto()
    '''A system-defined color.'''
    GHOST_WHITE = enum.auto()
    '''A system-defined color.'''
    GOLD = enum.auto()
    '''A system-defined color.'''
    GOLDENROD = enum.auto()
    '''A system-defined color.'''
    GRAY = enum.auto()
    '''A system-defined color.'''
    GREEN = enum.auto()
    '''A system-defined color.'''
    GREEN_YELLOW = enum.auto()
    '''A system-defined color.'''
    HONEYDEW = enum.auto()
    '''A system-defined color.'''
    HOT_PINK = enum.auto()
    '''A system-defined color.'''
    INDIAN_RED = enum.auto()
    '''A system-defined color.'''
    INDIGO = enum.auto()
    '''A system-defined color.'''
    IVORY = enum.auto()
    '''A system-defined color.'''
    KHAKI = enum.auto()
    '''A system-defined color.'''
    LAVENDER = enum.auto()
    '''A system-defined color.'''
    LAVENDER_BLUSH = enum.auto()
    '''A system-defined color.'''
    LAWN_GREEN = enum.auto()
    '''A system-defined color.'''
    LEMON_CHIFFON = enum.auto()
    '''A system-defined color.'''
    LIGHT_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_CORAL = enum.auto()
    '''A system-defined color.'''
    LIGHT_CYAN = enum.auto()
    '''A system-defined color.'''
    LIGHT_GOLDENROD_YELLOW = enum.auto()
    '''A system-defined color.'''
    LIGHT_GRAY = enum.auto()
    '''A system-defined color.'''
    LIGHT_GREEN = enum.auto()
    '''A system-defined color.'''
    LIGHT_PINK = enum.auto()
    '''A system-defined color.'''
    LIGHT_SALMON = enum.auto()
    '''A system-defined color.'''
    LIGHT_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    LIGHT_SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    LIGHT_STEEL_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_YELLOW = enum.auto()
    '''A system-defined color.'''
    LIME = enum.auto()
    '''A system-defined color.'''
    LIME_GREEN = enum.auto()
    '''A system-defined color.'''
    LINEN = enum.auto()
    '''A system-defined color.'''
    MAGENTA = enum.auto()
    '''A system-defined color.'''
    MAROON = enum.auto()
    '''A system-defined color.'''
    MEDIUM_AQUAMARINE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_BLUE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_ORCHID = enum.auto()
    '''A system-defined color.'''
    MEDIUM_PURPLE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SPRING_GREEN = enum.auto()
    '''A system-defined color.'''
    MEDIUM_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_VIOLET_RED = enum.auto()
    '''A system-defined color.'''
    MIDNIGHT_BLUE = enum.auto()
    '''A system-defined color.'''
    MINT_CREAM = enum.auto()
    '''A system-defined color.'''
    MISTY_ROSE = enum.auto()
    '''A system-defined color.'''
    MOCCASIN = enum.auto()
    '''A system-defined color.'''
    NAVAJO_WHITE = enum.auto()
    '''A system-defined color.'''
    NAVY = enum.auto()
    '''A system-defined color.'''
    OLD_LACE = enum.auto()
    '''A system-defined color.'''
    OLIVE = enum.auto()
    '''A system-defined color.'''
    OLIVE_DRAB = enum.auto()
    '''A system-defined color.'''
    ORANGE = enum.auto()
    '''A system-defined color.'''
    ORANGE_RED = enum.auto()
    '''A system-defined color.'''
    ORCHID = enum.auto()
    '''A system-defined color.'''
    PALE_GOLDENROD = enum.auto()
    '''A system-defined color.'''
    PALE_GREEN = enum.auto()
    '''A system-defined color.'''
    PALE_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    PALE_VIOLET_RED = enum.auto()
    '''A system-defined color.'''
    PAPAYA_WHIP = enum.auto()
    '''A system-defined color.'''
    PEACH_PUFF = enum.auto()
    '''A system-defined color.'''
    PERU = enum.auto()
    '''A system-defined color.'''
    PINK = enum.auto()
    '''A system-defined color.'''
    PLUM = enum.auto()
    '''A system-defined color.'''
    POWDER_BLUE = enum.auto()
    '''A system-defined color.'''
    PURPLE = enum.auto()
    '''A system-defined color.'''
    RED = enum.auto()
    '''A system-defined color.'''
    ROSY_BROWN = enum.auto()
    '''A system-defined color.'''
    ROYAL_BLUE = enum.auto()
    '''A system-defined color.'''
    SADDLE_BROWN = enum.auto()
    '''A system-defined color.'''
    SALMON = enum.auto()
    '''A system-defined color.'''
    SANDY_BROWN = enum.auto()
    '''A system-defined color.'''
    SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    SEA_SHELL = enum.auto()
    '''A system-defined color.'''
    SIENNA = enum.auto()
    '''A system-defined color.'''
    SILVER = enum.auto()
    '''A system-defined color.'''
    SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    SNOW = enum.auto()
    '''A system-defined color.'''
    SPRING_GREEN = enum.auto()
    '''A system-defined color.'''
    STEEL_BLUE = enum.auto()
    '''A system-defined color.'''
    TAN = enum.auto()
    '''A system-defined color.'''
    TEAL = enum.auto()
    '''A system-defined color.'''
    THISTLE = enum.auto()
    '''A system-defined color.'''
    TOMATO = enum.auto()
    '''A system-defined color.'''
    TURQUOISE = enum.auto()
    '''A system-defined color.'''
    VIOLET = enum.auto()
    '''A system-defined color.'''
    WHEAT = enum.auto()
    '''A system-defined color.'''
    WHITE = enum.auto()
    '''A system-defined color.'''
    WHITE_SMOKE = enum.auto()
    '''A system-defined color.'''
    YELLOW = enum.auto()
    '''A system-defined color.'''
    YELLOW_GREEN = enum.auto()
    '''A system-defined color.'''

class LineCap(enum.Enum):
    FLAT = enum.auto()
    '''Specifies a flat line cap.'''
    SQUARE = enum.auto()
    '''Specifies a square line cap.'''
    ROUND = enum.auto()
    '''Specifies a round line cap.'''
    TRIANGLE = enum.auto()
    '''Specifies a triangular line cap.'''
    NO_ANCHOR = enum.auto()
    '''Specifies no anchor.'''
    SQUARE_ANCHOR = enum.auto()
    '''Specifies a square anchor line cap.'''
    ROUND_ANCHOR = enum.auto()
    '''Specifies a round anchor cap.'''
    DIAMOND_ANCHOR = enum.auto()
    '''Specifies a diamond anchor cap.'''
    ARROW_ANCHOR = enum.auto()
    '''Specifies an arrow-shaped anchor cap.'''
    ANCHOR_MASK = enum.auto()
    '''Specifies a custom line cap.'''
    CUSTOM = enum.auto()
    '''Specifies a mask used to check whether a line cap is an anchor cap.'''

class LineJoin(enum.Enum):
    MITER = enum.auto()
    '''Specifies a mitered join. This produces a sharp corner or a clipped corner, depending on whether the length of the miter exceeds the miter limit.'''
    BEVEL = enum.auto()
    '''Specifies a beveled join. This produces a diagonal corner.'''
    ROUND = enum.auto()
    '''Specifies a circular join. This produces a smooth, circular arc between the lines.'''
    MITER_CLIPPED = enum.auto()
    '''Specifies a mitered join. This produces a sharp corner or a beveled corner, depending on whether the length of the miter exceeds the miter limit.'''

class MatrixOrder(enum.Enum):
    PREPEND = enum.auto()
    '''The new operation is applied before the old operation.'''
    APPEND = enum.auto()
    '''The new operation is applied after the old operation.'''

class PaletteMiningMethod(enum.Enum):
    USE_CURRENT_PALETTE = enum.auto()
    '''Use exisiting palette of the image'''
    COLOR_CLUSTERING = enum.auto()
    '''The color clustering method'''
    HISTOGRAM = enum.auto()
    '''The histogram method'''

class PdfComplianceVersion(enum.Enum):
    PDF15 = enum.auto()
    '''The output file will be PDF 1.5 compliant.'''
    PDF_A1A = enum.auto()
    '''The output file will be PDF/A-1a compliant.'''
    PDF_A1B = enum.auto()
    '''The output file will be PDF/A-1b compliant.'''

class PenAlignment(enum.Enum):
    CENTER = enum.auto()
    '''Specifies that the  object is centered over the theoretical line.'''
    INSET = enum.auto()
    '''Specifies that the  is positioned on the inside of the theoretical line.'''
    OUTSET = enum.auto()
    '''Specifies the  is positioned on the outside of the theoretical line.'''
    LEFT = enum.auto()
    '''Specifies the  is positioned to the left of the theoretical line.'''
    RIGHT = enum.auto()
    '''Specifies the  is positioned to the right of the theoretical line.'''

class PenType(enum.Enum):
    SOLID_COLOR = enum.auto()
    '''Specifies a solid fill.'''
    HATCH_FILL = enum.auto()
    '''Specifies a hatch fill.'''
    TEXTURE_FILL = enum.auto()
    '''Specifies a bitmap texture fill.'''
    PATH_GRADIENT = enum.auto()
    '''Specifies a path gradient fill.'''
    LINEAR_GRADIENT = enum.auto()
    '''Specifies a linear gradient fill.'''

class PixelFormat(enum.Enum):
    GRAYSCALE = enum.auto()
    '''The grayscale color space'''
    BGR = enum.auto()
    '''The BGR color space.'''
    RGB = enum.auto()
    '''The RGB color space.'''
    Y_CB_CR = enum.auto()
    '''The YCbCr color space.'''
    CMYK = enum.auto()
    '''The CMYK color space.'''
    YCCK = enum.auto()
    '''The YCCK color space.'''
    CIE_LAB = enum.auto()
    '''The CIE lab color space.'''

class ProcessingType(enum.Enum):
    DEFAULT = enum.auto()
    '''The default processing.'''
    INTERLACED8 = enum.auto()
    '''Interlaced by 8 lines processing.'''

class ResizeType(enum.Enum):
    NONE = enum.auto()
    '''The pixels are not preserved during resize operation.'''
    LEFT_TOP_TO_LEFT_TOP = enum.auto()
    '''Left top point of the new image will coincide with the left top point of the original image. Crop will occur if required.'''
    RIGHT_TOP_TO_RIGHT_TOP = enum.auto()
    '''Right top point of the new image will coincide with the right top point of the original image. Crop will occur if required.'''
    RIGHT_BOTTOM_TO_RIGHT_BOTTOM = enum.auto()
    '''Right bottom point of the new image will coincide with the right bottom point of the original image. Crop will occur if required.'''
    LEFT_BOTTOM_TO_LEFT_BOTTOM = enum.auto()
    '''Left bottom point of the new image will coincide with the left bottom point of the original image. Crop will occur if required.'''
    CENTER_TO_CENTER = enum.auto()
    '''Center of the new image will coincide with the center of the original image. Crop will occur if required.'''
    LANCZOS_RESAMPLE = enum.auto()
    '''Resample using lanczos algorithm with a=3.'''
    NEAREST_NEIGHBOUR_RESAMPLE = enum.auto()
    '''Resample using nearest neighbour algorithm.'''
    ADAPTIVE_RESAMPLE = enum.auto()
    '''Resample using adaptive algorithm based on weighted and blended rational function and lanczos3 interpolation algorithms.'''
    BILINEAR_RESAMPLE = enum.auto()
    '''Resample using bilinear interpolation. Image pre-filtering is allowed to remove the noice before resample, when needed'''
    HIGH_QUALITY_RESAMPLE = enum.auto()
    '''The high quality resample'''
    CATMULL_ROM = enum.auto()
    '''The Catmull-Rom cubic interpolation method.'''
    CUBIC_CONVOLUTION = enum.auto()
    '''The Cubic Convolution interpolation method'''
    CUBIC_B_SPLINE = enum.auto()
    '''The CubicBSpline cubic interpolation method'''
    MITCHELL = enum.auto()
    '''The Mitchell cubic interpolation method'''
    SIN_C = enum.auto()
    '''The Sinc (Lanczos3) cubic interpolation method'''
    BELL = enum.auto()
    '''The Bell interpolation method'''

class ResolutionUnit(enum.Enum):
    NONE = enum.auto()
    '''Undefined units'''
    INCH = enum.auto()
    '''Inch units'''
    CM = enum.auto()
    '''Metric centimeter units'''

class RotateFlipType(enum.Enum):
    ROTATE_NONE_FLIP_NONE = enum.auto()
    '''Specifies no clockwise rotation and no flipping.'''
    ROTATE_90_FLIP_NONE = enum.auto()
    '''Specifies a 90-degree clockwise rotation without flipping.'''
    ROTATE_180_FLIP_NONE = enum.auto()
    '''Specifies a 180-degree clockwise rotation without flipping.'''
    ROTATE_270_FLIP_NONE = enum.auto()
    '''Specifies a 270-degree clockwise rotation without flipping.'''
    ROTATE_NONE_FLIP_X = enum.auto()
    '''Specifies no clockwise rotation followed by a horizontal flip.'''
    ROTATE_90_FLIP_X = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_180_FLIP_X = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_270_FLIP_X = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_NONE_FLIP_Y = enum.auto()
    '''Specifies no clockwise rotation followed by a vertical flip.'''
    ROTATE_90_FLIP_Y = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_180_FLIP_Y = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_270_FLIP_Y = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_NONE_FLIP_XY = enum.auto()
    '''Specifies no clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_90_FLIP_XY = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_180_FLIP_XY = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_270_FLIP_XY = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a horizontal and vertical flip.'''

class SeekOrigin(enum.Enum):
    BEGIN = enum.auto()
    '''Specifies the beginning of a stream.'''
    CURRENT = enum.auto()
    '''Specifies the current position within a stream.'''
    END = enum.auto()
    '''Specifies the end of a stream.'''

class SmoothingMode(enum.Enum):
    INVALID = enum.auto()
    '''Specifies an invalid mode.'''
    DEFAULT = enum.auto()
    '''Specifies no antialiasing.'''
    HIGH_SPEED = enum.auto()
    '''Specifies no antialiasing.'''
    HIGH_QUALITY = enum.auto()
    '''Specifies antialiased rendering.'''
    NONE = enum.auto()
    '''Specifies no antialiasing.'''
    ANTI_ALIAS = enum.auto()
    '''Specifies antialiased rendering.'''

class StringAlignment(enum.Enum):
    NEAR = enum.auto()
    '''Specifies the text be aligned near the layout. In a left-to-right layout, the near position is left. In a right-to-left layout, the near position is right.'''
    CENTER = enum.auto()
    '''Specifies that text is aligned in the center of the layout rectangle.'''
    FAR = enum.auto()
    '''Specifies that text is aligned far from the origin position of the layout rectangle. In a left-to-right layout, the far position is right. In a right-to-left layout, the far position is left.'''

class StringDigitSubstitute(enum.Enum):
    USER = enum.auto()
    '''Specifies a user-defined substitution scheme.'''
    NONE = enum.auto()
    '''Specifies to disable substitutions.'''
    NATIONAL = enum.auto()
    '''Specifies substitution digits that correspond with the official national language of the user's locale.'''
    TRADITIONAL = enum.auto()
    '''Specifies substitution digits that correspond with the user's native script or language, which may be different from the official national language of the user's locale.'''

class StringFormatFlags(enum.Enum):
    DIRECTION_RIGHT_TO_LEFT = enum.auto()
    '''Text is displayed from right to left.'''
    DIRECTION_VERTICAL = enum.auto()
    '''Text is vertically aligned.'''
    FIT_BLACK_BOX = enum.auto()
    '''Parts of characters are allowed to overhang the string's layout rectangle. By default, characters are repositioned to avoid any overhang.'''
    DISPLAY_FORMAT_CONTROL = enum.auto()
    '''Control characters such as the left-to-right mark are shown in the output with a representative glyph.'''
    NO_FONT_FALLBACK = enum.auto()
    '''Fallback to alternate fonts for characters not supported in the requested font is disabled. Any missing characters are displayed with the fonts missing glyph, usually an open square.'''
    MEASURE_TRAILING_SPACES = enum.auto()
    '''Includes the trailing space at the end of each line. By default the boundary rectangle returned by the MeasureString method excludes the space at the end of each line. Set this flag to include that space in measurement.'''
    NO_WRAP = enum.auto()
    '''Text wrapping between lines when formatting within a rectangle is disabled. This flag is implied when a point is passed instead of a rectangle, or when the specified rectangle has a zero line length.'''
    LINE_LIMIT = enum.auto()
    '''Only entire lines are laid out in the formatting rectangle. By default layout continues until the end of the text, or until no more lines are visible as a result of clipping, whichever comes first.
    Note that the default settings allow the last line to be partially obscured by a formatting rectangle that is not a whole multiple of the line height. To ensure that only whole lines are seen,
    specify this value and be careful to provide a formatting rectangle at least as tall as the height of one line.'''
    NO_CLIP = enum.auto()
    '''Overhanging parts of glyphs, and unwrapped text reaching outside the formatting rectangle are allowed to show. By default all text and glyph parts reaching outside the formatting rectangle are clipped.'''
    EXACT_ALIGNMENT = enum.auto()
    '''The exact alignment, correct padding GDI+'''

class StringTrimming(enum.Enum):
    NONE = enum.auto()
    '''Specifies no trimming.'''
    CHARACTER = enum.auto()
    '''Specifies that the text is trimmed to the nearest character.'''
    WORD = enum.auto()
    '''Specifies that text is trimmed to the nearest word.'''
    ELLIPSIS_CHARACTER = enum.auto()
    '''Specifies that the text is trimmed to the nearest character, and an ellipsis is inserted at the end of a trimmed line.'''
    ELLIPSIS_WORD = enum.auto()
    '''Specifies that text is trimmed to the nearest word, and an ellipsis is inserted at the end of a trimmed line.'''
    ELLIPSIS_PATH = enum.auto()
    '''The center is removed from trimmed lines and replaced by an ellipsis. The algorithm keeps as much of the last slash-delimited segment of the line as possible.'''

class TextRenderingHint(enum.Enum):
    SYSTEM_DEFAULT = enum.auto()
    '''Each character is drawn using its glyph bitmap, with the system default rendering hint. The text will be drawn using whatever font-smoothing settings the user has selected for the system.'''
    SINGLE_BIT_PER_PIXEL_GRID_FIT = enum.auto()
    '''Each character is drawn using its glyph bitmap. Hinting is used to improve character appearance on stems and curvature.'''
    SINGLE_BIT_PER_PIXEL = enum.auto()
    '''Each character is drawn using its glyph bitmap. Hinting is not used.'''
    ANTI_ALIAS_GRID_FIT = enum.auto()
    '''Each character is drawn using its antialiased glyph bitmap with hinting. Much better quality due to antialiasing, but at a higher performance cost.'''
    ANTI_ALIAS = enum.auto()
    '''Each character is drawn using its antialiased glyph bitmap without hinting. Better quality due to antialiasing. Stem width differences may be noticeable because hinting is turned off.'''
    CLEAR_TYPE_GRID_FIT = enum.auto()
    '''Each character is drawn using its glyph ClearType bitmap with hinting. The highest quality setting. Used to take advantage of ClearType font features.'''

class WarpMode(enum.Enum):
    PERSPECTIVE = enum.auto()
    '''Specifies a perspective warp.'''
    BILINEAR = enum.auto()
    '''Specifies a bilinear warp.'''

class WrapMode(enum.Enum):
    TILE = enum.auto()
    '''Tiles the gradient or texture.'''
    TILE_FLIP_X = enum.auto()
    '''Reverses the texture or gradient horizontally and then tiles the texture or gradient.'''
    TILE_FLIP_Y = enum.auto()
    '''Reverses the texture or gradient vertically and then tiles the texture or gradient.'''
    TILE_FLIP_XY = enum.auto()
    '''Reverses the texture or gradient horizontally and vertically and then tiles the texture or gradient.'''
    CLAMP = enum.auto()
    '''The texture or gradient is not tiled.'''

