"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
/**
 * Includes a CloudFormation template into a stack. All elements of the template will be merged into
 * the current stack, together with any elements created programmatically.
 */
class CfnInclude extends cfn_element_1.CfnElement {
    /**
     * Creates an adopted template construct. The template will be incorporated into the stack as-is with no changes at all.
     * This means that logical IDs of entities within this template may conflict with logical IDs of entities that are part of the
     * stack.
     * @param scope The parent construct of this template
     * @param id The ID of this construct
     * @param props Initialization properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.template = props.template;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return this.template;
    }
}
exports.CfnInclude = CfnInclude;
//# sourceMappingURL=data:application/json;base64,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